﻿// $Id$

#ifndef INCLUDE_ccc_xml_XMLParserSrcIterator_h
#define INCLUDE_ccc_xml_XMLParserSrcIterator_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

class XMLParserSrc;
class XMLParserSrcIterator;

/*!
 * \ja
 * XMLParserSrcIterator クラスは残りのソースデータイメージ
 * に対するイタレータインターフェースを提供します。
 * \ja_end
 * \en
 * XMLParserSrcIterator class provides the iterator interface 
 * against the rest of the src data images.
 * \en_end
 */
class XMLParserSrcIterator
{
  /*!
   * XMLParserSrc
   */
  XMLParserSrc* src;
  /*!
   * \ja
   * イタレート中のXMLParserSrcUnit
   * \ja_end
   */
  const XMLParserSrcUnit* current_unit;
  /*!
   * \ja
   * イタレート中のデータ位置
   * \ja_end
   */
  const DOMChar* current_pos;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  XMLParserSrcIterator();
  /*!
   * \ja
   * コンストラクタ
   * \param src 対象のXMLParserSrc
   * \ja_end
   */
  XMLParserSrcIterator(XMLParserSrc* src);
  /*!
   * \ja
   * イタレート箇所の文字を得ます。
   * \return イタレート箇所の文字
   * \ja_end
   */
  DOMChar current() { return *current_pos; }
  /*!
   * \ja
   * このメソッドはイタレート位置を進めます。
   * \return 新しいイタレート位置がデータイメージ内なら真
   * \ja_end
   * \en
   * This method puts forward the iterate position.
   * \return true, if new iterate position is placed within the data.
   * \en_end
   */
  bool putForward();
  /*!
   * \ja
   * このメソッドは、イタレート位置が有効な位置かどうかを調べます。
   * \ja_end
   * \en
   * This method checks whether current iterate position is valid position.
   * \en_end
   */
  bool validPositionP();
  /*!
   * \ja
   * このメソッドは、イタレート位置をソースの走査位置に戻します。
   * \ja_end
   * \en
   * This method backs iterate position to the src scanning position.
   * \en_end
   */
  void rewind();
  /*!
   * \ja
   * 引数で渡したイタレート位置を代入します。
   * \param itr セットするイタレート位置を持ったXMLParserSrcIteratorオブジェクト
   * \ja_end
   */
  void assign(XMLParserSrcIterator& itr);
  /*!
   * \ja
   * 引数で渡したイタレート位置を代入します。
   * \param itr セットするイタレート位置を持ったXMLParserSrcIteratorオブジェクト
   * \ja_end
   */
  void operator = (XMLParserSrcIterator& itr) { assign(itr); }
  /*!
   * \ja
   * イタレート位置のXMLParserSrcUnitを得ます。
   * \return イタレート位置のXMLParserSrcUnit
   * \ja_end
   */
  const XMLParserSrcUnit* getCurrentUnit() { return current_unit; }
  /*!
   * イタレート中のデータ位置を得ます。
   * \return データ位置
   */
  const DOMChar* getCurrentPos() { return current_pos; }
 private:
  /*!
   * \ja
   * XMLParserSrcUnitに対するイタレートが終了しているかをチェックし、
   * 終了している場合には次のXMLParserSrcUnitに対するイタレート用に
   * 内部情報をセットします。
   * \ja_end
   */
  void unitEndCheck();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XMLParserSrcIterator_h */
