﻿// $Id$

#include <assert.h>
#include <ccc/xml/XMLParserSrc.h>

using namespace CCC;

// ------------------------------------------------------------------------
// class XMLParserSrcUnit

XMLParserSrcUnit::XMLParserSrcUnit(const DOMString* name, DOMString* data, bool has_data_p)
{
  XMLParserSrcUnit::name = name;
  XMLParserSrcUnit::data = data;
  XMLParserSrcUnit::has_data_p = has_data_p;
  pos = XMLParserSrcUnit::data->getStartPtr();
  end = pos + XMLParserSrcUnit::data->getLength();
}

XMLParserSrcUnit::XMLParserSrcUnit(const DOMString* name, DOMChar* data, Size data_len)
{
  XMLParserSrcUnit::name = name;
  XMLParserSrcUnit::data = new DOMString(data, data_len);
  XMLParserSrcUnit::has_data_p = true;
  pos = XMLParserSrcUnit::data->getStartPtr();
  end = pos + XMLParserSrcUnit::data->getLength();
}

XMLParserSrcUnit::~XMLParserSrcUnit()
{
  if (has_data_p)
  {
    delete data;
  }
}

bool
XMLParserSrcUnit::putForward(Size n)
{
  pos += n;
  return validPositionP();
}

bool
XMLParserSrcUnit::setPos(const DOMChar* pos)
{
  XMLParserSrcUnit::pos = pos;
  return validPositionP();
}

