﻿// $Id$

#ifndef INCLUDE_ccc_xml_XMLParserSrcUnit_h
#define INCLUDE_ccc_xml_XMLParserSrcUnit_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \ja
 * このクラスはXMLパーサの個々の入力単位として動作します。
 * \ja_end
 * \en
 * This class corresponds to an independent XML parser source unit.
 * \en_end
 */
class XMLParserSrcUnit
  : public NDLinkListNode<XMLParserSrcUnit>
{
  /*!
   * \ja
   * ソース名(ファイル名、URL、エンティティ等) 
   * \ja_end
   * \en
   * source name (file name, url, entity etc...)
   * \en_end
   */
  const DOMString* name;
  /*!
   * \ja
   * ソースデータイメージ文字列
   * \ja_end
   * \en
   * A source data image string.
   * \en_end
   */
  DOMString* data;
  /*!
   * \ja
   * このフラグが真ならば、データイメージのオブジェクトは、このオブジェクトの破棄に
   * ともない破棄されます。
   * \ja_end
   * \en
   * if this flag is true, data image object will be deleted according to
   * this object deletion.
   * \en_end
   */
  bool has_data_p;
  /*!
   * \ja
   * データの終了位置
   * \ja_end
   * \en
   * Data end position.
   * \en_end
   */
  const DOMChar* end;
  /*!
   * \ja
   * 現在の走査箇所
   * \ja_end
   * \en
   * current scaning position
   * \en_end
   */
  const DOMChar* pos;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param name ソース名
   * \param data データイメージ文字列
   * \param has_data_p データイメージをこのオブジェクトに所有させる場合に真を指定します。
   * \ja_end
   */
  XMLParserSrcUnit(const DOMString* name, DOMString* data, bool has_data_p);
  /*!
   * \ja
   * コンストラクタ
   * \param name ソース名
   * \param data データイメージ文字列
   * \param data_len データイメージ文字列の長さ
   * \ja_end
   */
  XMLParserSrcUnit(const DOMString* name, DOMChar* data, Size data_len);
  /*!
   * \ja	
   * デストラクタ
   * \ja_end
   */
  ~XMLParserSrcUnit();
  /*!
   * \ja
   * 残りのデータサイズを得ます。
   * \return データサイズ
   * \ja_end
   */
  Size restSize() const { return (Size)(end - pos); }
  /*!
   * \ja
   * ソース名を取得します。
   * \return ソース名
   * \ja_end
   */
  const DOMString* getName() const { return name; }
  /*!
   * \ja
   * 現在の走査箇所を取得します。
   * \return 走査箇所
   * \ja_end
   */
  const DOMChar* getPos() const { return pos; }
  /*!
   * \ja
   * データの終了位置を取得します。
   * \return 終了位置
   * \ja_end
   */
  const DOMChar* getEnd() const { return end; }
  /*!
   * \ja
   * 走査位置を進めます。
   * \param n 進める字数
   * \return 新しい走査位置がデータイメージ内なら真
   * \ja_end
   */
  bool putForward(Size n = 1);
  /*!
   * \ja
   * 走査位置がデータイメージ内かどうかを調べます。
   * \return データイメージ内なら真
   * \ja_end
   */
  bool validPositionP() { return pos < end; }
  /*!
   * \ja
   * 走査位置をセットします。
   * \param pos 新しい走査位置
   * \return データイメージ内なら真
   * \ja_end
   */
  bool setPos(const DOMChar* pos);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XMLParserSrcUnit_h */
