﻿// $Id$
/*!
 * \file
 * XML文字クラスを定義します。
 */

#ifndef INCLUDE_CCC_XML_XMLCHARCLASS_H
#define INCLUDE_CCC_XML_XMLCHARCLASS_H

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \ja
 * XML文字クラス
 * http://www.w3.org/TR/REC-xml/ 
 * http://www.w3.org/TR/REC-xml-names/
 * \ja_end
 * \en
 * XML Character class
 * http://www.w3.org/TR/REC-xml/
 * http://www.w3.org/TR/REC-xml-names/
 * \en_end
 */
enum XmlCharClass
{
  // XML 1.0
  // http://www.w3.org/TR/REC-xml/
  /*! BaseChar */
  XMLCHARCLASS_BASECHAR		= 0x01,
  /*! Ideographic */
  XMLCHARCLASS_IDEOGRAPHIC	= 0x02,
  /*! CombiningChar */
  XMLCHARCLASS_COMBININGCHAR	= 0x04,
  /*! Digit */
  XMLCHARCLASS_DIGIT		= 0x08,
  /*! Extender */
  XMLCHARCLASS_EXTENDER		= 0x10,
  /*! '.' | '-' | '_' */
  XMLCHARCLASS_NAMECHARETC	= 0x20,
  /*! '_' */
  XMLCHARCLASS_NAMETOPETC	= 0x40,
  /*! ':' */
  XMLCHARCLASS_COLON		= 0x80,
  /*! Letter ::= BaseChar | Ideographic */
  XMLCHARCLASS_LETTER		= (XMLCHARCLASS_BASECHAR | XMLCHARCLASS_IDEOGRAPHIC),
  /*! NameChar */
  XMLCHARCLASS_NAMECHAR		= (XMLCHARCLASS_LETTER | XMLCHARCLASS_DIGIT |
				   XMLCHARCLASS_NAMECHARETC | XMLCHARCLASS_COLON |
				   XMLCHARCLASS_COMBININGCHAR | XMLCHARCLASS_EXTENDER),
  /*! Nameの先頭文字 */
  XMLCHARCLASS_NAMETOP		= (XMLCHARCLASS_LETTER | XMLCHARCLASS_NAMETOPETC |
				   XMLCHARCLASS_COLON),

  // Namespaces in XML
  // http://www.w3.org/TR/REC-xml-names/
  /*! NCNameChar */
  XMLCHARCLASS_NCNAMECHAR	= (XMLCHARCLASS_LETTER | XMLCHARCLASS_DIGIT |
				   XMLCHARCLASS_NAMECHARETC | XMLCHARCLASS_COMBININGCHAR |
				   XMLCHARCLASS_EXTENDER),
  /*! NCNameの先頭文字 */
  XMLCHARCLASS_NCNAMETOP	= (XMLCHARCLASS_LETTER | XMLCHARCLASS_NAMETOPETC),
};

/*!
 * このテーブルは、0x10000のサイズを持ちます。配列のインデックス
 * をUCS2の文字コードとし、該当文字が属するXmlCharClassによる
 * 文字クラスを示します。
 */
extern unsigned char xml_char_class_tbl[];

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_CCC_XML_XMLCHARCLASS_H */
