﻿#line 1 "dump.upp"
#include <ccc/xml/dom.h>
#include <ccc/xml/XMLParser.h>

CCC_NAMESPACE_START(CCC);

void
Document::writeXML(OFlow* of) const CCC_RAISES(DOMException)
{
  try 
  {
    XMLOutputter xo(of);
    writeXml(&xo);
  }
  catch (IOException)
  {
    throw DOMException(WRITE_XML_STREAM_ERR);
  }
  catch (DOMException ex)
  {
    throw ex;
  }
}

void
Document::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  Iterator<Node>* it = getChildNodes()->createIterator();
  Node* node;
  while ((node = it->next()))
  {
    node->writeXml(xo);
  }
  delete it;
}

void
XMLDecl::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  static DOMChar* atts[] =
  {
    // The following sequence is defined strictly.
    XMLToken::str_version,
    XMLToken::str_encoding,
    XMLToken::str_standalone,
    0
  };
  xo->print(XMLToken::str_xmldecl_start);
  DOMChar** x = atts;
  NamedNodeMap* xml_decl_node_map = getAttributes();
  while (*x)
  {
    DOMString s(*x);
    Node* node = xml_decl_node_map->getNamedItem(&s);
    if (node)
    {
      xo->print(XMLToken::str_sp);
      node->writeXml(xo);
    }
    x++;
  }
  if (!xo->optionSetP(XMLOutputter::DONT_OUTPUT_SPACE_BEFORE_XML_DECL_END))
  {
    xo->print(XMLToken::str_sp);
  }
  xo->print(XMLToken::str_xmldecl_end);
}

void
Element::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  const DOMString* name = getTagName();
  xo->print(XMLToken::str_open);
  xo->print(name);
  if (xo->getOption() & XMLOutputter::OPTION_DEBUG)
  {
    static DOMChar str_1[] = { 0x5b /* [ */, 0x00, };
    static DOMChar str_2[] = { 0x5d /* ] */, 0x00, };
    static DOMChar str_node_name[] = { 0x4e /* N */, 0x4f /* O */, 0x44 /* D */, 0x45 /* E */, 0x5f /* _ */, 0x4e /* N */, 0x41 /* A */, 0x4d /* M */, 0x45 /* E */, 0x3a /* : */, 0x00, };
    static DOMChar str_prefix[] = { 0x50 /* P */, 0x52 /* R */, 0x45 /* E */, 0x46 /* F */, 0x49 /* I */, 0x58 /* X */, 0x3a /* : */, 0x00, };
    static DOMChar str_local_name[] = { 0x4c /* L */, 0x4f /* O */, 0x43 /* C */, 0x41 /* A */, 0x4c /* L */, 0x5f /* _ */, 0x4e /* N */, 0x41 /* A */, 0x4d /* M */, 0x45 /* E */, 0x3a /* : */, 0x00, };
    static DOMChar str_namespace_uri[] = { 0x4e /* N */, 0x41 /* A */, 0x4d /* M */, 0x45 /* E */, 0x53 /* S */, 0x50 /* P */, 0x41 /* A */, 0x43 /* C */, 0x45 /* E */, 0x5f /* _ */, 0x55 /* U */, 0x52 /* R */, 0x49 /* I */, 0x3a /* : */, 0x00, };
    static DOMChar str_null[] = { 0x6e /* n */, 0x75 /* u */, 0x6c /* l */, 0x6c /* l */, 0x00, };
    DOMString s_null(str_null);
    xo->print(XMLToken::str_sp);
    xo->print(str_1);
    xo->print(str_node_name);
    xo->print(getNodeName());
    xo->print(XMLToken::str_sp);
    xo->print(str_prefix);
    const DOMString* x = getPrefix();
    xo->print(x ? x : &s_null);
    xo->print(XMLToken::str_sp);
    xo->print(str_local_name);
    x = getLocalName();
    xo->print(x ? x : &s_null);
    xo->print(XMLToken::str_sp);
    xo->print(str_namespace_uri);
    x = getNamespaceURI();
    xo->print(x ? x : &s_null);
    xo->print(str_2);
  }
  // write attributes
  {
    Iterator<Node>* it = getAttributes()->createIterator();
    Node* node;
    while ((node = it->next()))
    {
      xo->print(XMLToken::str_sp);
      node->writeXml(xo);
    }
    delete it;
  }

  if (getChildNodes()->getLength() == 0)
  {
#ifndef CODEX_PURE_DOM
    if (xo->optionSetP(XMLOutputter::USE_REDUNDANT_EMPTY_TAG_EXPRESSION_CONTROL))
    {
      if (getRedundantEmptyTagExpressionP())
      {
	// <A>
	xo->print(XMLToken::str_close);
	// </A>
	xo->print(XMLToken::str_etag);
	xo->print(name);
	xo->print(XMLToken::str_close);
      }
      else
      {
	// <A/>
	if (xo->optionSetP(XMLOutputter::OUTPUT_SPACE_BEFORE_EMPTY_ELEM_TAG))
	{
	  xo->print(XMLToken::str_sp);
	}
	xo->print(XMLToken::str_empclose);
      }
    }
    else
#endif /* CODEX_PURE_DOM */
    {
      if (xo->optionSetP(XMLOutputter::OUTPUT_SPACE_BEFORE_EMPTY_ELEM_TAG))
      {
	xo->print(XMLToken::str_sp);
      }
      xo->print(XMLToken::str_empclose);
    }
  }
  else
  {
    xo->print(XMLToken::str_close);
    // write children
    {
      Iterator<Node>* it = getChildNodes()->createIterator();
      Node* node;
      while ((node = it->next()))
      {
	node->writeXml(xo);
      }
      delete it;
    }
    xo->print(XMLToken::str_etag);
    xo->print(name);
    xo->print(XMLToken::str_close);
  }
}

void
Node::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  // nothing to do
}

void
Attr::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  const DOMString* name = getName();
  const DOMString* value = getValue();
  if (value->getLength() > 0)
  {
    xo->print(name);
    xo->print(XMLToken::str_eq);
    xo->print(XMLToken::str_dquote);
    // &amp; &lt; &gt; &apos; &quot; escape.
    xo->escPrint(value);
    xo->print(XMLToken::str_dquote);
  }
  else
  {
    xo->print(name);
    xo->print(XMLToken::str_eq);
    xo->print(XMLToken::str_dquote);
    xo->print(XMLToken::str_dquote);
  }
}

void
Text::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  // &amp; &lt; &gt; &apos; &quot; escape.
  xo->escPrint(getData());
}

void
Comment::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_comment_start);
  xo->print(getData());
  xo->print(XMLToken::str_comment_end);
}

void
CDATASection::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_cdata_start);
  xo->print(getData());
  xo->print(XMLToken::str_cdata_end);
}

void
EntityReference::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_and);
  xo->print(getNodeName());
  xo->print(XMLToken::str_semicol);
}

void
ProcessingInstruction::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_pi_start);
  xo->print(getTarget());
  if (node_value.getLength() > 0)
  {
    xo->print(XMLToken::str_sp);
    xo->print(getData());
  }
  xo->print(XMLToken::str_pi_end);
}

void
DocumentType::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_doctype_start);
  xo->print(XMLToken::str_sp);
  xo->print(getNodeName());
  if (getPublicId())
  {
    // S 'PUBLIC' S PubidLiteral S SystemLiteral
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_externalidpublic);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getPublicId());
    xo->print(XMLToken::str_dquote);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
  }
  else if (getSystemId())
  {
    // S 'SYSTEM' S SystemLiteral
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_externalidsystem);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
  }

  if (internals.number() > 0)
  {
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_markupdecl_start);
    Iterator<Node>* it = internals.createIterator();
    Node* node;
    Node* prev = 0;
    while ((node = it->next()))
    {
      node->writeXml(xo);
      prev = node;
    }
    delete it;
    xo->print(XMLToken::str_markupdecl_end);
  }
  xo->print(XMLToken::str_close);
}

void
DtdAttlist::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  if (first_attdef_p)
  {
    xo->print(XMLToken::str_attlist_start);
    xo->print(XMLToken::str_sp);
    Node* parent = getParentNode();
    assert(!!parent);
    xo->print(parent->getNodeName());	// Element name
  }
  // AttDef
  xo->print(XMLToken::str_sp);
  xo->print(node_name);
  // AttType
  xo->print(XMLToken::str_sp);
  switch (att_type)
  {
   case ATTTYPE_UNKNOWN:
    assert(false);
    break;
   case ATTTYPE_CDATA:
    xo->print(XMLToken::str_cdata);
    break;
   case ATTTYPE_ID:
    xo->print(XMLToken::str_id);
    break;
   case ATTTYPE_IDREF:
    xo->print(XMLToken::str_idref);
    break;
   case ATTTYPE_IDREFS:
    xo->print(XMLToken::str_idrefs);
    break;
   case ATTTYPE_NMTOKEN:
    xo->print(XMLToken::str_nmtoken);
    break;
   case ATTTYPE_NMTOKENS:
    xo->print(XMLToken::str_nmtokens);
    break;
   case ATTTYPE_ENTITY:
    xo->print(XMLToken::str_entity);
    break;
   case ATTTYPE_ENTITIES:
    xo->print(XMLToken::str_entities);
    break;
   case ATTTYPE_NOTATION:
    xo->print(XMLToken::str_notation);
    xo->print(XMLToken::str_sp);
    // follow down
   case ATTTYPE_CANDIDATES:
    xo->print(XMLToken::str_openbr);
    {
      assert(!!candidates);
      Iterator<DOMString>* it = candidates->createIterator();
      DOMString* s;
      bool first_p = true;
      while ((s = it->next()))
      {
	if (!first_p)
	{
	  xo->print(XMLToken::str_sp);
	  xo->print(XMLToken::str_or);
	}
	xo->print(s);
	first_p = false;
      }
      delete it;
    }
    xo->print(XMLToken::str_closebr);
    break;
  }
  xo->print(XMLToken::str_sp);
  // DefaultDecl
  switch (default_type)
  {
   case DEFAULTTYPE_UNKNOWN:
    assert(false);
    break;
   case DEFAULTTYPE_REQUIRED:
    xo->print(XMLToken::str_required);
    break;
   case DEFAULTTYPE_IMPLIED:
    xo->print(XMLToken::str_implied);
    break;
   case DEFAULTTYPE_FIXED:
    xo->print(XMLToken::str_fixed);
    xo->print(XMLToken::str_sp);
    // follow down
   case DEFAULTTYPE_DEFAULT:
    assert(!!default_value);
    xo->print(default_value);
    break;
  }
  if (last_attdef_p)
  {
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_close);
  }
}

void
DtdElement::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_element_start);
  xo->print(XMLToken::str_sp);
  xo->print(node_name);
  xo->print(XMLToken::str_sp);
  spec.writeXml(xo);	// contentspec
  xo->print(XMLToken::str_sp);
  xo->print(XMLToken::str_close);
}

void
DtdECUnit::writeXmlChild(XMLOutputter* xo, DOMChar* sep) const
{
  assert(!!children);
  Iterator<DtdECUnit>* it = children->createIterator();
  DtdECUnit* unit;
  bool first_p = true;
  while ((unit = it->next()))
  {
    if (!first_p)
    {
      xo->print(sep);
    }
    unit->writeXml(xo);
    first_p = false;
  }
  delete it;
}

void
DtdECUnit::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  switch ((UnitType)((int)unit_type & (~UT_REP_MASK)))
  {
   case UT_TIP_EMPTY:
    xo->print(XMLToken::str_empty);
    break;
   case UT_TIP_ANY:
    xo->print(XMLToken::str_any);
    break;
   case UT_TIP_PCDATA:
    xo->print(XMLToken::str_pcdata);
    break;
   case UT_TIP_NAME:
    xo->print(name);
    break;
   case UT_MIXED_ONE:
    xo->print(XMLToken::str_openbr);
    writeXmlChild(xo, XMLToken::str_null);
    xo->print(XMLToken::str_closebr);
    break;
   case UT_MIXED_CHOICE:
    xo->print(XMLToken::str_openbr);
    writeXmlChild(xo, XMLToken::str_or);
    xo->print(XMLToken::str_closebr);
    xo->print(XMLToken::str_aster);
    break;
   case UT_SEQUENCE:
    xo->print(XMLToken::str_openbr);
    writeXmlChild(xo, XMLToken::str_seq);
    xo->print(XMLToken::str_closebr);
    break;
   case UT_CHOICE:
    xo->print(XMLToken::str_openbr);
    writeXmlChild(xo, XMLToken::str_or);
    xo->print(XMLToken::str_closebr);
    break;
   default:
    assert(false);
    break;
  }
  switch ((UnitType)((int)unit_type & UT_REP_MASK))
  {
   case UT_REP_ZERO_OR_ONE:
    xo->print(XMLToken::str_question);
    break;
   case UT_REP_ONE_OR_MORE:
    xo->print(XMLToken::str_plus);
    break;
   case UT_REP_ZERO_OR_MORE:
    xo->print(XMLToken::str_aster);
    break;
   default:
    assert(false);
    break;
  }
}

void
Entity::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_entity_start);
  xo->print(XMLToken::str_sp);
  xo->print(node_name);
  xo->print(XMLToken::str_sp);
  // EntityDef
  if (getPublicId())
  {
    // 'PUBLIC' S PubidLiteral S SystemLiteral (S 'NDATA' S Name)?
    xo->print(XMLToken::str_externalidpublic);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getPublicId());
    xo->print(XMLToken::str_dquote);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
    if (ndata)
    {
      xo->print(XMLToken::str_sp);
      xo->print(XMLToken::str_ndata);
      xo->print(XMLToken::str_sp);
      xo->print(ndata);
    }
  }
  else if (getSystemId())
  {
    // 'SYSTEM' S SystemLiteral (S 'NDATA' S Name)?
    xo->print(XMLToken::str_externalidsystem);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
    if (ndata)
    {
      xo->print(XMLToken::str_sp);
      xo->print(XMLToken::str_ndata);
      xo->print(XMLToken::str_sp);
      xo->print(ndata);
    }
  }
  else
  {
    // EntityValue
    xo->print(XMLToken::str_dquote);
    // &amp; &lt; &gt; &apos; &quot; escape.
    xo->escPrint(&entity_value);
    xo->print(XMLToken::str_dquote);
  }
  xo->print(XMLToken::str_sp);
  xo->print(XMLToken::str_close);
}

void
DtdPEntity::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_entity_start);
  xo->print(XMLToken::str_sp);
  xo->print(XMLToken::str_percent);
  xo->print(XMLToken::str_sp);
  xo->print(node_name);
  xo->print(XMLToken::str_sp);

  if (getPublicId())
  {
    // PUBLIC
    xo->print(XMLToken::str_externalidpublic);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getPublicId());
    xo->print(XMLToken::str_dquote);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
  }
  else if (getSystemId())
  {
    // SYSTEM
    xo->print(XMLToken::str_externalidsystem);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
  }
  else
  {
    xo->print(XMLToken::str_dquote);
    xo->print(getPEDef());
    xo->print(XMLToken::str_dquote);
  }
  xo->print(XMLToken::str_sp);
  xo->print(XMLToken::str_close);
}

void
Notation::writeXml(XMLOutputter* xo) const CCC_RAISES(IOException)
{
  xo->print(XMLToken::str_notation_start);
  xo->print(XMLToken::str_sp);
  xo->print(getNodeName());
  xo->print(XMLToken::str_sp);
  if (getPublicId())
  {
    // PUBLIC
    xo->print(XMLToken::str_externalidpublic);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getPublicId());
    xo->print(XMLToken::str_dquote);
    if (getSystemId())
    {
      xo->print(XMLToken::str_sp);
      xo->print(XMLToken::str_dquote);
      xo->print(getSystemId());
      xo->print(XMLToken::str_dquote);
    }
  }
  else if (getSystemId())
  {
    // SYSTEM
    xo->print(XMLToken::str_externalidsystem);
    xo->print(XMLToken::str_sp);
    xo->print(XMLToken::str_dquote);
    xo->print(getSystemId());
    xo->print(XMLToken::str_dquote);
  }
  xo->print(XMLToken::str_sp);
  xo->print(XMLToken::str_close);
}

CCC_NAMESPACE_END(CCC);

