﻿// $Id$

#include <stdio.h>
#include <ccc/xml/XmlCharClass.h>

#if 0
enum CharClass
{
  BaseChar = 0x01,
  Ideographic = 0x02,
  CombiningChar = 0x04,
  Digit = 0x08,
  Extender = 0x10,
  NameCharEtc = 0x20,	// '.' | '-' | '_'
  NameTopEtc = 0x40,	// '_'
  Colon = 0x80,
};
#endif

static unsigned char char_class_tbl[0x10000];

void
set(CCC::XmlCharClass c, int from, int to)
{
  int i;
  for (i = from; i <= to; i++) 
  {
    char_class_tbl[i] |= (unsigned char)c;
  }
}

void
set(CCC::XmlCharClass c, int n)
{
  char_class_tbl[n] |= (unsigned char)c;
}

void
set_table()
{
  // [85]
  // BaseChar ::=
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0041, 0x005A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0061, 0x007A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x00C0, 0x00D6);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x00D8, 0x00F6);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x00F8, 0x00FF);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0100, 0x0131);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0134, 0x013E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0141, 0x0148);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x014A, 0x017E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0180, 0x01C3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x01CD, 0x01F0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x01F4, 0x01F5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x01FA, 0x0217);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0250, 0x02A8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x02BB, 0x02C1);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0386);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0388, 0x038A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x038C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x038E, 0x03A1);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03A3, 0x03CE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03D0, 0x03D6);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03DA);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03DC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03DE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03E0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x03E2, 0x03F3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0401, 0x040C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x040E, 0x044F);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0451, 0x045C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x045E, 0x0481);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0490, 0x04C4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x04C7, 0x04C8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x04CB, 0x04CC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x04D0, 0x04EB);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x04EE, 0x04F5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x04F8, 0x04F9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0531, 0x0556);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0559);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0561, 0x0586);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x05D0, 0x05EA);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x05F0, 0x05F2);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0621, 0x063A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0641, 0x064A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0671, 0x06B7);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x06BA, 0x06BE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x06C0, 0x06CE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x06D0, 0x06D3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x06D5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x06E5, 0x06E6);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0905, 0x0939);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x093D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0958, 0x0961);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0985, 0x098C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x098F, 0x0990);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0993, 0x09A8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09AA, 0x09B0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09B2);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09B6, 0x09B9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09DC, 0x09DD);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09DF, 0x09E1);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x09F0, 0x09F1);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A05, 0x0A0A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A0F, 0x0A10);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A13, 0x0A28);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A2A, 0x0A30);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A32, 0x0A33);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A35, 0x0A36);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A38, 0x0A39);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A59, 0x0A5C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A5E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A72, 0x0A74);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A85, 0x0A8B);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A8D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A8F, 0x0A91);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0A93, 0x0AA8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0AAA, 0x0AB0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0AB2, 0x0AB3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0AB5, 0x0AB9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0ABD);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0AE0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B05, 0x0B0C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B0F, 0x0B10);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B13, 0x0B28);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B2A, 0x0B30);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B32, 0x0B33);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B36, 0x0B39);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B3D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B5C, 0x0B5D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B5F, 0x0B61);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B85, 0x0B8A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B8E, 0x0B90);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B92, 0x0B95);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B99, 0x0B9A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B9C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0B9E, 0x0B9F);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0BA3, 0x0BA4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0BA8, 0x0BAA);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0BAE, 0x0BB5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0BB7, 0x0BB9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C05, 0x0C0C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C0E, 0x0C10);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C12, 0x0C28);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C2A, 0x0C33);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C35, 0x0C39);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C60, 0x0C61);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C85, 0x0C8C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C8E, 0x0C90);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0C92, 0x0CA8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0CAA, 0x0CB3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0CB5, 0x0CB9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0CDE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0CE0, 0x0CE1);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0D05, 0x0D0C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0D0E, 0x0D10);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0D12, 0x0D28);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0D2A, 0x0D39);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0D60, 0x0D61);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E01, 0x0E2E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E30);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E32, 0x0E33);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E40, 0x0E45);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E81, 0x0E82);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E84);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E87, 0x0E88);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E8A);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E8D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E94, 0x0E97);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0E99, 0x0E9F);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EA1, 0x0EA3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EA5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EA7);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EAA, 0x0EAB);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EAD, 0x0EAE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EB0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EB2, 0x0EB3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EBD);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0EC0, 0x0EC4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0F40, 0x0F47);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x0F49, 0x0F69);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x10A0, 0x10C5);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x10D0, 0x10F6);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1100);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1102, 0x1103);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1105, 0x1107);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1109);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x110B, 0x110C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x110E, 0x1112);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x113C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x113E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1140);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x114C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x114E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1150);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1154, 0x1155);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1159);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x115F, 0x1161);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1163);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1165);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1167);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1169);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x116D, 0x116E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1172, 0x1173);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1175);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x119E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11A8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11AB);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11AE, 0x11AF);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11B7, 0x11B8);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11BA);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11BC, 0x11C2);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11EB);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11F0);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x11F9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1E00, 0x1E9B);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1EA0, 0x1EF9);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F00, 0x1F15);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F18, 0x1F1D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F20, 0x1F45);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F48, 0x1F4D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F50, 0x1F57);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F59);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F5B);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F5D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F5F, 0x1F7D);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1F80, 0x1FB4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FB6, 0x1FBC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FBE);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FC2, 0x1FC4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FC6, 0x1FCC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FD0, 0x1FD3);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FD6, 0x1FDB);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FE0, 0x1FEC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FF2, 0x1FF4);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x1FF6, 0x1FFC);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x2126);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x212A, 0x212B);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x212E);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x2180, 0x2182);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x3041, 0x3094);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x30A1, 0x30FA);
  set(CCC::XMLCHARCLASS_BASECHAR, 0x3105, 0x312C);
  set(CCC::XMLCHARCLASS_BASECHAR, 0xAC00, 0xD7A3);

  // [86]
  // Ideographic ::=
  set(CCC::XMLCHARCLASS_IDEOGRAPHIC, 0x4E00, 0x9FA5);
  set(CCC::XMLCHARCLASS_IDEOGRAPHIC, 0x3007);
  set(CCC::XMLCHARCLASS_IDEOGRAPHIC, 0x3021, 0x3029);  

  // [87]
  // CombiningChar ::=
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0300, 0x0345);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0360, 0x0361);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0483, 0x0486);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0591, 0x05A1);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x05A3, 0x05B9);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x05BB, 0x05BD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x05BF);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x05C1, 0x05C2);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x05C4);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x064B, 0x0652);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0670);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x06D6, 0x06DC);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x06DD, 0x06DF);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x06E0, 0x06E4);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x06E7, 0x06E8);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x06EA, 0x06ED);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0901, 0x0903);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x093C);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x093E, 0x094C);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x094D);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0951, 0x0954);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0962, 0x0963);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0981, 0x0983);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09BC);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09BE);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09BF);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09C0, 0x09C4);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09C7, 0x09C8);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09CB, 0x09CD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09D7);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x09E2, 0x09E3);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A02);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A3C);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A3E);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A3F);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A40, 0x0A42);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A47, 0x0A48);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A4B, 0x0A4D);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A70, 0x0A71);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0A81, 0x0A83);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0ABC);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0ABE, 0x0AC5);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0AC7, 0x0AC9);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0ACB, 0x0ACD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B01, 0x0B03);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B3C);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B3E, 0x0B43);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B47, 0x0B48);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B4B, 0x0B4D);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B56, 0x0B57);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0B82, 0x0B83);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0BBE, 0x0BC2);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0BC6, 0x0BC8);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0BCA, 0x0BCD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0BD7);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C01, 0x0C03);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C3E, 0x0C44);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C46, 0x0C48);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C4A, 0x0C4D);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C55, 0x0C56);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0C82, 0x0C83);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0CBE, 0x0CC4);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0CC6, 0x0CC8);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0CCA, 0x0CCD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0CD5, 0x0CD6);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0D02, 0x0D03);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0D3E, 0x0D43);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0D46, 0x0D48);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0D4A, 0x0D4D);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0D57);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0E31);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0E34, 0x0E3A);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0E47, 0x0E4E);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0EB1);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0EB4, 0x0EB9);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0EBB, 0x0EBC);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0EC8, 0x0ECD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F18, 0x0F19);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F35);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F37);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F39);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F3E);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F3F);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F71, 0x0F84);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F86, 0x0F8B);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F90, 0x0F95);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F97);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0F99, 0x0FAD);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0FB1, 0x0FB7);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x0FB9);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x20D0, 0x20DC);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x20E1);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x302A, 0x302F);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x3099);
  set(CCC::XMLCHARCLASS_COMBININGCHAR, 0x309A);

  // [88]
  // Digit ::=
  set(CCC::XMLCHARCLASS_DIGIT, 0x0030, 0x0039);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0660, 0x0669);
  set(CCC::XMLCHARCLASS_DIGIT, 0x06F0, 0x06F9);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0966, 0x096F);
  set(CCC::XMLCHARCLASS_DIGIT, 0x09E6, 0x09EF);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0A66, 0x0A6F);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0AE6, 0x0AEF);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0B66, 0x0B6F);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0BE7, 0x0BEF);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0C66, 0x0C6F);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0CE6, 0x0CEF);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0D66, 0x0D6F);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0E50, 0x0E59);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0ED0, 0x0ED9);
  set(CCC::XMLCHARCLASS_DIGIT, 0x0F20, 0x0F29);

  // [89]
  // Extender ::=
  set(CCC::XMLCHARCLASS_EXTENDER, 0x00B7);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x02D0);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x02D1);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x0387);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x0640);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x0E46);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x0EC6);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x3005);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x3031, 0x3035);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x309D, 0x309E);
  set(CCC::XMLCHARCLASS_EXTENDER, 0x30FC, 0x30FE);

  // NameCharEtc ::= '.' | '-' | '_'
  set(CCC::XMLCHARCLASS_NAMECHARETC, '.');
  set(CCC::XMLCHARCLASS_NAMECHARETC, '-');
  set(CCC::XMLCHARCLASS_NAMECHARETC, '_');

  // NameTopEtc ::= '_'
  set(CCC::XMLCHARCLASS_NAMETOPETC, '_');

  // Colon
  set(CCC::XMLCHARCLASS_COLON, ':');
}

int
main()
{
  int i;
  for (i = 0; i <= 0xffff; i++)
  {
    char_class_tbl[i] = 0;
  }
  set_table();

  printf("namespace CCC {\n");
  printf("unsigned char xml_char_class_tbl[0x10000] =\n");
  printf("{\n");
  for (i = 0; i <= 0xfff; i++)
  {
    printf("  /* %04x */ ", i * 16);
    int j;
    for (j = 0; j < 16; j++)
    {
      printf("0x%02x, ", char_class_tbl[i * 16 + j]);
    }
    printf("\n");
  }
  printf("};\n");
  printf("};\n");
  return 0;
}
