﻿// $Id$

// g++ -o xmlparser -g -I../../ xmlparser_test.cpp ../libccc.a

#include <stdio.h>
#include <ccc/file/FileOFlow.h>
#include <ccc/base/Spooler.h>
#include <ccc/xml/dom.h>
#include <ccc/xml/XMLParser.h>
#include <ccc/xml/XLog.h>
#include <ccc/iceman/Utf8String.h>
#include <ccc/xml/MiniXMLParser.h>

void
putIndent(int level)
{
  while (level-- > 0)
  {
    printf("  ");
  }
}

void
dump(CCC::Element* node, int level)
{
  const CCC::DOMString null("(null)");
  CCC::Utf8String node_name((node->getNodeName() != 0) ? *(node->getNodeName()) : null);
  CCC::Utf8String node_value((node->getNodeValue() != 0) ? *(node->getNodeValue()) : null);
  CCC::Utf8String prefix((node->getPrefix() != 0) ? *(node->getPrefix()) : null);
  CCC::Utf8String local_name((node->getLocalName() != 0) ? *(node->getLocalName()) : null);
  CCC::Utf8String namespace_uri((node->getNamespaceURI() != 0) ? *(node->getNamespaceURI()) : null);
  putIndent(level);
  printf("Element NodeName:[%s] NodeValue:[%s] Prefix:[%s] LocalName:[%s] NamespaceURI:[%s]\n",
	 node_name.getCString(),
	 node_value.getCString(),
	 prefix.getCString(),
	 local_name.getCString(),
	 namespace_uri.getCString()
    );
  CCC::Node* child = node->getFirstChild();
  while (child != 0)
  {
    if (child->getNodeType() == CCC::Node::ELEMENT_NODE)
    {
      dump((CCC::Element*)child, level + 1);
    }
    child = child->getNext();
  }
}

void
output(CCC::Document* dom)
{
  CCC::Spooler spool(CCC::IOTYPE_UINT16,CCC::IOTYPE_INT8, CCC::stdout_flow);
  CCC::CompositIFilter* ifilter = CCC::Iceman::createCompositIFilter(CCC_DOM_CEID, CCC::CEID_UTF8N);
  spool.add(ifilter);
  try
  {
    //CCC::XMLOutputter xo(&spool, CCC::XMLOutputter::OPTION_DEBUG);
    CCC::XMLOutputter xo(&spool);
    dom->writeXml(&xo);
    spool.flush();
  }
  catch (CCC::DOMException e)
  {
  }
}

int
dump_dstr(CCC::DOMString* x)
{
  CCC::Utf8String x8(*x);
  printf("%s\n", x8.getCString());
}

int
main(int argc, char** argv)
{
  CCC::Ccc::initialize();
  if (argc < 2)
  {
    fprintf(stderr, "USAGE:%s XML-path\n", argv[0]);
    return -1;
  }

  // read XML by XMLParser
  CCC::XLog log;
  CCC::Document* dom = CCC::XMLParser::readXML(argv[1], 0, 0, 0, log.textWriter(), CCC::XMLParser::DEFAULT_OPTION);
  if (dom == 0)
  {
    CCC::BString result;
    log.getResult(CCC::CEID_UTF8N, &result);
    fprintf(stderr, "Parser error:%s\n", result.getCString());
    return -1;
  }
  dump(dom->getDocumentElement(), 0);
  output(dom);
  
  CCC::Ccc::unInitialize();
  return 0;
}
