﻿#ifndef INCLUDE_wakach_h
#define INCLUDE_wakach_h

#include "ccc/file/PathString.h"
#include "ccc/app/Application.h"
#include "ccc/base/TextWriter.h"

class Wakati
  : public CCC::Application
{
  enum Option
  {
    OPT_MODE_VERSION = 1,
    OPT_MODE_HELP = 2,
    OPT_NORMAL = 3,
    OPT_RUBI = 4, /*!< ルビ出力 */
    OPT_PRE_JYOSHI_WAKACHI = 8,
    OPT_PRE_MITUMURA_WAKACHI = 14, /*!< 光村分かち書き */
  };
  Option run_mode;	/*!< 動作モード */
  bool rubi_flag; /*!< ルビ出力を行います */
  bool mitumura_flag; /*!< 光村分かち書きを行う */
  bool joshi_wakachi; /*!< 助詞分かち書きを行う */
  CCC::PathString source_path;	/*!< 変換元ファイル(utf8) */
  CCC::PathString dist_path;	/*!< 変換先ファイル(utf8) */
 private:
  /*!
   * コマンドラインヘルプを表示します。
   */
  virtual void showHelp();
  /*!
   * バージョン番号を表示します。
   */
  virtual void showVersion();
  void wakachi_convert_stream(CCC::BTextReader& reader, CCC::BTextWriter& writer);
  int wakati_convert_file();
  int wakati_convert_file_input();
  int wakati_convert_filter();
protected:
  /*!
   * 引数の機能番号と、現在解析中の引数位置の情報を使って、
   * アプリケーション内にオプションの情報をセットします。
   * 引数を2つ取るオプションの場合には、iの値をこのメソッド内
   * でインクリメントすることで対応します。
   * \param n 機能番号
   * \param i 引数リスト中における現在の引数解析位置
   * \param eq_str =文字列形式の追加オプション文字列
   * \retval true 正常に引数解析が行なえたことを示します。
   * \retval false 正常に引数解析が行なえなかったことを示します。
   */
  virtual bool checkArgument(int n, int& i, char* eq_str);
  /*!
   * Applicationクラスを継承したクラスで、このメソッドは
   * 上書きされることを前提としています。
   * AppArgの構造体に引数オプションと、機能番号をセットした
   * データの配列を返します。
   * 配列の最後には{0,0}を用意してください。<br>
   * 引数解析では、この構造体のデータを元に、checkArgument()メソッド
   * が呼び出されます。
   * \return AppArgの構造体
   */
  virtual CCC::AppArg* getAppArg();
 public:
  /*!
   * コンストラクタ
   */
  Wakati();
  /*!
   * \brief コンストラクタ
   *
   * mainに渡された引数をセットし、このクラスで
   * 引数の内容を解析します。
   * \param argc 引数の数
   * \param argv 引数文字列のポインタのポインタ
   */
  Wakati(int argc, char** argv);
  /*!
   * デストラクタ
   */
  virtual ~Wakati();
  /*!
   * アプリケーションの主動作を実行します。
   * \return 終了コード、正常終了を0としますが、別の意味づけを行なっても構いません。
   */
  virtual int run();
  /*!
   * アプリケーションを途中で終了します。
   * このメソッドはrun()メソッドの実行中に利用できます。
   * \param ret 終了コード、run()の返り値となります。
   */
  virtual void exit(int ret);
  /*!
   * アプリケーションを初期化します。
   * \retval true 正常に初期化できたことを示します。
   * \retval false 正常に初期化できなかったことを示します。
   */
  virtual bool initialize();
  /*!
   * アプリケーションの終了処理を行ないます。
   * \param ret run()メソッドの返した終了コードを渡します。
   * \return 終了コード、通常引数のretの値をそのまま返しますが、終了処理で
   * エラーが発生した場合などでは別の値を返すことができます。
   */
  virtual int unInitialize(int ret);

};

#endif /* INCLUDE_wakach_h */
