// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: abortpri.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of AbortPrintDialog class

#include "pword.h"

#include "abortpri.h"

#include "dialogs.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pwordpre.h"
#include "screen.h"
#include "xstr.h"


#ifdef _WIN32
// TODO:
// 16-bit Windows code doesn't support WM_CTLCOLOR message very well.
// So I ignore this function. (kudou)
#  define NCTLCOLOR
#endif

#ifndef NCTLCOLOR
// Meter control sends WM_CTLCOLOR message to parent window 
// with the following identifier with in the HIWORD of the lParam.
#define CTLCOLOR_METER	(100)
#endif

// The Meter control doesn't have any class-specific window styles.


// Meter control's class-specific window messages.
#define MM_SETPARTSINJOB	(WM_USER + 0)
#define MM_GETPARTSINJOB	(WM_USER + 1)
#define MM_SETPARTSCOMPLETE	(WM_USER + 2)
#define MM_GETPARTSCOMPLETE	(WM_USER + 3)

// Meter control has no notification codes to send to parent.

char _szControlName[] = "BWMeter";

#define CBWNDEXTRA		(4)
#define GWW_PARTSINJOB		(0)
#define GWW_PARTSCOMPLETE	(2)

PModelessDialog* AbortPrintDialog::_this = NULL;

int AbortPrintDialog::aborted = 0;
int AbortPrintDialog::abort_reported = 0;

// private method
inline int NEAR
AbortPrintDialog::Healthy()
{
  return(meter_exists_p);
}

// public constructor
AbortPrintDialog::AbortPrintDialog(char* _doc_name, char* _printer_name)
  : doc_name(_doc_name),
    printer_name(_printer_name)
{
  _this = this;
  this->class_name = "AbortPrint";
  this->aborted = 0;
  this->abort_reported = 0;
#ifdef notdef
  this->meter_exists_p = False;

  WNDCLASS wc;
  wc.style         = CS_GLOBALCLASS | CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = MeterWndFn;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = CBWNDEXTRA;
  wc.hInstance     = PWordPresentation::hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = NULL;
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = _szControlName;
  this->meter_exists_p = RegisterClass(&wc);
#else /* not notdef */
  static int registerdp = False;
  if (!registerdp)
  {
    registerdp = True;
    WNDCLASS wc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = MeterWndFn;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = CBWNDEXTRA;
    wc.hInstance     = (HINSTANCE)PWordPresentation::hInstance;
    wc.hIcon         = NULL;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = _szControlName;
    RegisterClass(&wc);
  }
#endif /* not notdef */
}

AbortPrintDialog::~AbortPrintDialog()
{
#ifdef notdef
  if (this->meter_exists_p)
  {
    this->meter_exists_p = False;
    UnregisterClass(_szControlName, PWordPresentation::hInstance);
  }
#endif /* notdef */
}

int
AbortPrintDialog::Go()
{
  if (Healthy())
  {
    PModelessDialog::Go();
    Show(SW_SHOWNORMAL);
  }
  
  return 0;
}

LRESULT_T
AbortPrintDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      main_window->Enable(0);
      aborted = 0;
      abort_reported = 0;
      if (doc_name && printer_name)
      {
	char buf[256];
	wsprintf(buf, S_AbortPrint_Msg, doc_name, printer_name);
	SetItemText(IDD_AbortPrint_Msg, buf);
      }
    }
    return 1;
    
#ifndef NCTLCOLOR
   case WM_CTLCOLOR:
    switch (HIWORD(lParam))
    {
     case CTLCOLOR_METER:
#if (0)
      HDC dc = (HDC)wParam;
      ::SetTextColor(dc, GetSysColor(COLOR_ACTIVECAPTION));
#endif
      return ::GetStockObject(WHITE_BRUSH);
#if 0
      LOGBRUSH logbrush;
      logbrush.lbColor = GetSysColor(COLOR_ACTIVECAPTION);
      logbrush.lbStyle = BS_SOLID;
      HANDLE brush = CreateBrushIndirect(&logbrush);
      return brush;
#endif
    }
    break;
#endif /* NCTLCOLOR */
    
  case WM_COMMAND:		// Cancel button
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDCANCEL:
	{
	  this->Cancel();
	  return 1;
	}
       default:
	// error
	break;
      }
    }
    break;
    
   case WM_CLOSE:
    Cancel();
    return 1;
    
   default: 
    return 0;
  }
  return 0;
}

void
AbortPrintDialog::Cancel()
{
  this->aborted=1;
  main_window->Enable(1);
  this->Destroy();
  ::StatusOut(S_PrintAbort_Cancelled);
}

void
AbortPrintDialog::SetNPages(int n)
{
  if (Healthy())
  {
    SendItemMessage(IDD_AbortPrint_Meter, MM_SETPARTSINJOB, n);
  }
}

void
AbortPrintDialog::SetDonePages(int n)
{
  if (Healthy())
  {
    SendItemMessage(IDD_AbortPrint_Meter, MM_SETPARTSCOMPLETE, n);
  }
}

BOOL
AbortPrintDialog::AbortProc_ (HDC /*hdcPrn*/, short code)
{
  if (code)
  {
    aborted = True;
  }
  else
  {
    MSG msg;
    while (!aborted && PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
      if (_this->GetHandle() == 0
	  || !::IsDialogMessage(_this->GetHandle(), &msg))
      {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
      }
    }
  }
  abort_reported = aborted;
  return(!aborted);
}

LRESULT_T
MeterWndFn_ (HWND hWnd, MSG_T wMsg, WPARAM_T wParam, LPARAM_T lParam)
{
  LONG lResult = 0;
  char szPercentage[10];
  RECT rcClient, rcPrcnt;
  PAINTSTRUCT ps;
  WORD wPartsInJob, wPartsComplete;
#ifndef NCTLCOLOR
  HBRUSH hBrush;
#endif /* NCTLCOLOR */
  DWORD dwColor;
  
  switch (wMsg) {
   case WM_GETDLGCODE:
    lResult = DLGC_STATIC;
    break;
    
   case WM_CREATE:   // lParam == &CreateStruct
    SendMessage(hWnd, MM_SETPARTSINJOB, 100, 0l);
    SendMessage(hWnd, MM_SETPARTSCOMPLETE, 50, 0);
    break;
    
   case WM_PAINT:
    wPartsInJob = (WORD) SendMessage(hWnd, MM_GETPARTSINJOB,  0, 0l);
    wPartsComplete = (WORD) SendMessage(hWnd, MM_GETPARTSCOMPLETE, 0, 0l);
    if (wPartsInJob == 0) {
      wPartsInJob = 1;
      wPartsComplete = 0;
    }
#ifdef PERCENT
    wsprintf(szPercentage, "%d%%", (100 * wPartsComplete) / wPartsInJob);
#else
    wsprintf(szPercentage, "%d/%d", wPartsComplete,wPartsInJob);
#endif
    BeginPaint(hWnd, &ps);
    
    // Set-up default foreground and background text colors.
#ifdef notdef
    SetBkColor(ps.hdc, GetSysColor(COLOR_WINDOW));
    SetTextColor(ps.hdc, GetSysColor(COLOR_WINDOWTEXT));
#else
    // fix color conbination
//#define WHITE RGB(0xff,0xff,0xff)
//#define BLACK RGB(0, 0, 0)
    SetBkColor(ps.hdc, WHITE);
    SetTextColor(ps.hdc, BLACK);
#endif

#ifndef NCTLCOLOR
    // Send WM_CTLCOLOR message to parent in case parent want to 
    // use a different color in the Meter control.
    hBrush = (HBRUSH) SendMessage(GetParent(hWnd), WM_CTLCOLOR, ps.hdc,
				  MAKELONG(hWnd, CTLCOLOR_METER));
    // Always use brush returned by parent.
    SelectObject(ps.hdc, hBrush);

#endif /* NCTLCOLOR */
    SetTextAlign(ps.hdc, TA_CENTER | TA_TOP);
    
    // Invert the foreground and background colors.
    dwColor = GetBkColor(ps.hdc);
    SetBkColor(ps.hdc, SetTextColor(ps.hdc, dwColor));
    
    // Set rectangle coordinates to include only left
    // percentage of the window.
    GetClientRect(hWnd, &rcClient);
    SetRect(&rcPrcnt, 0, 0,
            (rcClient.right * wPartsComplete) / wPartsInJob, rcClient.bottom);
    
    // Output the percentage value in the window.
    // Function also paints left part of window.
#ifdef _WIN32
    SIZE text_size;
    GetTextExtentPoint32(ps.hdc, "X", 1, &text_size);
    ExtTextOut(ps.hdc, rcClient.right / 2,
	       (rcClient.bottom - text_size.cy) / 2,
	       ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
	       szPercentage, lstrlen(szPercentage), NULL);
#else /* _WIN32 */
    ExtTextOut(ps.hdc, rcClient.right / 2,
	       (rcClient.bottom - HIWORD(GetTextExtent(ps.hdc, "X", 1))) / 2,
	       ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
	       szPercentage, lstrlen(szPercentage), NULL);
#endif /* _WIN32 */
    
    // Adjust rectangle so that it includes the remaining 
    // percentage of the window.
    rcPrcnt.left = rcPrcnt.right;
    rcPrcnt.right = rcClient.right;
    
    // Invert the foreground and background colors.
    dwColor = GetBkColor(ps.hdc);
    SetBkColor(ps.hdc, SetTextColor(ps.hdc, dwColor));
    
    // Output the percentage value a second time in the window.
    // Function also paints right part of window.
#ifdef _WIN32
    ExtTextOut(ps.hdc, rcClient.right / 2,
	       (rcClient.bottom - text_size.cy) / 2,
	       ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
	       szPercentage, lstrlen(szPercentage), NULL);
#else /* _WIN32 */
    ExtTextOut(ps.hdc, rcClient.right / 2,
	       (rcClient.bottom - HIWORD(GetTextExtent(ps.hdc, "X", 1))) / 2,
	       ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
	       szPercentage, lstrlen(szPercentage), NULL);
#endif /* _WIN32 */
    
    EndPaint(hWnd, &ps);
    break;
    
   case MM_SETPARTSINJOB:
    SetWindowWord(hWnd, GWW_PARTSINJOB, wParam);
    InvalidateRect(hWnd, NULL, FALSE);
    UpdateWindow(hWnd);
    break;
    
   case MM_GETPARTSINJOB:
    lResult = (LONG) GetWindowWord(hWnd, GWW_PARTSINJOB);
    break;
    
   case MM_SETPARTSCOMPLETE:
    SetWindowWord(hWnd, GWW_PARTSCOMPLETE, wParam);
    InvalidateRect(hWnd, NULL, FALSE);
    UpdateWindow(hWnd);
    break;
    
   case MM_GETPARTSCOMPLETE:
    lResult = (LONG) GetWindowWord(hWnd, GWW_PARTSCOMPLETE);
    break;
    
   default:
    lResult = DefWindowProc(hWnd, wMsg, wParam, lParam);
    break;
  }
  return(lResult);
}
