// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: again.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define again class, for handling again processing

#ifndef AGAIN_H
#define AGAIN_H

// All slots and methods of class Again are declared STATIC.
// Keep this rule for best performance.  (konno)

// This class manages information used in implementing Again.
//
// The basic idea is it remembers the command to do again if invoked.
// This remembering is done at a general level at the top of the
// MainWindow::Dispatch procedure.  However, some commands may wish to
// announce that they cannot be agained.  To allow this, the method
// CantDoAgain is provided; it uses a one-deep stack to restore the
// previous againable command.  This facility would be used, for instance,
// by Save, which shouldn't be againable.
//   
// Commands can also announce a companion command which should be executed
// if the AgainReverse command is invoked.  They do this with the
// ToDoAgainInOtherDirection function.  Normally the reverse command is
// zeroed out when a command to again is saved, which will just cause the
// AgainReverse command to beep.

class AgainThing
{
  friend class Again;
  
  enum
  {
    OTHER_INFO_COUNT = 8,
  };
  int command_to_do_again;
  int command_for_other_direction;
  int other_info[OTHER_INFO_COUNT];

public:
  AgainThing();
};

class Again 
{
public:
  // AgainThing is a single instance of againability.  We use it since we
  // keep a one-deep stack of againable items.
  static AgainThing STATIC_NEAR cur;
  static AgainThing STATIC_NEAR prev;
  static int STATIC_NEAR doing_again;

public:
  static int GetCommandForOtherDirection();
  static int GetCommandToDoAgain();
  static int GetDoingAgain();
  static int GetOtherInfo();
  static int GetOtherInfo(int i);
  static sjis* GetInput(int& len);
  static void BackInput();
  static void CantDoAgain();
  static void ClearInput();
  static void SetAgain(int foo);
  static void SetAgainFast(int foo);
  static void SetDoingAgain(int foo = 1);
  static void SetInput(sjis* foo, int len);
  static void SetOtherInfo(int foo);
  static void SetOtherInfo(int foo, int i);
  static void ToDoAgainInOtherDirection(int foo);
  static void init();
};

// fast code for MainWindow::Dispatch.
inline void
Again::SetAgainFast(int foo)
{
  doing_again = 0;
  prev = cur;
  cur.command_for_other_direction = cur.command_to_do_again = foo;
}

inline int
Again::GetDoingAgain()
{
  return(doing_again);
}

inline void
Again::SetDoingAgain(int foo)
{
  doing_again = foo;
}

inline int
Again::GetCommandToDoAgain()
{
  return(cur.command_to_do_again);
}

inline int
Again::GetCommandForOtherDirection()
{
  return(cur.command_for_other_direction);
}

// the application calls this to provide "other" information which it
// needs to do the action again.  Example: a command might bring up a
// dialog box, but when doing this action again, we don't want to get the
// dialog box again, but rather reapply the settings made in it

inline int
Again::GetOtherInfo(int i)
{
  return(cur.other_info[i]);
}

inline int
Again::GetOtherInfo()
{
  return(GetOtherInfo(0));
}

inline void
Again::SetOtherInfo(int foo, int i)
{
  cur.other_info[i] = foo;
}

inline void
Again::SetOtherInfo(int foo)
{
  SetOtherInfo(foo, 0);
}

#endif /* AGAIN_H */
