// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: alist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// array list class

#ifndef ALIST_H
#define ALIST_H

class ArrayList 
{
  friend class ArrayListIterator;
  
  // buffer
  void* (* buf)[];
  
  // buffer size
  uword buf_size;
  
  // list top 
  uword top;
  
  // list bottom
  uword bot;
  
public:
  ArrayList();
  ~ArrayList();
  
#define LIST_METHODS   
#include "commlist.h"   
#undef LIST_METHODS
  enum 
  {
    default_expand_size = 10,
  };
  
private:
  // right ward expand
  void RExpandBuf(uword additional_size = default_expand_size);
  
  // left ward expand
  void LExpandBuf(uword additional_size = default_expand_size);
  
  // shrink buffer
  void ShrinkBuf() 
  { ; } // do nothing now
};

// Array list iterator
class ArrayListIterator 
{
  // Array list
  ArrayList* list;
  
  // current data
  uword current;
public:
  // constructor
  ArrayListIterator(ArrayList* list);
  
  // constructor
  ArrayListIterator(ArrayList& list);
  
#define LISTITERATOR_METHODS
#include "commlist.h"
#undef LISTITERATOR_METHODS
};

inline
ArrayListIterator::ArrayListIterator(ArrayList* list)
{
  ArrayListIterator::list = list;
  current = 0;
}

inline
ArrayListIterator::ArrayListIterator(ArrayList& list)
{
  ArrayListIterator::list = &list;
  current = 0;
}

inline void*
ArrayListIterator::operator() ()
{
  return((current < list->bot - list->top) ? 
	  (*list->buf)[list->top + current++] : 0);
}

inline bool
ArrayListIterator::IsEnd()
{
  return current >= list->bot - list->top;
}

inline void
ArrayListIterator::Revert()
{
  current = 0;
}

#endif /* ALIST_H */
