// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: attribut.cpp,v 3.3 1999/06/25 23:38:36 kudou Exp $
// basic external routines for attribute system

#include "pword.h"

#include "attribut.h"

#include "pstreams.h"
#include "rats.h"
#include "sjis.h"
#include "xstr.h"

#ifdef BW2_ABBREV
AbbrevEntry&
get_abbrev_entry(unsigned int i)
{
  return(GlobalAbbrevTable.GetEntry(i));
}
#endif /* BW2_ABBREV */

AttsEntry&
get_atts_entry(unsigned int i)
{
  return(GlobalAttsTable.GetEntry(i));
}

BorderEntry&
get_border_entry(unsigned int i)
{
  return(GlobalBorderTable.GetEntry(i));
}

DerivEntry&
get_deriv_entry(unsigned int i)
{
  return(GlobalDerivTable.GetEntry(i));
}

FontEntry&
get_font_entry(unsigned int i)
{
  return(GlobalFontTable.GetEntry(i));
}

MarkEntry&
get_mark_entry(unsigned int i)
{
  return(GlobalMarkTable.GetEntry(i));
}

StyleEntry&
get_style_entry(unsigned int i)
{
  return(GlobalStyleTable.GetEntry(i));
}

// StepTextSize is used to step a font size to a next reasonable value,
// either up or down depending on the dir argument.

int StepTextSize(int cur, int dir)
{
  static int sizes[] = { 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 18, 20, 24, 36, 48, 72, 0 };
  
  return StepSize(cur, dir, sizes);
}

#ifndef NDEBUG
void
AttStatusOut(attr a)
{
  DerivEntry& adt_entry = ::get_deriv_entry(a);
  StatusOutPermanent("att=%d, how=%d, what=%d, based on style %d(%s)",
		      a, 
		      adt_entry.GetAttsIndex(),
		      adt_entry.GetResultIndex(),
		      adt_entry.GetBase(),
		      GetStyleName(GetBaseStyle(a)));
}
#endif /* not NDEBUG */

// Note: these are NOT all the tables in the attribute subsystem.
// They are only the ones that are read and written.

GenericTable* tables[] =
{
  &GlobalMarkTable,          // marks
  &GlobalBorderTable,        // borders
  &GlobalFontTable,          // fonts
  &GlobalAttsTable,          // att values
  &GlobalDerivTable,         // att derivations
  &GlobalStyleTable,         // styles
  NULL
};

#define FORALLTABLES for (GenericTable** table=tables;* table; table++)

void
InitAttributeSystem()
{
  GlobalAttsTable.Init();
  GlobalBorderTable.Init();
}

void
MarkCookieConnections(attr a)
{
  ::get_deriv_entry(a) .Mark();
}

void
UnmarkCookieConnections()
{
  FORALLTABLES
  {
    (*table) ->ClearMarks();
  }
}

void
RegenerateAttributes()
{
  GlobalDerivTable.Apply(&DerivEntry::xResolve, 0);
}

void
WriteCharAtt(PStream* stream, attr a)
{
  GlobalDerivTable.WriteEntry(stream, a);
}

attr
ReadCharAtt(PStream* stream)
{
  return(GlobalDerivTable.ReadEntry(stream));
}

#ifndef NDEBUG
// DumpAtts dumps the whole attribute table to a file called attr.tbl.
// Right now in the debugging version of pWord it is invoked with Ctrl-3.
void
DumpAtts()
{
  FILE* f = fopen("attr.tbl", "w");
  fprintf(f, "Hey Jose.  Attribute table follows.\n\n");
  FORALLTABLES
  {
    (*table) ->Dump(f);
  }
  fclose(f);
}
#endif /* not NDEBUG */

// ApplyAttList is the most general routine here -- it takes
// a list of attribute specifications and applies them to an
// existing attribute, returning the result
// It handles both character attributes and paragraph attributes
attr
ApplyAttList(attr org, AttSpecList* speclist)
{
  return(::get_deriv_entry(org) .ApplyAttList(speclist));
}

// ------------------------------------------------------------
// routines seen from outside

attr
ApplyAtt(attr org, int attcode, int attvalue)
{
  AttSpecList specs[2];
  specs[0].attcode=attcode;
  specs[0].attvalue=attvalue;
  specs[1].attcode=0;
  return ApplyAttList(org, specs);
}

// ------------------------------------------------------------
// retrieve attribute values

// create a completely blank set of attributes and put in att table
attr
get_default_attributes(Paragraph* par)
{
  DerivEntry adt_entry;
  adt_entry.SetAttsIndex(par ? UnknownCharAtts : UnknownParAtts);
  return((attr) adt_entry.Enter());
}

FontMetric* 
get_font_metric(attr attrib, int kanjip, int tategakip)
{
  DerivEntry& de = ::get_deriv_entry(attrib);
  AttsEntry& ae = de.GetResultEntry();
  if (ae.rat_entry == NULL)
  {
    ae.rat_entry = new RATEntry(de.GetResultIndex());
  }
  FontMetric* fm = ae.rat_entry->GetFontMetric(kanjip);
  if (tategakip)
  {
    fm = fm->get_tategaki_font_metric();
  }
  return(fm);
}

int* 
get_atts(attr a)
{
  return(::get_deriv_entry(a) .GetResultEntry() .vals);
}

// GetAttValue gets the final, derived attributes in effect at an
// attribute cookie
int
GetAttValue(attr a, int attcode)
{
  return(get_atts(a) [attcode]);
}

void
GetAttValueList(attr a, AttSpecList* specs)
{
  int* vals = get_atts(a);
  for (; specs->attcode; ++specs)
  {
    specs->attvalue = vals[specs->attcode];
  }
}

// ------------------------------------------------------------
// Styles

// DefineStyle is an internal routine to define styles.
// It returns a style code(index into style table)

static int NEAR
DefineStyle(unsigned int style, attr attributes)
{
  // get the attribute table entries for the added stuff
  DerivEntry& deriv_entry = ::get_deriv_entry(attributes);
  AttsEntry& at_entry = deriv_entry.GetAttsEntry();
  
  // create a new attribute table entry to be used to merge these two
  AttsEntry new_at_entry(at_entry);
  
  // get the attribute derivation table entry defining the style
  if (deriv_entry.GetBase() != NULL)
  {
    StyleEntry &st_entry = deriv_entry.GetStyleEntry();
    if (st_entry.GetAttsIndex() != 0)
    {
      new_at_entry.FillIn(st_entry.GetAttsEntry());
    }
  }
  
  // put the new entry in the attribute table
  int new_at_index = new_at_entry.Enter();
  
  // These are the attributes for the style
  ::get_style_entry(style) .SetAttsIndex(new_at_index);
  return(style);
}

static int NEAR
DefineStyle(char* name, attr attributes, int typ)
{
  assert(name != NULL
	  && name[0] != '\0'
	  && attributes != 0
	  && (typ == AttsEntry::PARSTYLE || typ == AttsEntry::CHARSTYLE));
  assert(GlobalStyleTable.FindEntry(name, typ, False) == 0);
  
  // this is the new entry we are creating
  StyleEntry e(name, typ);
  return(::DefineStyle(e.Enter(), attributes));
}

int
GetStyleAttValue(int style, int attcode)
{
  return(::get_style_entry(style) .GetAttsEntry() .vals[attcode]);
}

int
DefineCharStyle(char* name, attr atts)
{
  return DefineStyle(name, atts, AttsEntry::CHARSTYLE);
}

int
DefineParaStyle(char* name, attr atts)
{
  return DefineStyle(name, atts, AttsEntry::PARSTYLE);
}

int
RedefineCharStyle(unsigned int style, attr atts)
{
  return DefineStyle(style, atts);
}

int
RedefineParaStyle(unsigned int style, attr atts)
{
  return DefineStyle(style, atts);
}

int
DerivationMarked(attr a)
{
  return(::get_deriv_entry(a) .GetMark());
}

attr
PureStyle(attr atts)
{
  // get attribute derivation table entry
  DerivEntry& adt_entry = ::get_deriv_entry(atts);
  
  // we need to look at this to get the type
  AttsEntry& atts_entry = adt_entry.GetResultEntry();
  
  // make a new attribution derivation table entry and put in table
  DerivEntry new_adt_entry(adt_entry);
  new_adt_entry.SetAttsIndex((atts_entry.type == AttsEntry::CHARSTYLE) ? 
			      UnknownCharAtts : UnknownParAtts);
  uword adt_index = new_adt_entry.Enter();
  return adt_index;
}

attr
ApplyStyle(attr atts, int style)
{
  // get attribute derivation table entry
  DerivEntry& adt_entry = ::get_deriv_entry(atts);
  
  // applying styles is now defined as REMOVING locally applied attributes.
  uword new_atts_index = adt_entry.GetAttsIndex();
  if (style != 0)
  {
    AttsEntry& style_atts_entry = ::get_style_entry(style) .GetAttsEntry();
    AttsEntry& atts_entry = adt_entry.GetAttsEntry();
    AttsEntry new_atts_entry(atts_entry);
    new_atts_entry.SubtractAny(style_atts_entry);
    new_atts_index = new_atts_entry.Enter();
  }
  
  // create a new ADT entry with same atts but new style
  DerivEntry new_adt_entry(new_atts_index, style);
  return new_adt_entry.Enter();
}


// GetBaseStyle -- get base style for attributes
int
GetBaseStyle(attr a)
{
  return(::get_deriv_entry(a) .GetBase());
}

char* 
GetStyleName(int s)
{
  return(s == 0 ? S_none_style_name
	  : ::get_style_entry(s) .get_pure_name());
}

int
GetStyleType(uword s)
{
  return(s == 0 ? 0 : ::get_style_entry(s) .GetType());
}

// make a good paragraph att for the next para
attr
MakeNextParAtt(attr a)
{
  attr ret = a;
  
  DerivEntry& deriv = ::get_deriv_entry(a);
  AttsEntry& atts = deriv.GetAttsEntry();
  
#ifdef ESCAPE_FROM_PAR_BOXES
  if ((atts.vals[ PA_placement ] != PL_none) || (atts.vals[ PA_lines ] != 0))
  {
    AttsEntry natts(atts);
    natts.vals[ PA_placement ] = AttsEntry::UNKNOWN;
    natts.vals[ PA_lines ] = AttsEntry::UNKNOWN;
    unsigned int attindex = natts.Enter();
    DerivEntry nderiv(deriv);
    nderiv.SetAttsIndex(attindex);
    ret = nderiv.Enter();
  }
#else
  if (atts.vals[ PA_placement ] != PL_none)
  {
    AttsEntry natts(atts);
    natts.vals[ PA_placement ] = AttsEntry::UNKNOWN;
    unsigned int attindex = natts.Enter();
    DerivEntry nderiv(deriv);
    nderiv.SetAttsIndex(attindex);
    ret = nderiv.Enter();
  }
#endif
  return ret;
}
