// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: atts.h,v 3.3 1999/07/24 15:38:09 kudou Exp $
// AttsEntry is a class which defines attribute value sets, where
// each attribute has a value(or UNKNOWN).  These things are pointed to both
// in RATEntry's(entries in the resolved attribute table) and in
// ADSEntry's(entries in the attribute derivation source table).

#ifndef ATTS_H
#define ATTS_H

#include "generics.h"

class DerivEntry;
class RATEntry;

class AttsEntry
  : public GenericEntry
{
  friend class BaseAttsTable;
  
public:
  enum AttCodes
  {
#ifdef _WIN32
    // Next value should be a short int (attr) minimum number. (kudou)
    UNKNOWN = 0xffff8000,	// not set, not defined
#else /* _WIN32 */
    UNKNOWN = (int) 0x8000,	// not set, not defined
#endif /* _WIN32 */
    NUMATTS = 16,		// must be > #par atts and #char atts
    CHARSTYLE = 1,		// character style entry
    PARSTYLE = 2,		// paragraph style entry
  };
  
  int vals[NUMATTS];
  int type;			// one of xxxSTYLE constants above
  RATEntry* rat_entry;
  
public:
  AttsEntry();
  AttsEntry(int type);
  AttsEntry(AttsEntry&);	// copy constructor
  AttsEntry(DerivEntry&);	// construct based on derivation
  AttsEntry(int type, int*);	// construct from values
  
private:
  unsigned char NEAR AttsEntry::GetHash();
  void NEAR AttsEntry::Init();
public:
  int AttsEntry::AllUnknown();
  unsigned int AttsEntry::Enter();
  void AttsEntry::CopyVals(AttsEntry&);
  void AttsEntry::FillIn(AttsEntry&);
  void AttsEntry::Mark();
  void AttsEntry::Plug(DerivEntry&);
  void AttsEntry::ReadFromStream(PStream*);
  void AttsEntry::Subtract(AttsEntry&);
  void AttsEntry::SubtractAny(AttsEntry&);
  void AttsEntry::WriteToStream(PStream*);
#ifndef NDEBUG
  void AttsEntry::Dump(unsigned int i, void*);
  static void AttsEntry::DumpHeader(FILE* f);
#endif

public:
  friend int operator == (AttsEntry&, AttsEntry&);
};

// ------------------------------------------------------------
// TABLE

#define T AttsEntry
#define TABLE BaseAttsTable
#define SEG BaseAttsTableSeg
#define DO_READ_WRITE
#include "tabletem.h"

extern unsigned int DefaultCharAtts;
extern unsigned int DefaultParAtts;
extern unsigned int UnknownCharAtts;
extern unsigned int UnknownParAtts;

class AttsTable
  : public BaseAttsTable
{
public:
  void Init();
  void SetDefaultSize(int);
};

extern AttsTable STATIC_NEAR GlobalAttsTable;

#endif /* ATTS_H */
