// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: autosave.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the AutoSaveDialog class dialog box

#include "pword.h"
#include "autosave.h"
#include <stdlib.h>
#include "dialogs.h"
#include "document.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pref.h"
#include "ptimer.h"
#include "pword.h"
#include "pwordbas.h"

// ------------------------------------------------------------
// STATICS

// used in running autosave
PTimer* AutoSaveDialog::timer          = 0;
int AutoSaveDialog::mins_remaining     = 0;
bool AutoSaveDialog::suppress_autosave = False;
bool AutoSaveDialog::do_autosave       = False;

AutoSaveDialog::AutoSaveDialog()
{
  this->class_name = "AutoSave";
}

LRESULT_T
AutoSaveDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  int tempfreq = Pref_auto_save_frequency;
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      this->SendItemMessage(IDD_AutoSave_Activate,
			     BM_SETCHECK, Pref_auto_save);
      this->SendItemMessage(IDD_AutoSave_Confirm,
			     BM_SETCHECK, Pref_auto_save_confirm);
      this->SetItemInt(IDD_Value, Pref_auto_save_frequency);
      this->SendItemMessage(IDD_Value, EM_LIMITTEXT, 2);
      this->Enable(Pref_auto_save);
    }
    return(1);
    
   case WM_COMMAND:
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_Value:
	{
#ifdef _WIN32
	  switch (HIWORD(wParam))
#else /* _WIN32 */
	  switch (HIWORD(lParam))
#endif /* _WIN32 */
	  {
	   case EN_CHANGE:
	   case EN_UPDATE:
	    {
	      int ok;
	      tempfreq = this->GetItemInt(IDD_Value, &ok);
	      ::EnableWindow(GetItem(IDOK), 
			      (ok != 0
			       && MIN_AUTO_SAVE_FREQUENCY <= tempfreq
			       && tempfreq <= MAX_AUTO_SAVE_FREQUENCY));
	    }
	    break;
	   default:
	    break;
	  }
	}
	break;
	
       case(IDD_AutoSave_Activate):
	{
	  Enable(get_item_check(IDD_AutoSave_Activate));
	}
	break;
	
       case IDOK: 
	{
	  Pref_auto_save = this->get_item_check(IDD_AutoSave_Activate);
	  Pref_auto_save_confirm = this->get_item_check(IDD_AutoSave_Confirm);
	  int ok;
	  Pref_auto_save_frequency = this->GetItemInt(IDD_Value, &ok);
	  End(1);
	}
	return(1);
	
       case IDCANCEL:
	{
	  End(0);
	}
	return(1);
	
       default:
	break;
      }
      break;
    }
    
   case WM_CLOSE:
    End(0);
    return(1);
    
   default: 
    return(0);
  }
  return(0);
}

void 
AutoSaveDialog::Restart()
{
  delete AutoSaveDialog::timer;
  AutoSaveDialog::timer = 0;
  if (Pref_auto_save)
  {
    AutoSaveDialog::timer = new PTimer(main_window,
					0, 
					60000u, 
					(TIMERPROC) AutoSaveDialog::DoSave);
  }
  AutoSaveDialog::mins_remaining = Pref_auto_save_frequency;
}

int 
AutoSaveDialog::Go()
{
  AutoSaveDialog::suppress_autosave = True;
  int result = PModalDialog::Go();
  if (result)
  {
    Restart();
  }
  AutoSaveDialog::suppress_autosave = False;
  return(result);
}

void FAR PASCAL
AutoSaveDialog::DoSave_ (HWND, UINT, UINT, DWORD)
{
  if (--AutoSaveDialog::mins_remaining <= 0)
  {
    AutoSaveDialog::do_autosave = True;
    AutoSaveDialog::mins_remaining = Pref_auto_save_frequency;  // reset
  }
}

void
AutoSaveDialog::Do()
{
  if (AutoSaveDialog::do_autosave
      && !AutoSaveDialog::suppress_autosave
      && main_window->GetSize() != SIZEICONIC
      && main_window_handle == ::GetActiveWindow())
  {
    AutoSaveDialog::suppress_autosave = True;
    PWordBase::QueryEndSession(True /*local*/, Pref_auto_save_confirm);
    AutoSaveDialog::suppress_autosave = False;
    AutoSaveDialog::do_autosave = False;
  }
}

void 
AutoSaveDialog::Enable(int on)
{
  ::EnableWindow(this->GetItem(IDD_AutoSave_Confirm), on);
  ::EnableWindow(this->GetItem(IDD_Value), on);
  ::EnableWindow(this->GetItem(IDD_AutoSave_Frequency), on);
  ::EnableWindow(this->GetItem(IDD_AutoSave_Minutes), on);
}

