// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: autosave.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define AutoSaveDialog class

#ifndef AUTOSAVE_H
#define AUTOSAVE_H

#include "dlg.h"

class AutoSaveDialog
  : public NoKanjiModalDialog
{
private:
  // autosave parameters
  static bool do_autosave;
  
  // used in running autosave
  static PTimer* timer;
  static int mins_remaining;
  static bool suppress_autosave;

public:
  AutoSaveDialog();
  
private: // functions
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // utilities for running dialog box
  void Enable(int on);
  
  // located in ../wutil/export.c
  static void FAR PASCAL _export DoSave(HWND, UINT, UINT, DWORD);
  static void FAR PASCAL DoSave_ (HWND, UINT, UINT, DWORD);

public:
  static void Restart();

  // virtual function from class PModalDialog
  int Go();

  static bool AutoSaveDialog::GetAutoSave();

  // called to actually perform save
  static void AutoSaveDialog::Do();
};

inline bool
AutoSaveDialog::GetAutoSave()
{
  return AutoSaveDialog::do_autosave;
}

#endif /* AUTOSAVE_H */
