// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: base.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// implement BaseInterval and BaseIntervalList classes

#include "pword.h"
#include "base.h"
#include "pundo.h"

BaseIntervalList::BaseIntervalList()
{
  Init();
}

BaseIntervalList::BaseIntervalList(BaseInterval* i)
{
  Init();
  head = i;
}

void
BaseIntervalList::Copy(BaseIntervalList* il)
{
  BaseInterval** plug = &head;
  
  for (BaseInterval* i = il->head; i; i=i->next) {
    BaseInterval* copy = NewMember(i);
    *plug = copy;
    plug = & (copy->next);
  }
  *plug = 0;
}

void
BaseIntervalList::Init()
{
  head = 0;
}

BaseIntervalList::~BaseIntervalList()
{
  BaseIntervalListTraversor ilt(this);
  BaseInterval* i;
  while ((i=ilt.GetNext()) != 0)
  {
    delete i;
  }
}


// ------------------------------------------------------------
// List Manipulation

// add an interval to the list -- at its end
void
BaseIntervalList::AddIntervalAtTail(BaseInterval* i)
{
  THIS_CHECK;
  BaseInterval** here = &head;
  while (*here) {
    here = & ((*here)->next);
  }
  *here = i;
}

// add another interval to the list -- at its head
void
BaseIntervalList::AddIntervalAtHead(BaseInterval* i)
{
  THIS_CHECK;
  if (i)
  {
    i->next = head;
    head = i;
  }
}

// delete an interval from the list
void
BaseIntervalList::DeleteInterval(BaseInterval* i)
{
  THIS_CHECK;
  BaseInterval** hereptr = &head;
  
  while (*hereptr)
  {
    if (*hereptr == i)
    {
      *hereptr = (*hereptr)->next;
      delete i;
      break;
    }
    hereptr = & (*hereptr)->next;
  }
}

void
BaseIntervalList::CutOffTail()
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt(this);
  BaseInterval* i = ilt.GetNext();
  while ((i=ilt.GetNext()) != 0)
  {
    delete i;
  }
  head->next = 0;
}

void
BaseIntervalList::CutOffHead()
{
  if (head)
  {
    BaseInterval* new_head = head->next;
    if (new_head)
    {
      delete head;
      head = new_head;
    }
  }
}

// Cycle() -- move the first interval on the list to the back
void
BaseIntervalList::Cycle(int direction)
{
  THIS_CHECK;
  BaseInterval* first = this->head;
  if (first != NULL && first->next != NULL)
  {
    if (0 < direction)
    {
      this->head = first->next;
      first->next = NULL;
      this->AddIntervalAtTail(first);
    }
    else
    {
      BaseInterval* tail;
      BaseInterval* prev = first;
      for (;;)
      {
	tail = prev->next;
	if (tail->next == NULL)
	{
	  break;
	}
	prev = tail;
      }
      prev->next = NULL;
      this->AddIntervalAtHead(tail);
    }
  }
}

// see if two interval lists are the same.
// The plan is to traverse both of them.  Any non-matching
// intervals disqualify.  The traverse stops when either side
// ends;  equality holds only if they both ran out at the same time.
int
BaseIntervalList::EQ(BaseIntervalList &il)
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt1(this);
  BaseIntervalListTraversor ilt2(&il);
  
  BaseInterval* i1;
  BaseInterval* i2;
  
  while (1)
  {
    i1=ilt1.GetNext();
    i2=ilt2.GetNext();
    
    if (!i1 || !i2) break;
    
    if (i1->EQ(*i2)) // virtual function call
    {
      continue;
    }
    return 0;
  }
  if (!i1 && !i2)
  {
    return 1;
  }
  return 0;
}

// Apply() -- apply a function on intervals to all intervals
void
BaseIntervalList::Apply(void(BaseInterval::*func) ())
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt(this);
  BaseInterval* i;
  while ((i = ilt.GetNext()) != 0)
  {
    (i->*func) ();
  }
}

bool
BaseIntervalList::SingleP()
{
  THIS_CHECK;
  return head && head->next ? False : True;
}

int
BaseIntervalList::Count()
{
  int n=0;
  BaseIntervalListTraversor ilt(this);
  while (ilt.GetNext())
  {
    n++;
  }
  return n;
}

void
BaseIntervalList::Reverse()
{
  BaseInterval* prev = 0;
  BaseInterval* here = head;
  while (here)
  {
    BaseInterval* old_next = here->next;
    here->next = prev;
    prev = here;
    here = old_next;
  }
  head = prev;
}


// ------------------------------------------------------------
// List Traversal

BaseIntervalListTraversor::BaseIntervalListTraversor(BaseIntervalList* il)
{
  this->cur = il ? il->head : NULL;
}

BaseIntervalListTraversor::BaseIntervalListTraversor(BaseInterval* i)
{
  this->cur = i;
}

BaseInterval* 
BaseIntervalListTraversor::GetNext()
{
  THIS_CHECK;
  BaseInterval* result = this->cur;
  if (result)
  {
    this->cur = result->next;
  }
  return(result);
}
