// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: blueprin.cpp,v 3.4 1999/07/05 13:29:47 kudou Exp $
// class BluePrint
// t[\t@CZ[uA[hړIŎgNX
// ʏ̃t[\kނ`ŕ\ĂB
// BluePrint kނt[\Ŝ\AFrameStage 
// X̃t[LqB
// BluePrint  FrameStage ɏ]ăvC FissionFrame ɂ
// t[\oオB

#include "pword.h"

class FrameStage
{
public:
  enum Command 
  {
    Dummy     = 0,
    Create	= 0,
    Divide	= 1,
    Vanish	= 2,
    Flow	= 3,
    Border	= 4,		// Don't use for file save
    SegBorder	= 5,
    Object	= 6,
  };
  
  enum 
  { MaxParameter = 5, };
  
private:
  // stage command
  Command command;
  
  // parameter
  uword param[MaxParameter];
  
public:
  // constructor
  NEAR FrameStage(Command com = Dummy, 
		   uword p1 = 0, uword p2 = 0, 
		   uword p3 = 0, uword p4 = 0, uword p5 = 0);
  
  // get stage command
  Command NEAR GetCommand() 
  {
    return command;
  }
  
  // get param
  uword NEAR GetParam(uword index) 
  {
    return param[index];
  }
  
  // set param
  void NEAR SetParam(uword index, uword p) 
  {
    param[index] = p;
  }
};

#ifdef _WIN32
struct Bw2_FrameStage
{
  bit16_enum_t command;
  uword param[FrameStage::MaxParameter];
};
#endif /* _WIN32 */

#include "gslist.h"
GSListDeclare(FrameStage);
typedef GSList(FrameStage)         FrameStageList;
typedef GSListIterator(FrameStage) FrameStageIterator;
#define FRAMESTAGELIST_DEFINED

class Seed;
GSListDeclare(Seed);
typedef GSList(Seed)               SeedList;
typedef GSListIterator(Seed)       SeedListIterator;
#define SEEDLIST_DEFINED
  
#include "flist.h"
#include "frametem.h"
#include "fillobjc.h"
#include "grphobjc.h"
#include "picture.h"
#include "allayout.h"
#include "seeds.h"
#include "blueprin.h"
#include "pagesize.h"
#include "table.h"
#include "metafile.h"
#include "mfobject.h"
#include "unknowno.h"
#include "fission.h"
#include "frameown.h"
#include "foiterat.h"
#include "pstreams.h"
#include "borderli.h"
#include "borders.h"
  
#ifndef NDEBUG
#include "ddisplay.h"
#endif
  
NEAR
FrameStage::FrameStage(Command com,
			uword p1, uword p2, uword p3, uword p4, uword p5)
{
  command = com;
  param[0] = p1;
  param[1] = p2;
  param[2] = p3;
  param[3] = p4;
  param[4] = p5;
}
  
// constructor
BluePrint::BluePrint(FissionFrame* ff)
{
  stages = new FrameStageList();
  seeds  = new SeedList();
  MakeSeed(ff);
  MakeStages(ff);
  version = 0;
}

// constructor for file load 
BluePrint::BluePrint()
{
  stages = new FrameStageList();
  seeds  = new SeedList();
  version = 0;
}

// destructor
BluePrint::~BluePrint()
{
  FrameStage* fs = 0;
  while ((fs = stages->Pop()) != 0) 
  {
    delete fs;
  }
  delete stages;
  
  Seed* s = 0;
  while ((s = seeds->Pop()) != 0) 
  {
    delete s;
  }
  delete seeds;
}

// save
void 
BluePrint::Save(PStream* stream)
{
  // save header and version
  stream->StartBlockOut(PStream::HDR_BLUEPRINT, save_version);
  CHECK;
  
  // save seeds
  SaveSeeds(stream);
  CHECK;
  
  // save stages
  SaveStages(stream);
  CHECK;
  
  stream->EndBlockOut();
}

// save 
void NEAR
BluePrint::SaveSeeds(PStream* stream)
{
  stream->OutUWord(seeds->Number()); CHECK;
  
  Seed* s = 0;
  SeedListIterator sli(seeds);
  while ((s = sli()) != 0) 
  {
    s->Save(stream);
    CHECK;
  }
}

void NEAR
BluePrint::SaveStages(PStream* stream)
{
  stream->OutUWord(stages->Number());
  
  FrameStage* fs = 0;
  FrameStageIterator fsi(stages);
  //int size = sizeof(FrameStage);
  while ((fs = fsi()) != 0) 
  {
    stream->OutUWord(fs->GetCommand());
    CHECK;
    for (uword index = 0; index < FrameStage::MaxParameter; index++) 
    {
      stream->OutUWord(fs->GetParam(index));
      CHECK;
    }
    switch (fs->GetCommand()) 
    {
     case FrameStage::SegBorder:
      {
	GlobalBorderTable.WriteEntry(stream, fs->GetParam(3));
      }
      break;
     case FrameStage::Border:
      {
	GlobalBorderTable.WriteEntry(stream, fs->GetParam(1));
      }
      break;
     default:
      break;
    }
  }
}

// load
void 
BluePrint::Load(PStream* stream)
{
  // load header and version
  stream->StartTypedBlockIn(PStream::HDR_BLUEPRINT, version);
  CHECK;
  
  // load seeds
  LoadSeeds(stream);
  CHECK;
  
  // load stages
  LoadStages(stream);
  CHECK;
  
  stream->EndBlockIn();
}

// load
void NEAR
BluePrint::LoadSeeds(PStream* stream)
{
  uword num = stream->InUWord();
  CHECK;
  
  for (uword n = 1; n <= num; n++) 
  {
    Seed* s = Seed::Load(stream, version);
    CHECK;
    seeds->Inject(s);
  }
}

void NEAR
BluePrint::LoadStages(PStream* stream)
{
  uword num = stream->InUWord();
  CHECK;
  
#ifdef _WIN32
  int size = sizeof(Bw2_FrameStage);
#else /* _WIN32 */
  int size = sizeof(FrameStage);
#endif /* _WIN32 */
  for (uword n = 1; n <= num; n++) 
  {
    FrameStage* fs;
    if (version >= 3) 
    {
      FrameStage::Command com = (FrameStage::Command)stream->InUWord();
      CHECK;
      fs = new FrameStage(com);
      for (uword index = 0; index < FrameStage::MaxParameter; index++) 
      {
	uword prm = stream->InUWord();
	CHECK;
	fs->SetParam(index, prm);
      }
    }
    else 
    {
#ifdef _WIN32
      // for to read old version of beatword file.
      Bw2_FrameStage bw2fs;
      stream->In(&bw2fs, size);
      fs = new FrameStage((FrameStage::Command)bw2fs.command,
			  bw2fs.param[0],
			  bw2fs.param[1],
			  bw2fs.param[2],
			  bw2fs.param[3],
			  bw2fs.param[4]);
#else /* _WIN32 */
      fs = new FrameStage();
      stream->In(fs, size);
#endif /* _WIN32 */
      CHECK;
    }
    switch (fs->GetCommand()) 
    {
     case FrameStage::SegBorder:
      fs->SetParam(3, GlobalBorderTable.ReadEntry(stream));
      break;
     case FrameStage::Border:
      fs->SetParam(1, GlobalBorderTable.ReadEntry(stream));
      break;
     default:
      break;
    }
    stages->Inject(fs);
    CHECK;
  }
}

// add seed
void NEAR
BluePrint::AddSeed(Seed* s)
{
  seeds->Inject(s);
}

// make seed
void 
BluePrint::MakeSeed(FissionFrame* ff)
{
  FOIterator fri(ff);
  FrameObject* fo;
  while ((fo = fri()) != 0) 
  {
    Seed* s = Seed::GenerateSeed(fo);
    seeds->Inject(s);
  }
}

uword NEAR
BluePrint::GetSeedId(FissionFrame* ff, FrameObject* fr)
{
  FOIterator foi(ff);
  uword n = 0;
  FrameObject* fo;
  while ((fo = foi()) != 0)
  {
    n++;
    if (fo == fr)
    {
      break;
    }
  }
  return n;
}

void NEAR
BluePrint::AddStage(FrameStage* stage)
{
  stages->Inject(stage);
}

// get stage
FrameStage* NEAR
BluePrint::GetStage(uword index)
{
  return stages->Access(index);
}

// get fission number
uword 
GetFNum(FList& fl, Fission* f)
{
  return fl.Number() - fl.Search(f) + 1;
}

// frame script generater
void NEAR
BluePrint::MakeStages(FissionFrame* ff)
{
  FList gl;		// generated list
  FrameStage* stage = 0;
  
  // make fission frame script
  {
    // create fission-frame
    gl.Push(ff->GetTop());
    gl.Push(ff->GetLeft());
    gl.Push(ff->GetRight());
    gl.Push(ff->GetBottom());
    Vector v(ff->GetSize());
    
    stage = new FrameStage(FrameStage::Create, v.x, v.y);
    AddStage(stage);
    
    // create fission
    FList lg;			// late generation list
    Fission* top    = ff->GetTop();
    Fission* bottom = ff->GetBottom();
    Fission* left   = ff->GetLeft();
    Fission* right  = ff->GetRight();
    Fission* f;
    FissionIterator fi(ff);
    while ((f = fi()) != 0) 
    {
      if ((f != top) && (f != bottom) && (f != left) && (f != right)) 
      {
	if ((gl.Search(f->GetStartFission()) != 0) &&
	    (gl.Search(f->GetEndFission()) != 0)) 
	{
	  // find
	  // add generated list
	  gl.Push(f);
	  
	  // divide fission
	  stage = new FrameStage(FrameStage::Divide,
				  GetFNum(gl, f->GetStartFission()),
				  GetFNum(gl, f->GetEndFission()),
				  f->GetPoint());
	  AddStage(stage);
	  
	  // check dependant
	  bool done_flag = True;
	  while (done_flag) 
	  {
	    FListIterator fli(lg);
	    Fission* f;
	    while ((f = fli()) != 0)
	    {
	      if ((gl.Search(f->GetStartFission()) != 0) &&
		  (gl.Search(f->GetEndFission()) != 0)) 
	      {
		// now the time to create fission
		gl.Push(f);		// add generated list
		lg.Delete(f);		// remove from late generation list
		
		// divide fission
		FrameStage* stage = 
		new FrameStage(FrameStage::Divide,
				GetFNum(gl, f->GetStartFission()),
				GetFNum(gl, f->GetEndFission()),
				f->GetPoint());
		AddStage(stage);
		break;
	      }
	    }
	    if (f == 0) 
	    {
	      done_flag = False;
	    }
	  }
	}
	else 
	{
	  // late generation
	  lg.Inject(f);
	}
      }
    }
  }
  
  // set all border
  {
    FListIterator fli(gl);
    Fission* f;
    while ((f = fli()) != 0) 
    {
      CrossPoint* from = f->GetStartCrossPoint();
      if (f->GetDir() == Fission::Vertical) 
      {
	do 
	{
	  CrossPoint* to = from->GetVNext();
	  uword bl = from->GetVBorder();
	  
	  // position
	  stage = new FrameStage(FrameStage::SegBorder,
				  GetFNum(gl, f),
				  GetFNum(gl, from->GetHFission()),
				  GetFNum(gl, to->GetHFission()),
				  bl);
	  AddStage(stage);
	  
	  from = to;
	} while (from->GetVNext() != 0);
      }
      else 
      {	// horizontal
	do 
	{
	  CrossPoint* to = from->GetHNext();
	  uword bl = from->GetHBorder();
	  
	  stage = new FrameStage(FrameStage::SegBorder,
				  GetFNum(gl, f),
				  GetFNum(gl, from->GetVFission()),
				  GetFNum(gl, to->GetVFission()),
				  bl);
	  AddStage(stage);
	  
	  from = to;
	} while (from->GetHNext() != 0);
      }
    }
  }
  
  // set seeding command
  FOIterator fri(ff);
  FrameObject* fr;
  while ((fr = fri()) != 0)
  {
    if (fr->IsFirstObject()) 
    {
      do 
      {
	// object command
	stage = new FrameStage(FrameStage::Object,
				GetFNum(gl, fr->GetCrossPoint()->
					 GetVFission()),
				GetFNum(gl, fr->GetCrossPoint()->
					 GetHFission()),
				GetSeedId(ff, fr));
	AddStage(stage);
	
	FrameObject* src = fr;
	for (FrameObject* fo = fr->GetNextFrameObject();
	     fo != 0;
	     fo = fo->GetNextFrameObject()) 
	{
	  // flow command
	  stage = new FrameStage(FrameStage::Flow,
				  GetFNum(gl, src->GetCrossPoint()->
					   GetVFission()),
				  GetFNum(gl, src->GetCrossPoint()->
					   GetHFission()),
				  GetFNum(gl, fo->GetCrossPoint()->
					   GetVFission()),
				  GetFNum(gl, fo->GetCrossPoint()->
					   GetHFission()),
				  GetSeedId(ff, fo));
	  AddStage(stage);
	  src = fo;
	}
      } while ((fr = fr->GetNextLinkObject()) != 0);
    }
  }
}

void 
BluePrint::CopyRegion(FrameOwner* fo, FrameRectRgn& rgn, bool insert_line)
{
  HFission* top = rgn.GetTop();
  HFission* bot = rgn.GetBottom();
  VFission* lft = rgn.GetLeft();
  VFission* rgh = rgn.GetRight();
  
  FissionFrame* ff = fo->GetFissionFrame();
  Iunit x1 = lft->X();
  Iunit x2 = rgh->X();
  Iunit y1 = top->Y();
  Iunit y2 = bot->Y();
  
  FList gl;		// generated list
  gl.Push(top);
  gl.Push(lft);
  gl.Push(rgh);
  gl.Push(bot);
  
  FrameStage* stage = 0;
  // make fission frame script
  {
    // create fission
    FList lg;			// late generation list
    Fission* f;
    FissionIterator fi(ff);
    while ((f = fi()) != 0) 
    {
      CrossPoint* cp_s = f->GetStartCrossPoint();
      CrossPoint* cp_e = f->GetEndCrossPoint();
      if ((f != top) && (f != bot) &&
	  (f != lft) && (f != rgh) &&
	  (cp_s->X() >= x1) && (cp_s->X() <= x2) &&
	  (cp_e->X() >= x1) && (cp_e->X() <= x2) &&
	  (cp_s->Y() >= y1) && (cp_s->Y() <= y2) &&
	  (cp_e->Y() >= y1) && (cp_e->Y() <= y2))
      {
	if ((gl.Search(f->GetStartFission()) != 0) &&
	    (gl.Search(f->GetEndFission()) != 0)) 
	{
	  // find
	  // add generated list
	  gl.Push(f);
	  
	  // divide fission
	  Iunit pos = f->GetPoint();
	  if (f->GetDir() == Fission::Vertical)
	  {
	    if (!insert_line)
	    {
	      pos -= x1;
	    }
	  }
	  else
	  {
	    if (insert_line)
	    {
	      pos -= y1;
	    }
	  }
	  stage = new FrameStage(FrameStage::Divide,
				  GetFNum(gl, f->GetStartFission()),
				  GetFNum(gl, f->GetEndFission()),
				  pos);
	  AddStage(stage);
	  
	  // check dependant
	  bool done_flag = True;
	  while (done_flag) 
	  {
	    FListIterator fli(lg);
	    Fission* f;
	    while ((f = fli()) != 0)
	    {
	      if ((gl.Search(f->GetStartFission()) != 0) &&
		  (gl.Search(f->GetEndFission()) != 0)) 
	      {
		// now the time to create fission
		gl.Push(f);		// add generated list
		lg.Delete(f);		// remove from late generation list
		
		// divide fission
		pos = f->GetPoint();
		if (f->GetDir() == Fission::Vertical)
		{
		  if (!insert_line)
		  {
		    pos -= x1;
		  }
		}
		else
		{
		  if (insert_line)
		  {
		    pos -= y1;
		  }
		}
		FrameStage* stage = 
		new FrameStage(FrameStage::Divide,
				GetFNum(gl, f->GetStartFission()),
				GetFNum(gl, f->GetEndFission()),
				pos);
		AddStage(stage);
		break;
	      }
	    }
	    if (f == 0) 
	    {
	      done_flag = False;
	    }
	  }
	}
	else 
	{
	  // late generation
	  lg.Inject(f);
	}
      }
    }
  }
  
  //
  // set all border
  //
  {
    FListIterator fli(gl);
    Fission* f;
    while ((f = fli()) != 0) 
    {
      if ((f != top) && (f != bot) && (f != lft) && (f != rgh))
      {
	CrossPoint* from = f->GetStartCrossPoint();
	if (f->GetDir() == Fission::Vertical) 
	{
	  do 
	  {
	    CrossPoint* to = from->GetVNext();
	    uword bl = from->GetVBorder();
	    
	    // position
	    stage = new FrameStage(FrameStage::SegBorder,
				    GetFNum(gl, f),
				    GetFNum(gl, from->GetHFission()),
				    GetFNum(gl, to->GetHFission()),
				    bl);
	    AddStage(stage);
	    
	    from = to;
	  } while (from->GetVNext() != 0);
	}
	else 
	{	// horizontal
	  do 
	  {
	    CrossPoint* to = from->GetHNext();
	    uword bl = from->GetHBorder();
	    
	    stage = new FrameStage(FrameStage::SegBorder,
				    GetFNum(gl, f),
				    GetFNum(gl, from->GetVFission()),
				    GetFNum(gl, to->GetVFission()),
				    bl);
	    AddStage(stage);
	    
	    from = to;
	  } while (from->GetHNext() != 0);
	}
      }
    }
  }
  
  //
  // set seeding command
  //
  FOIterator fri(ff);
  FrameObject* fr;
  while ((fr = fri()) != 0)
  {
    if (fr->IsFirstObject()) 
    {
      do 
      {
	FrameObject* src = 0;
	VFission* s_vf = 0;
	HFission* s_hf = 0;
	VFission* o_vf = 0;
	HFission* o_hf = 0;
	for (FrameObject* fo = fr;
	     fo != 0;
	     fo = fo->GetNextFrameObject()) 
	{
	  o_vf = fo->GetCrossPoint()->GetVFission();
	  o_hf = fo->GetCrossPoint()->GetHFission();
	  Rect rec = fo->GetCrossPoint()->GetRect();
	  if ((rec.x1 >= x1) && (rec.x1 <= x2) &&
	      (rec.x2 >= x1) && (rec.x2 <= x2) &&
	      (rec.y1 >= y1) && (rec.y1 <= y2) &&
	      (rec.y2 >= y1) && (rec.y2 <= y2))
	  {
	    if (src == 0)
	    {
	      AddStage(new FrameStage(FrameStage::Object,
					GetFNum(gl, o_vf),
					GetFNum(gl, o_hf),
					GetSeedId(ff, fo)));
	    }
	    else 
	    {
	      AddStage(new FrameStage(FrameStage::Flow,
					GetFNum(gl, s_vf),
					GetFNum(gl, s_hf),
					GetFNum(gl, o_vf),
					GetFNum(gl, o_hf),
					GetSeedId(ff, fo)));
  	    }
	    src = fo;
	    s_vf = o_vf;
	    s_hf = o_hf;
	  }
	}
      } while ((fr = fr->GetNextLinkObject()) != 0);
    }
  }
}

inline Seed* NEAR
BluePrint::GetSeed(uword index)
{
  return seeds->Access(index);
}

// producing flag
bool BluePrint::now_produce = False;

// produce fission
FissionFrame* 
BluePrint::Produce(FrameOwner* fo)
{
  now_produce = True;
  FrameStageIterator fsi(stages);
  FissionFrame* ff = 0;
  FList* fl = new FList();
  for (FrameStage* fs = fsi();
       fs != 0;
       fs = fsi()) 
  {
    switch (fs->GetCommand()) 
    {
     case FrameStage::Create:
      ff = Create(fs, fo, fl);
      break;
     case FrameStage::Divide:
      Divide(fs, ff, fl);
      break;
     case FrameStage::Vanish:
      Vanish(fs, ff, fl);
      break;
     case FrameStage::Flow:
      Flow(fs, ff, fl);
      break;
     case FrameStage::Border:
      Border(fs, ff, fl);
      break;
     case FrameStage::SegBorder:
      SegBorder(fs, ff, fl);
      break;
     case FrameStage::Object:
      Object(fs, ff, fl);
      break;
     default:
      break;
    }
  }
  now_produce = False;
  delete fl;
  return ff;
}

void 
BluePrint::PlayRegion(FrameOwner* fo, FrameRectRgn& rgn, bool insert_line)
{
  now_produce = True;
  FissionFrame* ff = fo->GetFissionFrame();
  Iunit x_offset = insert_line ? 0 : rgn.X1();
  Iunit y_offset = insert_line ? rgn.Y1() : 0;
  
  FList* fl = new FList();
  // next order is critical
  fl->Inject(rgn.GetTop());
  fl->Inject(rgn.GetLeft());
  fl->Inject(rgn.GetRight());
  fl->Inject(rgn.GetBottom());
  
  FrameStageIterator fsi(stages);
  FrameStage* fs;
  while ((fs = fsi()) != 0)
  {
    switch (fs->GetCommand()) 
    {
     case FrameStage::Create:
      // this command isn't used in this operation
      break;
     case FrameStage::Divide:
      Divide(fs, ff, fl, x_offset, y_offset);
      break;
     case FrameStage::Vanish:
      Vanish(fs, ff, fl);
      break;
     case FrameStage::Flow:
      Flow(fs, ff, fl);
      break;
     case FrameStage::Border:
      Border(fs, ff, fl);
      break;
     case FrameStage::SegBorder:
      SegBorder(fs, ff, fl);
      break;
     case FrameStage::Object:
      Object(fs, ff, fl, True); // create instance
      break;
     default:
      break;
    }
  }
  now_produce = False;
  delete fl;
}

// produce frame and frame object
FissionFrame* NEAR
BluePrint::Create(FrameStage* fs, FrameOwner* fo, FList* fl)
{
  Iunit width  = fs->GetParam(0);
  Iunit height = fs->GetParam(1);
  FissionFrame* ff = new FissionFrame(width, height, fo);
  
  fl->Inject(ff->GetTop());			// top fission
  fl->Inject(ff->GetLeft());			// left fission
  fl->Inject(ff->GetRight());			// right fission
  fl->Inject(ff->GetBottom());		// bottom fission
  
  return ff;
}

void NEAR
BluePrint::Divide(FrameStage* fs, FissionFrame* ff, FList* fl)
{
  Fission* f_from = fl->Access(fs->GetParam(0));
  Fission* f_to   = fl->Access(fs->GetParam(1));
  Iunit pos = fs->GetParam(2);
  
  if ((f_from == 0) || (f_to == 0)) 
  {
    // error 
    return;
  }
  
  Fission* f = ff->Divide(f_from, f_to, pos, 
			   BorderLine::GetZeroWidthLineIndex());
  
  fl->Inject(f);
}

void NEAR
BluePrint::Divide(FrameStage* fs, FissionFrame* ff, FList* fl,
		   Iunit x_offset, Iunit y_offset)
{
  Fission* f_from = fl->Access(fs->GetParam(0));
  Fission* f_to   = fl->Access(fs->GetParam(1));
  Iunit pos = fs->GetParam(2);
  
  if ((f_from == 0) || (f_to == 0)) 
  {
    // error 
    return;
  }
  
  pos += (f_from->GetDir() == Fission::Horizontal) ? x_offset : y_offset;
  
  Fission* f = ff->Divide(f_from, f_to, pos, 
			   BorderLine::GetZeroWidthLineIndex());
  
  fl->Inject(f);
}

void NEAR
BluePrint::Vanish(FrameStage* fs, FissionFrame* ff, FList* fl)
{
  Fission* vanish = fl->Access(fs->GetParam(0));
  ff->Vanish(vanish);
  
  fl->Delete(vanish);
}

void NEAR
BluePrint::Flow(FrameStage* fs, FissionFrame* ff, FList* fl)
{
  Fission* vsrc = fl->Access(fs->GetParam(0));
  Fission* hsrc = fl->Access(fs->GetParam(1));
  Fission* vdst = fl->Access(fs->GetParam(2));
  Fission* hdst = fl->Access(fs->GetParam(3));
  
  CrossPoint* src = vsrc->FindCrossPoint(hsrc);
  CrossPoint* dst = vdst->FindCrossPoint(hdst);
  if ((src == 0) || (dst == 0)) 
  {
    return;
  }
  FrameObject* fo = ff->FlowTo(src, dst);
  
  Seed* s = GetSeed(fs->GetParam(4));
  fo->SetMargin(s->GetTopMargin(), s->GetBottomMargin(),
		 s->GetLeftMargin(), s->GetRightMargin());
  
}

void NEAR
BluePrint::Border(FrameStage* fs, FissionFrame* ff, FList* fl)
{
  Fission* f = fl->Access(fs->GetParam(0));
  uword index = fs->GetParam(1);
  if (f == 0) 
  {
    // error
    return;
  }
  ff->ChangeBorder(f, index);
}

void NEAR
BluePrint::SegBorder(FrameStage* fs, FissionFrame* ff, FList* fl)
{
  Fission* f      = fl->Access(fs->GetParam(0));
  Fission* from_f = fl->Access(fs->GetParam(1));
  Fission* to_f   = fl->Access(fs->GetParam(2));
  if ((from_f == 0) || (to_f == 0)) 
  {
    return;
  }
  uword index     = fs->GetParam(3);
  CrossPoint* from  = f->FindCrossPoint(from_f);
  CrossPoint* to    = f->FindCrossPoint(to_f);
  if ((from == 0) || (to == 0)) 
  {
    return;
  }
  f->ReorderSamePosition(from, to);
  ff->ChangeBorder(f, from, to, index);
}

void NEAR
BluePrint::Object(FrameStage* fs, FissionFrame* ff, 
		   FList* fl, bool create_instance)
{
  Fission* v = fl->Access(fs->GetParam(0));
  Fission* h = fl->Access(fs->GetParam(1));
  if ((v == 0) || (h == 0)) 
  {
    return;
  }
  CrossPoint* cp = v->FindCrossPoint(h);
  if (cp == 0) 
  {
    return;
  }
  Seed* s = seeds->Access(fs->GetParam(2));
  FrameObject* fo = cp->GetFrameObject();
  if (fo != 0)
  {
    delete fo;
  }
  
  fo = 0;
  switch (s->GetID()) 
  {
   case IDTextObject:
    {
      TextSeed* ts = (TextSeed*)s;
      if (create_instance)
      {
	fo = ff->GetFrameOwner()->CreateNewFlow(cp);
      }
      else
      {
	fo = ff->CreateInitialFlow(cp);
      }
      if (fo != 0)
      {
	FrameTemplate* ft = (FrameTemplate*)fo;
	ft->set_frame_align(ts->FrameAlign());
      }
    }
    break;
   case IDFillObject:
    {
      FillSeed* fs = (FillSeed*)s;
      fo = new FillObject(cp, fs->GetFillType());
    }
    break;
   case IDGraphicObject:
    {
      GraphicSeed* gs = (GraphicSeed*)s;
      Picture* pic = new Picture(gs->GetVMDIB(), gs->GetDIBSize());
      if (pic->IsValid()) 
      {
	fo = new GraphicObject(cp, pic);
      }
      else 
      {
	// memory trouble
	delete pic;
      }
    }
    break;
   case IDAllLayoutObject:
    {
      fo = new AllLayout(cp);
    }
    break;
   case IDMetafileObject:
    {
      MetafileSeed* ms = (MetafileSeed*)s;
      Metafile* mf = new Metafile(ms->CopyMETAFILEPICT());
      if (mf->IsValid()) 
      {
	fo = new MetafileObject(cp, mf);
      }
      else 
      {
	// memory trouble
	delete mf;
      }
    }
    break;
   case IDUnknownObject:
    {
      UnknownSeed* us = (UnknownSeed*)s;
      fo = new UnknownObject(cp, us->GetError());
    }
    break;
   default:
    break;
  }
  
  if (!fo) 
  {
    // uncleated 
    fo = new UnknownObject(cp, True);
  }
  
  if (s->GetID() != IDTextObject) 
  {
    cp->CreateFrameObject(fo);      
  }
  
  if (fo != 0) 
  {
    fo->SetMargin(s->GetTopMargin(), s->GetBottomMargin(),
		   s->GetLeftMargin(), s->GetRightMargin());
  }
}


// ------------------------------------------------------------
// static data and methods

BluePrint** BluePrint::templates = 0;

// make template blueprint
void 
BluePrint::MakeTemplates()
{
  BluePrint** bp_table = new BluePrint*[TemplateNumber];
  bp_table[0] = BluePrint::MakeZeroLayoutBluePrint();
  bp_table[1] = BluePrint::MakeDefLayoutBluePrint();
  bp_table[2] = BluePrint::MakeTableBluePrint();
  BluePrint::templates = bp_table;
}

// make zero layout template blueprint
//
// +--------+----------------+--------+
// | Fill   | Fill White     | Fill   |
// |  White +----------------+  White |
// |        | Header Text    |        |
// +--------+----------------+--------+
// | Fill   | AllLayout      | Fill   |
// |  White |                |  White |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// |        |                |        |
// +--------+----------------+--------+
// | Fill   | Footer Text    | Fill   |
// |  White +----------------+  White |
// |        | Fill White     |        |
// +--------+----------------+--------+
//
BluePrint* NEAR
BluePrint::MakeZeroLayoutBluePrint()
{
  BluePrint* bp = new BluePrint();
  // make seed
  Margin m(0, 0, Point_to_iu(DEFAULT_POINT), Point_to_iu(DEFAULT_POINT));
  bp->AddSeed(new FillSeed(FillObject::White));				// 1
  bp->AddSeed(new AllLayoutSeed(1));					// 2
  // bp->AddSeed(new FillSeed(FillObject::Gray));	// debug
  bp->AddSeed(new TextSeed(m));						// 3
  
  // make stage
  Vector size   = PageSize::GetDefaultSize();
  Margin margin = PageSize::GetDefaultMargin();
  Iunit top    = margin.GetTop();
  Iunit bottom = size.y - margin.GetBottom();
  Iunit left   = margin.GetLeft();
  Iunit right  = size.x - margin.GetRight();
  
  Iunit header_size = PageSize::GetDefaultHeaderSize();
  Iunit header = (margin.GetTop() <= header_size) 
  ? margin.GetTop() / 2
  : margin.GetTop() - header_size;
  Iunit footer_size = PageSize::GetDefaultFooterSize();
  Iunit footer = (margin.GetBottom() <= footer_size)
  ? bottom + margin.GetBottom() / 2
  : bottom + footer_size;
  bp->AddStage(new FrameStage(FrameStage::Create, size.x, size.y));	// 1
  bp->AddStage(new FrameStage(FrameStage::Divide, 1, 4, left));		// 2
  bp->AddStage(new FrameStage(FrameStage::Divide, 1, 4, right));	// 3
  bp->AddStage(new FrameStage(FrameStage::Divide, 2, 3, top));		// 4
  bp->AddStage(new FrameStage(FrameStage::Divide, 2, 3, bottom));	// 5
  bp->AddStage(new FrameStage(FrameStage::Divide, 5, 6, header));	// 6
  bp->AddStage(new FrameStage(FrameStage::Divide, 5, 6, footer));	// 7
  bp->AddStage(new FrameStage(FrameStage::Object, 2, 1, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 5, 1, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 5, 9, 3));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 6, 1, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 2, 7, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 5, 7, 2));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 6, 7, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 2, 8, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 5, 8, 3));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 5,10, 1));		// 
  bp->AddStage(new FrameStage(FrameStage::Object, 6, 8, 1));		// 
  return bp;
}

// make default layout template blueprint
//
// +----------------------+
// | Text                 |
// |                      |
// |                      |
// |                      |
// |                      |
// |                      |
// |                      |
// +----------------------+
// 
BluePrint* NEAR
BluePrint::MakeDefLayoutBluePrint()
{
  BluePrint* bp = new BluePrint();
  // make seed
  Margin m(0, 0, Point_to_iu(DEFAULT_POINT), Point_to_iu(DEFAULT_POINT));
  bp->AddSeed(new TextSeed(m));						// 1
  
  // make stage
  Vector size   = PageSize::GetDefaultSize();
  Margin margin = PageSize::GetDefaultMargin();
  size.x -= margin.GetLeft() + margin.GetRight();
  size.y -= margin.GetTop() + margin.GetBottom();
  bp->AddStage(new FrameStage(FrameStage::Create, size.x, size.y));	// 1
  bp->AddStage(new FrameStage(FrameStage::Object, 2, 1, 1));		// 2
  return bp;
}

// make table template blueprint
BluePrint* NEAR
BluePrint::MakeTableBluePrint()
{
  BluePrint* bp = new BluePrint();
  // make seed
  Margin m = Table::GetDefaultFrameMargin();
  
  bp->AddSeed(new TextSeed(m));			// number 1 object
  
  // make stage
  Vector size   = PageSize::GetDefaultSize();
  bp->AddStage(new FrameStage(FrameStage::Create, size.x, size.y));	// 1
  bp->AddStage(new FrameStage(FrameStage::Border, 1, 0));		// 2
  bp->AddStage(new FrameStage(FrameStage::Border, 2, 0));		// 3
  bp->AddStage(new FrameStage(FrameStage::Border, 3, 0));		// 4
  bp->AddStage(new FrameStage(FrameStage::Border, 4, 0));		// 5
  return bp;
}

// get zero layout blueprint
BluePrint* 
BluePrint::GetZeroLayoutBluePrint()
{
  assert(templates != 0);
  return templates[0];
}

// get default layout blueprint
BluePrint* 
BluePrint::GetDefLayoutBluePrint()
{
  assert(templates != 0);
  return templates[1];
}

// get table blueprint
BluePrint* 
BluePrint::GetTableBluePrint(Iunit width, Iunit height, 
			      uword border_index)
{
  assert(templates != 0);
  BluePrint* bp = templates[2];
  
  // set table size
  FrameStage* stage = bp->GetStage(1);
  stage->SetParam(0, width);
  stage->SetParam(1, height);
  bp->GetStage(2)->SetParam(1, border_index);
  bp->GetStage(3)->SetParam(1, border_index);
  bp->GetStage(4)->SetParam(1, border_index);
  bp->GetStage(5)->SetParam(1, border_index);
  
  return bp;
}
