// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: blueprin.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// class BluePrint
// t[\t@CZ[uA[hړIŎgNX
// ʏ̃t[\kނ`ŕ\ĂB
// BluePrint kނt[\Ŝ\AFrameStage 
// X̃t[LqB
// BluePrint  FrameStage ɏ]ăvC FissionFrame ɂ
// t[\oオB

#ifndef BLUEPRINT_H
#define BLUEPRINT_H

// frame blue print

#ifndef FRAMESTAGELIST_DEFINED
class FrameStageList;
#endif

#ifndef SEEDLIST_DEFINED
class SeedList;
#endif

#ifndef FLIST_DEFINED
class FList;
#endif

class Seed;
class FrameStage;
class Fission;
class FissionFrame;
class FrameOwner;
class FrameObject;

class BluePrint
{
  // stage list
  FrameStageList* stages;
  
  // seed list
  SeedList* seeds;
  
  // loading version
  word version;
  
public:
  // file save version
  enum 
  {
    sv_luna	= 1,		// luna version
    sv_snow	= 2,		// snow version
    sv_bw1	= 3,		// BeatWord Ver.1
    sv_bw2	= 4,		// BeatWord Ver.2
    save_version = sv_bw2,
  };
  
private:
  // produce flag
  static bool now_produce;
  
  // add stage
  void NEAR AddStage(FrameStage* stage);
  
  // get stage
  FrameStage* NEAR GetStage(uword index);
  
  // make stages
  void NEAR MakeStages(FissionFrame* ff);
  
  static uword NEAR GetSeedId(FissionFrame* ff, FrameObject* fr);
  
  // save 
  void NEAR SaveStages(PStream* ps);
  
  // load
  void NEAR LoadStages(PStream* ps);
  
  // add seed
  void NEAR AddSeed(Seed* seed);
  
public:
  // make seed
  void MakeSeed(FissionFrame* ff);
  
private:
  // get seed
  Seed* NEAR GetSeed(uword index);
  
  // save 
  void NEAR SaveSeeds(PStream* ps);
  
  // load
  void NEAR LoadSeeds(PStream* ps);
  
  // create fission
  FissionFrame* NEAR Create(FrameStage* fs, FrameOwner* fo, FList* fl);
  
  // divide frame
  void NEAR Divide(FrameStage* fs, FissionFrame* ff, FList* fl);
  void NEAR Divide(FrameStage* fs, FissionFrame* ff, FList* fl,
		    Iunit x_offset, Iunit y_offset);
  
  // vanish fission
  void NEAR Vanish(FrameStage* fs, FissionFrame* ff, FList* fl);
  
  // flow 
  void NEAR Flow(FrameStage* fs, FissionFrame* ff, FList* fl);
  
  // set border
  void NEAR Border(FrameStage* fs, FissionFrame* ff, FList* fl);
  
  // set segment border 
  void NEAR SegBorder(FrameStage* fs, FissionFrame* ff, FList* fl);
  
  // create frame object
  void NEAR Object(FrameStage* fs, FissionFrame* ff, FList* fl, 
		    bool create_instance = False);
  
public:
  // constructor
  BluePrint(FissionFrame* ff);
  
  // constructor for file load
  BluePrint();
  
  // destructor
  ~BluePrint();
  
  // save
  void Save(PStream* ps);
  
  // load
  void Load(PStream* ps);
  
  // produce fission
  FissionFrame* Produce(FrameOwner* fo);
  
  // produce flag
  static bool NowProduce() 
  {
    return now_produce; 
  }
  
  // play in the region
  void PlayRegion(FrameOwner* fo, FrameRectRgn& rgn, bool insert_line);
  
  // copy region
  void CopyRegion(FrameOwner* fo, FrameRectRgn& rgn, bool insert_line);
  
  // ------------------------------
  // static
private:
  enum 
  { TemplateNumber = 3 };
  static BluePrint** templates;
  
private:
  // make zero layout template blueprint
  static BluePrint* NEAR MakeZeroLayoutBluePrint();
  
  // make default layout template blueprint
  static BluePrint* NEAR MakeDefLayoutBluePrint();
  
  // make table template blueprint
  static BluePrint* NEAR MakeTableBluePrint();
  
public:
  // get zero layout blueprint
  static BluePrint* GetZeroLayoutBluePrint();
  
  // get default layout blueprint
  static BluePrint* GetDefLayoutBluePrint();
  
  // get table blueprint
  static BluePrint* GetTableBluePrint(Iunit width, Iunit height, 
                                       uword border_index);
  // make template blueprint
  static void MakeTemplates();
};

#endif /* BLUEPRINT_H */
