// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: border.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the BorderDialog class for PWord Border dialog box

#include "pword.h"
#include "pmenus.h"
#include "dialogs.h"
#include "editfram.h"
#include "border.h"
#include "xstr.h"

BorderDialog::BorderDialog(unsigned int value)
{
  if (value)
  {
    line = BorderLine::GetBorderLine(value);
  }
}

LRESULT_T
BorderDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      InitDialog();
      return 1;
    }
    
    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
			
   case WM_CLOSE:
    {
      End(0);
    }
    break;

   case WM_COMMAND:		
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_Border_Single:
       case IDD_Border_Double:
       case IDD_Border_Solid:
       case IDD_Border_Broken:
       case IDD_Border_Invisible:
       case IDD_Border_Dotted:
       case IDD_Border_Inside:
       case IDD_Border_Outside:
       case IDD_Border_Center:
       case IDD_Border_Above:
       case IDD_Border_Below:
       case IDD_Border_Right:
       case IDD_Border_Left:
       case IDD_Border_Box:
       case IDD_Border_Both:
       case IDD_Border_Mixed:
       case IDD_Border_None:
	{
	  Enable();
	}
	break;
	
       case IDD_Border_Bisai:
	{
	  // bisai being checked is good enough to enable OK button
	  int value = get_item_check(IDD_Border_Bisai);
	  if (value)
	  {
	    EnableWindow(GetItem(IDOK), 1);
	  }
	  // bisai turns off the linesize edit control
	  EnableWindow(GetItem(IDD_Border_LineSize), !value);
	}
	break;
	  
       case IDD_Border_LineSize:
	{
	  int val;
	  int ok = get_item_mm0(this->GetHandle(),
				 IDD_Border_LineSize, &val);
	  EnableWindow(GetItem(IDOK), ok && 1 <= val && val <= MAXLINESIZE);
	}
	break;

       case IDOK:
	GetDialog();  // retrieve values
	End(1);
	break;
	
       case IDCANCEL:
	End(0);
	break;
	
       default:
	break;
      }
    }
    break;
		
   default: 
    {
      return 0;
    }
  }
  return 0;
}

void BorderDialog::InitOther()
{
  // do nothing 
}

void
BorderDialog::InitDialog()
{
  InitLineShape();
  InitLineType();
  InitLineWidth();  
  InitAlignment();
  InitOther();
  EnableWindow(GetItem(IDD_Border_LineSize), !line.bisai);
  Enable();
}

void
BorderDialog::GetDialog()
{
  GetLineWidth();  
  GetLineShape();
  GetLineType();
  GetAlignment();
}

unsigned int
BorderDialog::GetValue()
{
  return(line.Enter());
}

void
BorderDialog::InitLineShape()
{
  if (line.single) 
  {
    set_item_check(IDD_Border_Single);
  }
  else
  {
    set_item_check(IDD_Border_Double);
  }
}
 
void 
BorderDialog::GetLineShape()
{
  if (get_item_check(IDD_Border_Single))
  {
    line.single = True;
  }
  else if (get_item_check(IDD_Border_Double))
  {
    line.single = False;
  }
#if (!defined(NDEBUG))
  else
  {
    syserr("BorderDialog::GetLineShape -- invalid checkbox setting");
  }
#endif
}

void 
BorderDialog::InitLineType()
{
  switch (line.type)
  {
   case BorderLine::Solid:
    set_item_check(IDD_Border_Solid);
    break;
   case BorderLine::Broken:
    set_item_check(IDD_Border_Broken);
    break;
   case BorderLine::Dot:
    set_item_check(IDD_Border_Dotted);
    break;
   case BorderLine::Invisible:
    set_item_check(IDD_Border_Invisible);
    break;
  }
}

void 
BorderDialog::GetLineType()
{
  if (get_item_check(IDD_Border_Solid))
  {
    line.type = BorderLine::Solid;
  }
  else if (get_item_check(IDD_Border_Broken))
  {
    line.type = BorderLine::Broken;
  }
  else if (get_item_check(IDD_Border_Dotted))
  {
    line.type = BorderLine::Dot;
  }
  else if (get_item_check(IDD_Border_Invisible))
  {
    line.type = BorderLine::Invisible;
  }
#if (!defined(NDEBUG))
  else
  {
    syserr("BorderDialog::GetLineType -- invalid checkbox settings");
  }
#endif
}

void
BorderDialog::InitLineWidth()
{
  if (line.bisai)
  {
    set_item_check(IDD_Border_Bisai);
  }
  set_item_mm0(this->GetHandle(), IDD_Border_LineSize, line.width);
}

void 
BorderDialog::GetLineWidth()
{
  line.bisai = 0;
  
  if (get_item_check(IDD_Border_Bisai))
  {
    line.bisai = 1;
  }
  {
    int foo;
    get_item_mm0(this->GetHandle(), IDD_Border_LineSize, &foo);
    line.width = foo;
  }
}

void 
BorderDialog::Enable()
{
  xEnable(!get_item_check(IDD_Border_None));
}
  
void 
BorderDialog::xEnable(int setting)
{
  EnableWindow(GetItem(IDD_Border_LineSize), setting);
  EnableWindow(GetItem(IDD_Border_Single), setting);
  EnableWindow(GetItem(IDD_Border_Double), setting);
  EnableWindow(GetItem(IDD_Border_Solid), setting);
  EnableWindow(GetItem(IDD_Border_Broken), setting);
  EnableWindow(GetItem(IDD_Border_Dotted), setting);
  EnableWindow(GetItem(IDD_Border_Invisible), setting);
  EnableWindow(GetItem(IDD_Border_Bisai), setting);
  EnableWindow(GetItem(IDD_Border_LineSize), 
		(setting && !get_item_check(IDD_Border_Bisai)));
}  

// ------------------------------------------------------------
// text(character) borders

TextBorderDialog::TextBorderDialog(unsigned int value)
  : BorderDialog(value)
{
  this->class_name = "tborderDlg";
}

void 
TextBorderDialog::InitAlignment()
{
  if (line.algn & BorderLine::AlignAbove)
  {
    set_item_check(IDD_Border_Above);
  }
  if (line.algn & BorderLine::AlignBelow)
  {
    set_item_check(IDD_Border_Below);
  }
}

void 
TextBorderDialog::GetAlignment()
{
  line.algn = 0;
  
  if (get_item_check(IDD_Border_Below))
  {
    line.algn |= BorderLine::AlignBelow;
  }
  if (get_item_check(IDD_Border_Above))
  {
    line.algn |= BorderLine::AlignAbove;
  }
}

void 
TextBorderDialog::Enable()
{
  xEnable(get_item_check(IDD_Border_Above) ||
	   get_item_check(IDD_Border_Below));
}

// ------------------------------------------------------------
// Paragraph border

ParBorderDialog::ParBorderDialog(unsigned int value)
  : BorderDialog(value)
{
  this->class_name = "PBorderDlg";
}

void
ParBorderDialog::InitAlignment()
{
  if (line.algn & BorderLine::AlignBelow)
  {
    set_item_check(IDD_Border_Below);
  }
  if (line.algn & BorderLine::AlignAbove)
  {
    set_item_check(IDD_Border_Above);
  }
  if (line.algn & BorderLine::AlignLeft)
  {
    set_item_check(IDD_Border_Left);
  }
  if (line.algn & BorderLine::AlignRight)
  {
    set_item_check(IDD_Border_Right);
  }
}

void 
ParBorderDialog::GetAlignment()
{
  line.algn = 0;
  
  if (get_item_check(IDD_Border_Below))
  {
    line.algn |= BorderLine::AlignBelow;
  }
  if (get_item_check(IDD_Border_Above))
  {
    line.algn |= BorderLine::AlignAbove;
  }
  if (get_item_check(IDD_Border_Right))
  {
    line.algn |= BorderLine::AlignRight;
  }
  if (get_item_check(IDD_Border_Left))
  {
    line.algn |= BorderLine::AlignLeft;
  }
}

void 
ParBorderDialog::Enable()
{
  xEnable(get_item_check(IDD_Border_Above) ||
	   get_item_check(IDD_Border_Below) ||
	   get_item_check(IDD_Border_Left) ||
	   get_item_check(IDD_Border_Right));
}

// ------------------------------------------------------------
// line borders

LineBorderDialog::LineBorderDialog(unsigned int value, int type)
  : BorderDialog(value)
{
  this->class_name = "LBorderDlg";
  this->type = type;
}

LRESULT_T
LineBorderDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  if (Msg == WM_INITDIALOG)
  {
    char* str;
    switch (this->type)
    {
     case DEFAULT_LINE:
      str = S_DefaultLineCaption;
      break;
      
     case DEFAULT_TABLE:
      str = S_DefaultTableCaption;
      break;
      
     case SPECIFIC_LINE:
      str = S_SpecificLineCaption;
      break;
    }
    this->SetText(str);
  }
  return(BorderDialog::WndProc(Msg, wParam, lParam));
}

void 
LineBorderDialog::InitAlignment()
{
  if ((line.algn & BorderLine::AlignBelow) ||
      (line.algn & BorderLine::AlignRight))
  {
    set_item_check(IDD_Border_Below);
  }
  else if ((line.algn & BorderLine::AlignAbove) ||
	   (line.algn & BorderLine::AlignLeft))
  {
    set_item_check(IDD_Border_Above);
  }
  else if (line.algn & BorderLine::AlignCenter)
  {
    set_item_check(IDD_Border_Center);
  }
  else
  {
    set_item_check(IDD_Border_None);
    set_item_check(IDD_Border_Center);
  }
}

void 
LineBorderDialog::GetAlignment()
{
  if (get_item_check(IDD_Border_None))
  {
    line.algn = 0;
  }
  else if (get_item_check(IDD_Border_Below))
  {
    line.algn = BorderLine::AlignBelow | BorderLine::AlignRight;
  }
  else if (get_item_check(IDD_Border_Above))
  {
    line.algn = BorderLine::AlignLeft | BorderLine::AlignAbove;
  }
  else if (get_item_check(IDD_Border_Center))
  {
    line.algn = BorderLine::AlignCenter;
  }
  else 
  {
    assert(False);
    line.algn = 0;
  } 
}

void 
LineBorderDialog::InitLineShape()
{
  if (line.algn == 0)
  {
    set_item_check(IDD_Border_None);
  }
  else if (line.single) 
  {
    set_item_check(IDD_Border_Single);
  }
  else
  {
    set_item_check(IDD_Border_Double);
  }
}

void 
LineBorderDialog::GetLineShape()
{
  if (get_item_check(IDD_Border_Single))
  {
    line.single = True;
  }
  else if (get_item_check(IDD_Border_Double))
  {
    line.single = False;
  }
  else
  {
    // layout line
    line.single = True;
  }
}

void 
LineBorderDialog::xEnable(int setting)
{
  EnableWindow(GetItem(IDD_Border_Solid), setting);
  EnableWindow(GetItem(IDD_Border_Broken), setting);
  EnableWindow(GetItem(IDD_Border_Dotted), setting);
  EnableWindow(GetItem(IDD_Border_Invisible), setting);
  EnableWindow(GetItem(IDD_Border_Bisai), setting);
  EnableWindow(GetItem(IDD_Border_LineSize), 
		 (setting && 
		 ! (int)get_item_check(IDD_Border_Bisai)));
  EnableWindow(GetItem(IDD_Border_Above), setting);
  EnableWindow(GetItem(IDD_Border_Below), setting);
  EnableWindow(GetItem(IDD_Border_Center), setting);
}  


// ------------------------------------------------------------
// frame borders

FrameBorderDialog::FrameBorderDialog(unsigned int value_above,
				      unsigned int value_left,
				      unsigned int value_right,
				      unsigned int value_below)
  : BorderDialog(value_above)
{
  this->class_name = "FBorderDlg";
  if (value_left)
  {
    line_left = BorderLine::GetBorderLine(value_left);
  }
  if (value_right)
  {
    line_right = BorderLine::GetBorderLine(value_right);
  }
  if (value_below)
  {
    line_below = BorderLine::GetBorderLine(value_below);
  }
  target = EditFrame::AllLines;
}

void 
FrameBorderDialog::GetValues(unsigned int& u, 
			      unsigned int& l, 
			      unsigned int& r, 
			      unsigned int& b , 
			      unsigned int& inter,
			      EditFrame::TargetLine& t)
{
  BorderLine i = line;
  if ((BorderLine::BLAlignment)i.GetAlignment() != BorderLine::AlignNone)
  {
    i.SetAlign(BorderLine::AlignCenter);
  }
  inter = i.Enter();
  t = target;
  line_left.single = line_right.single = line_below.single = line.single;
  line_left.type = line_right.type = line_below.type = line.type;
  line_left.width = line_right.width = line_below.width = line.width;
  line_left.bisai = line_right.bisai = line_below.bisai = line.bisai;
  
  u = GetValue();
  l = line_left.Enter();
  r = line_right.Enter();
  b = line_below.Enter();
}

LRESULT_T
FrameBorderDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_COMMAND:		
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_Border_VBoundary:
	{
	  bool val = (bool)(get_item_check(IDD_Border_VBoundary) != 0);
	  if (val) 
	  {
	    target = (EditFrame::TargetLine) (target | EditFrame::VBoundary);
	  }
	  else 
	  {
	    target = (EditFrame::TargetLine) (target & ~EditFrame::VBoundary);
	  }
	}
	return 0;
       case IDD_Border_HBoundary:
	{
	  bool val = (bool)(get_item_check(IDD_Border_HBoundary) != 0);
	  if (val)
	  {
	    target = (EditFrame::TargetLine) (target | EditFrame::HBoundary);
	  }
	  else 
	  {
	    target = (EditFrame::TargetLine) (target & ~EditFrame::HBoundary);
	  }
	}
	return 0;
       case IDD_Border_VInter:
	{
	  bool val = (bool)(get_item_check(IDD_Border_VInter) != 0);
	  if (val)
	  {
	    target = (EditFrame::TargetLine) (target | EditFrame::VInter);
	  }
	  else
	  {
	    target = (EditFrame::TargetLine) (target & ~EditFrame::VInter);
	  }
	}
	return 0;
       case IDD_Border_HInter:
	{
	  bool val = (bool)(get_item_check(IDD_Border_HInter) != 0);
	  if (val)
	  {
	    target = (EditFrame::TargetLine) (target | EditFrame::HInter);
	  }
	  else
	  {
	    target = (EditFrame::TargetLine) (target & ~EditFrame::HInter);
	  }
	}
	return 0;
       default:
	break;
      }
    }
   default:
    break;
  }
	
  return(BorderDialog::WndProc(Msg, wParam, lParam));
}

void
FrameBorderDialog::InitAlignment()
{
#if 0
  if (!line.algn && !line_left.algn && !line_right.algn && !line_below.algn)
  {
    set_item_check(IDD_Border_None);
    set_item_check(IDD_Border_Center);
  }
  else if ((line.algn & BorderLine::AlignCenter) &&
	   (line_left.algn & BorderLine::AlignCenter) &&
	   (line_right.algn & BorderLine::AlignCenter) &&
	   (line_below.algn & BorderLine::AlignCenter))
  {
    set_item_check(IDD_Border_Center);
  }
  else if ((line.algn & BorderLine::AlignAbove) &&
	   (line_left.algn & BorderLine::AlignLeft) &&
	   (line_right.algn & BorderLine::AlignRight) &&
	   (line_below.algn & BorderLine::AlignBelow))
  {
    set_item_check(IDD_Border_Outside);
  }
  else if ((line.algn & BorderLine::AlignBelow) &&
	   (line_left.algn & BorderLine::AlignRight) &&
	   (line_right.algn & BorderLine::AlignLeft) &&
	   (line_below.algn & BorderLine::AlignAbove))
  {
    set_item_check(IDD_Border_Inside);
  }
  else if ((line.algn != 0) ||
	   (line_left.algn != 0) ||
	   (line_right.algn != 0) ||
	   (line_below.algn != 0))
  {
    set_item_check(IDD_Border_Center);
  }
  else 
  {
    set_item_check(IDD_Border_None);
    set_item_check(IDD_Border_Center);
  }
#else
//  if (!line.algn && !line_left.algn && !line_right.algn && !line_below.algn)
//  {
//    set_item_check(IDD_Border_None);
//  }
#endif
}

void
FrameBorderDialog::InitOther()
{
  if (target & EditFrame::VBoundary)
  {
    set_item_check(IDD_Border_VBoundary);
  }
  if (target & EditFrame::HBoundary)
  {
    set_item_check(IDD_Border_HBoundary);
  }
  if (target & EditFrame::VInter)
  {
    set_item_check(IDD_Border_VInter);
  }
  if (target & EditFrame::HInter)
  {
    set_item_check(IDD_Border_HInter);
  }
}

void 
FrameBorderDialog::GetAlignment()
{
#if 0
  if (get_item_check(IDD_Border_None))
  {
    line.algn = line_left.algn = line_right.algn = line_below.algn = 0;
  }
  else if (get_item_check(IDD_Border_Center))
  {
    line.algn = line_left.algn = line_right.algn = line_below.algn 
    = BorderLine::AlignCenter;
  }
  else if (get_item_check(IDD_Border_Inside))
  {
    line.algn = BorderLine::AlignBelow;
    line_left.algn = BorderLine::AlignRight;
    line_right.algn = BorderLine::AlignLeft;
    line_below.algn = BorderLine::AlignAbove;
  }
  else if (get_item_check(IDD_Border_Outside))
  {
    line.algn = BorderLine::AlignAbove;
    line_left.algn = BorderLine::AlignLeft;
    line_right.algn = BorderLine::AlignRight;
    line_below.algn = BorderLine::AlignBelow;
  }
#if (!defined(NDEBUG))
  else
  {
    syserr("FrameBorderDialog::GetAlignment -- bad button settings?");
  }
#endif
#else
  if (get_item_check(IDD_Border_None))
  {
    line.algn = line_left.algn = line_right.algn = line_below.algn = 0;
  }
  else
  {
    line.algn = line_left.algn = line_right.algn = line_below.algn 
    = BorderLine::AlignCenter;
  }
#endif
}

void 
FrameBorderDialog::InitLineShape()
{
  int shape[3];
  shape[0] = shape[1] = shape[2] = 0;
  BorderLine* l[4];
  l[0] = &line;
  l[1] = &line_left;
  l[2] = &line_right;
  l[3] = &line_below;
  for (uword i = 0; i < 4; i++)
  {
    if (l[i]->algn == 0)
    {
      shape[0]++;
    }
    else if (l[i]->single)
    {
      shape[1]++;
    }
    else
    {
      shape[2]++;
    }
  }
  if ((shape[0] == 4) ||
      ((shape[0] > shape[1]) &&
       (shape[0] > shape[2])))
  {
    set_item_check(IDD_Border_None);
  }
  else if (shape[1] > shape[2])
  {
    set_item_check(IDD_Border_Single);
  }
  else
  {
    set_item_check(IDD_Border_Double);
  }
}

void 
FrameBorderDialog::GetLineShape()
{
  if (get_item_check(IDD_Border_Single))
  {
    line.single = True;
  }
  else if (get_item_check(IDD_Border_Double))
  {
    line.single = False;
  }
  else
  {
    // layout line
    line.single = True;
  }
}
  
void 
FrameBorderDialog::xEnable(int setting)
{
  EnableWindow(GetItem(IDD_Border_Solid), setting);
  EnableWindow(GetItem(IDD_Border_Broken), setting);
  EnableWindow(GetItem(IDD_Border_Dotted), setting);
  EnableWindow(GetItem(IDD_Border_Invisible), setting);
  EnableWindow(GetItem(IDD_Border_Bisai), setting);
  EnableWindow(GetItem(IDD_Border_LineSize), 
	       (setting && !get_item_check(IDD_Border_Bisai)));
  EnableWindow(GetItem(IDD_Border_Inside), setting);
  EnableWindow(GetItem(IDD_Border_Outside), setting);
  EnableWindow(GetItem(IDD_Border_Center), setting);
}  
