// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: borderli.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class BorderLine
// description of border line

#ifndef BORDERLI_H
#define BORDERLI_H

#define DOUBLE_LINE_GAP mm0_to_iu(5)

class BorderLine
{
  friend class BorderEntry;
  friend class BorderTable;
  friend class BorderDialog;
  friend class TextBorderDialog;
  friend class ParBorderDialog;
  friend class FrameBorderDialog;
  friend class LineBorderDialog;
  
public:
  // ------------------------------
  // public enum
  enum BLLineType
  {
    ReservedLineType = 0,
    Broken    = 1,			// __ __ __ __ __
    Dot       = 2,			// ..............
    BrokenDot = 3,			// __ . __ . __ .
    Wavy      = 4,			// ~~~~~~~~~~~~~~
    Solid     = 5,			// ______________
    Invisible = 6,                      //
  };
  
  // line placement, for words & paras
  enum BLAlignment
  {
    AlignNone  = 0,
    AlignBelow = 1<<0,
    AlignAbove = 1<<1,
    AlignLeft  = 1<<2,
    AlignRight = 1<<3,
    AlignCenter= 1<<4,
  };
  
private:
  // ------------------------------
  // line data
  BLLineType type;			// line type
  uword width;				// line width(1/10 mm)
  unsigned int algn;			// region alignment
  bool bisai;       			// finest possible line
  bool single;				// single or double
  
private:
  // ------------------------------
  // class static value
  static const uword line_width_max;	// line width max
  static const uword default_width;	// line width max
  
  // ------------------------------
  // index
  static uword def_ch_index;		// default character border index
  static uword def_par_index;		// default paragraph border index
  static uword def_fr_index;		// default frame border index
  static uword def_table_fr_index;	// default frame border index for tables
  static uword zero_index;		// zero width line index
  
public:
  BorderLine();
  BorderLine(BLLineType mt, uword mw, unsigned int algn = AlignCenter, bool single = True);
  
public:
  BLLineType GetType();
  HBRUSH get_brush(int index_hv);
  Iunit GetWidth();
  Iunit strict_width(int index_hv);
  bool BisaiP();
  bool Present();
  bool SingleP();
  int GetAlignment();
  int GetHAlign();
  int GetVAlign();
  int overlinep();
  int strict_pixel_width(View* view, int index_hv);
  int underlinep();
  unsigned int Enter();
  void Init();
  void SetAlign(BLAlignment algn);
  void draw_border_in_drect(View* view, Drect* dr, int index_hv);
  void draw_para_border(View* view, Lrect* guide_lrect, int index_x);
  
  // static method
public:
  static BorderLine* Get(int index);
  static BorderLine& GetBorderLine(uword index);
  static Iunit GetLeftWidth(uword index);
  static Iunit GetLowerWidth(uword index);
  static Iunit GetRightWidth(uword index);
  static Iunit GetUpperWidth(uword index);
  static bool Present(uword index);
  static uword ForceAlignment(uword index, BLAlignment algn);
  static uword GetDefaultCharacterIndex();
  static uword GetDefaultParagraphIndex();
  static uword GetDefaultFrameIndex();
  static uword GetDefaultTableIndex();
  static uword GetZeroWidthLineIndex();
  static void Mark(uword index);
  static void SetDefaultFrameIndex(uword index);
  static void SetDefaultTableIndex(uword index);
};

inline int
BorderLine::GetAlignment()
{
  return((int) this->algn);
}

inline int
BorderLine::GetHAlign()
{
  return((int) this->algn & (AlignCenter | AlignAbove | AlignBelow));
}

inline int
BorderLine:: GetVAlign()
{
  return((int) this->algn & (AlignCenter | AlignLeft | AlignRight));
}

inline void
BorderLine::SetAlign(BLAlignment algn)
{
  this->algn = algn;
}

inline int
BorderLine::overlinep()
{
  return((int) this->algn & BorderLine::AlignAbove);
}

inline int
BorderLine::underlinep()
{
  return((int) this->algn & BorderLine::AlignBelow);
}

inline void
BorderLine::SetDefaultFrameIndex(uword index)
{
  def_fr_index = index;
}

inline void
BorderLine::SetDefaultTableIndex(uword index)
{
  def_table_fr_index = index;
}

inline uword
BorderLine::GetDefaultCharacterIndex()
{
  return(def_ch_index);
}

inline uword
BorderLine::GetDefaultParagraphIndex()
{
  return(def_par_index);
}

inline uword
BorderLine::GetDefaultTableIndex()
{
  return(def_table_fr_index);
}

inline uword
BorderLine::GetDefaultFrameIndex()
{
  return(def_fr_index);
}

inline uword
BorderLine::GetZeroWidthLineIndex()
{
  return(BorderLine::zero_index);
}

inline BorderLine::BLLineType
BorderLine::GetType()
{
  return(this->type);
}

inline bool
BorderLine::BisaiP()
{
  return(this->bisai);
}

inline bool
BorderLine::SingleP()
{
  return(this->single);
}

#endif /* BORDERLI_H */
