// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: borders.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the BorderTable and BorderEntry classes

#include "pword.h"

#ifdef __BORLANDC__
#include <mem.h>
#endif

#include "borders.h"
#include "attribut.h"
#include "pstreams.h"

#define T BorderEntry
#define TABLE BaseBorderTable
#define SEG BaseBorderTableSeg
#define DO_READ_WRITE
#define NO_ENTRY_ADD_TO_INTERFACE
#include "tabletem.cpp"

BorderTable STATIC_NEAR GlobalBorderTable;

BorderEntry::BorderEntry(BorderLine &bl)
  : line(bl)
{
}

// copy constructor
BorderEntry::BorderEntry(BorderEntry& entry)
  : line(entry.line)
{
}

// private method
unsigned char NEAR
BorderEntry::GetHash()
{
  unsigned char x = 0;
  unsigned char* p = (unsigned char*) &this->line;
  int count = sizeof(BorderLine);
  do
  {
    x = x ^ (x << 1) ^ *p++;
  } while (--count);
  return(x);
}

int
operator == (BorderEntry& e1, BorderEntry& e2)
{
  return(memcmp(&e1.line, &e2.line, sizeof(BorderLine)) == 0);
}

unsigned int
BorderEntry::Enter()
{
  return GlobalBorderTable.MakeEntry(*this);
}

void
BorderEntry::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_BORDERENTRY);
  CHECK;
  
  stream->OutUByte(line.single);
  CHECK;
  
  stream->OutUWord(line.type);
  CHECK;
  
  stream->OutUWord(line.width);
  CHECK;
  
  stream->OutUByte(line.bisai);
  CHECK;
  
  stream->OutUWord(line.algn);
  CHECK;
  
  stream->EndBlockOut(); CHECK;
}

void
BorderEntry::ReadFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_BORDERENTRY, vers);
  CHECK;
  
  line.single = (bool)(stream->InUByte() != 0); CHECK;
  line.type   = (BorderLine::BLLineType)(stream->InWord()); CHECK;
  line.width  = stream->InUWord(); CHECK;
  line.bisai  = (bool)(stream->InUByte() != 0); CHECK;
  line.algn   = stream->InUWord(); CHECK;
  
  stream->EndBlockIn(); CHECK;
}


#ifndef NDEBUG

void
BorderEntry::DumpHeader(FILE* f)
{
  fprintf(f, 
	  "\nBorderline Table\n\n"
	  "NNNN Sing Widt Type Algn\n"
	);
}

void
BorderEntry::Dump(unsigned int i, void* v)
{
  FILE* f = (FILE*) v;
  fprintf(f, "%4d %4d %4d %4d %4x\n",
	  i,
	  line.single, line.type, line.width,
	  line.algn);
}

#endif // NDEBUG

void
BorderTable::Init()
{
  // default character underline entry.  This entry is used when the user
  // simply selects "Underline" from the Text|Style submenu, without
  // bringing up the dialog box.
  {
    BorderLine bl;
    bl.algn = BorderLine::AlignBelow;
    BorderEntry entry(bl);
    BorderLine::def_ch_index = bl.Enter();
  }
  // default paragraph border entry.  This entry is used when the user
  // simply selects the icon from the Paragraph box.
  {
    BorderLine bl;
    bl.algn = BorderLine::AlignBelow | BorderLine::AlignAbove | BorderLine::AlignLeft | BorderLine::AlignRight;
    BorderEntry entry(bl);
    BorderLine::def_par_index = bl.Enter();
  }
  {
    BorderLine bl;
    BorderEntry entry(bl);
    BorderLine::def_fr_index = bl.Enter();
  } 
  {
    BorderLine bl;
    bl.algn = BorderLine::AlignCenter;
    BorderEntry entry(bl);
    BorderLine::def_table_fr_index = bl.Enter();
  } 
}

