// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bound.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// operations on bound BufferPointers, bound intervals, bound 
// interval lists

#include "pword.h"
#include "docconte.h"
#include "bufnew.h"
#include "interval.h"
#include "intlist.h"
#include "textflow.h"
#include "pstreams.h"
#include "bound.h"

// ------------------------------------------------------------
// Bound Buffer Pointers

BoundBufferPointer::BoundBufferPointer()
{
  Init();
}

BoundBufferPointer::BoundBufferPointer(long _par_id, int _byte_offset)
{
  Init();
  par_id = _par_id;
  byte_offset = _byte_offset;
}

BoundBufferPointer::BoundBufferPointer(BoundBufferPointer& bbp)
{
  Init();
  byte_offset = bbp.byte_offset;
  par_id = bbp.par_id;
}

BoundBufferPointer::BoundBufferPointer(BufferPointer& bp)
{
  Init();
  byte_offset = bp.GetLogicalOffset();
  par_id = bp.GetParagraph()->GetID();
}

BoundBufferPointer::BoundBufferPointer(PStream* stream)
{
  Init();
  this->ReadFromStream(stream);
}

void
BoundBufferPointer::Init()
{
  byte_offset = 0;
  par_id = 0;
}

BoundBufferPointer::~BoundBufferPointer() 
{
}

void
BoundBufferPointer::ReadFromStream(PStream* stream)
{
  par_id = stream->InULong();
  CHECK;
  byte_offset = stream->InUWord();
  CHECK;
}

void
BoundBufferPointer::WriteToStream(PStream* stream)
{
  stream->OutULong(par_id); CHECK;
  stream->OutUWord(byte_offset); CHECK;
}

int
BoundBufferPointer::EQ(BoundBufferPointer& right)
{
  return(byte_offset==right.byte_offset) && (par_id==right.par_id);
}


// ------------------------------------------------------------
// Bound Intervals

void
BoundInterval::Init()
{
  textflow_serial = 0;
  textflow = 0;
}

BoundInterval::BoundInterval(BoundInterval& i)
  : BP0(i.BP0),
    BP1(i.BP1)
{
  Init();
  textflow_serial = i.textflow_serial;
  textflow = i.textflow;
}

BoundInterval::BoundInterval(BoundInterval* i)
  : BP0(i->BP0),
    BP1(i->BP1)
{
  Init();
  textflow_serial = i->textflow_serial;
  textflow = i->textflow;
}

BoundInterval::BoundInterval(PStream* stream)
{
  Init();
  this->ReadFromStream(stream);
}

BoundInterval::BoundInterval(Interval& i)
  : BP0(*i.GetBP0()),
    BP1(*i.GetBP1())
{
  Init();
  textflow = i.GetBP0()->GetTextFlow();
  textflow_serial = textflow->GetSerial();
}

BoundInterval::~BoundInterval()
{
}

BoundBufferPointer&
BoundInterval::GetBP0()
{
  return BP0;
}

BoundBufferPointer&
BoundInterval::GetBP1()
{
  return BP1;
}

udword
BoundInterval::GetTextFlowSerial()
{
  return textflow_serial;
}

TextFlow*
BoundInterval::GetTextFlow()
{
  return textflow;
}

void
BoundInterval::ReadFromStream(PStream* stream)
{
  Init();
  textflow_serial = stream->InULong(); CHECK;
  BP0.ReadFromStream(stream); CHECK;
  BP1.ReadFromStream(stream); CHECK;
}

void
BoundInterval::WriteToStream(PStream* stream)
{
  stream->OutULong(textflow_serial); CHECK;
  GetBP0().WriteToStream(stream); CHECK;
  GetBP1().WriteToStream(stream); CHECK;
}

int
BoundInterval::EQ(BaseInterval &bi)
{
  BoundInterval& i = *(BoundInterval*)&bi;
  return(BP0.EQ(i.GetBP0())) && (BP1.EQ(i.GetBP1())) && (textflow_serial==i.GetTextFlowSerial());
}


// ------------------------------------------------------------
// Bound Interval Lists

void
BoundIntervalList::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_INTLIST); CHECK;
  stream->OutUWord(Count()); CHECK;

  BaseIntervalListTraversor ilt(this);
  BoundInterval* i;
  while ((i=(BoundInterval*)ilt.GetNext()) != 0)
  {
    i->WriteToStream(stream); CHECK;
  }
  stream->EndBlockOut(); CHECK;
}

void
BoundIntervalList::ReadFromStream(PStream* stream)
{
  word vers;
  int count;
  
  stream->StartTypedBlockIn(PStream::HDR_INTLIST, vers); 
  CHECK;

  count = stream->InUWord(); 
  CHECK;
  
  while (count--)
  {
    AddIntervalAtTail(new BoundInterval(stream));
  }
  stream->EndBlockIn(); CHECK;
}

BaseInterval*
BoundIntervalList::NewMember(BaseInterval* i)
{
  return new BoundInterval(* (Interval*) i);
}

IntervalList*
BoundIntervalList::Unbind(DocumentContent* dc)
{
  IntervalList* il = new IntervalList;
  
  BaseInterval** plug = &il->head;
	
#if 0
  for (BoundInterval* bi = (BoundInterval*)head; bi; bi=bi->next)
  {
    Interval* copy = new Interval(*bi, dc);
    *plug = copy;
    plug = &(copy->next);
  }
#else
  BaseInterval* bi = head; 
  while (1)
  {
    Interval* copy = new Interval(*(BoundInterval*)bi, dc);
    *plug = copy;
    plug = &(copy->next);
    bi=bi->next;
    if (!bi)
    {
      break;
    }
  }
#endif
  *plug = 0;
  return il;
}

bool
BoundIntervalList::ContainsTextFlow(TextFlow *tf)
{
  bool ret = False;
  for (BaseInterval* bi = GetHead(); bi && !ret; bi=bi->GetNext())
  {
    BoundInterval* i = (BoundInterval*)bi;
    if (i->GetTextFlow() == tf)
    {
      ret = True;
    }
  }
  return ret;
}

void
BoundIntervalList::WeedDeadTextFlow(TextFlow* tf)
{
  BaseInterval** bi = &head;
  while (*bi != NULL)
  {
    BoundInterval* i = (BoundInterval*)*bi;
    if (i->GetTextFlow() == tf)
    {
      *bi = (*bi)->next;
    }
    else
    {
      bi = &((*bi)->next);
    }
  }
}
