// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bufnew.cpp,v 3.4 1999/05/12 00:22:16 kudou Exp $
// buffer

// next 2 symbols for powerfull debugging.  see bufnew.h
// Ex. bcc -DDEBUG_BP ...
//#define DEBUG_BP
//#define DEBUG_ATTR

#include "pword.h"
#include "bufnew.h"
#include "attribut.h"
#include "atts.h"
#include "statdlg.h"
#include "docconte.h"
#include "line.h"
#include "sjis.h"
#include "pmenus.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "panel.h"
#include "vtextpnl.h"
#include "pstreams.h"
#include "bound.h"
#include "interval.h"
#include "intlist.h"
#include "pref.h"
#include "vtext.h"
#include "view.h"
#include "vmem.h"

// define private operator new & delete
#include "smartnew.h"
DEFINE_SMARTNEW(Buffer)
DEFINE_SMARTNEW(BP)

#define BUFUNIT 2U

#if (!defined(NDEBUG) && defined(DEBUG_BP))
#define CHECK_BPS(this) ((this)->CheckBPs())
#else
#define CHECK_BPS(this)
#endif

// ------------------------------------------------------------
// private inline

inline BP* NEAR
Buffer::GetBPLink()
{
  return((BP*) &this->bp_link);
}

// ------------------------------------------------------------
// `Buffer' class

#if (!defined(NDEBUG))
// private method
void NEAR
Buffer::CheckBPs()
{
  unsigned int bot = this->gapbottom;
  unsigned int top = this->gaptop;
  unsigned length = this->buflen;
  BP* bp_link = this->GetBPLink();
  BP* bp = bp_link;
  while ((bp = bp->next) != bp_link)
  {
    unsigned int i = (unsigned int) bp->byte_offset;
    if (!(i <= bot || (top < i && i <= length)))
    {
      syserr("Buffer::CheckBPs : bot = %d, top = %d, length = %d, bp = %d",
	      bot, top, length, i);
    }
  }
}
#endif

#if (!defined(NDEBUG))
#include "derivs.h"

attr
check_attr(attr a)
{
  if ((int) a < 0 || GlobalDerivTable.GetNEntries() <= a)
  {
    syserr("bad attribute value %d(0x%02x)", a, a);
  }
  return(a);
}
#endif

udword 
Buffer::GetID()
{
  Buffer* dirty = this->GetTextFlow() ->GetFirstDirtyID();
  if (dirty && dirty->GetCmpValue() <= this->GetCmpValue())
  {
    unsigned long id = dirty->prev ? dirty->prev->id : 0;
    for (;;)
    {
      assert(dirty);
      dirty->id = ++id;
      if (dirty == this)
      {
	break;
      }
      dirty = dirty->next;
    }
    this->GetTextFlow() ->SetFirstDirtyID(NULL);
    this->GetTextFlow() ->SetFirstDirtyID(dirty->next);
  }
  return(this->id);
}

// private method
int NEAR
Buffer::SubSize(int i0, int i1)
{
  if (i1 < 0)
  {
    i1 = this->buflen;
  }
  
  int piece10 = MAX(i0, 0);
  int piece11 = MIN((unsigned int) i1, this->gapbottom);
  int piece20 = MAX((unsigned int) i0, this->gaptop);
  int piece21 = MIN((unsigned int) i1, this->buflen);
  
  int size = 0;
  if (0 < (piece11 -= piece10))
  {
    size += piece11;
  }
  if (0 < (piece21 -= piece20))
  {
    size += piece21;
  }
  return(size);
}

// private method
Panel* NEAR
Buffer::GetPanel(sjis c)
{
  assert(IsPanel(c));
  assert(this->GetDocContent() ->GetPanel(GetSpecialCode(c)));
  
  return(this->GetDocContent() ->GetPanel(GetSpecialCode(c)));
}

// private method
void NEAR
Buffer::KillPanels(unsigned int i0, unsigned int i1)
{
  unsigned int i_limit = MIN(this->gapbottom, i1);
  unsigned int i = i0;
  for (bool firstp = True;; firstp = False)
  {
    sjis* buf_ptr;
    for (buf_ptr = &this->buf[i]; i < i_limit; ++buf_ptr, ++i)
    {
      if (IsPanel(*buf_ptr))
      {
	delete this->GetPanel(*buf_ptr);
	*buf_ptr = 0;
      }
    }
    if (firstp)
    {
      i_limit = i1;
      i = MAX(i0, this->gaptop);
      continue;
    }
    break;
  }
}

// private static method
void NEAR
Buffer::DeregisterBP(BP* bp)
{
  BP* prev = bp->prev;
  (prev->next = bp->next)->prev = prev;
}

// private method
void NEAR
Buffer::RegisterBP(BP* bp)
{
  bp->editor = this;
  BP* prev = this->GetBPLink();
  prev->next = (bp->next = (bp->prev = prev)->next)->prev = bp;
}

// private method
void NEAR
Buffer::RegisterBPs(BP* bps, int offset)
{
  BP* first = bps->next;
  if (first != bps)
  {
    BP* bp = bps;
    while ((bp = bp->next) != bps)
    {
      bp->editor = this;
      bp->byte_offset = offset;
    }
    BP* last = bps->prev;
    BP* prev = this->GetBPLink();
    BP* next = prev->next;
    first->prev = prev;
    last->next = next;
    prev->next = first;
    next->prev = last;
  }
}

// private nethod
void NEAR
Buffer::CrushBPs(int above_here, int below_here, int makeum_this)
{
  CHECK_BPS(this);
  BP* bp_link = this->GetBPLink();
  BP* bp = bp_link;
  while ((bp = bp->next) != bp_link)
  {
    int offset;
    if (above_here < (offset = bp->byte_offset) && offset <= below_here)
    {
      bp->byte_offset = makeum_this;
    }
  }
  CHECK_BPS(this);
}

// private method
void NEAR
Buffer::RelocateBPs(int above_here, int below_here, int this_much)
{
  BP* bp_link = this->GetBPLink();
  BP* bp = bp_link;
  while ((bp = bp->next) != bp_link)
  {
    int offset;
    if (above_here < (offset = bp->byte_offset) && offset <= below_here)
    {
      bp->byte_offset = offset + this_much;
    }
  }
}

// Important convention -- when we have a buffer ptr for the position
// actually at the gap, it is == gapbottom, not gaptop.  This is real
// important.
// private method
void NEAR
Buffer::GetGapToBP(BP* bp)
{
  CHECK_BPS(this);
  unsigned int new_bot = bp->byte_offset;
  unsigned int bot = this->gapbottom;
  
  assert(new_bot <= this->buflen);
  assert(!(bot < new_bot && new_bot <= this->gaptop));
  
  if (new_bot != bot)
  {
    unsigned int top = this->gaptop;
    sjis* buf = this->buf;
    attr* att = this->attributes;
    if (bot < new_bot)
    {
      unsigned int count = new_bot - top;
      this->RelocateBPs(bot, new_bot, bot - top);
      memmove(&buf[bot], &buf[top], BUFUNIT * count);
      memmove(&att[bot], &att[top], BUFUNIT * count);
      bot += count;
      top += count;
    }
    else
    {
      unsigned int count = bot - new_bot;
      this->RelocateBPs(new_bot, bot, top - bot);
      top -= count;
      bot -= count;
      memmove(&buf[top], &buf[bot], BUFUNIT * count);
      memmove(&att[top], &att[bot], BUFUNIT * count);
    }
    assert(bot <= this->buflen && top <= this->buflen);
    this->gapbottom = bot;
    this->gaptop = top;
  }
  CHECK_BPS(this);
}

// private method
void NEAR
Buffer::EnsureAllocSpace(unsigned int new_gap)
{
  CHECK_BPS(this);
  this->flags &= ~BF_ERROR;
  unsigned int top = this->gaptop;
  unsigned int bot = this->gapbottom;
  unsigned int gap = top - bot;
  if (gap < new_gap)
  {
    unsigned int length = this->buflen;
    unsigned int new_length = length + (new_gap - gap);
    if (new_length < length
	|| (1U << LOG2_OF_MAX_ALLOC) / BUFUNIT < new_length)
    {
      this->flags |= BF_ERROR;
      this->GetDocContent() ->ParTooBig();
    }
    else
    {
      unsigned int new_log2 = ceil_log2(BUFUNIT * new_length);
      unsigned int size1 = length - top;
      new_length = (1U << new_log2) / BUFUNIT;
      unsigned int new_top = new_length - size1;
      assert(this->log2_of_buffer_size < new_log2);

      sjis* new_buf = (sjis*) xmalloc_on_log2(new_log2);
      attr* new_att = (attr*) xmalloc_on_log2(new_log2);

      unsigned int old_log2 = this->log2_of_buffer_size;
      if (old_log2)
      {
	sjis* buf = this->buf;
	attr* att = this->attributes;
	memcpy(&new_buf[0], &buf[0], BUFUNIT * bot);
	memcpy(&new_buf[new_top], &buf[top], BUFUNIT * size1);
	memcpy(&new_att[0], &att[0], BUFUNIT * bot);
	memcpy(&new_att[new_top], &att[top], BUFUNIT * size1);
	xfree_on_log2(att, old_log2);
	xfree_on_log2(buf, old_log2);
      }

      this->buflen = new_length;
      this->gaptop = new_top;
      this->log2_of_buffer_size = new_log2;
      this->buf = new_buf;
      this->attributes = new_att;

      this->RelocateBPs(top, length, new_length - length);
    }
  }
  CHECK_BPS(this);
}

// static private method
void NEAR
Buffer::Transport(BP* dest_bp, BP* src_bp)
{
  Buffer* dest = dest_bp->editor;
  Buffer* src = src_bp->editor;
  if (dest != src)
  {
    src->GetGapToBP(src_bp);
    unsigned int src_bot = src->gapbottom;
    unsigned int src_top = src->gaptop;
    unsigned int src_length = src->buflen;
    unsigned int count = src_length - src_top;
    if (count)
    {
      dest->EnsureAllocSpace(count);
      if (dest->flags & BF_ERROR)
      {
	return;
      }
      dest->GetGapToBP(dest_bp);
      int dest_top = dest->gaptop - count;
      dest->gaptop = dest_top;
      src->gaptop = src_length;
      memcpy(&dest->buf[dest_top], &src->buf[src_top], BUFUNIT * count);
      memcpy(&dest->attributes[dest_top],
	      &src->attributes[src_top], BUFUNIT * count);
      
      // relocate buffer pointers

      int offset_delta = dest_top - src_top;
      BP* bp_link = src->GetBPLink();
      BP* bp = bp_link;
      while ((bp = bp->next) != bp_link)
      {
	int offset = bp->byte_offset;
	if (src_bot < (unsigned int) offset)
	{
	  bp->byte_offset = offset + offset_delta;
	  BP* prev = bp->prev;
	  BP* next = bp->next;
	  prev->next = next;
	  next->prev = prev;
	  dest->RegisterBP(bp);
	  bp = prev;
	}
      }
    }
  }
}

// private method
void NEAR
Buffer::StoreFlagdAttRange(unsigned int start,
			    unsigned int count, attr attrib)
{
  if (count)
  {
    attr* att = &this->attributes[start];
    do
    {
      *att++ = attrib;
    } while (--count);
  }
}

void
Buffer::GetCharInfo(int offset, sjis* c_return, attr* attrib_return)
{
  int index = GetPhysicalIndex(offset);
  if (index < 0)
  {
    *c_return = EOB;
  }
  else
  {
    *c_return = this->buf[index];
    *attrib_return = CHECK_ATTR(this->attributes[index] & ~IV_ALLMASK);
   }
}

BP* 
Buffer::GetStartBufferPointer()
{
  return(new BP(this, this->GetBeginningOffset()));
}

BP* 
Buffer::GetEndBufferPointer()
{
  return(new BP(this, this->GetEndOffset()));
}

BP* 
Buffer::FindText(sjis* what, BP* from_where, bool reverse)
{
  unsigned int what_len = what ? jislen(what) : 0;
  if (what_len == 0)
  {
    return(new BP(from_where));
  }
  
  // get thee behind me, Satan!
  this->GetGapToBP(from_where);
  
  sjis* buf = this->buf;
  uword bot = this->gapbottom;
  uword top = this->gaptop;
  if (reverse)
  {
    // ------------------------------
    // Backward search
    // search string longer than buffer always fails
    
    if (what_len <= bot)
    {
      unsigned int count = bot - what_len;
      sjis* bufferp = &buf[count];
      ++count;
      do
      {
	if (jiscmp(bufferp, what, what_len) == 0)
	{
	  // Adhere to bp gap convention
	  unsigned int here = (unsigned int) (bufferp - buf);
	  if (here == top)
	  {
	    here = bot;
	  }
	  return(new BP(this, here));
	}
	--bufferp;
      } while (--count);
    }
  }
  else
  {
    // ------------------------------
    // Forward search
    // search string longer than buffer always fails
    
    if (what_len <= (unsigned int)(this->buflen - top))
    {
      sjis* bufferp = &buf[top];
      unsigned int count = this->buflen - what_len - top + 1;
      do
      {
#if (1)
	if (*bufferp == *what)
	{
	  sjis* a = bufferp;
	  sjis* b = what;
	  int len = what_len;
	  while (*a++ == *b++)
	  {
	    if (--len == 0)
	    {
	      // Adhere to bp gap convention
	      unsigned int here = (unsigned int) (bufferp - buf);
	      if (here == top)
	      {
		here = bot;
	      }
	      return(new BP(this, here));
	    }
	  }
	} 
#else
	if (jiscmp(bufferp, what, what_len) == 0)
	{
	  // Adhere to bp gap convention
	  unsigned int here = (unsigned int) (bufferp - buf);
	  if (here == top)
	  {
	    here = bot;
	  }
	  return(new BP(this, here));
	}
#endif
	++bufferp;
      } while (--count);
    }
  }

  // We have failed
  return(NULL);
}

void
Buffer::Count(Stats& stats)
{
  unsigned int i_limit = this->gapbottom;
  unsigned int i = 0;
  for (bool firstp = True;; firstp = False)
  {
    sjis* buf_ptr;
    for (buf_ptr = &this->buf[i]; i < i_limit; ++buf_ptr, ++i)
    {
      sjis c = *buf_ptr;
      switch (GET_CHAR_TYPE(c))
      {
       case CharType_ANSI:
       case CharType_KANA:
	if (c >= ' ')
	{
	  ++stats.han;
	}
	break;
	
       case CharType_KANJI:
	++stats.zen;
	break;
      }
    }
    if (firstp)
    {
      i_limit = this->buflen;
      i = this->gaptop;
      continue;
    }
    break;
  }
}

void
Buffer::DelayFormat()
{
  Interval whole(this);
  whole.DelayFormat();
}

void
Buffer::SetAtts(attr a)
{
  this->atts = a;
  this->DelayFormat();
}

void
Buffer::SetParCharAtts()
{
  attr a = CHECK_ATTR(GetAttValue(this->GetAtts(), PA_charatt));
  unsigned int i_limit = this->gapbottom;
  unsigned int i = 0;
  for (bool firstp = True;; firstp = False)
  {
    attr* att_ptr;
    for (att_ptr = &this->attributes[i]; i < i_limit; ++att_ptr, ++i)
    {
      *att_ptr = CHECK_ATTR((*att_ptr & IV_ALLMASK) | a);
    }
    if (firstp)
    {
      i_limit = this->buflen;
      i = this->gaptop;
      continue;
    }
    break;
  }
}

void
Buffer::RedisplayHidden(attr& atts, bool& hidden)
{
  for (unsigned int i = 0; i < buflen; i++)
  {
    if (i == gapbottom)
    {
      i = gaptop;
      if (buflen <= i)
      {
	break;
      }
    }
    attr a = (attributes[i] & ~IV_ALLMASK);
    if (a != atts)
    {
      atts = a;
      hidden = (GetAttValue(a, CA_hidden) != 0);
    }
    if (hidden)
    {
      this->DelayFormat();
      break;
    }
  }
}

static void NEAR
sort_two_bp(BP** a, BP** b)
{
  BP* bp0 = *a;
  BP* bp1 = *b;
  if (LT(bp1, bp0))
  {
    *a = bp1;
    *b = bp0;
  }
}

// static method
IntervalList* 
Buffer::GreatFindParaStyle(DocumentContent* conte, uword style)
{
  IntervalList* list = new IntervalList;
  
  attr old_attrib = 0;
  bool found = False;
  for (TextFlow* flow = conte->GetFirstTextFlow();
       flow; flow = flow->GetNext())
  {
    bool old_found = False;
    Interval* interval = NULL;
    Buffer* end_buffer = NULL;
    for (Buffer* b = flow->GetFirstParagraph(); b; b = b->GetNext())
    {
      attr attrib = b->GetAtts();
      if (attrib != old_attrib)
      {
	old_attrib = attrib;
	found = (::GetBaseStyle(attrib) == (int) style);
      }
      if (found != old_found)
      {
	old_found = found;
	if (found)
	{
	  interval = new Interval(b);
	  list->AddIntervalAtHead(interval);
	}
	else
	{
	  interval->GetBP1() ->EndOfBuffer(end_buffer);
	  interval = NULL;
	}
      }
      end_buffer = b;
    }
    if (old_found)
    {
      interval->GetBP1() ->EndOfBuffer(end_buffer);
    }
  }
  
  if (list->GetHead() == NULL)
  {
    delete list;
    list = NULL;
  }
  return(list);
}

IntervalList* 
Buffer::GreatFindCharStyle(DocumentContent* conte, uword style)
{
  IntervalList* list = new IntervalList;
  
  attr old_attrib = 0;
  bool found = False;
  for (TextFlow* flow = conte->GetFirstTextFlow();
       flow; flow = flow->GetNext())
  {
    bool old_found = False;
    Buffer* start_buffer = NULL;
    int start_offset = 0;
    for (Buffer* b = flow->GetFirstParagraph(); b; b = b->GetNext())
    {
      int i0 = b->GetBeginningOffset();
      int i1 = b->GetEndOffset();
      unsigned int i_limit = MIN(b->gapbottom, (unsigned int) i1);
      unsigned int i = i0;
      for (bool firstp = True;; firstp = False)
      {
	attr* att_ptr;
	for (att_ptr = &b->attributes[i]; i < i_limit; ++att_ptr, ++i)
	{
	  attr attrib = (*att_ptr & ~IV_ALLMASK);
	  if (attrib != old_attrib)
	  {
	    old_attrib = attrib;
	    found = (::GetBaseStyle(attrib) == (int) style);
	  }
	  if (found != old_found)
	  {
	    old_found = found;
	    if (found)
	    {
	      start_buffer = b;
	      start_offset = i;
	    }
	    else
	    {
	      BP* bp0 = new BP(start_buffer, start_offset);
	      BP* bp1 = new BP(b, i);
	      list->AddIntervalAtHead(new Interval(bp0, bp1));
	      delete bp1;
	      delete bp0;
	      start_buffer = NULL;
	    }
	  }
	}
	if (firstp)
	{
	  i_limit = i1;
	  i = MAX((unsigned int) i0, b->gaptop);
	  continue;
	}
	break;
      }
    }
    if (old_found)
    {
      BP* bp0 = new BP(start_buffer, start_offset);
      BP* bp1 = flow->GetEndBufferPointer();
      list->AddIntervalAtHead(new Interval(bp0, bp1));
      delete bp1;
      delete bp0;
    }
  }
  
  if (list->GetHead() == NULL)
  {
    delete list;
    list = NULL;
  }
  return(list);
}

IntervalList* 
Buffer::FindVText(int i0, int i1)
{
  IntervalList* il = NULL;
  unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
  unsigned int i = i0;
  for (bool firstp = True;; firstp = False)
  {
    sjis* buf_ptr;
    for (buf_ptr = &this->buf[i]; i < i_limit; ++buf_ptr, ++i)
    {
      if (IsPanel(*buf_ptr))
      {
	Panel* p = this->GetPanel(*buf_ptr);
	if (p->GetPanelID() == Panel::VTextPanelID)
	{
	  if (il == NULL)
	  {
	    il = new IntervalList;
	  }
	  il->AddInterval(new Interval(p->GetRightBP()));
	}
      }
    }
    if (firstp)
    {
      i_limit = i1;
      i = MAX((unsigned int) i0, this->gaptop);
      continue;
    }
    break;
  }
  return(il);
}

void
Buffer::VariableTextUpdate(int i0, int i1, int& present, int& changed)
{
  assert(i0 <= i1);
  
  present = changed = 0;
  unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
  unsigned int i = i0;
  for (bool firstp = True;; firstp = False)
  {
    sjis* buf_ptr;
    for (buf_ptr = &this->buf[i]; i < i_limit; ++buf_ptr, ++i)
    {
      if (IsPanel(*buf_ptr))
      {
	Panel* p = this->GetPanel(*buf_ptr);
	if (p->GetPanelID() == Panel::VTextPanelID)
	{
	  ++present;
	  VTextPanel* vtp = p->CastToVTextPanel();
	  if ((vtp->GetVText()->GetVTextID() != VText::PageNoVTextID) &&
	      (vtp->Evaluate(0)))
	  {
	    ++changed;
	    vtp->DelayFormat();
	  }
	}
      }
    }
    if (firstp)
    {
      i_limit = i1;
      i = MAX((unsigned int) i0, this->gaptop);
      continue;
    }
    break;
  }
}

bool
Buffer::GetCommonAtt(attr& common_att, int i0, int i1)
{
  attr attrib = 0;
  bool present = False;
  unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
  unsigned int i = i0;
  for (bool firstp = True;; firstp = False)
  {
    attr* att_ptr;
    for (att_ptr = &this->attributes[i]; i < i_limit; ++att_ptr, ++i)
    {
      present = True;
      attr a = (*att_ptr & ~IV_ALLMASK);
      if (attrib == 0)
      {
	attrib = a;
      }
      else if (attrib != a)
      {
	attrib = 0;
	goto done;
      }
    }
    if (firstp)
    {
      i_limit = i1;
      i = MAX((unsigned int) i0, this->gaptop);
      continue;
    }
    break;
  }
 done:
  common_att = attrib;
  return(present);
}

// static method
void
Buffer::BigApplyCharAtt(BP* bp0,
			 BP* bp1,
			 attr(*func) (attr, int, int),
			 int attcode, int attval)
{
  sort_two_bp(&bp0, &bp1);
  
  attr old_attrib = 0;
  attr new_attrib = 1;
  Buffer* b0 = bp0->GetBuffer();
  Buffer* b1 = bp1->GetBuffer();
  for (Buffer* b = b0; b; b = b->GetNext())
  {
    int i0 = b == b0 ? bp0->GetByteOffset() : b->GetBeginningOffset();
    int i1 = b == b1 ? bp1->GetByteOffset() : b->GetEndOffset();
    unsigned int i_limit = MIN(b->gapbottom, (unsigned int) i1);
    unsigned int i = i0;
    for (bool firstp = True;; firstp = False)
    {
      attr* att_ptr;
      for (att_ptr = &b->attributes[i]; i < i_limit; ++att_ptr, ++i)
      {
	uword att_and_flags;
	attr a;
	if ((a = ((att_and_flags = *att_ptr) & ~IV_ALLMASK)) != old_attrib)
	{
	  old_attrib = a;
	  new_attrib = (*func) (a, attcode, attval);
	}
	*att_ptr = (att_and_flags & IV_ALLMASK) | new_attrib;
      }
      if (firstp)
      {
	i_limit = i1;
	i = MAX((unsigned int) i0, b->gaptop);
	continue;
      }
      break;
    }
    if (b == b1)
    {
      break;
    }
  }
}

// static method
void
Buffer::BigSetFlags(BP* bp0, BP* bp1, uword off, uword on)
{
  sort_two_bp(&bp0, &bp1);
  
  off = ~off;
  Buffer* b0 = bp0->GetBuffer();
  Buffer* b1 = bp1->GetBuffer();
  for (Buffer* b = b0; b; b = b->GetNext())
  {
    int i0 = b == b0 ? bp0->GetByteOffset() : b->GetBeginningOffset();
    int i1 = b == b1 ? bp1->GetByteOffset() : b->GetEndOffset();
    unsigned int i_limit = MIN(b->gapbottom, (unsigned int) i1);
    unsigned int i = i0;
    for (bool firstp = True;; firstp = False)
    {
      attr* att_ptr;
      for (att_ptr = &b->attributes[i]; i < i_limit; ++att_ptr, ++i)
      {
	*att_ptr = (*att_ptr & off) | on;
      }
      if (firstp)
      {
	i_limit = i1;
	i = MAX((unsigned int) i0, b->gaptop);
	continue;
      }
      break;
    }
    if (b == b1)
    {
      break;
    }
    b->eob_flags = (b->eob_flags & off) | on;
  }
}

// static method
void
Buffer::BigDelete(BP* bp0, BP* bp1)
{
  sort_two_bp(&bp0, &bp1);
  
  Buffer* b0 = bp0->editor;
  Buffer* b1 = bp1->editor;
  if (b0 == b1)
  {
    b0->KillPanels(bp0->byte_offset, bp1->byte_offset);
    for (;;)
    {
      int bot = b0->gapbottom;
      int i0 = bp0->byte_offset;
      int i1 = bp1->byte_offset;
      if (i0 == i1)
      {
	break;
      }
      if (i0 == bot)
      {
	b0->CrushBPs(i0, i1, i0);
	b0->gaptop = i1;
	break;
      }
      if (i1 == bot)
      {
	b0->CrushBPs(i0, i1, i0);
	b0->gapbottom = i0;
	break;
      }
      if (i0 < bot && bot < i1)
      {
	b0->CrushBPs(i0, i1, i0);
	b0->gapbottom = i0;
	b0->gaptop = i1;
	break;
      }
      b0->GetGapToBP(bot < i0 ? bp0 : bp1);
    }
  }
  else
  {
    b0->eob_flags = 0;
    b0->GetGapToBP(bp0);
    unsigned int bot0 = b0->gapbottom;
    unsigned int top0 = b0->gaptop;
    unsigned int length0 = b0->buflen;
    if (top0 != length0)
    {
      b0->KillPanels(bot0, length0);
      b0->CrushBPs(bot0, length0, bot0);
      b0->gaptop = length0;
    }
    
    Buffer* b = b0->GetNext();
    while (b != b1)
    {
      Buffer* next = b->GetNext();
      delete b;
      b = next;
    }
    
    Buffer::Transport(bp0, bp1);
    if (b0->flags & BF_ERROR)
    {
      return;
    }
    b0->RegisterBPs(b1->GetBPLink(), bp0->byte_offset);
    b1->GetBPLink() ->prev = b1->GetBPLink();
    b1->GetBPLink() ->next = b1->GetBPLink();
    delete b1;
  }
  CHECK_BPS(b0);
}

void
Buffer::InsertChars(BP* bp, sjis* stuff, uword count, attr attrib)
{
  if (0 < count)
  {
    this->EnsureAllocSpace(count);
    if (!(this->flags & BF_ERROR))
    {
      this->GetGapToBP(bp);
      unsigned int bot = this->gapbottom;
      memcpy(&this->buf[bot], stuff, BUFUNIT * count);
      this->StoreFlagdAttRange(bot, count, attrib);
      bot += count;
      bp->byte_offset = bot;
      this->gapbottom = bot;
    }
  }
}

// ReadFormattedFromStream -- read all or parts of a paragraph from a stream.
// stream -- stream to read from
// where -- where to start insertion.  updated to end of insertion. 
void
Buffer::ReadFormattedFromStream(PStream* stream, BP* where)
{
  word dummy;
  
  PStream::WriteWhat what = stream->GetWhat();
  
  bool ww_text_p = (what & PStream::WW_TEXT) != 0;
  bool ww_char_atts_p = (what & PStream::WW_CHARATTS) != 0;
  bool ww_att_content_p = (what & PStream::WW_ATTCONTENT) != 0;
  
  // read in paragraph header information(attributes)
  stream->StartTypedBlockIn(PStream::HDR_PARAGRAPH, dummy);
  CHECK;
  
  if (what & PStream::WW_PARATTS)
  {
    attr a;
    if (ww_att_content_p)
    {
      a = ::ReadParAtt(stream);
    }
    else
    {
      a = stream->InUWord();
    }
    if ((what & PStream::WW_UNDO) || !ww_text_p || this->GetSize() == 0)
    {
      this->atts = a;
    }
  }

  // read text
  {
    DocumentContent* dc = this->GetDocContent();

    stream->StartTypedBlockIn(PStream::HDR_BUFFER, dummy);
    CHECK;

    int count = stream->InUWord();
    CHECK;

    if (count)
    {
      int plugloc;
      if (ww_text_p)
      {
	this->GetGapToBP(where);
	this->EnsureAllocSpace(count);
	if (this->flags & BF_ERROR)
	{
	  stream->EndBlockIn();
	  return;
	}
	// kill all flags
	this->StoreFlagdAttRange(this->gapbottom, count, 0);
	plugloc = this->gapbottom;
      }
      else if (ww_char_atts_p)
      {
	plugloc = where->byte_offset;
      }

      int bad_panels = 0;
      for (int i = 0; i < count; ++i, ++plugloc)
      {
	bool bad_panel = False;
	if (ww_text_p)
	{
	  sjis ch;
	  this->buf[plugloc] = ch = stream->InUWord();
	  CHECK;
	  if (IsPanel(ch))
	  {
	    Panel* p;
	    {
	      BP bp(this, this->gapbottom + i + 1);
	      p = Panel::ReadFromStream(dc, &bp, stream);
	    }
	    CHECK;
	    if (p == NULL)
	    {
#if (1)
	      stream->SetError(SE_TOOMUCH);
	      return;
#else
	      bad_panel = True;
	      bad_panels++;
	      --plugloc;
#endif
	    }
	    else
	    {
	      this->buf[plugloc] = dc->GetPanelCode(p);
	    }
	  }
	}
	if (ww_char_atts_p)
	{
	  if (!ww_text_p)
	  {
	    if ((unsigned int) plugloc == gapbottom)
	    {
	      plugloc = gaptop;
	    }
	  }
	  attr a;
	  if (!ww_att_content_p)
	  {
	    a = stream->InUWord();
	  }
	  else
	  {
	    a = ReadCharAtt(stream);
	  }
	  CHECK;
	  if (!bad_panel)
	  {
	    this->attributes[plugloc] = ((this->attributes[plugloc] & IV_ALLMASK) | a);
	  }
	}
      }
      if (ww_text_p)
      {
	gapbottom += count - bad_panels;
	where->byte_offset = plugloc;
      }
    }

    stream->EndBlockIn();
    CHECK;
  }
  
  stream->EndBlockIn();
}

void
Buffer::WriteFormattedToStream(PStream* stream, int i0, int i1)
{
  assert(i0 <= i1);
  
  PStream::WriteWhat what = stream->GetWhat();
  
  // write out paragraph header information(attributes)
  stream->StartBlockOut(PStream::HDR_PARAGRAPH);
  CHECK;
  
  bool ww_text_p = (what & PStream::WW_TEXT) != 0;
  bool ww_char_atts_p = (what & PStream::WW_CHARATTS) != 0;
  bool ww_att_content_p = (what & PStream::WW_ATTCONTENT) != 0;
  
  if (what & PStream::WW_PARATTS) 
  {
    if (ww_att_content_p)
    {
      ::WriteParAtt(stream, this->GetAtts());
    }
    else
    {
      stream->OutUWord(this->GetAtts());
    }
    CHECK;
  }
  
  // write out text
  {
    stream->StartBlockOut(PStream::HDR_BUFFER);
    CHECK;
    
    stream->OutUWord(this->SubSize(i0, i1));
    CHECK;
    
    unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
    unsigned int i = i0;
    for (bool firstp = True;; firstp = False)
    {
      sjis* buf_ptr;
      attr* att_ptr;
      for (buf_ptr = &this->buf[i], att_ptr = &this->attributes[i];
	   i < i_limit; ++buf_ptr, ++att_ptr, ++i)
      {
	if (ww_text_p)
	{
	  sjis ch = *buf_ptr;
	  stream->OutUWord(ch);
	  CHECK;
	  if (IsPanel(ch))
	  {
	    this->GetPanel(ch) ->WriteToStream(stream);
	    CHECK;
	  }
	}
	if (ww_char_atts_p)
	{
	  uword aid = (*att_ptr & ~IV_ALLMASK);
	  if (!ww_att_content_p)
	  {
	    stream->OutUWord(aid);
	  }
	  else
	  {
	    WriteCharAtt(stream, aid);
	  }
	  CHECK;
	}
      }
      if (firstp)
      {
	i_limit = i1;
	i = MAX((unsigned int) i0, this->gaptop);
	continue;
      }
      break;
    }
    stream->EndBlockOut();
    CHECK;
  }
  
  stream->EndBlockOut();
}

// WriteASCIIToStream -- convert the buffer to ASCII text, using just
// one byte for one-byte characters, then write it to the specified
// stream
void
Buffer::WriteASCIIToStream(BufStream* stream, int i0, int i1)
{
  assert(i0 <= i1);
  if (i0 < i1)
  {
    unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
    unsigned int i = i0;
    for (bool firstp = True;; firstp = False)
    {
      sjis* buf_ptr;
      for (buf_ptr = &this->buf[i]; i < i_limit; ++buf_ptr, ++i)
      {
	char outbuf[2];
	int count = 0;
	sjis ch = *buf_ptr;
	CharType type = GET_CHAR_TYPE(ch);
	switch (type)
	{
	 case CharType_ANSI:
	 case CharType_KANA:
	  outbuf[0] = (char)ch;
	  ++count;
	  if (ch == NLC)
	  {
	    outbuf[0] = '\r';
	    outbuf[1] = '\n';
	    count++;
	  }
	  break;
	  
	 case CharType_KANJI:
	  outbuf[0] = ch >> 8;
	  outbuf[1] = (char)ch;
	  count = 2;
	  break;
	  
	 case CharType_PANEL:
	  this->GetPanel(ch) ->WriteASCIIToStream(stream);
	  break;
	}
	if (count)
	{
	  stream->Put(outbuf, count);
	}
      }
      if (firstp)
      {
	i_limit = i1;
	i = MAX((unsigned int) i0, this->gaptop);
	continue;
      }
      break;
    }
  }
}

void 
Buffer::MarkCookieConnections(PStream* stream, int i0, int i1)
{
  assert(i0 <= i1);
  
  // mark attributes on the paragraph itself
  if (stream == NULL || (stream->GetWhat() & PStream::WW_ATTCONTENT))
  {
    ::MarkCookieConnections(this->GetAtts());
  }
  
  unsigned int i_limit = MIN(this->gapbottom, (unsigned int) i1);
  unsigned int i = i0;
  for (bool firstp = True;; firstp = False)
  {
    sjis* buf_ptr;
    attr* att_ptr;
    for (buf_ptr = &this->buf[i], att_ptr = &this->attributes[i];
	 i < i_limit; ++buf_ptr, ++att_ptr, ++i)
    {
      ::MarkCookieConnections(*att_ptr & ~IV_ALLMASK);
      if (IsPanel(*buf_ptr))
      {
	this->GetPanel(*buf_ptr) ->Mark(stream);
      }
    }
    if (firstp)
    {
      i_limit = i1;
      i = MAX((unsigned int) i0, this->gaptop);
      continue;
    }
    break;
  }
}

Buffer::~Buffer()
{
  TextFlow* flow = this->textflow;
  Buffer* prev = this->prev;
  Buffer* next = this->next;
  if (prev)
  {
    flow->SetFirstDirtyID(prev);
  }
  
  this->KillPanels(0, buflen);
  if (this->log2_of_buffer_size)
  {
    xfree_on_log2(this->buf, this->log2_of_buffer_size);
    xfree_on_log2(this->attributes, this->log2_of_buffer_size);
  }
  
  BP* bp_link = this->GetBPLink();
  if (bp_link->next != bp_link)
  {
    if (prev == NULL && next == NULL)
    {
#if (!defined(NDEBUG))
      syserr("Delete last Buffer, what about these BP's?");
#endif
      BP* prev_bp = bp_link->prev;
      BP* next_bp = bp_link->next;
      prev_bp->next = next_bp;
      next_bp->prev = prev_bp;
    }
    if (prev)
    {
      prev->RegisterBPs(bp_link, prev->GetEndOffset());
    }
    else if (next)
    {
      next->RegisterBPs(bp_link, next->GetBeginningOffset());
    }
  }
  
  *(next ? &next->prev : flow->GetLastParagraphPtr()) = prev;
  *(prev ? &prev->next : flow->GetFirstParagraphPtr()) = next;
}

// Please use `Buffer::MakeInstance'
// private method
inline
Buffer::Buffer()
{
  // memory allocation only
}

#ifndef MAX_LONG
#define MAX_LONG 0x7fffffffL
#endif

// depending on windows design
#define MAX_NUM_OF_WINDOWS_MEMORY_HANDLE 8192
#define MAX_SIZE_OF_WINDOWS_MEMORY \
((1L << LOG2_OF_MAX_ALLOC) * MAX_NUM_OF_WINDOWS_MEMORY_HANDLE)
#define MAX_NUM_OF_BUFFER	(MAX_SIZE_OF_WINDOWS_MEMORY / sizeof(Buffer))

#define CMP_VALUE_STEP	(MAX_LONG / MAX_NUM_OF_BUFFER)

// static method
Buffer* 
Buffer::MakeInstance(TextFlow* flow, Buffer* prev, attr attrib)
{
  assert(flow != NULL);
  assert((prev == NULL
	   && flow->GetFirstParagraph() == NULL
	   && flow->GetLastParagraph() == NULL)
	  || (flow->GetFirstParagraph() && flow->GetLastParagraph()));
  
  Buffer* buffer = new Buffer;
  buffer->textflow = flow;
  buffer->buf = NULL;
  buffer->attributes = NULL;
  buffer->buflen = 0;
  buffer->gapbottom = 0;
  buffer->gaptop = 0;
  buffer->log2_of_buffer_size = 0;
  buffer->GetBPLink() ->prev = buffer->GetBPLink();
  buffer->GetBPLink() ->next = buffer->GetBPLink();
  buffer->first_frame = NULL;
  buffer->eob_flags = 0;
  buffer->flags = 0;
  buffer->atts = attrib;
  
  Buffer* next = NULL;
  if (prev == NULL)
  {
    flow->SetFirstParagraph(buffer);
    buffer->id = 1;
  }
  else
  {
    assert(prev->GetTextFlow() == flow);
    prev->eob_flags = 0;
    next = prev->next;
    prev->next = buffer;
    buffer->id = prev->id + 1;
  }
  buffer->prev = prev;
  buffer->next = next;
  if (next)
  {
    next->prev = buffer;
  }
  else
  {
    flow->SetLastParagraph(buffer);
  }
  
  // setup `cmp_value' slot
  if (prev == NULL)
  {
    buffer->cmp_value = 0;
  }
  else
  {
    long value = prev->cmp_value;
    if (next == NULL)
    {
      buffer->cmp_value = value += CMP_VALUE_STEP;
    }
    else
    {
      buffer->cmp_value = ++value;
      assert(value <= next->cmp_value);
      if (value == next->cmp_value)
      {
	value += CMP_VALUE_STEP;
	Buffer* b = next;
	for (;;)
	{
	  b->cmp_value = ++value;
	  if ((b = b->next) == NULL || value < b->cmp_value)
	  {
	    break;
	  }
	}
      }
    }
    if (value <= 0)
    {
      // you're loose
      Buffer* b = flow->GetFirstParagraph();
      value = 0;
      do
      {
	b->cmp_value = value;
	value += CMP_VALUE_STEP;
      } while ((b = b->next) != NULL);
    }
  }
  
  if (next)
  {
    flow->SetFirstDirtyID(next);
  }
  return(buffer);
}

// ------------------------------------------------------------
// `BP' class

#if (!defined(NDEBUG))
void
CheckSameFlow(BP* bp0, BP* bp1)
{
  if (bp0->GetTextFlow() != bp1->GetTextFlow())
  {
    syserr("two BPs point different text-flow");
  }
}
#endif

int
BPcmp(BP& bp0, BP& bp1)
{
  CHECK_SAME_FLOW(&bp0, &bp1);
  
  if (bp0.GetBuffer() != bp1.GetBuffer())
  {
    return((bp0.GetBuffer() ->GetCmpValue()
	     < bp1.GetBuffer() ->GetCmpValue())
	    ? 1 : -1);
  }
  int diff;
  return((diff = bp1.GetByteOffset() - bp0.GetByteOffset()) < 0 ? -1
	  : diff == 0 ? 0 : 1);
}

int
BP::EndOfBufferP()
{
  return(this->GetBuffer() ->GetSize() <= this->GetLogicalOffset());
}

int
BP::BeginningOfTextP()
{
  return(this->BeginningOfBufferP()
	  && this->GetBuffer() ->GetPrev() == NULL);
}

int
BP::EndOfTextP()
{
  return(this->EndOfBufferP() && this->GetBuffer() ->GetNext() == NULL);
}

BP* 
BP::SetBuffer(Buffer* editor)
{
  if (editor != this->editor)
  {
    if (this->editor)
    {
      this->editor->DeregisterBP(this);
    }
    editor->RegisterBP(this);
  }
  return(this);
}

int
BP::GetLogicalOffset()
{
  return(this->editor->GetLogicalOffset(this->byte_offset));
}

BP* 
BP::SetLogicalOffset(int l_offset)
{
  this->byte_offset = this->editor->GetPhysicalOffset(l_offset);
  return(this);
}

BP* 
BP::SetLogicalOffset(Buffer* editor, int l_offset)
{
  this->SetBuffer(editor);
  return(this->SetLogicalOffset(l_offset));
}

// Set `this''s location by `source'.
BP* 
BP::Set(BP* source)
{
  this->byte_offset = source->byte_offset; // simple copy
  this->SetBuffer(source->editor);
  return(this);
}

BP* 
BP::SetAndDelete(BP* source)
{
  this->Set(source);
  delete source;
  return(this);
}

BP* 
BP::SetMax(BP* source)
{
  if (LT(this, source))
  {
    this->Set(source);
  }
  return(this);
}

BP* 
BP::SetMin(BP* source)
{
  if (LT(source, this))
  {
    this->Set(source);
  }
  return(this);
}

BP* 
BP::Add(int i)
{
  Buffer* b = this->GetBuffer();
  
  this->byte_offset
  = b->GetPhysicalOffset(b->GetLogicalOffset(this->byte_offset) + i);
  
  return(this);
}

// This method increments location, and returns True.
// Returns False if end of buffer.
bool
BP::Increment()
{
  int old_i = this->GetByteOffset();
  this->Add(1);
  return(old_i != this->GetByteOffset());
}

// This method sees if it is possible to increment location, 
// returning True if it is.
// This method decrements location, and returns True.
// Returns False if beginning of buffer.
bool
BP::Decrement()
{
  int old_i = this->GetByteOffset();
  this->Add(-1);
  return(old_i != this->GetByteOffset());
}

// cross editor increment --
// This method returns if `this' is end of text.
bool
BP::XIncrement()
{
  if (!this->Increment())
  {
    Buffer* buffer;
    if ((buffer = this->GetBuffer() ->GetNext()) == NULL)
    {
      return(False);
    }
    this->BeginningOfBuffer(buffer);
  }
  return(True);
}

// cross editor decrement --
// This method returns if `this' is beginning of text.
bool
BP::XDecrement()
{
  if (!this->Decrement())
  {
    Buffer* buffer;
    if ((buffer = this->GetBuffer() ->GetPrev()) == NULL)
    {
      return(False);
    }
    this->EndOfBuffer(buffer);
  }
  return(True);
}

BP* 
BP::BeginningOfBuffer(Buffer* editor)
{
  this->byte_offset = editor->GetBeginningOffset();
  return(this->SetBuffer(editor));
}

BP* 
BP::EndOfBuffer()
{
  this->byte_offset = this->GetBuffer() ->GetEndOffset();
  return(this);
}

BP* 
BP::EndOfBuffer(Buffer* editor)
{
  this->byte_offset = editor->GetEndOffset();
  return(this->SetBuffer(editor));
}

// This method moves `this' to beginning of `text', and returns `this'.
BP* 
BP::BeginningOfText(TextFlow* text)
{
  return(this->BeginningOfBuffer(text->GetFirstParagraph()));
}

// This method moves `this' to beginning of text-flow, and returns `this'.
BP* 
BP::BeginningOfText()
{
  return(this->BeginningOfText(this->GetTextFlow()));
}

// This method moves `this' to end of `text', and returns `this'.
BP* 
BP::EndOfText(TextFlow* text)
{
  return(this->EndOfBuffer(text->GetLastParagraph()));
}

// This method moves `this' to end of text-flow, and returns `this'.
BP* 
BP::EndOfText()
{
  return(this->EndOfText(this->GetTextFlow()));
}

// This method moves `this' to `count' characters forward.
// if `count' is negative, moves backward.
// And returns True on success, False on fail.
// If method returns False, `this' is moved maybe.
// If `count' is zero, does nothing and returns True.
bool
BP::ForwardChar(int count)
{
  for (; count < 0; ++count)
  {
    if (!this->XDecrement())
    {
      return(False);
    }
  }
  for (; 0 < count; --count)
  {
    if (!this->XIncrement())
    {
      return(False);
    }
  }
  return(True);
}

// Char_Syntax -- This value define word.
enum Char_Syntax
{
  Char_Syntax_PUNCT,		// normal punctuator
  Char_Syntax_SPACE,		// space, tab, newline, and-of-buffer ...
  Char_Syntax_DIGIT,		// decimal digit
  Char_Syntax_EUROCHAR,		// alphabet, greek, ...
  Char_Syntax_KANA,		// han-kaku katakana
  Char_Syntax_HIRAGANA,		// zen-kaku hiragana
  Char_Syntax_KATAKANA,		// zen-kaku katakana
  Char_Syntax_KANJI,		// kanji
};

static Char_Syntax NEAR
char_syntax(sjis ch)
{
  switch (GET_CHAR_TYPE(ch))
  {
   case CharType_ANSI:
    if (0x80 <= ch)
    {
      return(Char_Syntax_EUROCHAR);
    }
    if (ch <= 0x20)
    {
      return(Char_Syntax_SPACE);
    }
    if (('a' <= ch && ch <= 'z')
	|| ('A' <= ch && ch <= 'Z') || ch == '\"' || ch == '\'')
    {
      return(Char_Syntax_EUROCHAR);
    }
    if ('0' <= ch && ch <= '9')
    {
      return(Char_Syntax_DIGIT);
    }
    break;
    
   case CharType_KANA:
    switch (ch & 0xff)
    {
     case 0xa0:
      return(Char_Syntax_SPACE);
      
     case 0xa1:			// maru
     case 0xa2:			// left kakko
     case 0xa3:			// right kakko
     case 0xa4:			// ten
     case 0xa5:			// nakaguro
      return(Char_Syntax_PUNCT);
    }
    return(Char_Syntax_KANA);
    
   case CharType_KANJI:
    if (0x8800 <= ch)
    {
      return(Char_Syntax_KANJI);
    }
    if (ch < 0x829f)
    {
      if (0x8260 <= ch)
      {
	return(Char_Syntax_EUROCHAR);
      }
      if (0x824f <= ch)
      {
	return(Char_Syntax_DIGIT);
      }
      switch (ch)
      {
       case 0x8140:		// ZENKANU space
	return(Char_Syntax_SPACE);

       case 0x8152:		// repeat chars
       case 0x8153:
       case 0x8154:
       case 0x8155:
       case 0x8156:
	return(Char_Syntax_HIRAGANA);

       case 0x8157:		// repeat chars
       case 0x8158:
	return(Char_Syntax_KANJI);
	
       case 0x815b:		// chyo-on
	return(Char_Syntax_KATAKANA);
      }
    }
    else
    {
      if (ch < 0x8340)
      {
	return(Char_Syntax_HIRAGANA);
      }
      if (ch < 0x839f)
      {
	return(Char_Syntax_KATAKANA);
      }
      if (ch < 0x849f)
      {
	return(Char_Syntax_EUROCHAR);
      }
    }
    break;
  }
  return(Char_Syntax_PUNCT);
}

// This method moves `this' to `count' words forward.
// if `count' is negative, moves backward.
// And returns True on success, False on fail.
// If method returns False, `this' is moved maybe.
// If `count' is zero, does nothing and returns True.
bool
BP::ForwardWord(int count)
{
  while (count < 0)
  {
    if (!this->XDecrement())
    {
      break;
    }
    ++count;
    sjis c = this->GetRightChar();
    Char_Syntax syntax = char_syntax(c);
    if (syntax == Char_Syntax_PUNCT)
    {
      while (this->GetLeftChar() == c && this->XDecrement())
      {
      }
    }
    else
    {
      while (char_syntax(this->GetLeftChar()) == syntax
	     && this->XDecrement())
      {
      }
    }
  }
  
  while (0 < count)
  {
    if (!this->XIncrement())
    {
      break;
    }
    --count;
    sjis c = this->GetLeftChar();
    Char_Syntax syntax = char_syntax(c);
    if (syntax == Char_Syntax_PUNCT)
    {
      while (this->GetRightChar() == c && this->XIncrement())
      {
      }
    }
    else
    {
      while (char_syntax(this->GetRightChar()) == syntax
	     && this->XIncrement())
      {
      }
    }
  }
  
  return(count == 0);
}

// This method moves `this' to `count' lines forward.
// if `count' is negative, moves backward.
// And returns True on success, False on fail.
// If method returns False, `this' is moved maybe.
// If `count' is zero, does nothing and returns True.
bool
BP::ForwardLine(int count)
{
  if (count != 0)
  {
    Lpoint frame_lp[1];
    Lpoint old_lp[1];
    Line* line = this->maybe_find_line_and_lpoint(old_lp);
    line->GetFrame() ->get_lpoint(frame_lp);
    POINT_X(old_lp) -= POINT_X(frame_lp);
    POINT_Y(old_lp) -= POINT_Y(frame_lp);
    
    for (; count < 0; ++count)
    {
      line = line->XGetPrev();
      if (line->NilP())
      {
	return(False);
      }
    }

    for (; 0 < count; --count)
    {
      line = line->XGetNext();
      if (line->NilP())
      {
	return(False);
      }
    }

    line->GetFrame() ->get_lpoint(frame_lp);
    POINT_X(old_lp) += POINT_X(frame_lp);
    POINT_Y(old_lp) += POINT_Y(frame_lp);
    line->navigate_bp(old_lp, this, NULL);
  }
  return(True);
}

// Returns True for success, False for fail.
int
BP::Move(uword wParam)
{
  int result = False;
  switch (wParam)
  {
   case IDM_Nav_CharLeft:
    result = this->ForwardChar(-1);
    break;
    
   case IDM_Nav_CharRight:
    result = this->ForwardChar(1);
    break;
    
   case IDM_Nav_LineUp:
    result = this->ForwardLine(-1);
    break;
    
   case IDM_Nav_LineDown:
    result = this->ForwardLine(1);
    break;
    
   case IDM_Nav_WordLeft:
    result = this->ForwardWord(-1);
    break;
    
   case IDM_Nav_WordRight:
    result = this->ForwardWord(1);
    break;
    
   case IDM_Nav_ParStart:
    if (this->XDecrement())
    {
      this->BeginningOfBuffer();
      result = True;
    }
    break;
    
   case IDM_Nav_ParEnd:
    if (this->XIncrement())
    {
      this->EndOfBuffer();
      result = True;
    }
    break;
    
   case IDM_Nav_LineLeft:
    {
      Line* line = this->FindLine();
      if (line != NULL)
      {
	result = True;
	BP* first_bp = line->GetFirstBP();
	int already_there = EQ(this, first_bp);
	this->Set(first_bp);
	if (already_there)
	{
	  result = this->ForwardLine(-1);
	}
      }
    }
    break;
    
   case IDM_Nav_LineRight:
    {
      Line* line = this->FindLine();
      if (line != NULL)
      {
	result = True;
	BP bp(line->GetFirstBP());
	bp.Add(line->GetNumChars());
	if (EQ(&bp, this))
	{
	  line = line->GetNext();
	  if (line == NULL)
	  {
	    result = False;
	  }
	  else
	  {
	    this->Set(line->GetFirstBP());
	    this->Add(line->GetNumChars());
	  }
	}
	else 
	{
	  this->Set(&bp);
	}
      }
    }
    break;
    
   case IDM_Nav_DocTop:
    this->BeginningOfText();
    result = True;
    break;
    
   case IDM_Nav_DocBottom:
    this->EndOfText();
    result = True;
    break;
  }
  return(result);
}

#ifdef notdef
bool
BP::Move(uword wParam, int control)
{
  switch (wParam)
  {
   case IDM_Nav_DocTop:
    this->BeginningOfText();
    break;
    
   case IDM_Nav_DocBottom:
    this->EndOfText();
    break;
    
   case IDM_Nav_LineUp:
    return(this->ForwardLine(-1));
    
   case IDM_Nav_LineDown:
    return(this->ForwardLine(1));
    
   case IDM_Nav_LineLeft:
    {
      Line* line = this->FindLine();
      if (line == NULL)
      {
	return(False);
      }
      BufferPointer bp(line->GetFirstBP());
      bool already_there = bp == *this;
      *this = bp;
      if (already_there)
      {
	return this->ForwardLine(-1);
      }
    }
    break;
    
   case IDM_Nav_LineRight:
    {
      Line* line = this->FindLine();
      if (line == NULL)
      {
	return(False);
      }
      BufferPointer bp(line->GetFirstBP());
      bp.Add(line->GetNumChars());
      bool already_there = bp == *this;
      if (already_there)
      {
	line = line->GetNext();
	if (line != NULL)
	{
	  *this = *(line->GetFirstBP());
	  this->Add(line->GetNumChars());
	}
	else
	{
	  return False;
	}
      }
      else 
      {
	*this = bp;
      }
    }
    break;
   
   case IDM_Nav_CharLeft:
    return(control ? this->ForwardWord(-1) : this->ForwardChar(-1));
    
   case IDM_Nav_CharRight:
    return(control ? this->ForwardWord(1) : this->ForwardChar(1));
    
   case IDM_Nav_ParEnd:
    if (!this->XIncrement())
    {
      return(False);
    }
    this->EndOfBuffer();
    break;
    
   case IDM_Nav_ParStart:
    if (!this->XDecrement())
    {
      return(False);
    }
    this->BeginningOfBuffer();
    break;
    
   default:
#if (!defined(NDEBUG))
    syserr("BufferPointer::Move -- invalid command %x", wParam);
#endif
    return(False);
  }
  return(True);
}
#endif /* notdef */

// This method returns right side character.
// `this' is NOT changed.
sjis
BP::GetRightChar()
{
  return(this->editor->GetChar(this->GetLogicalOffset()));
}

// This method returns left side character.
// `this' is NOT changed.
sjis
BP::GetLeftChar()
{
  return(this->editor->GetChar(this->GetLogicalOffset() - 1));
}

// This method returns right side attribute.
// `this' is NOT changed.
attr
BP::GetRightAttr()
{
  return(CHECK_ATTR(this->editor->GetAttr(this->GetLogicalOffset())));
}

// This method returns left side attribute.
// `this' is NOT changed.
attr
BP::GetLeftAttr()
{
  return(CHECK_ATTR(this->editor->GetAttr(this->GetLogicalOffset() - 1)));
}

attr
BP::InferAttributes(bool prefer_right)
{
  THIS_CHECK;
  bool eob = (bool)(this->EndOfBufferP() != 0);
  bool bob = (bool)(this->BeginningOfBufferP() != 0);
  attr a = 0;
  if (eob && bob)
  {
    int par_char_att_val = ::GetAttValue(this->GetBuffer()-> GetAtts(), PA_charatt);
    if (par_char_att_val != AttsEntry::UNKNOWN)
    {
      a = par_char_att_val;
    }
  }
  if (a == 0)
  {
    if (prefer_right)
    {
      if (!eob)
      {
	a = this->GetRightAttr();
      }
      else if (!bob)
      {
	a = this->GetLeftAttr();
      }
      else if (this->XIncrement())
      {
	a = this->GetRightAttr();
	this->XDecrement();
      } 
    }
    else 
    {
      if (!bob)
      {
	a = this->GetLeftAttr();
      }
      else if (!eob)
      {
	a = this->GetRightAttr();
      }
    }
  }
  
  if (a == 0)
  {
    if (this->XDecrement())
    {
      a = GetLeftAttr();
      this->XIncrement();
    }
    if (a == 0)
    {
      a = get_default_attributes(this->GetBuffer());
    }
  }
  return(CHECK_ATTR(a));
}

// FindText -- find a specified string somewhere after a buffer pointer
IntervalList* 
BP::FindText(sjis* what, bool reverse)
{
  return(this->GetTextFlow() ->FindText(what, reverse, this));
}

Buffer* 
BP::Mitose()
{
  Buffer* prev_buf = this->GetBuffer();
  TextFlow* flow = prev_buf->GetTextFlow();
  
  Buffer* new_buf
  = Buffer::MakeInstance(flow,
			  prev_buf, MakeNextParAtt(prev_buf->GetAtts()));
  
  BP newbase(new_buf, new_buf->GetBeginningOffset());
  Buffer::Transport(&newbase, this);
  this->BeginningOfBuffer(new_buf);
  return(new_buf);
}

Buffer* 
BP::MitoseFast()
{
  Buffer* prev_buf = this->GetBuffer();
  Buffer* new_buf = Buffer::MakeInstance(prev_buf->GetTextFlow(),
					  prev_buf, prev_buf->GetAtts());
  this->BeginningOfBuffer(new_buf);
  return(new_buf);
}

void
BP::InsertText(sjis* stuff, uword count, attr atts)
{
  this->GetBuffer() ->InsertChars(this, stuff, count, atts);
}

#define IBUFSIZE_LOG2 LOG2_OF_BEST_BUFSIZE
#define IBUFSIZE	((1 << IBUFSIZE_LOG2) / sizeof(sjis))

static BufStream* local_stream;
static int local_next_ch;

static void
initialize_local_stream(BufStream* stream)
{
  local_stream = stream;
  local_next_ch = 0;
}

static int
read_character()
{
  int ch;
  if ((ch = local_next_ch) != 0)
  {
    local_next_ch = 0;
  }
  else
  {
    ch = local_stream->GetByte();
  }
  if (ch == '\r')
  {
    ch = '\n';
    if ((local_next_ch = local_stream->GetByte()) == '\n')
    {
      local_next_ch = 0;
    }
  }
  return(ch);
}

static void NEAR
insert_ascii(BP* bp,
	      BufStream* stream,
	      int break_type, bool zero_terminated, sjis* sbuf)
{
  initialize_local_stream(stream);
  attr a = bp->InferAttributes(True);
  sjis* shere = sbuf;
  int sind = 0;
  int ch;
  int ch2;
#define PUT(a) \
  do \
  { \
    *shere++ = a; \
    sind++; \
  } while (0) \

#define FLUSH() \
  do \
  { \
    if (sind) \
    { \
      bp->InsertText(sbuf, sind, a); \
      shere = sbuf; \
      sind = 0; \
    } \
  } while (0) \
  
#define DONE_WHEN_ERROR() \
  do \
  { \
    if (stream->GetError() != SE_NOERROR) \
    { \
      goto done; \
    } \
  } while (0) \
  
#define GET(a) \
  do \
  { \
    a = read_character(); \
    DONE_WHEN_ERROR(); \
  } while (0) \
  
  GET(ch);
  for (;;)
  {
    if ((signed char) ch < 0)
    {
      if (Pref_read_high_ansi)
      {
	ch = MakeAnsiChar(ch);
      }
      else if (iskanji(ch))
      {
	GET(ch2);
	ch = MakeKanjiChar(ch, ch2);
      }
      else 
      {
	ch = MakeKanaChar(ch);
      }
      PUT(ch);
      GET(ch);
    }
    else if (' ' <= ch || ch == '\t')
    {
      PUT(MakeAnsiChar(ch));
      GET(ch);
    }
    else if (ch == '\n')
    {
      switch (break_type)
      {
       default:
       case IDD_TextConvert_OneCRasPar:
	FLUSH();
	bp->MitoseFast();
	GET(ch);
	break;
	
       case IDD_TextConvert_OneCRasLF:
	PUT(MakeAnsiChar(ch));
	GET(ch);
	break;
	
       case IDD_TextConvert_TwoCRsLineBreak:
       case IDD_TextConvert_TwoCRs:
	ch = read_character();
	if (stream->GetError() != SE_NOERROR)
	{
	  if (break_type == IDD_TextConvert_TwoCRsLineBreak)
	  {
	    PUT(NLC);
	  }
	  goto done;
	}
	if (ch == '\n')
	{
	  FLUSH();
	  bp->MitoseFast();
	  GET(ch);
	}
	else if (break_type == IDD_TextConvert_TwoCRsLineBreak)
	{
	  PUT(NLC);
	}
	break;
      }
    }
    else if (ch == '\0' && zero_terminated)
    {
      goto done;
    }
    else
    {
      GET(ch);
    }
    
    assert(sind <= IBUFSIZE);
    if (IBUFSIZE <= sind)
    {
      FLUSH();
    }
  }
  
 done:
  FLUSH();
}

void
BP::InsertASCII(BufStream* stream, int break_type, bool zero_terminated)
{
  sjis* sbuf = (sjis*) xmalloc_on_log2(IBUFSIZE_LOG2);
  
  insert_ascii(this, stream, break_type, zero_terminated, sbuf);
  
  ::xfree_on_log2(sbuf, IBUFSIZE_LOG2);
  if (stream->GetError() == SE_NOTENOUGHERROR)
  {
    stream->SetError(SE_NOERROR);
  }
}

// insert after "this".  "this" changes to point to end of inserted range
void
BP::InsertFromStream(PStream* stream)
{
  PStream::WriteWhat what = stream->GetWhat();
  
  word type;
  word vers;
  stream->StartBlockIn(type, vers);
  CHECK;
  
  if (type != PStream::HDR_PARLIST)
  {
    stream->SetError(SE_BADHEADER);
    return;
  }
  
  uword count = stream->InUWord();
  CHECK;
  if (count == 0)
  {
    stream->SetError(SE_BADVAL);
    return;
  }
  
  Buffer* b = this->GetBuffer();
  for (;;)
  {
    b->ReadFormattedFromStream(stream, this);
    CHECK;
    if (--count == 0)
    {
      break;
    }
    if ((what & PStream::WW_TEXT) || b->GetNext() == NULL)
    {
      this->Mitose();
    }
    b = b->GetNext();
    this->BeginningOfBuffer(b);
  }
  
  stream->EndBlockIn();
//  CHECK; // not-needed
}

// this routine corresponds to IntervalList::WriteFormattedtoStream
void
BP::InsertIntlistFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_INTLIST, vers);
  CHECK;
  
  udword n = stream->InULong();
  while (n--)
  {
    this->InsertFromStream(stream);
    CHECK;
  }
  
  stream->EndBlockIn();
  CHECK;
}

BP::~BP()
{
  this->editor->DeregisterBP(this);
}

BP::BP(Buffer* buffer, int bpos)
{
  this->byte_offset = bpos;
  buffer->RegisterBP(this);
}

BP::BP(BP* bp)
{
  this->byte_offset = bp->byte_offset;
  bp->editor->RegisterBP(this);
}

BP::BP(BoundBufferPointer& bound, TextFlow* flow)
{
  this->editor = NULL;
  Buffer* buffer = flow->FindParagraph(bound.par_id);

  // there are cases when we won't be able to find the paragraph, such
  // as an interval which has been deleted and is going to be redone.
  // In this case, we only need the first buffer pointer anyway?
  if (buffer)
  {
    this->byte_offset = buffer->GetPhysicalOffset(bound.byte_offset);
    buffer->RegisterBP(this);
  }
}
