// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: bufnew.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// buffer

#ifndef BUFNEW_H
#define BUFNEW_H

#include "smartnew.h"

#include "textflow.h"
#include "view.h"

class BPLink
{
  friend class Buffer;
private:
  BP* prev;
  BP* next;
};

class Buffer
{
  friend class BP;
  
private:
  enum
  {
    BF_ERROR = 0x0001,
  };
  
private:
  TextFlow* textflow;
  Buffer* prev;
  Buffer* next;
  udword id;
  long cmp_value;
  FrameInstance* first_frame;
  sjis* buf;
  attr* attributes;
  BPLink bp_link;
  uword buflen;
  uword gapbottom;
  uword gaptop;
  unsigned int log2_of_buffer_size;
  uword eob_flags;
  int flags;
  attr atts;
  
private:
  Buffer();
  
public:
  REFER_SMARTNEW(Buffer)
  static Buffer* MakeInstance(TextFlow* flow, Buffer* prev, attr attrib);
  ~Buffer();
  
private:
  static void NEAR DeregisterBP(BP* bp);
  static void NEAR Transport(BP* dest_bp, BP* src_bp);
  
private:
  BP* NEAR GetBPLink();
  Panel* NEAR GetPanel(sjis c);
  int NEAR SubSize(int i0, int i1);
  void NEAR CrushBPs(int above, int below, int makeum_this);
  void NEAR EnsureAllocSpace(unsigned int new_gap);
  void NEAR GetGapToBP(BP* bp);
  void NEAR KillPanels(unsigned int i0, unsigned int i1);
  void NEAR RegisterBP(BP* bp);
  void NEAR RegisterBPs(BP* bps, int offset);
  void NEAR RelocateBPs(int above, int below, int this_much);
  void NEAR StoreFlagdAttRange(unsigned int start, unsigned int count, attr attrib);
  
public:
  static IntervalList* GreatFindCharStyle(DocumentContent* conte, uword style);
  static IntervalList* GreatFindParaStyle(DocumentContent* conte, uword style);
  static void BigApplyCharAtt(BP* bp0, BP* bp1, attr(*func) (attr, int, int), int attcode, int attval);
  static void BigDelete(BP* bp0, BP* bp1);
  static void BigSetFlags(BP* bp0, BP* bp1, uword off, uword on);
  
public:
  BP* FindText(sjis* what, BP* from_where, bool reverse);
  BP* GetEndBufferPointer();
  BP* GetStartBufferPointer();
  Buffer* GetNext();
  Buffer* GetNextParagraph();
  Buffer* GetPrevParagraph();
  Buffer* GetPrev();
  DocumentContent* GetDocContent();
  FrameInstance* GetFirstFrame();
  IntervalList* FindVText(int i0, int i1);
  TextFlow* GetTextFlow();
  attr GetAttr(int offset);
  attr GetAtts();
  bool GetCommonAtt(attr& common_att, int i0, int i1);
  int GetBeginningOffset();
  int GetEndOffset();
  int GetLogicalOffset(int p_offset);
  int GetPhysicalIndex(int offset);
  int GetPhysicalOffset(int l_offset);
  int GetSize();
  int NormalizeLogicalOffset(int l_offset);
  long GetCmpValue();
  sjis GetChar(int offset);
  udword GetID();
  udword GetRawID();
  uword GetEOBFlags();
  uword GetFlags(int offset);
  void Count(Stats& stats);
  void DelayFormat();
  void GetCharInfo(int offset, sjis* c_return, attr* attrib_return);
  void InsertChars(BP* bp, sjis* stuff, uword count, attr attrib);
  void MarkCookieConnections(PStream* stream, int i0, int i1);
  void ReadFormattedFromStream(PStream* stream, BP* where);
  void RedisplayHidden(attr& atts, bool& hidden);
  void SetAtts(attr a);
  void SetFirstFrame(FrameInstance* frame);
  void SetParCharAtts();
  void VariableTextUpdate(int i0, int i1, int& present, int& changed);
  void WriteASCIIToStream(BufStream* stream, int i0, int i1);
  void WriteFormattedToStream(PStream* stream, int i0, int i1);
  void xSetAtts(attr a);
#if (!defined(NDEBUG))
private:
  void NEAR CheckBPs();
#endif
};

class BP
  : public BPLink
{
  friend class Buffer;
  
private:
  Buffer* editor;
  int byte_offset;
  
public:
  REFER_SMARTNEW(BP)
  BP(Buffer* buffer, int pos);
  BP(BP* bp);
  BP(BoundBufferPointer& bound, TextFlow* flow);
  ~BP();
  
public:
  BP* operator = (BP& a);
  int operator != (BP& that);
  int operator < (BP& that);
  int operator <= (BP& that);
  int operator == (BP& that);
  int operator > (BP& that);
  int operator >= (BP& that);
  void operator += (int a);
  
public:
  BP* Add(int i);
  BP* BeginningOfBuffer();
  BP* BeginningOfBuffer(Buffer* editor);
  BP* BeginningOfText();
  BP* BeginningOfText(TextFlow* text);
  BP* EndOfBuffer();
  BP* EndOfBuffer(Buffer* editor);
  BP* EndOfText();
  BP* EndOfText(TextFlow* text);
  BP* Set(BP* source);
  BP* SetAndDelete(BP* source);
  BP* SetBuffer(Buffer* editor);
  BP* SetEditor(Buffer* editor);
  BP* SetLogicalOffset(int l_offset);
  BP* SetLogicalOffset(Buffer* editor, int l_offset);
  BP* SetMax(BP* source);
  BP* SetMin(BP* source);
  Buffer* GetBuffer();
  Buffer* GetEditor();
  Buffer* GetParagraph();
  Buffer* Mitose();
  Buffer* MitoseFast();
  FrameInstance* FindFrame();
  FrameInstance* MaybeFindFrame();
  IntervalList* FindText(sjis* what, bool reverse);
  LayoutInstance* FindLayout();
  LayoutInstance* FindTopLevelLayout();
  LayoutInstance* MaybeFindLayout();
  Line* FindLine();
  Line* find_line_and_lpoint(Lpoint* lp);
  Line* find_line_and_lpoint(Lpoint* lp, DocumentWindow* window);
  Line* maybe_find_line_and_lpoint(Lpoint* lp);
  Line* maybe_find_line_and_lpoint(Lpoint* lp, DocumentWindow* window);
  TextFlow* GetTextFlow();
  attr InferAttributes(bool prefer_right);
  attr GetLeftAttr();
  attr GetRightAttr();
  bool Decrement();
  bool FormattedP();
  bool ForwardChar(int count);
  bool ForwardLine(int count);
  bool ForwardWord(int count);
  bool FrameMove(int direction_x, int direction_y);
  bool Increment();
  bool Move(uword wParam, int control);
  bool XDecrement();
  bool XIncrement();
  int BeginningOfBufferP();
  int BeginningOfTextP();
  int EndOfBufferP();
  int EndOfTextP();
  int GetByteOffset();
  int GetLogicalOffset();
  int Move(uword wParam);
  sjis GetLeftChar();
  sjis GetRightChar();
  void InsertASCII(BufStream* stream, int break_type, bool zero_terminated);
  void InsertFromStream(PStream* stream);
  void InsertIntlistFromStream(PStream* stream);
  void InsertText(sjis* stuff, uword count, attr atts);
  bool FrameMove0(Line* line, Lunit lx, Lunit ly, int dir_x, int dir_y);
};
  
int BPcmp(BP& bp0, BP& bp1);
int EQ(BP* bp0, BP* bp1);
int GE(BP* bp0, BP* bp1);
int GT(BP* bp0, BP* bp1);
int LE(BP* bp0, BP* bp1);
int LT(BP* bp0, BP* bp1);
int NE(BP* bp0, BP* bp1);

#if (!defined(NDEBUG))
#define CHECK_SAME_FLOW(bp0, bp1) ::CheckSameFlow(bp0, bp1)
void CheckSameFlow(BP* bp0, BP* bp1);
#else
#define CHECK_SAME_FLOW(bp0, bp1)
#endif

#if (!defined(NDEBUG) && defined(DEBUG_ATTR))
#define CHECK_ATTR(a) check_attr(a)
attr check_attr(attr a);
#else
#define CHECK_ATTR(a) (a)
#endif

// ------------------------------------------------------------
// Buffer's inline

inline TextFlow* 
Buffer::GetTextFlow()
{
  return(this->textflow);
}

inline DocumentContent* 
Buffer::GetDocContent()
{
  return(this->textflow->GetDocContent());
}

inline Buffer* 
Buffer::GetPrev()
{
  return(this->prev);
}

inline Buffer* 
Buffer::GetNext()
{
  return(this->next);
}

inline uword
Buffer::GetEOBFlags()
{
  return(this->eob_flags);
}
  
inline attr
Buffer::GetAtts()
{
  return(CHECK_ATTR(this->atts));
}
  
inline void
Buffer::xSetAtts(attr a)
{
  this->atts = a;
}

inline udword
Buffer::GetRawID()
{
  return(this->id);
}

inline long
Buffer::GetCmpValue()
{
  return(this->cmp_value);
}

inline FrameInstance* 
Buffer::GetFirstFrame()
{
  return(this->first_frame);
}
  
inline void
Buffer::SetFirstFrame(FrameInstance* frame)
{
  this->first_frame = frame;
}

inline int
Buffer::GetBeginningOffset()
{
  return(0);
}

inline int
Buffer::GetEndOffset()
{
  return((int)
	  (this->buflen == this->gaptop ? this->gapbottom : this->buflen));
}

// for convention
#define GAP_SIZE(this) ((this)->gaptop - (this)->gapbottom)

// Return number of character, it's a buffer size.
inline int
Buffer::GetSize()
{
  return(this->buflen - GAP_SIZE(this));
}

// Convert physical offset to logical offset.
// Logical offset is continuous integer,  very useful.
inline int
Buffer::GetLogicalOffset(int p_offset)
{
  return(p_offset <= (int) this->gapbottom ? p_offset
	  : p_offset + this->gapbottom - this->gaptop);
}

inline int
Buffer::NormalizeLogicalOffset(int l_offset)
{
  int size;
  return(l_offset <= 0 ? 0
	  : l_offset < (size = this->GetSize()) ? l_offset : size);
}

// Convert logical offset to physical offset.
// Physical offset is use for BufferPointer->byte_offset member.
inline int
Buffer::GetPhysicalOffset(int l_offset)
{
  l_offset = this->NormalizeLogicalOffset(l_offset);
  return(l_offset + (l_offset <= (int) this->gapbottom ? 0
		      : GAP_SIZE(this)));
}

// Convert logical offset to exact vector's index.
// Returns -1 if out of bounds.
// This is difference from physical-offset.
// No, It's mismatch design.
inline int
EditText::GetPhysicalIndex(int l_offset)
{
  return((l_offset < 0 || this->GetSize() <= l_offset) ? -1
	  : l_offset + (l_offset < (int) this->gapbottom ? 0
			: GAP_SIZE(this)));
}

// This method returns character pointed logical offset.
// if offset is out of bounds,  returns EOB.
inline sjis
Buffer::GetChar(int offset)
{
  int index = GetPhysicalIndex(offset);
  return(index < 0 ? EOB : this->buf[index]);
}

// This method returns character pointed logical offset.
// if offset is out of bounds,  returns 0.
inline attr
Buffer::GetAttr(int offset)
{
  int index = GetPhysicalIndex(offset);
  return(index < 0 ? 0 : this->attributes[index] & ~IV_ALLMASK);
}

inline uword
Buffer::GetFlags(int offset)
{
  int index = GetPhysicalIndex(offset);
  return(index < 0 ? 0 : this->attributes[index] & IV_ALLMASK);
}

// ------------------------------------------------------------
// BP's inline

inline Buffer* 
BP::GetBuffer()
{
  return(this->editor);
}

inline TextFlow* 
BP::GetTextFlow()
{
  return(this->editor->GetTextFlow());
}

inline int
BP::GetByteOffset()
{
  return(this->byte_offset);
}

inline int
BP::BeginningOfBufferP()
{
  return(this->byte_offset == 0);
}

#define MACRO_BP_EQ(a, b) \
((a)->GetByteOffset() == (b)->GetByteOffset() \
 && (a)->GetBuffer() == (b)->GetBuffer()) \

#define MACRO_BP_NE(a, b) (!MACRO_BP_EQ(a, b))

#define MACRO_BP_LT(a, b) \
((a)->GetBuffer() != (b)->GetBuffer() \
 ? (a)->GetBuffer() ->GetCmpValue() < (b)->GetBuffer() ->GetCmpValue() \
 : (a)->GetByteOffset() < (b)->GetByteOffset()) \

#define MACRO_BP_LE(a, b) (!MACRO_BP_LT(b, a))
#define MACRO_BP_GT(a, b) MACRO_BP_LT(b, a)
#define MACRO_BP_GE(a, b) (!MACRO_BP_LT(a, b))

inline int
EQ(BP* bp0, BP* bp1)
{
  return(MACRO_BP_EQ(bp0, bp1));
}

inline int
NE(BP* bp0, BP* bp1)
{
  return(MACRO_BP_NE(bp0, bp1));
}

inline int
LT(BP* bp0, BP* bp1)
{
  return(MACRO_BP_LT(bp0, bp1));
}

inline int
LE(BP* bp0, BP* bp1)
{
  return(MACRO_BP_LE(bp0, bp1));
}

inline int
GT(BP* bp0, BP* bp1)
{
  return(MACRO_BP_GT(bp0, bp1));
}

inline int
GE(BP* bp0, BP* bp1)
{
  return(MACRO_BP_GE(bp0, bp1));
}

inline int
BP::operator == (BP& that)
{
  return(::EQ(this, &that));
}

inline int
BP::operator != (BP& that)
{
  return(::NE(this, &that));
}

inline int
BP::operator < (BP& that)
{
  return(::LT(this, &that));
}

inline int
BP::operator <= (BP& that)
{
  return(::LE(this, &that));
}

inline int
BP::operator > (BP& that)
{
  return(::GT(this, &that));
}

inline int
BP::operator >= (BP& that)
{
  return(::GE(this, &that));
}

inline BP* 
BP::operator = (BP& a)
{
  return(this->Set(&a));
}

inline void
BP::operator += (int a)
{
  this->Add(a);
}

inline BP* 
BP::BeginningOfBuffer()
{
  this->byte_offset = this->GetBuffer() ->GetBeginningOffset();
  return(this);
}

// ------------------------------------------------------------
// COMPAT

inline Buffer* 
Buffer::GetPrevParagraph()
{
  return(this->GetPrev());
}

inline Buffer* 
Buffer::GetNextParagraph()
{
  return(this->GetNext());
}

inline Buffer* 
BP::GetEditor()
{
  return(this->GetBuffer());
}

inline Buffer* 
BP::GetParagraph()
{
  return(this->GetBuffer());
}

inline BP* 
BP::SetEditor(Buffer* editor)
{
  return(this->SetBuffer(editor));
}

#endif /* BUFNEW_H */
