// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: caret.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// caret

#ifndef CARET_H
#define CARET_H

// caret type for Pref_caret_type
#define CARET_TYPE_BAR 0
#define CARET_TYPE_FRAME 1
#define CARET_TYPE_BOX 2

struct CaretMetric
{
  int lwidth;
  int rwidth;
  int ascent;
  int descent;
  int base_width;
  int crossbar_width;
  int overhang;
  int flags;
};

class Caret
{
public:
  enum
  {
    BOLD = 1 << 0,
    ITALIC = 1 << 1,
    UNDERLINE = 1 << 2,
    STRIKEOUT = 1 << 3,
    HIDDEN = 1 << 4,
    OVERFLOW = 1 << 5,
    LINERIGHT = 1 << 6,
    TATEGAKI = 1 << 7,
  };
  
private:
  // If `window' has non-zero value, caret is visible.
  static HWND STATIC_NEAR window;
  
  static HBITMAP STATIC_NEAR bitmap;
  static CaretMetric STATIC_NEAR metric;
  
public:
  static CaretMetric GetCaretMetric(int width, int ascent, int descent, int flags);
  static void Kill();
  static void KillAllResources();
  static void Reset(HWND window);
  static void Set(HWND window, int x, int y, int width, int ascent, int descent, int flags);
};

#endif /* CARET_H */
