// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: clip.cpp,v 3.4 1999/07/19 17:27:25 kudou Exp $
// implement clipboard functionality

#include "pword.h"
#include "clip.h"
#include "attribut.h"
#include "bufnew.h"
#include "cplist.h"
#include "docchar.h"
#include "docconte.h"
#include "docedit.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "editfram.h"
#include "fillobjc.h"
#include "fission.h"
#include "frameown.h"
#include "grphobjc.h"
#include "interval.h"
#include "intlist.h"
#include "mcursor.h"
#include "metafile.h"
#include "mfobject.h"
#include "mwindow.h"
#include "pclipboa.h"
#include "picture.h"
#include "pmenus.h"
#include "pstreams.h"
#include "pundo.h"
#include "pwordbas.h"
#include "sjis.h"
#include "tablepnl.h"
#include "view.h"

// clipboard material over this size will result in hourglass cursor
const int BIGTEXT = 128;
const int BIGGRAPHIC = 4096;

void NEAR
DocumentClip::PasteGraphicPanel(HANDLE data,
				 WORD format, Iunit width, Iunit height)
{
  bool big_p = ::GlobalSize(data) > BIGGRAPHIC;
  if (big_p)
  {
    MouseCursor::StartLongActivity();
  }
  DocumentContent* docconte = this->GetEditor()->GetDocumentContent();
  Inserter inserter(this->GetEditor(), PUndo::UD_InsertGraphic);
  do
  {
    inserter.Before();
    if (!docconte->CheckPanelNumMax())
    {
      break;
    }
    Picture* pic = new Picture(data, format);
    if (pic->IsValid()) 
    {
      Interval* i = inserter.GetInterval();
      TablePanel* pnl = new TablePanel(docconte,
					i->GetBP0(), width, height, pic);
      editor->InsertPanel(pnl, i);
    }
    else
    {
      // memory trouble
      delete pic;
    }
    inserter.After();
  }
  while (inserter.Next());
  
  if (big_p)
  {
    MouseCursor::EndLongActivity();
  }
}

// private method
int
DocumentClip::paste_pword(HANDLE h)
{
  DocumentEdit* editor = GetEditor();
  assert(editor != NULL);
  
  PUndo* undo = editor->GetDocumentContent()->GetUndo();
  undo->SetMoved();
  
  VMem* vmem = new VMemBig(h, True);
  bool big_p = (vmem->GetSize() > BIGTEXT);
  if (big_p)
  {
    MouseCursor::StartLongActivity();
  }    
  
  Inserter inserter(editor, PUndo::UD_Paste);
  do
  {
    Interval* i = inserter.GetInterval();
    
    undo->Register(i, PUndo::UF_ParAtt);
    inserter.Before();
    
    PStream stream(vmem, PStream::WW_CLIPBOARD);
    stream.InitIn();
    if (stream.GetError() == SE_NOERROR)
    {
      ::StartAttributeImport();
      i->GetRight()->InsertIntlistFromStream(&stream);
      ::EndAttributeImport();
      i->DelayFormat();
#ifndef NDEBUG
      if (stream.GetError() != SE_NOERROR)
      {
	char* msg;
	syserr("DocumentClip::InsertFromStream failed(%s)",
		msg = stream.MakeErrorString());
	delete msg;
      }
#endif
      stream.TermIn();
    }
    inserter.After();
  }
  while (inserter.Next());
  
  delete vmem;
  if (big_p)
  {
    MouseCursor::EndLongActivity();
  }    
  return 0;
}

// private method
int
DocumentClip::paste_text(HANDLE h)
{
  VMem* vmem = new VMemBig(h, True);
  bool big_p = (vmem->GetSize() > BIGTEXT);
  if (big_p)
  {
    MouseCursor::StartLongActivity();
  }    
  
  editor->GetDocumentContent()->GetUndo()->SetMoved();
  
  Inserter inserter(editor, PUndo::UD_Paste);
  
  do
  {
    inserter.Before();
    
    BufStream stream(vmem);
    inserter.GetInterval()->InsertASCII(&stream, IDD_TextConvert_OneCRasPar, True);
    inserter.After();
  }
  while (inserter.Next());
  
  delete vmem;
  if (big_p)
  {
    MouseCursor::EndLongActivity();
  }    
  return 0;
}

// private method
int
DocumentClip::paste_bitmap(HANDLE hBitmap)
{
  assert(hBitmap != 0);
  
  // paste as panel
#ifdef _WIN32
  SIZE size;
  ::GetBitmapDimensionEx((HBITMAP)hBitmap, &size);
  WORD mm0_width = (WORD)size.cx;
  WORD mm0_height = (WORD)size.cy;
#else /* _WIN32 */
  DWORD size = ::GetBitmapDimension(hBitmap);
  WORD mm0_width = LOWORD(size);
  WORD mm0_height = HIWORD(size);
#endif /* _WIN32 */
  Iunit width  = mm0_to_iu(mm0_width);
  Iunit height = mm0_to_iu(mm0_height);
  if ((width == 0) || (height == 0)) 
  {
    BITMAP bm;
    GetObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);
    width = (Iunit) (Default_View->ScaleLunitX(bm.bmWidth));
    height = (Iunit) (Default_View->ScaleLunitY(bm.bmHeight));
  }
  this->PasteGraphicPanel(hBitmap, CF_BITMAP, width, height);
  return 0;
}

// paste DIB as panel
// private method
int
DocumentClip::paste_dib(HANDLE c_dib)
{
  assert(c_dib != 0);
  
  Iunit width, height;
  Picture::GetDIBWidthAndHeightDIB(c_dib, width, height);
  if (width && height)
  {
    this->PasteGraphicPanel(c_dib, CF_DIB, width, height);
  }
  return(0);
}

// private method
int
DocumentClip::paste_metafile(HANDLE hmeta)
{
  assert(hmeta != 0);
  // paste as panel
  METAFILEPICT* mp = Metafile::CopyClipBoardData(hmeta);
  if (mp != NULL)
  {
    bool bigp = ::GlobalSize(hmeta) > BIGGRAPHIC;
    if (bigp)
    {
      MouseCursor::StartLongActivity();
    }
    Iunit width, height;
    Metafile::GetWidthAndHeight(mp, width, height);
    DocumentEdit* editor = GetEditor();
    DocumentContent* docconte = editor->GetDocumentContent();
    Inserter inserter(editor, PUndo::UD_InsertGraphic);
    do
    {
      inserter.Before();
      if (!docconte->CheckPanelNumMax())
      {
	break;
      }
      Metafile* mf = new Metafile(mp);
      Interval* i = inserter.GetInterval();
      Panel* pnl = new TablePanel(docconte, i->GetLeft(), width, height, mf);
      sjis foo = docconte->GetPanelCode(pnl);
      i->InsertText(&foo, 1);
      inserter.After();
    } while (inserter.Next());
    if (bigp)
    {
      MouseCursor::EndLongActivity();
    }
  }
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentClip::Paste(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentClip::Paste(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  // table of each format we support, plus a routine that knows what to do
  // with the data on the clipboard in that format
  static struct FORMAT 
  {
    uword format;
    int(DocumentClip::*func) (HANDLE);
    int paste_as_panel;
  } formats[] =
  {
    { 0, 		&DocumentClip::paste_pword, 	False},
    { CF_TEXT, 		&DocumentClip::paste_text, 	False},
    { CF_DIB, 		&DocumentClip::paste_dib, 	True },
    { CF_BITMAP, 	&DocumentClip::paste_bitmap, 	True },
//    { CF_METAFILEPICT, 	&DocumentClip::paste_metafile, 	True },
    { 0, }
  };
  
  formats[0].format = Clipboard_Format;
  for (FORMAT* f=formats; f->format; f++)
  {
    if (::IsClipboardFormatAvailable(f->format))
    {
      break;
    }
  }
  if (f->format == 0)
  {
    return(disabled_command(menu_state_p));
  }
  if (!menu_state_p)
  {
    // handling the clipboard is a breeze with the spiffy PClipboard
    // classes
    PClipboardRead clip;
    clip.Open(main_window_handle);
    if (!clip.ErrorP())
    {
      HANDLE h = clip.Handle(f->format);
      if (h != 0)
      {
	(this->* (f->func)) (h);
      }
      clip.Close();
    }
  }
  return 0;
}

// ------------------------------------------------------------
// Cut, Copy, Delete

// WriteFormatted, WriteASCII -- write pword selection to clipboard

void NEAR
DocumentClip::WriteFormatted(PClipboardWrite* clip)
{
  VMem* vmem = VMem::Make(5 /* 2**5 */, True /*GlobalAlloc*/);
  {
    PStream stream(vmem, PStream::WW_CLIPBOARD);
    stream.InitOut();
    ::StartAttributeExport();
    IntervalList* il = GetEditor()-> GetSelection();
    
    // write out intervals in order they were selected!
    il->Reverse();
    il-> WriteFormattedToStream(&stream);
    il->Reverse();
    
    stream.TermOut();
#ifndef NDEBUG
    if (stream.GetError() != SE_NOERROR)
    {
      char* msg = 0;
      syserr("failed writing data to clipboard ", 
	      msg = stream.MakeErrorString());
      delete msg;
    }
#endif
  }
  if (vmem->GetStuff() != NULL)
  {
    HANDLE h = vmem->CastToVMemBig()->GrabHandle();
    if (h)
    {
      clip->Handle(Clipboard_Format, h);
    }
  }
  delete vmem;
  ::EndAttributeExport();
}

void NEAR
DocumentClip::WriteASCII(PClipboardWrite* clip)
{
  VMem* vmem = VMem::Make(5, True /*GlobalAlloc*/);
  {
    BufStream stream(vmem);
    GetEditor()->GetSelection()->WriteASCIIToStream(&stream);
    if (stream.GetError() == SE_NOERROR)
    {
      stream.PutByte(0);
    }
    stream.TermOut();
#ifndef NDEBUG
    if (stream.GetError() != SE_NOERROR)
    {
      syserr("failed writing ascii data to clipboard ");
    }
#endif
  }
  clip->Handle(CF_TEXT, vmem->CastToVMemBig()->GrabHandle());
  delete vmem;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentClip::Delete(bool menu_state_p, WORD command)
#else /* BW3_DISPATCH */
long NEAR
DocumentClip::Delete(int command, int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return(this->GetEditor() ->GetSelection() ->PointP()
	    ? MF_GRAYED : MF_ENABLED);
  }
  return(this->editor->GetDocumentChar() ->Edit(command));
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentClip::Copy(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentClip::Copy(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (this->GetEditor() ->GetSelection() ->PointP())
  {
    return(disabled_command(menu_state_p));
  }
  else if (!menu_state_p)
  {
    PClipboardWrite clip;
    clip.Open(main_window_handle);
    if (!clip.ErrorP()) 
    {
      IntervalList* il = GetEditor()->GetSelection();
      int big_p = il->BigP();
      if (big_p)
      {
	MouseCursor::StartLongActivity();
      }
      this->WriteFormatted(&clip);
      this->WriteASCII(&clip);
      clip.Close();
      if (big_p)
      {
	MouseCursor::EndLongActivity();
      }
    }
  }
  // MF_ENABLED == 0
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentClip::Cut(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentClip::Cut(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  Copy(menu_state_p);
#ifdef BW3_DISPATCH
  return Delete(menu_state_p, IDM_Edit_Cut);
#else /* BW3_DISPATCH */
  return Delete(IDM_Edit_Cut, menu_state_p);
#endif /* BW3_DISPATCH */
}

// public method
#ifdef BW3_DISPATCH
LRESULT_T
DocumentClip::Dispatch(bool menu_state_p, WORD command)
#else /* BW3_DISPATCH */
long
DocumentClip::Dispatch(int command, int menu_state_p)
#endif /* BW3_DISPATCH */
{
  switch (command)
  {
   case IDM_Edit_Copy:
    return(Copy(menu_state_p));
    
   case IDM_Edit_Cut:
    return(Cut(menu_state_p));
    
   case IDM_Edit_Paste:
    return(Paste(menu_state_p));
    
   case IDM_Edit_Delete:
   case IDM_Edit_DeleteNotOnMenu:
#ifdef BW3_DISPATCH
    return Delete(menu_state_p, command);
#else /* BW3_DISPATCH */
    return Delete(command, menu_state_p);
#endif /* BW3_DISPATCH */
    
#ifndef NDEBUG
#ifdef BW2_VERBOSE
   default:
    syserr("bad msg 0x%x to DocumentClip::Dispatch", wParam);
#endif
#endif
  }
  return(0);
}
