// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: clip.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// class to manage clipboard activity

#ifndef CLIP_H
#define CLIP_H

class DocumentClip
{
private:
  DocumentEdit* editor;
  
public:
  DocumentClip(DocumentEdit* editor);

private:
  int paste_bitmap(HANDLE hBitmap);
  int paste_dib(HANDLE dib);
  int paste_metafile(HANDLE hmeta);
  int paste_pword(HANDLE h);
  int paste_text(HANDLE h);
#ifdef BW3_DISPATCH
  LRESULT_T NEAR Copy(bool menu_state_p);
  LRESULT_T NEAR Cut(bool menu_state_p);
  LRESULT_T NEAR Delete(bool menu_state_p, WORD command);
  LRESULT_T NEAR Paste(bool menu_state_p);
#else /* BW3_DISPATCH */
  long NEAR Copy(int menu_state_p);
  long NEAR Cut(int menu_state_p);
  long NEAR Delete(int command, int menu_state_p);
  long NEAR Paste(int menu_state_p);
#endif /* BW3_DISPATCH */
  void NEAR PasteGraphicPanel(HANDLE data, WORD format, Iunit width, Iunit height);
  void NEAR WriteASCII(PClipboardWrite* clip);
  void NEAR WriteFormatted(PClipboardWrite* clip);
public:
  DocumentEdit* GetEditor();
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(bool menu_state_p, WORD command);
#else /* BW3_DISPATCH */
  long Dispatch(int command, int menu_state_p);
#endif /* BW3_DISPATCH */
};

inline DocumentEdit* 
DocumentClip::GetEditor()
{
  return(this->editor);
}

// public constructor
inline
DocumentClip::DocumentClip(DocumentEdit* editor)
{
  this->editor = editor;
}

#endif /* CLIP_H */
