// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: defstyle.cpp,v 3.4 1999/05/12 00:22:16 kudou Exp $
// implement the DefStyleDialog class for PWord
// DefineStyle dialog box

#include "pword.h"
#include "defstyle.h"
#include "attribut.h"
#include "atts.h"
#include "styles.h"
#include "pmenus.h"
#include "dialogs.h"
#include "xstr.h"

// ------------------------------------------------------------
// DefStyleDialog class

// virtual method
LRESULT_T
DefStyleDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    this->SetText(this->caption);
    this->SetItemText(IDD_DefStyleName, StyleName);
    SendItemMessage(IDD_DefStyleName, EM_LIMITTEXT, STYLENAMELEN);
    return(1);

    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      this->existing_style = GlobalStyleTable.FindEntry(this->StyleName, 
							 this->style_type,
							 False);
      if (this->existing_style != 0
	  && (IssueVA(S_OverrideStyleMsg,
		       MB_ICONQUESTION | MB_OKCANCEL, this->StyleName)
	      == IDCANCEL))
      {
#ifdef _WIN32
	this->SendItemMessage(IDD_DefStyleName,
			       EM_SETSEL, 0, 32767);
#else /* _WIN32 */
	this->SendItemMessage(IDD_DefStyleName,
			       EM_SETSEL, 0, MAKELONG(0, 32767));
#endif /* _WIN32 */
	return(1);
      }
      End(1);
      break;
      
     case IDD_DefStyleName:
      EnableWindow(GetItem(IDOK),
		    GetItemText(IDD_DefStyleName, StyleName, STYLENAMELEN+1));
      break;

     case IDCANCEL:
      End(0);
      break;
    }
    break;
  }
  return(0);
}

// protected constructor
DefStyleDialog::DefStyleDialog(char* suggestion,
				char* caption, int style_type)
{
  this->class_name = "DefStyle";
  this->caption = caption;
  this->style_type = style_type;
  StyleName[0] = '\0';
  if (suggestion != NULL)
  {
    ::copy_string(StyleName, suggestion, STYLENAMELEN + 1);
  }
}

// ------------------------------------------------------------
// DefParaStyleDialog class -- PWord Define Paragraph Style dialog box

// public constructor
DefParaStyleDialog::DefParaStyleDialog(char* suggestion)
  : DefStyleDialog(suggestion, S_DefineParaCap, AttsEntry::PARSTYLE)
{
}

// ------------------------------------------------------------
// DefTextStyleDialog -- PWord Define Text Style dialog box

// public constructor
DefTextStyleDialog::DefTextStyleDialog(char* suggestion)
  : DefStyleDialog(suggestion, S_DefineTextCap, AttsEntry::CHARSTYLE)
{
}

