// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: dlg.h,v 3.3 1999/05/18 18:51:49 kudou Exp $
// some simple dialogs

#ifndef DLG_H
#define DLG_H

#include "boxes.h"
#include "window.h"

// This class should be made a super class of dialog boxes for which you
// want to turn off kana-kanji conversion.

class NoKanjiDialog
{
private:
  int open_status;

public:
  NoKanjiDialog();
  ~NoKanjiDialog();

  void MaybeRestoreIME();
  void MaybeUnrestoreIME();
};

class PDialog
  : public Window
{
private:
  PDialog* chain;
public:
  char* class_name;
  
public:
  PDialog();
  ~PDialog();
  
protected:
  void before_go();
  void after_go();
public:
  HWND GetItem(int id);
  LONG SendItemMessage(int id, MSG_T msg);
  LONG SendItemMessage(int id, MSG_T msg, WPARAM_T wParam);
  LONG SendItemMessage(int id, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);
  WORD GetItemInt(int id, BOOL* translated);
  int GetItemText(int id, LPSTR text, int blah);
  int get_item_check(int id);
  void End(BOOL blah);
  void SetItemInt(int id, UINT val);
  void SetItemText(int id, LPSTR text);
  void set_item_check(int id);
  
public:
  static LRESULT_T CALLBACK _export xWndProc(HWND hWnd, MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T xWndProc_ (HWND hWnd, MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

class PModelessDialog
  : public PDialog
{
public:
  int Go();
};


class PModalDialog
  : public PDialog
{
private:
  static int depth;
  
public:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

public:
  int Go();
  
public:
  static int Open();
};

inline int
PModalDialog::Open()
{
  return(0 < PModalDialog::depth);
}


class NoKanjiModalDialog
  : public PModalDialog,
    NoKanjiDialog
{
public:
  NoKanjiModalDialog();
  ~NoKanjiModalDialog();
};


// AboutDialog's argument.
#define SPECIAL_ABOUT 0
#define TIMER_ABOUT 1
#define NORMAL_ABOUT 2
#define CUSTOM_NOTE 3

class AboutDialog
  : public PModalDialog
{
private:
  PTimer* p_timer;
  int type;
  int end_value;

private:
  NEAR AboutDialog(int type);
  NEAR ~AboutDialog();

private:
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  void NEAR KillTimer();
  void NEAR StartTimer();

public:
  static void AboutDialog::About(int type);
  int GetEndValue() { return end_value; }
};


class VTPageNoDialog
  : public NoKanjiModalDialog
{
public:
  VTPageNoDialog();
  
public:
  virtual LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};


class NumberDialog
  : public NoKanjiModalDialog
{
private:
  int min_value;
  int max_value;
  int value;
  int mm0;
  
public:
  NumberDialog(char* class_name, int min_value, int max_value, int value);
  
public:
  virtual LRESULT_T NumberDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
private:
  void NEAR fix_value();
  void NEAR update_value();
public:
  int get_value();
  void set_mm0_mode(int mm0);
};

// public method
inline int
NumberDialog::get_value()
{
  return(this->value);
}

inline void
NumberDialog::set_mm0_mode(int mm0)
{
  this->mm0 = mm0;
}


struct MessageDialogValues
{
  int where;
  int guidep;
};

class MessageDialog 
  : public NoKanjiModalDialog
{
private:
  int initializing_now;
  MessageDialogValues values;

public:
  MessageDialog(MessageDialogValues* values);
  
public:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

private:
  void NEAR check_values();
  void NEAR init_values();
public:
  void get_values(MessageDialogValues* values);
};


class IndentDialog
  : public NoKanjiModalDialog
{
  int l1_mm0;
  int l2_mm0;
  int r_mm0;
  
public:
  IndentDialog(Iunit l1, Iunit l2, Iunit r);
  
  Iunit GetL1Indent() { return mm0_to_iu(l1_mm0); }
  Iunit GetL2Indent() { return mm0_to_iu(l2_mm0); }
  Iunit GetRIndent() { return mm0_to_iu(r_mm0); }
private:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

// tategaki dialog
class HVSetDialog
  : public NoKanjiModalDialog
{
  static bool change_frame_margin;
  bool tate_p;
  
public:
  static bool ChangeFrameMarginP()
  {
    return change_frame_margin;
  }
  HVSetDialog(bool tate_p);
  bool TateP() { return tate_p; }
  
private:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

#endif /* DLG_H */
