// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docchar.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// Dispatch routine and window procedure for DocumentChar

#include "pword.h"
#include "docchar.h"
#include "sjis.h"
#include "docconte.h"
#include "docedit.h"
#include "document.h"
#include "docwindo.h"
#include "pundo.h"
#include "pmenus.h"
#include "again.h"
#include "messbox.h"
#include "pwordpre.h"
#include "bufnew.h"
#include "interval.h"
#include "intlist.h"
#include "textflow.h"
#include "pime.h"
#include "pref.h"

bool DocumentChar::ime_string_pending = False;
sjis DocumentChar::buf[ 128 ];
int DocumentChar::bufp;
bool DocumentChar::kanji_pending = False;

bool DocumentChar::eurocombo_on = False;
char DocumentChar::eurocombo_deadchar = '\0';

// private method
inline void NEAR
DocumentChar::ClearEuroCombo()
{
  eurocombo_on = False;
  eurocombo_deadchar = '\0';
}

// private method
inline void NEAR
DocumentChar::SetEuroCombo()
{
  eurocombo_on = True;
  eurocombo_deadchar = '\0';
}

// private method
inline int NEAR
DocumentChar::GetEuroCombo()
{
  return eurocombo_on;
}

// private method
inline bool NEAR
DocumentChar::TryEuroCombo(char c, unsigned char* r)
{
  return eurocombo_on ? TryEuroCombo1(c, r) : False;
}

// public constructor
DocumentChar::DocumentChar(DocumentEdit* de)
{
  this->editor = de;
  this->pending_kanji = 0;
  this->waiting_for_last_ime_char = 0;
}

// private method
void NEAR
DocumentChar::InsertText(sjis* stuff, int count)
{
  Again::SetDoingAgain(False);
  GetEditor()->InsertText(stuff, count);
}

#ifdef BW3_DISPATCH
LRESULT_T
DocumentChar::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
DocumentChar::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  THIS_CHECK;
  
  switch (command)
  {
#ifndef NDEBUG
   case IDM_CTRLY:
    {
      static char* test_string = 
      "ABCDE FGHIJ KLMNO PQRST UVWXY Z"
      "abcde fghij klmno pqrst uvwxy z"
      "12345 67890";
      
      GetEditor()->InsertAscii(test_string, strlen(test_string));
    }
    break;
#endif
    
   case IDM_Edit_Back:
   case IDM_Edit_DeleteWord:
   case IDM_Edit_DeleteLine:
   case IDM_Edit_DeletePara:
   case IDM_Edit_DeleteRight:
   case IDM_Edit_DeleteRightWord:
    return Edit(command);
    
   case IDM_InputText:
    // this is a fake message used to "again" the input of text
    {
      int len;
      sjis* again_input = Again::GetInput(len);
      // ƁA`DocumentChar::InsertText'
      // `DocumentEdit::InsertText'ĂяoBAgain̏ɒӂ邱ƁB
      GetEditor()->InsertText(again_input, len);
    }
    break;
    
   case IDM_Edit_EuroCombo:
    {
#ifdef BW3_DISPATCH
      if (!MENU_STATE_P(notify_code))
#else /* BW3_DISPATCH */
      if (!MENU_STATE_P(lParam))
#endif /* BW3_DISPATCH */
      {
	SetEuroCombo();
      }
    }
    break;
  }
  return 0;
}

LRESULT_T
DocumentChar::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  if (Msg == WM_CHAR)
  {
    if (!ime_string_pending)
    {
      do // dummy loop
      {
	// fast version of StatusClear()
	PWordPresentation::GetMessBox() ->Clear();
	
	// Function or numeric key
	if (HIWORD(lParam) & 0x0100)
	{
	  MessageBeep(0);
	}
	
	unsigned char thisc = (unsigned char) wParam;
	if (thisc < ' ')
	{
	  if (thisc == '\r')
	  {
	    thisc = '\n';
	  }
	  else if (thisc != '\n' && thisc != '\t')
	  {
	    break;
	  }
	}
	
	// Characterize the data!
	// if (NOT pending_kanji)
	// then pending_kanji == 0, jbuf == character code
	// else pending_kanji == kanji's first byte, jbuf == kanji-code
	
	sjis jbuf;
	if (!pending_kanji)
	{
	  if (0 <= (signed char) thisc || (wParam & 0xff00))
	  {
	    unsigned char combo;
	    if (TryEuroCombo(thisc, &combo))
	    {
	      if (combo)
	      {
		jbuf = MakeAnsiChar(combo);
		this->InsertText(&jbuf, 1);
	      }
	    }
	    else
	    {
	      jbuf = thisc;
	      this->InsertText(&jbuf, 1);
	    }
	  }
	  else if (iskana(thisc))
	  {
	    jbuf = MakeKanaChar(thisc);
	    this->InsertText(&jbuf, 1);
	  }
	  else if (iskanji(thisc))
	  {
	    pending_kanji = thisc;
	  }
	}
	else if ((wParam & 0xff00) == 0 && iskanji2(thisc))
	{
	  jbuf = (pending_kanji << 8) | thisc;
	  this->InsertText(&jbuf, 1);
	  pending_kanji = 0;
	}
      } while (0);
    }
    else
    {
      if (NUMBER_OF(buf) <= bufp)
      {
#if (!defined(NDEBUG))
	syserr("DocumentChar::WndProc : BUG !");
#endif
	bufp = 0;
      }
      
      // Buffer the character 		
      unsigned char c = wParam;
      
      if (kanji_pending)
      {
	buf[bufp++] |= c;
	kanji_pending = False;
      }
      
      else if (iskanji(c))
      {
	buf[bufp] = c << 8;
	kanji_pending = True;
      }
      
      else if (iskana(c))
      {
	buf[bufp++] = MakeKanaChar(c);
      }
      
      else
      {
	buf[bufp++] = c;
      }
      
      if (waiting_for_last_ime_char && !kanji_pending)
      {
	waiting_for_last_ime_char = False;
	ime_string_pending = False;
	if (bufp != 0)
	{
	  this->InsertText(buf, bufp);
	  bufp = 0;
	}
      }
      
      if (NUMBER_OF(buf) - 2 <= bufp && !kanji_pending)
      {
	// local buffer full - ship buffered text(but don't ship half
	// a character)
	this->InsertText(buf, bufp);
	bufp = 0;
      }
    }
  }
  else if (Msg == WM_IME_REPORT)
  {
    switch (wParam)
    {
     case IR_STRINGSTART:
      ime_string_pending = True;
      kanji_pending = False;
      bufp = 0;
      break;
      
     case IR_STRINGEND:
      waiting_for_last_ime_char = True;
      break;
      
     case IR_OPENCONVERT:
      DocumentWindow::IME_sends_open_window = True;
      editor->GetDocumentWindow()->ControlIME();
      break;
      
      // quicker way for the ime to get stuff to us
     case IR_STRING:
      {
        HANDLE handle = (HANDLE)LOWORD(lParam);
	char* stuff = (char*)GlobalLock(handle);
	if (stuff != NULL)
	{
	  // VJEȂǂł́AIR_CLOSECONVERŤ0IR_STRING邱
	  // BȂ݂ɁAWindows 3.1̃Cg͂̏oOĂ
	  // 悤B
	  int length = strlen(stuff);
	  if (0 < length)
	  {
	    int foo_length;
	    sjis* foo = jis_spread(stuff, length, &foo_length);
	    this->InsertText(foo, foo_length);
	    delete foo;
	  }
	  GlobalUnlock(handle);
	  // handled it -- no WM_CHAR msgs will come
	  return(1);
	}
      }
      break;
      
     case IR_FULLCONVERT:
      PIME::DefaultConvertWin();
      break;
      
#if (0)
      // comment out to faster code
     case IR_CHANGECONVERT:
     case IR_CLOSECONVERT:
     case IR_IMESELECT:
#endif
    }
  }
  return(0);
}

#ifdef BW3_DISPATCH
LRESULT_T
DocumentChar::Edit(WORD command)
#else /* BW3_DISPATCH */
long
DocumentChar::Edit(uword command)
#endif /* BW3_DISPATCH */
{
  PUndo::UndoDesc desc = PUndo::UD_Delete;
  DocumentEdit* editor = GetEditor();
  PUndo* undo = editor->GetDocumentContent()->GetUndo();
  
  IntervalList* il = GetEditor()->GetSelection();
  
  editor->WillEdit();
  
  switch (command)
  {
   case IDM_Edit_Back:
    desc = PUndo::UD_Backspace;
    break;
    
   case IDM_Edit_DeleteWord:
    desc = PUndo::UD_DeleteWord;
    break;
    
   case IDM_Edit_DeleteLine:
    desc = PUndo::UD_DeleteLine;
    break;
    
   case IDM_Edit_DeletePara:
    desc = PUndo::UD_DeletePara;
    break;
    
   case IDM_Edit_DeleteRight:
    desc = PUndo::UD_DeleteRight;
    break;
    
   case IDM_Edit_DeleteNotOnMenu: // SPECIAL
   case IDM_Edit_Delete:
    desc = PUndo::UD_Delete;
    break;
    
   case IDM_Edit_Cut:
    desc = PUndo::UD_Cut;
    break;
    
   case IDM_Edit_DeleteRightWord:
    desc = PUndo::UD_DeleteWordRight;
    break;
  }
  
  IntervalList* will_delete = new IntervalList(il);
  void(Interval::*fun) () = NULL;
  switch (command)
  {
   case IDM_Edit_Back:
    if (il->PointP())
    {
      Again::BackInput();
    }
    fun = &Interval::MakeBackSpace;
    break;
    
   case IDM_Edit_DeleteWord:
    fun = &Interval::MakeWord;
    break;
    
   case IDM_Edit_DeleteLine:
    fun = &Interval::MakeLine;
    break;
    
   case IDM_Edit_DeletePara:
    fun = &Interval::MakePara;
    break;
    
   case IDM_Edit_DeleteNotOnMenu: // SPECIAL
   case IDM_Edit_DeleteRight:
    fun = &Interval::MakeRight;
    break;
    
   case IDM_Edit_DeleteRightWord:
    fun = &Interval::MakeRightWord;
    break;
  }
  if (fun)
  {
    will_delete->Apply(fun);
  }
  
  will_delete->RemoveNested();
  il->RemoveNested();
  
  undo->StartAtom(il, desc);
  int deletedp = False;
  for (Interval* i = will_delete->GetHead(); i != NULL; i = i->GetNext())
  {
    undo->Register(i, PUndo::UF_Delete);
    deletedp |= i->Cut();
  }
  delete will_delete;
  
  // backspaces at multiple locations might catch up to each other
  il->MergePoints();
  
  undo->EndAtom(il);
  editor->DidEdit();
  if (!deletedp && Pref_beep_if_cannot_delete && command != IDM_Edit_Cut)
  {
    ::MessageBeep(0);
  }
  return 0;
}

// private method
bool NEAR
DocumentChar::TryEuroCombo1(char c, unsigned char* r)
{
  assert(eurocombo_on);
  *r = SearchEuroCombo(c);
  if (*r)
  {
    ClearEuroCombo();
    return True;
  }
  else
  {
    if (!eurocombo_deadchar)
    {
      // first character, wait for second
      eurocombo_deadchar = c;
      return True;
    }
    else
    {
      // second character, must match else error
      ::MessageBeep(0);
      ClearEuroCombo();
      return False;
    }
  }
}

// SearchEuroCombo -- search for combination of dead character and
// specified character in combination table
// private method
unsigned char NEAR
DocumentChar::SearchEuroCombo(char c)
{
  eurocombo* x = eurocombo_table; 
  for (int i = 0xa0; i < 0x100; i++, x++)
  {
    if ((eurocombo_deadchar == x->c1 && c == x->c2) ||
	(eurocombo_deadchar == x->c2 && c == x->c1))
    {
      return i;
    }
  }
  return 0;
}

// list of combinations for direct input of european characters.
// this list goes from hex A0 to hex FF.
// Most of the definitions are natural, but 's' is used to mean
// superscript.  Space is used for accents by themselves.

DocumentChar::eurocombo DocumentChar::eurocombo_table[] = 
{
  { 0, 0, },
  { '!', 0, },    	// upside down exclamation mark
  { 'c', '/', },	// cents sign
  { 'L', '-', },	// pound sign
  { 'o', 'x', },     	// circle with hairs
  { 'Y', '=', },     	// yen sign
  { 'i', 'i', },     	// broken vertical bar
  { 'S', 'o', },     	// section mark
  { '\"', ' ', },    	// umlaut
  { 'c', 'o', },     	// copyright mark
  { 'a', '_', },     	// underined "a"
  { '<', '<', },     	// left guillemot
  { '-', 'i', },     	// not sign
  { '-', '-', },	// longer hyphen
  { 'r', 'o', },	// registered mark
  { 's', '_', },     	// overline
  { 's', 'o', },	// degree mark
  { '+', '-', },     	// plus-minus sign
  { 's', '2', },	// superscript 2
  { 's', '3', },	// superscript 3
  { '\'', ' ', },	// accent acute
  { 'm', 'u', },     	// greek "mu"
  { 'P',  0, },      	// paragraph mark
  { 's', '.', },     	// dot in middle  WHAT SHOULD THIS BE??
  { ',', ' ' },     	// cedilla
  { 's', '1', },     	// superscript 1
  { 'o', '_', },     	// underlined o
  { '>', '>', },     	// right guillemot
  { '1', '4', },     	// 1/4
  { '1', '2', },     	// 1/2
  { '3', '4', },     	// 3/4
  { '?', 0, },    	// upside down question mark
  { 'A', '`', },     
  { 'A', '\'', },
  { 'A', '^', },
  { 'A', '~', },
  { 'A', '\"', },
  { 'A', 'o', },
  { 'A', 'E', },
  { 'C', ',' },
  { 'E', '`', },     
  { 'E', '\'', },
  { 'E', '^', },
  { 'E', '\"', },
  { 'I', '`', },     
  { 'I', '\'', },
  { 'I', '^', },
  { 'I', '\"', },
  { 'D', '-', },
  { 'N', '~', },
  { 'O', '`', },     
  { 'O', '\'', },
  { 'O', '^', },
  { 'O', '~', },
  { 'O', '\"', },
  { 'x', 0, },
  { 'O', '/', },
  { 'U', '`', },     
  { 'U', '\'', },
  { 'U', '^', },
  { 'U', '\"', },
  { 'Y', '\'', },
  { '|', 'O', },	// what is this thing called?
  { 'b', ' ', },	// beta-like thing used in German for two s's
  { 'a', '`', },     
  { 'a', '\'', },
  { 'a', '^', },
  { 'a', '~', },
  { 'a', '\"', },
  { 'a', 'o', },
  { 'a', 'e', },
  { 'c', ',', },
  { 'e', '`', },     
  { 'e', '\'', },
  { 'e', '^', },
  { 'e', '\"', },
  { 'i', '`', },     
  { 'i', '\'', },
  { 'i', '^', },
  { 'i', '\"', },
  { 'd', '-', },
  { 'n', '~', },
  { 'o', '`', },     
  { 'o', '\'', },
  { 'o', '^', },
  { 'o', '~', },
  { 'o', '\"', },
  { ':', '-', },	// divide sign
  { 'o', '/', },
  { 'u', '`', },     
  { 'u', '\'', },
  { 'u', '^', },
  { 'u', '\"', },
  { 'y', '\'', },
  { '|', 'o', },
  { 'y', '\"', },
};
