// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docchar.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// define class to handle characters input to a document

#ifndef DOCCHAR_H
#define DOCCHAR_H

class DocumentChar 
{
private:
  struct eurocombo
  {
    char c1, c2;
  };
  
private:
  static sjis buf[128];
  static int bufp;
  static bool kanji_pending;
  static bool ime_string_pending;
  static bool eurocombo_on;
  static char eurocombo_deadchar;
  static eurocombo eurocombo_table[];
  
private:
  // parent owning this DocumentEdit object
  DocumentEdit* editor;
  
  // this is crap used when inputting characters
  int pending_kanji;
  bool waiting_for_last_ime_char;
  
public:
  // constructor and destructor 
  DocumentChar(DocumentEdit*);
  
private:
  bool NEAR DocumentChar::TryEuroCombo(char, unsigned char*);
  bool NEAR DocumentChar::TryEuroCombo1(char, unsigned char*);
  int NEAR DocumentChar::GetEuroCombo();
  unsigned char NEAR DocumentChar::SearchEuroCombo(char);
  void NEAR DocumentChar::ClearEuroCombo();
  void NEAR DocumentChar::InsertText(sjis* stuff, int count);
  void NEAR DocumentChar::SetEuroCombo();
  
public:
  DocumentEdit* GetEditor() { return editor; }

#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
  LRESULT_T Edit(WORD command);
#else /* BW3_DISPATCH */
  long Dispatch(int, long);
  long Edit(uword command);
#endif /* BW3_DISPATCH */
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
};

#endif /* DOCCHAR_H */
