// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docmouse.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class definition for DocumentMouse
// The DocumentMouse class defines mouse behavior in a document window.

#ifndef DOCMOUSE_H
#define DOCMOUSE_H

class DocumentMouse
{
private:
  DocumentEdit* editor;
  BP* button_down_point;
  FrameInstance* multi_cell_start_frame;
  int shift_state;
  int double_clicking : 1;
  int cancelling_selection : 1;
  int multi_cell_p : 1;
  
private:
  DocumentMouse(DocumentEdit*);
  ~DocumentMouse();
  void Init();
  
public:
  static DocumentMouse* MakeInstance(DocumentEdit*);
  static void KillInstance(DocumentMouse*);
  
private:
  IntervalList* ClearMultiCell();
  void Clean();
  void ConfirmSelection();
  void InvalidateFrame(FrameInstance* frame);
  void SelectMultiCell(Lpoint* lp);
  void SetupSelection(BP* bp);
  
public:
  void WndProc(MSG_T message, WPARAM_T wParam, LPARAM_T lParam);
  BP* GetButtonDownPoint() 
  {
    return button_down_point;
  }
  void Reset();
};

#endif /* DOCMOUSE_H */
