// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docprese.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// docpresentation.cpp -- implement DocumentPresentation class

#include "pword.h"
#include "docprese.h"
#include "docconte.h"
#include "document.h"
#include "docwindo.h"
#include "editfram.h"
#include "layoutin.h"
#include "layoutte.h"
#include "pstreams.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

DocumentPresentation::DocumentPresentation
(
 Document* _document
)
  : document(_document)
{
  Init();
}

void
DocumentPresentation::Init()
{
  this->first_docwindow = NULL;
  this->request_caret_control = False;
}

DocumentPresentation::~DocumentPresentation()
{
  Close();	
}

void
DocumentPresentation::SafeDestruct()
{
  for (DocumentWindow* dw=GetFirstDocWindow(); dw; dw = dw->GetNextDocWindow())
  {
    // kill window only, not C++ object
    dw->MDIChild::Destroy();
  }
  SetFirstDocWindow(0);
}

void
DocumentPresentation::ControlCaret()
{
  for (DocumentWindow* w = this->first_docwindow;
       w != NULL; w = w->GetNextDocWindow())
  {
    w->ControlCaret();
  }
  this->request_caret_control = False;
}

void
DocumentPresentation::CheckCaret()
{
  for (DocumentWindow* w = this->first_docwindow;
       w != NULL; w = w->GetNextDocWindow())
  {
    w->CheckCaret();
  }
}

void
DocumentPresentation::Reset()
{
  for (DocumentWindow* dw = this->first_docwindow; dw; dw = dw->next_docwindow)
  {
    dw->Reset();
  }
}

void DocumentPresentation::Open()
{
  if (!first_docwindow)
  {
    (void*) NewDocumentWindow(True /*use preferences for initial size*/);
  }
}

DocumentWindow* 
DocumentPresentation::NewDocumentWindow(bool pref_size)
{
  DocumentWindow* dw = new DocumentWindow(this,
					   document->GetName(), pref_size);
  if (dw->GetHandle() != 0)
  {
    return dw;
  }
  else
  {
    delete dw;
    return 0;
  }
}

// Xg̍Ōɓ悤ɕύXB (konno)
void
DocumentPresentation::AddDocumentWindow(DocumentWindow* dw)
{
  DocumentWindow** place = &this->first_docwindow;
  for (;;)
  {
    DocumentWindow* next = *place;
    if (next == NULL)
    {
      break;
    }
    place = &next->next_docwindow;
  }
  *place = dw;
  dw->next_docwindow = NULL;
}

void
DocumentPresentation::RemoveDocumentWindow(DocumentWindow* dw)
{
  DocumentWindow** place = &this->first_docwindow;
  for (;;)
  {
    DocumentWindow* next = *place;
    if (next == NULL)
    {
      break;
    }
    if (next == dw)
    {
      *place = dw->next_docwindow;
      break;
    }
    place = &next->next_docwindow;
  }
  dw->next_docwindow = NULL;
}

void
DocumentPresentation::Activate()
{
  first_docwindow->Activate();
}

void
DocumentPresentation::RedrawWindows()
{
  for (DocumentWindow* dw = first_docwindow; dw; dw = dw->GetNextDocWindow())
  {
    if (dw->GetSize() != SIZEICONIC)
    {
      dw->InvalidateAll();
    }
  }
}

void
DocumentPresentation::CloseWindow(DocumentWindow* dw)
{
  DocumentWindow* first_dw;
  
  // if this is not the only window on the document, no need to check
  
  if (((first_dw=GetFirstDocWindow())!=0) && first_dw->GetNextDocWindow()) {
    DocumentWindow** plug = &first_docwindow;
    while (*plug) {
      if ((*plug)==dw) {
	*plug = dw->GetNextDocWindow();
	delete dw;  // take that!
	if (Selected_Window == dw)
	{
	  Selected_Window = 0;
	}
	break;
      }
      else plug = & ((*plug)->next_docwindow);
    }
  }
  else GetDocument()->Close();
}

// This is essentially destructor-like behavior, but there are times
// when we want to shut down the DocumentPresentation while leaving
// a Document alive

void
DocumentPresentation::Close()
{
  for (DocumentWindow* dw=GetFirstDocWindow(); dw;)
  {
    DocumentWindow* next = dw->GetNextDocWindow();
    delete dw;
    dw = next;
  }
  SetFirstDocWindow(0);
}

// get first layout
LayoutInstance*
DocumentPresentation::GetFirstLayout()
{
  return document->GetDocumentContent()->GetFirstLayout();
}

// get last layout
LayoutInstance*
DocumentPresentation::GetLastLayout()
{
  return document->GetDocumentContent()->GetLastLayout();
}

// presentation is not being written to stream now, but
// we write a header in case we want to do it later
void
DocumentPresentation::WriteFormattedToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_DOCPRES); 
  int i=0;
  {
    for (DocumentWindow* dw=GetFirstDocWindow(); dw; dw=dw->GetNextDocWindow())
    {
      i++;
    }
  }
  stream->OutUWord(i);
  {
    bool we_have_selected_window = False;
    for (DocumentWindow* dw=GetFirstDocWindow(); dw; dw=dw->GetNextDocWindow())
    {
      if (dw != ::Selected_Window)
      {
	dw->WriteToStream(stream);
      }
      else
      {
	we_have_selected_window = True;
      }
    }
    if (we_have_selected_window)
    {
      ::Selected_Window->WriteToStream(stream);
    }
  }
  stream->EndBlockOut(); 
}

void
DocumentPresentation::ReadFormattedFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DOCPRES, vers);
  CHECK;
  uword n = stream->InUWord();
  if (stream->GetError() == SE_NOMORE)
  {
    stream->SetError(SE_NOERROR);
    Open();
    return;
  }
  CHECK;
  
  if ((int) n <= 0)
  {
    stream->SetError(SE_BADVAL);
    return;
  }
  for (; n; --n)
  {
    DocumentWindow* dw = new DocumentWindow(this,
					     document->GetName(), stream);
    CHECK;
    if (dw->GetHandle() == 0)
    {
      delete dw;
      break;
    }
  }
  stream->EndBlockIn();
  CHECK;
}
