// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: document.h,v 3.6 1999/09/05 04:24:01 kudou Exp $
// define Document class
// The Document class categorizes instances of open documents in
// pWord.  The windows that belong to the document are managed 
// from here.

#ifndef DOCUMENT_H
#define DOCUMENT_H

class Document
{
  friend class DocumentWindow;
  
#ifdef BW3_LONGFILENAME
  enum 
  { 
    ADDDOCNAMELEN = 12,	// sizeof("<0123456789>")
    DOCNAMELEN = MAX_PATH + ADDDOCNAMELEN,
  };
  char name[DOCNAMELEN+1];
  char path_name[DOCNAMELEN+1];
#else /* BW3_LONGFILENAME */
  enum 
  { 
    DOCNAMELEN = 80
  };
  char name[DOCNAMELEN+1];
  char path_name[DOCNAMELEN+1];
#endif /* BW3_LONGFILENAME */
  
  Document* next_document;
  int error;
  
  DocumentPresentation&	presentation;
  DocumentContent&	content;
  bool text_format;
  int crtype;
  
  // If there are entity, we must so frequently recomple many parts
  // when edit the EditFrame and the EditPage class.
  // So untill next classes are fixed, I am going to leave it reference.
  
  // frame editor
  EditFrame&		frame_editor;
  
  // page editor
  EditPage&		page_editor;
  
  // are we saving file now?
  bool saving;

  // file version
#ifdef BW3_FILEVERSIONSAVE
  dword file_version;
  dword file_miner_version;
  dword file_beta_version;
  dword file_miner_beta_version;

public:
  dword GetFileVersion() { return file_version; }
  dword GetFileMinerVersion() { return file_miner_version; }
  dword GetFileBetaVersion() { return file_beta_version; }
  dword GetFileMinerBetaVersion() { return file_miner_beta_version; }
#endif /* BW3_FILEVERSIONSAVE */ 

private:
  Document();

public:
  ~Document();
  
private:
#ifdef BW3_DISPATCH
  LRESULT_T NEAR SearchAgain(bool menu_state_p, int reverse);
#else /* BW3_DISPATCH */
  long NEAR SearchAgain(int reverse, int menu_state_p);
#endif /* BW3_DISPATCH */
  void NEAR SetPathName(char* path_name);
  void NEAR Print(int sel_only, int from, int to, int copies, int reversep);
public:
  static Document* MakeNew();
  static Document* MakeForMemo(char* name);
  static Document* MakeFromFile(char* name);
  static Document* MakeForRevert(Document*);
  void Document::search_string(char* s, int reverse, int all);
  void SafeDestruct();
  void CheckWindow();
  void SetUntitledName();
  int QueryEndSession(int local, int confirm);
  void Close();
#ifdef BW3_FILEDLG
  int SaveAsDlg(char* filename, char* filter_str, bool& format);
#else /* BW3_FILEDLG */
  int SaveAsDlg(char* filename, bool& format);
#endif /* BW3_FILEDLG */
  char* GetName();
  char* GetPathName()
  {
    return path_name;
  }

  int GetError() const
  {
    return error;
  }

  bool GetTextFormat()
  {
    return(this->text_format);
  }
  
  Document* & GetNextDocument() { return next_document; }
  void SetNextDocument(Document* nd) { next_document=nd; }
  void ReadInFile(bool revert=False);
  void NEAR ReadInFile0(bool revert);
  void ReadInFileUntilMemo();
  void NewFile();
  void DelayFormat();
  void Activate();
  
  // searching
  IntervalList* FindText(sjis* what);
  IntervalList* FindText(sjis* what, bool reverse, bool all);
  
  // dispatchers
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(bool menu_state_p, WORD command);
#else /* BW3_DISPATCH */
  long Dispatch(int command, int menu_state_p);
#endif /* BW3_DISPATCH */
  
  void InsertFromStream(PStream*);
  void WriteASCIIToStream(BufStream*);
  void WriteFormattedToStream(PStream*);
  void ReadFormattedFromStream(PStream*);
  void ReadFormattedUntilMemo(PStream*);
  void ReadASCIIFromStream(BufStream*);
  void OpenTextAsBeatWordDialog();
  void ReportVersionError(int vers);
  
  void GotoMark(IntervalList*);
  void StyleChange(uword style);
  void ParCharAtts(uword style);
  IntervalList* FindStyle(uword style);
  
private:
  void WriteHeader(PStream* stream);
  void ReadHeader(PStream* stream, word& version);

private:
  // new buffer setup
  void NewBufSetup();
  void WriteOutFile();
  void NEAR WriteOutFile0();
  
public:
  // get document-presentation
  DocumentPresentation* GetDocumentPresentation() 
  { return &presentation; }
  
  // get document-content
  DocumentContent* GetDocumentContent() 
  { return &content; }
  
  DocumentWindow* GetFirstDocWindow();
  
  // get edit-frame
  EditFrame* GetEditFrame() { return &frame_editor; }
  
  // get page-editor
  EditPage* GetEditPage() { return &page_editor; }
  
  // get printer info
  PrinterInfo* GetPrinterInfo();
};

void ReportOpenError(char* name, bool save = False);
void ReportReadError();
void ShowFileName(char* name, char* s);
bool CheckFileAccess(char* name, bool);

#endif /* DOCUMENT_H */
