// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docwindo.h,v 3.4 1999/05/12 00:22:16 kudou Exp $
// class definition for DocumentWindow
// The DocumentWindow class defines MDI child windows which * provide
// one view on a document.

#ifndef DOCWINDO_H
#define DOCWINDO_H

#include "frameins.h"
#include "frametem.h"
#include "mdichild.h"
#include "rect.h"
#include "view.h"

#ifdef FAKE_TIMERBASED_MOUSEMOVE
#define WM_FAKETIMERBASEDMOUSEMOVE 0x4100
#endif /* FAKE_TIMERBASED_MOUSEMOVE */

class DocumentWindow
  : public MDIChild,
    public View
{
  friend class DocumentPresentation;
  friend class FrameInstance;
  
  DocumentEdit* editor;
  
  // window class name
  static char STATIC_NEAR szClassName[14];
  
private:
  static HBITMAP STATIC_NEAR bitmap;
  static int STATIC_NEAR bitmap_width;
  static int STATIC_NEAR bitmap_height;
  
  // to which I belong
  DocumentPresentation* presentation;
  
  // there are many windows which points same document
  DocumentWindow* next_docwindow;
  
  LayoutInstance* beginning_layout;
  LayoutInstance* end_layout;
  
  LayoutInstance* zero_caret_layout;

  // uniq window name, which is showed on the title bar.
  char* name;
  
public:
  // scaled window size
  long Width;
  long Height;
  
  // scaling factor, 100 means 100%
  int scaling;
  
private:
  // layout x margin
  static word STATIC_NEAR layout_x_margin;
  
  // layout y margin
  static word STATIC_NEAR layout_y_margin;
  
  // recent window size and position
  int size;
  RECT normal_position;
  
public:
  // generic mouse control
  struct
  {
    Lunit work_lx;
    Lunit work_ly;
    int activep : 1;
    int movedp : 1;
  } mouse;
  
private:
  // caret managing
  int request_caret : 1;
  int request_force_caret : 1;
  int request_caret_control : 1;
  
  // line
  int only_requested_line_p : 1;
  
  int hscroll_shown_p;
  int vscroll_shown_p;
  
  // fields used by IME control
private:
  static Lpoint STATIC_NEAR recent_caret_lp[1];
  static Lrect STATIC_NEAR recent_frame_drawing_lrect;
  static bool STATIC_NEAR recent_has_caret;
  static int STATIC_NEAR recent_tategaki_flow_p;
  
public:
  static bool STATIC_NEAR IME_sends_open_window;

public:
  DocumentWindow(DocumentPresentation* , char* name, bool pref_size);
  DocumentWindow(DocumentPresentation* , char* name, PStream*);
  ~DocumentWindow();

public:
  void SetName(char* name);

public:
  void Init(DocumentPresentation*);
  void Make(MDICREATESTRUCT&, char* , bool pref_size);
  
protected:
  // called from View class
  HDC GetTrueDC();
  HWND MaybeGetWindowHandle();
  void ReleaseTrueDC(HDC dc);
  
public:
  int
  GetSize()
  {
    return size;
  }
  
  void Reset();
  void Destroy();
  static void Register();
  
  // window procedures
private:
  int NEAR check_names(Document* d, char* name);
  void NEAR HandleMouse(WORD Msg, WORD wParam, LONG lParam);
  void NEAR HandlePaint();
  
public:
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // accessors
  DocumentEdit* 
  GetEditor()
  {
    return editor;
  }
  
  DocumentPresentation* 
  GetPresentation()
  {
    return presentation;
  }
  
  DocumentContent* GetContent();
  
  // ------------------------------
  // mouse navigation public methods
  
public:
  BP* navigate_bp(Lpoint* lp, BP* advice_bp, FrameInstance* *frame_return);
  LayoutInstance* navigate_layout(Lpoint* lp);
  LayoutInstance* navigate_layout1(Lpoint* lp);
  Line* navigate_line(Lpoint* lp);
  
  // ------------------------------
  // caret control
  
private:
  BP* GetCaretBP();
  
public:
  word GetCaretPageNum();
  TextFlow* GetCaretTextFlow();
  
  void
  RequestCaret()
  {
    this->request_caret = True;
  }
  
  static void control_ime();
  static void force_touch_caret();
  static void touch_caret();
  static void unforce_touch_caret();
  static void untouch_caret();
  void CheckCaret();
  void ControlCaret();
  void ControlIME();
  void ForceTouchCaret();
  void TouchCaret();
  void UnforceTouchCaret();
  void UntouchCaret();
  
  // ------------------------------
  // view control
  
private:
  void SetView0(Lunit x, Lunit y, bool do_all);
  void UpdateScrollPos();
  
public:
  void BreakBeginningLayout();
  void BreakLayout(LayoutInstance* layout);
  void RecalcLayouts();
  void Recenter(bool horizontal_only);
  void SetViewOnLayout(LayoutInstance* li);
  void SetViewOnLayout(LayoutInstance* li, Iunit x, Iunit y);
  void SetViewOnDunitRelative(int x_diff, int y_diff);
  void SetView(Lunit x, Lunit y);
  void control_scroll_bar();
  
  // ------------------------------
  // visible layout control
  
  LayoutInstance* GetTopLevelLayout(LayoutInstance* layout);
  LayoutInstance* GetCaretLayoutInstance();
  LayoutInstance* GetZeroCaretLayout();
  bool GetCaretPageAndLine(int* page_return, int* line_return, bool* ghost_return);
  void SetZeroCaretLayout(LayoutInstance* layout);
  
  // ------------------------------
private:
#ifdef BW3_DISPATCH
  LRESULT_T NEAR NewWindow(bool menu_state_p);
#else /* BW3_DISPATCH */
  long NEAR NewWindow(int menu_state_p);
#endif /* BW3_DISPATCH */
  
public:
  static void KillBitmap();
  
public:
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long Dispatch(int message, long lParam);
#endif /* BW3_DISPATCH */
  bool LayoutIsVisibleP(LayoutInstance* layout);
  int GotoPage(int, int);
  void Invalidate(BP* bp0, BP* bp1);
  void InvalidateZeroPage(FrameInstance* frame);
  void Invalidate(Lrect* r);
  void get_lrect(Lrect* rect);
  
private:
#ifdef BW3_DISPATCH
  LRESULT_T NEAR ZoomWindow(bool menu_state_p);
  LRESULT_T NEAR ZoomWindow_Inc_Dec(bool menu_state_p, int delta, int other_command);
#else /* BW3_DISPATCH */
  long NEAR ZoomWindow(int menu_state_p);
  long NEAR ZoomWindow_Inc_Dec(int menu_state_p, int delta, int other_command);
#endif /* BW3_DISPATCH */

  void NEAR Zoom(int new_scaling);
  
  void IncScroll(int xdir, int ydir);
  
  EditFrame* GetEditFrame();
  
public:
  LayoutInstance* 
  GetBeginningLayout()
  {
    return(this->beginning_layout);
  }
  
  LayoutInstance* 
  GetEndLayout()
  {
    return(this->end_layout);
  }
  
  // layout x margin
  static word GetLayoutXMargin()
  {
    return layout_x_margin;
  }
  
  // layout y margin
  static word GetLayoutYMargin()
  {
    return layout_y_margin;
  }
  
  // get window size
  // There methods are old interface. (konno)
  long GetWidth() { return Width; }
  long GetHeight() { return Height; }
  
  // get window size by Lunit
  Lunit
  GetLWidth()
  {
    return(this->Width);
  }
  
  Lunit
  GetLHeight()
  {
    return(this->Height);
  }
  
  // get next document window
  DocumentWindow* GetNextDocWindow()
  {
    return next_docwindow; 
  }
  
  // activate, as when going to mark
  void Activate();
  
  // write out to stream
  void WriteToStream(PStream*);
  
public:

#ifdef FAKE_TIMERBASED_MOUSEMOVE
#ifdef _WIN32
  static void CALLBACK timer_handler(HWND hWnd, UINT wMsg,
				     UINT nIDEvent, DWORD dwTime);
  static void timer_handler_ (HWND hWnd, UINT wMsg,
			      UINT nIDEvent, DWORD dwTime);
#else /* _WIN32 */
  // win3.1 TimerProc is also void return value. This may be potential bug.
  static WORD FAR PASCAL _export timer_handler(HWND hWnd, UINT wMsg,
					       UINT nIDEvent, DWORD dwTime);
  static WORD FAR PASCAL timer_handler_ (HWND hWnd, UINT wMsg,
					 UINT nIDEvent, DWORD dwTime);
#endif /* _WIN32 */
#endif /* FAKE_TIMERBASED_MOUSEMOVE */  

private:
  // invalidate layout
  void NEAR InvalidateLayout(LayoutInstance* li);
  
  // invalidate only requested frame
  void NEAR InvalidateRequestedFrame(LayoutInstance* li);
  
  // invalidate only requested line
  void NEAR InvalidateRequestedLine(LayoutInstance* li);
  
  enum invalidate_request
  {
    invalidate_all,
    invalidate_frame,
    invalidate_line,
  };
  
  // invalidate layout
  void NEAR Invalidate(LayoutTemplate* lt, invalidate_request ir);
  
  // invalidate layout
  void NEAR Invalidate(LayoutInstance* li, invalidate_request ir);
  
public:
  // invalidate layout
  void InvalidateLayout(LayoutTemplate* lt);
  
  // invalidate only redisplay requested frame
  void InvalidateRequestedFrame(LayoutTemplate* lt);  
  
  // invalidate only redisplay requested line
  void InvalidateRequestedLine(LayoutTemplate* lt);
  
  bool OnlyRequestedLineP()
  {
    return only_requested_line_p != 0;
  }
};

inline void
DocumentWindow::SetZeroCaretLayout(LayoutInstance* layout)
{
  this->zero_caret_layout = layout;
}

#endif /* DOCWINDO_H */
