// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: dpm.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// DocPageMapIterator:	all document page map iterator

#include "pword.h"
#include "pmlist.h"
#include "pllist.h"
#include "dpm.h"
#include "layoutin.h"
#include "panel.h"
#include "pagesize.h"
#include "tablepnl.h"
#include "table.h"
#include "docconte.h"

// constructor
DocPageMapIterator::DocPageMapIterator(DocumentContent* doc)
{
  DocPageMapIterator::doc = doc;
  stage = normal_page;
  pmli = new PMListIterator(doc->pm_list);
#if defined(BCC31)
  plli = new PLListIterator((AvlSearch*)* (doc->panels));
#else
  plli = new PLListIterator(* (doc->panels));
#endif
  pm = (*pmli) ();
  pl = (*plli) ();
}

// destructor
DocPageMapIterator::~DocPageMapIterator()
{
  delete pmli;
  delete plli;
}

// iterator
PageMap* 
DocPageMapIterator::operator() ()
{
  switch (stage) 
  {
   case normal_page:
    {
      while (pm != 0) 
      {
	PageMap* ret = pm;
	pm = (*pmli) ();
	return ret;
      }
      stage = table;
    }
   case table:
    {
      while (pl != 0) 
      {
	PageMap* ret = 0;
	if (pl->GetPanelID() == Panel::TablePanelID) 
	{
	  TablePanel* tp = (TablePanel*)pl;
	  ret = (PageMap*)tp->GetTable();
	}
	pl = (*plli) ();
	if (ret != 0) 
	{
	  return ret;
	}
      }
      stage = zero_page;
    }
   case zero_page:
    {
      PageSize* ps = doc->GetPageSize();
      stage = end;
      if (ps != 0) 
      {
	return(PageMap*)ps;
      }
    }
   case end:
   default:
    // error
    break;
  }
  return 0;
}

// iterator
PageMap* 
DocPageMapIterator::GetTemplatePageMap(LayoutTemplate* lt)
{
  for (PageMap* pm = (*this) ();
       pm != 0;
       pm = (*this) ()) 
  {
    if (pm->GetLayoutTemplate() == lt) 
    {
      return pm;
    }
  }
  return 0;
}

// revert
void 
DocPageMapIterator::Revert()
{
  delete pmli;
  delete plli;
  pmli = new PMListIterator(doc->pm_list);
#if defined(BCC31)
  plli = new PLListIterator((AvlSearch*)* (doc->panels));
#else
  plli = new PLListIterator(* (doc->panels));
#endif
  pm = (*pmli) ();
  pl = (*plli) ();
}
