// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: eca.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// class EditCharAtts

#ifndef ECA_H
#define ECA_H

#include "attman.h"
#include "pundo.h"

class EditCharAtts
  : public AttMan
{
  static attr clipboard;
  
public:
  EditCharAtts(DocumentEdit* de);
  
private:
  virtual char* GetRedefinitionMessageString();

public:
  attr GetCurrentAtts();
  
private:
  int NEAR GetNewStyleName(char* , int& existing);

#ifdef BW3_DISPATCH
  LRESULT_T NEAR Border(bool menu_state_p);
  LRESULT_T NEAR CopyAttr(bool menu_state_p);
  LRESULT_T NEAR DefineStyle(bool menu_state_p);
  LRESULT_T NEAR PasteAttr(bool menu_state_p);
  LRESULT_T NEAR Plain(bool menu_state_p);
  LRESULT_T NEAR RedefineStyle(bool menu_state_p);
  LRESULT_T NEAR SetPureStyle(bool menu_state_p);
  LRESULT_T NEAR Size(bool menu_state_p);
  LRESULT_T NEAR SizeAdjust(bool menu_state_p);
  LRESULT_T NEAR Size_Inc_Dec(bool menu_state_p, int delta, int other_command);
  LRESULT_T NEAR Spacing(bool menu_state_p);
  LRESULT_T NEAR Spacing_Inc_Dec(bool menu_state_p, int delta, int other_command);
  LRESULT_T NEAR Style_Search(bool menu_state_p);
  LRESULT_T NEAR Subscript(bool menu_state_p, int delta);
  LRESULT_T NEAR Toggle(bool menu_state_p, int attcode);
  LRESULT_T NEAR Underline(bool menu_state_p);
#else /* BW3_DISPATCH */
  long NEAR Border(int menu_state_p);
  long NEAR CopyAttr(int menu_state_p);
  long NEAR DefineStyle(int menu_state_p);
  long NEAR PasteAttr(int menu_state_p);
  long NEAR Plain(int menu_state_p);
  long NEAR RedefineStyle(int menu_state_p);
  long NEAR SetPureStyle(int menu_state_p);
  long NEAR Size(int menu_state_p);
  long NEAR SizeAdjust(int menu_state_p);
  long NEAR Size_Inc_Dec(int menu_state_p, int delta, int other_command);
  long NEAR Spacing(int menu_state_p);
  long NEAR Spacing_Inc_Dec(int menu_state_p, int delta, int other_command);
  long NEAR Style_Search(int menu_state_p);
  long NEAR Subscript(int menu_state_p, int delta);
  long NEAR Toggle(int menu_state_p, int attcode);
  long NEAR Underline(int menu_state_p);
#endif /* BW3_DISPATCH */
  void NEAR Apply(attr(*func) (attr, int, int), int attcode, int attval, PUndo::UndoDesc);
  void NEAR set_size(int size);
  void NEAR set_spacing(int mm0, int do_message);
public:
  attr GetCommonAtts();
  long ChangeTextSize(int menu_state_p, int size);
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long Dispatch(int command, long lParam);
#endif /* BW3_DISPATCH */
  long set_style(int menu_state_p, int style);
  long specific_value(int menu_state_p, int attcode, int attvalue);
  void ApplyIL(IntervalList* , attr(*func) (attr, int, int), int, int, PUndo::UndoDesc);
};

#endif /* ECA_H */
