// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: editfram.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class EditFrame
// class for frame editor
// every mode operations are described in each class

#ifndef EDITFRAME_H
#define EDITFRAME_H

#define MARGIN_SET_WITH_LEFT

#include "rect.h"
#include "margin.h"
#include "pwordpre.h"

class LayoutInstance;
class LayoutTemplate;
class FissionFrame;
class Fission;
class FrameObject;
class CrossPoint;
class TextFlow;
class PWordPresentation;
class DocumentPresentation;
class Document;
class LineSelection;
class VDisplay;
class NavPMargin;

#ifndef LSLIST_DEFINED
// line selection list dummy
//
// LSList is a typedef type. Real definition is so complex.
// Look at "lslist.h".
class LSList;
#endif

#ifndef CPLIST_DEFINED
class CPList;
#endif
#ifndef FOLIST_DEFINED
class FOList;
class FOListIterator;
#endif

#define EDIT_MODE_BODY

#ifdef EDIT_MODE_BODY
#include "editmode.h"
#else
// edit mode class
// these classes are declared in "editmode.h"
class EMCutLine;
class EMDrawLine;
class EMMoveLine;
class EMSelectFrame;
class EMSetFlow;
class EMExchFlow;
class EMSetMargin;
class EMMakeTable;
class EMFrameMargin;
#endif

class EditFrame 
{
  // document
  Document* doc;
  
  // which window
  // this value is set at beginning of the WindowProc.
  DocumentWindow* window;
  
  // current edit layout-instance
  LayoutInstance* edit_li;
  
  // current edit layout-template
  LayoutTemplate* edit_lt;
  
  // current edit fission-frame
  FissionFrame*   edit_ff;
  
  // regular layout-instance
  LayoutInstance* regular_li;
  
  // last tool box editmode
  EditMode toolbox;
  
  // multi line selection
  LSList* lines;
  
  // multi frame selection
  CPList* frames;
  
  // rectangular aria selection
  // next two cross-points form rectangular aria
  CrossPoint* rect_rgn_cp1;
  CrossPoint* rect_rgn_cp2;
  
  // selected frame outline
  CrossPoint* min_x_cp;
  CrossPoint* max_x_cp;
  CrossPoint* min_y_cp;
  CrossPoint* max_y_cp;

  // ------------------------------
  // each edit-mode working data
#ifdef EDIT_MODE_BODY
  EMCutLine	 cut;
  EMDrawLine	 line;
  EMMoveLine	 move;
  EMSelectFrame selfrm;
  EMSetFlow	 flow;
  EMExchFlow	 exch;
  EMSetMargin	 setmgn;
  EMMakeTable	 mktbl;
  EMFrameMargin  fmgn;
#else
  // These values are reference now. But I'm going to change entity
  // after edit-mode class development.
  EMCutLine&	 cut;
  EMDrawLine&	 line;
  EMMoveLine&	 move;
  EMSelectFrame& selfrm;
  EMSetFlow&	 flow;
  EMExchFlow&	 exch;
  EMSetMargin&	 setmgn;
  EMMakeTable&	 mktbl;
  EMFrameMargin& fmgn;
#endif
  
  // mouse offset
  // real point -> hot point
  VectW mouse_offset;
  
  // effective move flag
  bool effective;
  
  // now set flow
  static bool now_set_flow;
  
#ifdef BW2_GRID
  // grid
public:
  enum GridOrg 
  {
    GridOrgTop      = 0x01,
    GridOrgBottom   = 0x02, 
    GridOrgLeft     = 0x04,
    GridOrgRight    = 0x08,
  };
  
private:
  static bool grid_status;
  static Iunit grid_x_unit;
  static Iunit grid_y_unit;
  static Iunit grid_x_offset;
  static Iunit grid_y_offset;
  static GridOrg grid_org;
  
public:
  // grid interface
  static bool GetGridStatus() 
  {
    return grid_status; 
  }
  
  static Iunit GridXUnit() 
  {
    return grid_x_unit; 
  }
  
  static Iunit GridYUnit() 
  {
    return grid_y_unit; 
  }
  
  static Iunit GridXOffset() 
  {
    return grid_x_offset; 
  }
  
  static Iunit GridYOffset() 
  {
    return grid_y_offset; 
  }
  
  static GridOrg GridOrigin() 
  {
    return grid_org; 
  }
  
  static Iunit GridX(Iunit x);
  static Iunit GridY(Iunit y);
#endif
  
public:
  // this enum shows which frame lines are the target
  enum TargetLine
  {
    VBoundary = 0x1,                   // vertical boundary lines
    HBoundary = 0x2,                   // horizontal boundary lines
    VInter    = 0x4,                   // vertical internal lines
    HInter    = 0x8,                   // horizontal internal lines
    Boundary  = VBoundary | HBoundary, // boundary lines
    Inter     = VInter | HInter,       // internal lines
    AllLines  = Boundary | Inter,      // all lines
  };
  
public:
  // constructor
  EditFrame(Document* doc);
  
  // destructor
  ~EditFrame();
  
  // tool box item changed message
  void ReceiveChangeToolBoxItem(EditMode em);

  // change edit mode
  void ChangeEditMode(EditMode em);
  
  void EditFrame::Reset();
  void EditFrame::ReportBreakLayout();
  
  // report break layout
  void ReportBreakLayout(LayoutTemplate* lt);
  
  // report break layout
  void ReportBreakLayout(LayoutInstance* li);
  
  // visible selection
  void TurnOn();
  
  // invisible selection
  void TurnOff();
  
  // setflow now 
  static bool NowSetFlow() 
  {
    return now_set_flow;
  }
  
private:
  // current edit layout-instance
  LayoutInstance* GetEditLI();
  
  // current edit layout-template
  LayoutTemplate* GetEditLT() 
  {
    return edit_lt;
  }
  
  // current edit fission-frame
  FissionFrame*   GetEditFF() 
  {
    return edit_ff;
  }
  
  // lock layout by window position
  // return	: lock layout
  LayoutInstance* LockLayout(VectW& v);
  void EditFrame::SetLockedLayout(LayoutInstance* layout);
  
  // move line lock layout
  LayoutInstance* MoveLineLockLayout(VectW& v);
  
  // lock zero page layout
  LayoutInstance* LockZeroPageLayout(LayoutInstance* regular_li);
  
  // find layout from window position
  LayoutInstance* FindLayoutW(VectW& v);
  
  // find draw fission
  Fission* FindDrawFissionW(VectW& vw);
  
  // check margin line
  bool IsMarginLine(Fission* f);
  
  // check lock layout swap for margin line
  bool IsMarginLineSwapCase(LayoutInstance* li);
  
  // find draw to fission
  Fission* FindDrawToFissionW(VectW& vw, Fission* start, Iunit pos);
  
  // find move fission
  Fission* FindMoveFissionW(VectW& vw);
  
  // find cut fission
  Fission* FindCutFissionW(VectW& vw);
  
  // check rim fission
  bool IsRimFission(Fission* f);
  
  // check margin fission
  bool IsMarginFission(Fission* f);
  
  bool GetMarginFission(Fission** top, Fission** bottom, 
                         Fission** left, Fission** right);
  
  // find fission segment
  void FindSegmentW(Fission* f, VectW& wpos, 
		     CrossPoint*& start, CrossPoint*& end);
  
  // find frame
  FrameInstance* FindFrameW(VectW& vw);
  
  // find frame-object
  FrameObject* FindFrameObjectW(VectW& vw);
  
  // find cross-point
  CrossPoint* FindCrossPointW(VectW& pnt);
  
  // find move limit
  void FindMoveLimit(Fission* f, 
                      Iunit& l_move_lim, Iunit& u_move_lim,
                      Iunit& l_lim, Iunit& u_lim);
  
  // find paragraph margin
  // return		: 
  // 0: cann't find. 1: first line margin. 2: left margin. 3: right margin
  uword FindParagraphMarginW(VectW& pnt, Paragraph** ph, 
                              FrameInstance** fi, Line** ln, 
                              Vector& from, Vector& to, Dunit& offset_x);
  
  // return True: find, False can't find
  bool NEAR FindParagraphMarginW(VectW& pnt, NavPMargin& nav_dat);
  
  // find paragraph position
  // p1		: paragraph top
  // p2		: paragraph continuation pos
  // p3		: paragraph bottom
  void FindParagraphPos(FrameInstance* fi, Paragraph* ph, 
                         Iunit& p1, Iunit& p2, Iunit& p3);
  
  // get paragraph margin
  void GetParagraphMargin(Iunit& first, Iunit& left, Iunit& right);
  
  // find buffer pointer
  BufferPointer* FindBufferPointerW(VectW& pnt);
  
  // find frame margin
  // return		: 0:can't find, 1:top, 2:bottom, 3:left, 4:right
  uword FindFrameMarginW(VectW& pos, CrossPoint* cp, Dunit& offset);
  
  // get effective frame margin
  Margin GetEffectiveFrameMargin(FrameObject* fo);
  
  // get mouse error length
  Iunit GetMouseErrorLength();
  
  // check cut able
  bool CanCut(Fission* f);
  
  // check cut able segment
  bool CanCutSegment(Fission* f, CrossPoint* start, CrossPoint* end);
  
  // scan self dependency
  // return	: False: can't cut
  bool CCS_ScanSelfDependency(Fission* scan, 
                               CrossPoint* scan_start,
                               CrossPoint* scan_end,
                               Fission* f_start, 
                               Fission* f_end);
  
  // scan sub tree fission
  // return	: True: HIT!
  static bool CCS_ScanSubTree(Fission* root, Fission* f1, Fission* f2);
  
  // clear frame-object
  bool ClearFrameObject(CrossPoint* cp);
  
  // redraw windows
  void RedrawWindows();
  
  // unforce touch caret
  void UnforceTouchCaret();
  
  // check panel num max
  bool CheckPanelNumMax();
  
  // -- posision converter
  
  Iunit WtoIx(Dunit x);
  Iunit WtoIy(Dunit y);
  Vector WtoIv(VectW& v);
  Dunit ItoWx(Iunit x);
  Dunit ItoWy(Iunit y);
  VectW ItoWv(Vector v);
  VectL WtoLv(VectW& v);
  Dunit LtoWx(Lunit x);
  Dunit LtoWy(Lunit y);
  VectW ItoWv(Vector v, LayoutInstance* li);

  // ------------------------------
  // display
public:
  // redisplay
  void Redisplay(View* view);
  
private:
  // display cut
  void RedisplayCutLine();
  void RedisplayCutLine(VDisplay* vdsp);
  void RedisplayCutLine(HDC hDC);
  
  // display draw-line object
  void RedisplayDrawLine();
  void RedisplayDrawLine(VDisplay* vdsp);
  void RedisplayDrawLine(HDC hDC);
  
  // display set-flow object
  void RedisplaySetFlow();
  void RedisplaySetFlow(VDisplay* vdsp);
  void RedisplaySetFlow(HDC hDC);
  
  // display exchange object
  void RedisplayExchange();
  void RedisplayExchange(VDisplay* vdsp);
  void RedisplayExchange(HDC hDC);
  
  // display move line
  void RedisplayMoveLine();
  void RedisplayMoveLine(VDisplay* vdsp);
  void RedisplayMoveLine(HDC hDC);
  
  // display paragraph margin set
  void RedisplayMargin();
  void RedisplayMargin(VDisplay* vdsp);
  void RedisplayMargin(HDC hDC);
  
  // display make table
  void RedisplayMakeTable();
  void RedisplayMakeTable(VDisplay* vdsp);
  void RedisplayMakeTable(HDC hDC);
  
  // display frame margin object
  void RedisplayFrameMargin();
  void RedisplayFrameMargin(VDisplay* vdsp);
  void RedisplayFrameMargin(HDC hDC);
  
  // draw temp line
  void DisplaySelectedLine(HDC hDC, VectW& from, VectW& to);
  
public:
  // ------------------------------
  // windows proc

  // cut line mode
  void WndProcCut(DocumentWindow* wd, 
		   MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // draw line mode
  void WndProcDrawLine(DocumentWindow* wd, 
			MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // move line mode
  void WndProcMoveLine(DocumentWindow* wd, 
			MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // select frame mode
  void WndProcSelectFrame(DocumentWindow* wd, 
			   MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // set flow mode
  void WndProcSetFlow(DocumentWindow* wd, 
		       MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // exchange flow mode
  void WndProcExchFlow(DocumentWindow* wd, 
			MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // set margin mode
  void WndProcSetMargin(DocumentWindow* wd, 
			 MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // make table mode
  void WndProcMakeTable(DocumentWindow* wd, 
			 MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // frame margin mode
  void WndProcFrameMargin(DocumentWindow* wd, 
			   MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
private:
  // ------------------------------
  // cut line
  void NEAR Cut_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR Cut_MV(WPARAM_T wParam, LPARAM_T lParam);
  //void NEAR Cut_LUP(WPARAM_T wParam, LPARAM_T lParam);
  
  // ------------------------------
  // draw line
  void NEAR DrawLine_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR DrawLine_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR DrawLine_LUP(WPARAM_T wParam, LPARAM_T lParam);
  
  // ------------------------------
  // move line
  void NEAR MoveAlign(Vector& pnt, VectW& mpos);
  
  //void NEAR MoveLine_Idle_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_Idle_MV(LPARAM_T lParam);
  //void NEAR MoveLine_Idle_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_SelLine_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_SelLine_MV(LPARAM_T lParam);
  void NEAR MoveLine_SelLine_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_SelSeg_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_SelSeg_MV(LPARAM_T lParam);
  void NEAR MoveLine_SelSeg_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_Move_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_Move_MV(LPARAM_T lParam);
  void NEAR MoveLine_Move_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_SegMove_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_SegMove_MV(LPARAM_T lParam);
  void NEAR MoveLine_SegMove_LUP(LPARAM_T lParam);
  
  //void NEAR MoveLine_ScaleOneDirTable_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_ScaleOneDirTable_MV(LPARAM_T lParam);
  void NEAR MoveLine_ScaleOneDirTable_LUP(LPARAM_T lParam);
  
  //void NEAR MoveLine_StretchOneDirTable_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_StretchOneDirTable_MV(LPARAM_T lParam);
  void NEAR MoveLine_StretchOneDirTable_LUP(LPARAM_T lParam);
  
  //void NEAR MoveLine_ScaleTable_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_ScaleTable_MV(LPARAM_T lParam);
  void NEAR MoveLine_ScaleTable_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_StretchTable_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_StretchTable_MV(LPARAM_T lParam);
  void NEAR MoveLine_StretchTable_LUP(LPARAM_T lParam);
  
  void NEAR MoveLine_MoveExpansion_LDWN(LPARAM_T lParam);
  void NEAR MoveLine_MoveExpansion_MV(LPARAM_T lParam);
  void NEAR MoveLine_MoveExpansion_LUP(LPARAM_T lParam);

  // ------------------------------
  // select frame
  void NEAR SelectFrame_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SelectFrame_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SelectFrame_LUP(WPARAM_T wParam, LPARAM_T lParam);

  // ------------------------------
  // set flow
  void NEAR SetFlow_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SetFlow_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SetFlow_LUP(WPARAM_T wParam, LPARAM_T lParam);
  
  // ------------------------------
  // exchange flow
  void NEAR ExchFlow_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR ExchFlow_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR ExchFlow_LUP(WPARAM_T wParam, LPARAM_T lParam);
  
  // ------------------------------
  // make table
  void NEAR MakeTable_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR MakeTable_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR MakeTable_LUP(WPARAM_T wParam, LPARAM_T lParam);

  // ------------------------------
  // set paragraph margin
  void NEAR SetMargin_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SetMargin_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR SetMargin_LUP(WPARAM_T wParam, LPARAM_T lParam);
  
  // ------------------------------
  // frame margin
  void NEAR FrameMargin_LDWN(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR FrameMargin_MV(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR FrameMargin_LUP(WPARAM_T wParam, LPARAM_T lParam);
  void NEAR FrameMargin_GetLimit(uword m, FrameObject* fo,
				  bool move_together_p,
				  Iunit& l_limit, Iunit& u_limit);
  void NEAR FrameMargin_FixLimit(uword m, Iunit l_limit, Iunit u_limit,
				  Vector& pos);
  
  // ------------------------------
  // frame selection
private:
  // check selection is rectanglar region
  bool IsRectRgnSelection();

  // clear multi frame selection infomation
  void ClearMultiFrameSelection();
  
  // add another frame region 
  void AddMultiFrameSelection(CrossPoint* from, CrossPoint* to, Vector& v);
  
  // check rectagle frame region
  void CheckRectFrameSelection();
  
  // start frame selection
  void StartFrameSelection(CrossPoint* cp, Vector& v);
  
  // end frame selection
  void EndFrameSelection();
  
  // cancel this time drag
  void CancelFrameSelectionDrag();
  
  // move frame selection
  void MoveFrameSelection(CrossPoint* cp, Vector& v);
  
  // set frame selection bit
  void SetFrameSelectionBit(CrossPoint* cp);
  
  // clear frame selection bit
  void ClearFrameSelectionBit(CrossPoint* cp);
  
  // check frame selected
  bool FrameSelectedP(CrossPoint* cp);
  
  // clear redisplay request flag
  void ClearRedisplayRequestFlag();
  void ClearRedisplayRequestFlag(FissionFrame* ff);
  
  // display select frame object
  void InvalidateFrameSelection();
  void InvalidateFrameSelection(FissionFrame* ff);

  // set frame selection bit
  void SetFrameSelectionBit();
  
  // clear frame selection bit
  void ClearFrameSelectionBit();
  
  // select caret position frames
  void SelectCaretFrames();
  
  // install frame selection
  void InstallFrameSelection(FOList& fol);

  // get selected fission-frame
  FissionFrame* GetSelectedFrameFF();
  
  // browse frame
  void BrowseFrame(FrameObject* fo);
  
  // get single frame region rim fission
  bool GetSingleFrameRegionRim(FrameRectRgn& rgn);
  bool GetSingleFrameRegionRim(HFission*& top, HFission*& bot,
				VFission*& left, VFission*& right);

  
  // check single frame region existence
  bool ExistSingleFrameRegion();
  bool ExistSingleFrameRegion(HFission*& top,
			       HFission*& bot,
			       VFission*& left,
			       VFission*& right);
  
  // get insert region
  bool GetInsertRegion(FrameRectRgn& rgn, bool insert_line);
  
  // get delete region
  bool GetDeleteRegion(FrameRectRgn& rgn, bool delete_line);
  
public:
  // check frame selection
  bool ExistFrameSelection();
  
  // check single frame selection
  bool IsSingleFrameSelection();

  // check insertable single frame selection
  bool ExistInsertableFrameSel();
  
  // check deletable single frame selection
  bool ExistDeletableFrameSel();
  
  // check clipboad copy-able frame object
  bool ExistCopyAbleFrameSelection();
  
  // check wether selected frame objects are removeable
  bool IsRemoveableFrameSelectionObject();
  
  // insert 
  void InsertFrameSelection(bool keep_size, 
			     bool post_insert,
			     bool insert_line,
			     uword copy_num);
  
  // check insert line posibility
  bool PosibleInsertLine();
  
  // check insert column posibility
  bool PosibleInsertColumn(); 
  
  // table selection check
  bool TableSelectedP();
  
  // zeropage selection check
  bool ZeroPageSelectedP();
  
  // delete single frame selection
  void DeleteFrameSelection(bool keep_size, bool remove_line);
  
  // check delete line posibility
  bool PosibleDeleteLine();
  
  // check delete column posibility
  bool PosibleDeleteColumn();
  
  // copy frame object to clipboard
  void CopyFrameSelectionToClipboard();
  
  // get frame selection border line
  void GetFrameSelectionBorderLine(uword& top, uword& bottom, 
                                    uword& left, uword& right);
  
  // set frame selection border line
  void SetFrameSelectionBorderLine(uword top, uword bottom,
                                    uword left, uword right,
				    uword inter, TargetLine target);
  
  // split selected frame
  void SplitSelectedFrame(uword column, uword row);
  
  // clear all frame selection infomation
  void ClearFrameSelection();
  
  // get multi frame selection list
  // you can get multi selected frames as cross-points list. 
  CPList* GetMultiFrameSelection() 
  {
    return frames;
  }
  
  // combine selected frame
  void CombineFrame(bool combine_vertical, bool combine_horizontal);
  
  // check combine frame
  bool CanCombineFrame();
  
  // align frame
  void AlignFrame(bool align_vertical, bool align_horizontal);
  
  // check align frame
  bool CanAlignFrame();
  
  // -- line selection management
public:
  // check line selection existence
  bool ExistLineSelection();
  
  // get selection border line
  uword GetLineSelectionBorderLine();
  
  // set border line
  void SetLineSelectionBorderLine(uword new_index);
  
  // check selection
  bool HasSelection()
  {
    return ExistFrameSelection() || ExistLineSelection();
  }
  
private:
  // in itialize line selection(call FissionList constructor)
  void InitLineSelection();
  
  // destory multi line selection(call FissionList destructor)
  void EndLineSelection();
  
  // invalidate selected line
  void InvalidateLineSelection();
  void InvalidateLineSelection(LineSelection* ls);

  // add line selection
  // f			: fission
  // s			: start position, if 0 it meens fission start position.
  // e			: end position, if 0 it meens fission end position.
  // return		: generated line-selection
  LineSelection* AddLineSelection(Fission* f, 
				   CrossPoint* s = 0, CrossPoint* e = 0);
  
  // delete line selection
  // ls		: delete line-selection
  void DeleteLineSelection(LineSelection* ls);
  
  // delete line selection
  // f			: delete fission
  void DeleteLineSelection(Fission* f);
  
  // clear line selection
  // delete all selection
  void ClearLineSelection();
  
  // clear line selection
  // delete layout-template's selection
  // don't invalidate
  void ClearLineSelection(LayoutTemplate* lt);
  
  // find selection line
  LineSelection* FindLineSelection(Fission* f);
  LineSelection* FindLineSelection(Fission* f, 
                                    CrossPoint* st, CrossPoint* ed);
  
  // invisible line selection
  void InvisibleLineSelection();
  
  // visible line selection
  void VisibleLineSelection();
  
  // ------------------------------
  // internal util.
private:
  // set document dirty flag
  void SetDirty();
  
  // ------------------------------
  // display move position
private:
  // clear position
  void ClearPosition();
  
  // table size
  void ShowTableSize(Vector& from, Vector& to);
  
  // show draw line position
  void ShowDrawLinePos(Fission* f, VectW& pos);
  
  // show move line position
  void ShowMoveLinePos();
  void ShowMoveLinePos(Fission* move, Iunit pos, Iunit l_lim, Iunit u_lim);
  
  // show move frame line position
  void ShowMoveFrameLinePos(Vector& pos, uword m_num = 0, CrossPoint* cp = 0);
  
  // show move paragraph margin position
  void ShowMoveParagraphMarginPos(Vector& pos);
  
  // show change table size
  void ShowResizeTableSize();
  void ShowResizeTableSize(Iunit pos);
  void ShowResizeTableSize(Vector pos);
  
  // set brab cursor
  static void SetGrabCursor(Fission* f);
  void SetGrabCursor(Fission* f, VectW& wpos);
  
  // ------------------------------
  // mouse offset management
private:
  // set mouse offset
  void SetMouseXOffset(int x) 
  {
    mouse_offset.x = x; 
  }
  
  void SetMouseYOffset(int y) 
  {
    mouse_offset.y = y; 
  }
  
  void ClearMouseOffset() 
  {
    mouse_offset.x = mouse_offset.y = 0; 
  }
  
  // adapt offset
  void AdaptOffset(VectW& v);
  
  // effective
  void SetEffective()   
  {
    effective = True; 
  }
  
  void ClearEffective() 
  {
    effective = False; 
  }
  
  bool IsEffective() 
  { 
    return effective; 
  }
  
  // -- cancel
  void CancelCut(bool = False);
  void CancelDrawLine(bool beep = True);
  void CancelMoveLine(bool beep = True);
  void CancelSelectFrame(bool beep = True, bool mouse_ctrl = True);
  void CancelSetFlow(bool beep = True);
  void CancelExchFlow(bool beep = True);
  void CancelMargin(bool beep = True);
  void CancelMakeTable(bool beep = True);
  void CancelFrameMargin(bool beep = True);
  
private:
  // cancel edit
  void Cancel();
};

#endif /* EDITFRAME_H */
