// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: editpage.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// EditPage class
// class for page edit menu functions

#ifndef EDITPAGE_H
#define EDITPAGE_H

#ifndef VECTOR_RECT_DEFINED
class Vector;
#endif

#include "attribut.h"
#include "pagesize.h"

// page editor
class EditPage 
{
  // which Document
  Document* doc;
  
  // current page map
  PageMap* c_pm;
  
  // current layout-instance
  LayoutInstance* c_li;

public:
  EditPage(Document* doc);
  ~EditPage();
  
  Document *get_document()
  { 
    return(this->doc); 
  }
  
private:
  // set current page-map and layout-instance
  void NEAR SetCurrent();
  
  // redraw windows
  void NEAR RedrawWindows();
  
  // invalidate to
  void NEAR InvalidateToEnd(PageMap* pm);
  
  // set document dirty flag
  void NEAR SetDirty();
  
  // vanish page map
  // return		: update need page-map
  PageMap* NEAR VanishPageMap(PageMap* pm);
  
  // set zero-mapped-layout
  void NEAR SetZeroMappedLayout(LayoutInstance* li);

  // ------------------------------
  // layout menu interface
private:
  // replace layout
  // l_num		: replace layout-template number
  void NEAR ReplaceLayout(uword l_num);
  void NEAR ReplaceLayout();
  
  // replace 1 page
  // l_num		: replace layout-template number(0 ~)
  void NEAR Replace1Page(uword l_num);
  
  // new section
  void NEAR NewSection(bool prev_ins_flag);
  void NEAR NewSection();
  
  // rename layout
  void NEAR RenameLayout();

  // open page
  void NEAR OpenPage();
  
  // check open page usable
  bool NEAR CanOpenPage();
  
  // close page
  void NEAR ClosePage();
  
  // check close page usable
  bool NEAR CanClosePage();
  
  // set first page
  void NEAR SetFirstPage();
  
  void NEAR InteractiveSizeChanged();

  // change page size
  void NEAR ChangePageSize(PageSize::Kind kind, PageSize::Orientation orn);
  void NEAR ChangePageSize();
  
  // header setting
  void NEAR HeaderSetting();
  
#if 0
  // check layout sub menu
  long NEAR CheckLayoutSubMenu(uword layout_num, bool gate_size_match = True);
#endif
  
  // define new layout
  void NEAR DefineNewLayout();
  void NEAR DefineNewLayout(char* name);
  
  // gray check
  long NEAR GetLayoutMenuState(int command);
  
public:
  // layout menu dispatch
#ifdef BW3_DISPATCH
  LRESULT_T DispatchLayoutMenu(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long DispatchLayoutMenu(int command, long lParam);
#endif /* BW3_DISPATCH */

  // ------------------------------
  // frame menu interface
private:
  // get edit-frame
  EditFrame* NEAR GetEditFrame();
  
  // check removeable frame and display message
  // return : False : can't remove 
  bool NEAR CheckRemoveableFrame();
  
  // make table
  bool NEAR CanMakeTable();
  void NEAR MakeTable();
  
  // set frame margin 
  bool NEAR CanSetFrameMargin();
  void NEAR SetFrameMargin();
  
  // get frame aling menus state
  long NEAR GetFrameAlignMenuState(enum VerticalAlignment align);
  
  // frame align
  void NEAR handle_frame_align(enum VerticalAlignment align);
  
  // border line
  bool NEAR CheckSelectedFrameBorder();
  void NEAR SetSelectedBorderLine();
  void NEAR SetDefaultFrameBorderLine();
  void NEAR SetDefaultTableFrameBorderLine();

  // clip board
  bool NEAR CanCut();
  void NEAR Cut();
  bool NEAR CanCopy();
  void NEAR Copy();
  bool NEAR CanPaste();
  void NEAR Paste();
  
public:
  void PasteMetafile(HANDLE h);
  void PasteDib(HANDLE h);
  void PasteBitmap(HANDLE h);
  
private:
  // new flow
  bool NEAR CanNewFlow();
  void NEAR NewFlow();
  
  // fill frame
  bool NEAR CanFillFrame();
  void NEAR FillFrame();
  
  // read file
  bool NEAR CanReadFile();
  void NEAR ReadFile();
  
  // insert
  bool NEAR CanInsertFrame();
  void NEAR InsertFrame();

  // delete
  bool NEAR CanRemoveFrame();
  void NEAR RemoveFrame();

  // divide
  bool NEAR CanSplitFrame();
  void NEAR SplitFrame();
  
  // combine
  bool NEAR CanCombineFrame();
  void NEAR CombineFrame();
  
  // align
  bool NEAR CanAlignFrame();
  void NEAR AlignFrame();
  
  // frame menu check
  long NEAR GetFrameMenuState(int command);
  
public:
  // frame menu dispatch
#ifdef BW3_DISPATCH
  LRESULT_T DispatchFrameMenu(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long DispatchFrameMenu(int command, long lParam);
#endif /* BW3_DISPATCH */
};

#endif /* EDITPAGE_H */
