// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: epa.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// handle paragraph attribute-related messages to document
// This processing is implemented as the EditParAtts class.  An
// instance is present in DocumentEdit.

#include "pword.h"
#include "pmenus.h"
#include "attribut.h"
#include "atts.h"
#include "derivs.h"
#include "defstyle.h"
#include "dlg.h"
#include "border.h"
#include "document.h"
#include "docwindo.h"
#include "docedit.h"
#include "docsel.h"
#include "docconte.h"
#include "pundo.h"
#include "eca.h"
#include "mcursor.h"
#include "again.h"
#include "pwordbas.h"
#include "interval.h"
#include "bufnew.h"
#include "intlist.h"
#include "xstr.h"
#include "epa.h"

attr EditParAtts::clipboard = 0;

// ------------------------------------------------------------
// Functions to carry out various attribute assignments
// peculiar to paragraph attributes
// called from the Dispatch'er

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Border(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Border(long lParam)
#endif /* BW3_DISPATCH */
{
  do // dummy loop
  {
#ifdef BW3_DISPATCH
    if (menu_state_p)
#else /* BW3_DISPATCH */
    IF_MENU_STATE
#endif /* BW3_DISPATCH */
    {
      break; // no menu item graying
    }
    unsigned int cur_border = GetAttValue(PA_lines);
    unsigned int val = 0;
    if (Again::GetDoingAgain())
    {
      val = Again::GetOtherInfo();
    }
    else
    {
      ParBorderDialog dlg(cur_border);
      if (!dlg.Go()) 
      {
	Again::CantDoAgain();
	break;
      }
      else
      {
	val = dlg.GetValue();
	Again::SetOtherInfo(val);
      }
    }
    Apply(AttMan::_SetOne, PA_lines, val,
	   (PUndo::UndoDesc) (PUndo::UD_FirstParAtt+PA_lines));
  } while (0);
  return(0);
}

// Underline -- called when user chooses "Underline" from
// Style submenu.  This item is checked when there is any
// kind of underline present; choosing it then turns off underlining.
// Choosing it in the absence of an underline turns on a default
// single underline.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::SimpleBorder(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::SimpleBorder(long lParam)
#endif /* BW3_DISPATCH */ 
{
  int cur_border = GetAttValue(PA_lines);
  int present = BorderLine::Present(cur_border);
#ifdef BW3_DISPATCH
  if (menu_state_p)
#else /* BW3_DISPATCH */
  IF_MENU_STATE
#endif /* BW3_DISPATCH */
  {
    int ret = 0;
    ret |= MF_ENABLED;
    if (present) {
      ret |= MF_CHECKED;
    }
    return ret;
  }
  
  int new_val = 0;
  if (!present) {
    new_val = BorderLine::GetDefaultParagraphIndex();
  }
  Apply(AttMan::_SetOne, PA_lines, new_val, 
	 (PUndo::UndoDesc) (PUndo::UD_FirstParAtt+PA_lines));
  
  return 0;
}

// paragraph character attributes are confusing and a possibly
// useless feature at that, given rise to by the pWord over-design
// where there are separate styles for characters and paragraphs.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::ParCharStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::ParCharStyle(long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
#else /* BW3_DISPATCH */
  MENU_STATE_ENABLED
#endif /* BW3_DISPATCH */  

  DocumentEdit* editor = GetEditor();
  
  attr par_char_atts = editor->GetEditCharAtts()->GetCommonAtts();
  if (par_char_atts==0) 
  {
    BitchAboutConflictingAtts();
    return 0;
  }
  
  IntervalList* il = editor->GetSelection();
  
  // we are going to do this outselves
  editor->WillEdit();
  
  Interval* head = il->GetHead();
  if (!head) return 0;
  PUndo* undo = head->GetDocumentContent()->GetUndo();
  
  undo->StartAtom(il, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt+PA_charatt));  
  for (Interval* i = head; i != NULL; i = i->GetNext())
  {
    undo->Register(i, PUndo::UF_ParAtt);
    i->ApplyParAtt(_SetOne, PA_charatt, par_char_atts);
  }
  
  // now to change characters themselves
  IntervalList* cil = il->AllChars();
  
  for (i = cil->GetHead(); i != NULL; i = i->GetNext())
  {
    undo->Register(i, PUndo::UF_CharAtt);
    i->ApplyCharAtt(_SetDirect, 0, par_char_atts);
  }
  
  undo->EndAtom(il);
  
  delete cil;
  editor->DidEdit();
  return 0;
}


#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Margin(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Margin(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  GetAttValue(PA_tabsize);
  Iunit old_first = GetAttValue(PA_firstleftmargin);
  Iunit old_second = GetAttValue(PA_secondleftmargin);
  Iunit old_right = GetAttValue(PA_rightmargin);
  IndentDialog dialog(old_first, old_second, old_right);
  if (dialog.Go())
  {
    Iunit first = dialog.GetL1Indent();
    Iunit second = dialog.GetL2Indent();
    Iunit right = dialog.GetRIndent();
    Again::SetAgain(IDM_Para_ChangeIndent);
    Again::SetOtherInfo(True, 0);
    Again::SetOtherInfo(first, 1);
    Again::SetOtherInfo(True, 2);
    Again::SetOtherInfo(second, 3);
    Again::SetOtherInfo(True, 4);
    Again::SetOtherInfo(right, 5);
    ChangeIndent(True, first, True, second, True, right);
  }
  return 0;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Tab(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Tab(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
  
  int old_size = GetAttValue(PA_tabsize);
  int size = 0;
  
  if (Again::GetDoingAgain())
  {
    size = Again::GetOtherInfo();
  }
  else
  {
    NumberDialog dialog("Tab", 10, 1000, iu_to_mm0(old_size));
    dialog.set_mm0_mode(True);
    if (!dialog.Go())
    {
      Again::CantDoAgain();
    }
    else
    {
      size = mm0_to_iu(dialog.get_value());
      Again::SetOtherInfo(size);
    }
  }
  
  if (size != 0)
  {
    Apply(AttMan::_SetOne,
	   PA_tabsize,
	   size, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt + PA_tabsize));
  }
  return(0);
}

#define MIN_SPACING 0
#define MAX_SPACING 1000

// private method
void NEAR
EditParAtts::set_line_spacing(int mm0, int do_message)
{
  int value = mm0_to_iu(mm0);
  if (do_message)
  {
    char* s = mm0_to_string(mm0);
    ::StatusOut(S_LineSpacing, s);
    delete s;
  }
  Apply(AttMan::_SetOne,
	 PA_linespace,
	 value, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt + PA_linespace));
}

// This method handles IDM_Para_LineSpacing_Inc and IDM_Para_LineSpacing_Dec
// commands.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::LineSpacing_Inc_Dec(bool menu_state_p, int delta, int other_command)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::LineSpacing_Inc_Dec(int menu_state_p,
				 int delta, int other_command)
#endif /* BW3_DISPATCH */
{
  int old_mm0 = iu_to_mm0(GetAttValue(PA_linespace));
  int new_mm0 = old_mm0 + delta;
  SET_MAX(new_mm0, MIN_SPACING);
  SET_MIN(new_mm0, MAX_SPACING);
  if (menu_state_p)
  {
    return(new_mm0 == old_mm0 ? MF_GRAYED : MF_ENABLED);
  }
  if (new_mm0 == old_mm0)
  {
    MessageBeep(0);
  }
  else
  {
    set_line_spacing(new_mm0, True);
    Again::ToDoAgainInOtherDirection(other_command);
  }
  return(0);
}

// LineSpacing -- handle IDM_Para_LineSpacing
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::LineSpacing(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::LineSpacing(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
  if (!dispatch_inc_dec(IDM_Para_LineSpacing_Inc, IDM_Para_LineSpacing_Dec))
  {
    int mm0 = iu_to_mm0(GetAttValue(PA_linespace));
    int do_message = False;
    if (Again::GetDoingAgain())
    {
      mm0 = Again::GetOtherInfo();
    }
    else
    {
      do_message = True;
      NumberDialog dialog("LineDistDlg", MIN_SPACING, MAX_SPACING, mm0);
      dialog.set_mm0_mode(True);
      if (!dialog.Go())
      {
	Again::CantDoAgain();
	return(0);
      }
      mm0 = dialog.get_value();
      Again::SetOtherInfo(mm0);
    }
    set_line_spacing(mm0, do_message);
  }
  return(0);
}

// private method
void NEAR
EditParAtts::set_spacing(int mm0, int do_message)
{
  int value = mm0_to_iu(mm0);
  if (do_message)
  {
    char* s = mm0_to_string(mm0);
    ::StatusOut(S_ParSpacing, s);
    delete s;
  }
  Apply(AttMan::_SetOne,
	 PA_parspace,
	 value, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt + PA_parspace));
}

// This method handles IDM_Para_Spacing_Inc and IDM_Para_Spacing_Dec
// commands.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Spacing_Inc_Dec(bool menu_state_p, int delta, int other_command)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Spacing_Inc_Dec(int menu_state_p, int delta, int other_command)
#endif /* BW3_DISPATCH */
{
  int old_mm0 = iu_to_mm0(GetAttValue(PA_parspace));
  int new_mm0 = old_mm0 + delta;
  SET_MAX(new_mm0, MIN_SPACING);
  SET_MIN(new_mm0, MAX_SPACING);
  if (menu_state_p)
  {
    return(new_mm0 == old_mm0 ? MF_GRAYED : MF_ENABLED);
  }
  if (new_mm0 == old_mm0)
  {
    MessageBeep(0);
  }
  else
  {
    set_spacing(new_mm0, True);
    Again::ToDoAgainInOtherDirection(other_command);
  }
  return(0);
}

// Spacing -- handle IDM_Para_Spacing
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Spacing(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Spacing(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
  if (!dispatch_inc_dec(IDM_Para_Spacing_Inc, IDM_Para_Spacing_Dec))
  {
    int mm0 = iu_to_mm0(GetAttValue(PA_parspace));
    int do_message = False;
    if (Again::GetDoingAgain())
    {
      mm0 = Again::GetOtherInfo();
    }
    else
    {
      do_message = True;
      NumberDialog dialog("ParaDistDlg", MIN_SPACING, MAX_SPACING, mm0);
      dialog.set_mm0_mode(True);
      if (!dialog.Go())
      {
	Again::CantDoAgain();
	return(0);
      }
      mm0 = dialog.get_value();
      Again::SetOtherInfo(mm0);
    }
    set_spacing(mm0, do_message);
  }
  return(0);
}

// This method handles IDM_Para_Style_Search command.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::Style_Search(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Style_Search(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  return(this
	  ->GetEditor()
	  ->Style_Search(menu_state_p,
			 Menu_Type_PARA_STYLE, S_search_para_style_title));
}

// Dispatch dispatches a menu selection relating to paragraph attributes.
// It is called from Dispatch in docedit.cpp
#ifdef BW3_DISPATCH
LRESULT_T
EditParAtts::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
EditParAtts::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  bool menu_state_p = MENU_STATE_P(notify_code);
#else /* BW3_DISPATCH */
  int menu_state_p = MENU_STATE_P(lParam);
#endif /* BW3_DISPATCH */
  switch (command)
  {
#ifndef NDEBUG
   case IDM_Para_Test_2:
    ::AttStatusOut(GetCurrentAtts());
    return(0);
#endif
    
   case IDM_Para_Spacing:
    return(Spacing(menu_state_p));
    
   case IDM_Para_Spacing_Inc:  
    return(Spacing_Inc_Dec(menu_state_p, 1, IDM_Para_Spacing_Dec));
    
   case IDM_Para_Spacing_Dec:
    return(Spacing_Inc_Dec(menu_state_p, -1, IDM_Para_Spacing_Inc));
    
   case IDM_Para_LineSpacing:
    return(LineSpacing(menu_state_p));
    
   case IDM_Para_LineSpacing_Inc:  
    return(LineSpacing_Inc_Dec(menu_state_p, 1, IDM_Para_LineSpacing_Dec));
    
   case IDM_Para_LineSpacing_Dec:
    return(LineSpacing_Inc_Dec(menu_state_p, -1, IDM_Para_LineSpacing_Inc));
    
   case IDM_Para_Margin:
    return(Margin(menu_state_p));
    
   case IDM_Para_Tab:
    return(Tab(menu_state_p));
    
   case IDM_Para_Style_Search:
    return(Style_Search(menu_state_p));
    
    // ------------------------------
    // BW2_KONNO_NOT_IMPLEMENTED
    
   case IDM_Para_DontChopInTwo:
#ifdef BW3_DISPATCH
    return Toggle(menu_state_p, PA_nobreak);
#else /* BW3_DISPATCH */
    return /*AttMan::*/Toggle(lParam, PA_nobreak);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_PlaceOnNormal:
    return(specific_value(menu_state_p, PA_placement, PL_none));
    
   case IDM_Para_PlaceOnFrame:
    return(specific_value(menu_state_p, PA_placement, PL_frame));
    
   case IDM_Para_PlaceOnPage:
    return(specific_value(menu_state_p, PA_placement, PL_page));
    
   case IDM_Para_Border:
#ifdef BW3_DISPATCH
    return Border(menu_state_p);
#else /* BW3_DISPATCH */
    return Border(lParam);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_SimpleBorder:
#ifdef BW3_DISPATCH
    return SimpleBorder(menu_state_p);
#else /* BW3_DISPATCH */
    return SimpleBorder(lParam);
#endif /* BW3_DISPATCH */    

   case IDM_Para_AlignLeft:
    return specific_value(menu_state_p, PA_alignment, AL_leftaligned);
    
   case IDM_Para_AlignCenter:
    return specific_value(menu_state_p, PA_alignment, AL_centered); 
    
   case IDM_Para_AlignRight:
    return specific_value(menu_state_p, PA_alignment, AL_rightaligned);
    
   case IDM_Para_AlignEquality:
    return specific_value(menu_state_p, PA_alignment, AL_flushright);
    
   case IDM_Para_AlignStretched:
    return specific_value(menu_state_p, PA_alignment, AL_stretched);
    
   case IDM_Para_Style_Define:
#ifdef BW3_DISPATCH
    return DefineStyle(menu_state_p);
#else /* BW3_DISPATCH */
    return DefineStyle(lParam);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_Style_Redefine:
#ifdef BW3_DISPATCH
    return RedefineStyle(menu_state_p);
#else /* BW3_DISPATCH */
    return RedefineStyle(lParam);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_CopyAttr:
    return this->CopyAttr(menu_state_p);
    
   case IDM_Para_PasteAttr:
    return this->PasteAttr(menu_state_p);
    
   case IDM_Para_CharStyle:
#ifdef BW3_DISPATCH
    return this->ParCharStyle(menu_state_p);
#else /* BW3_DISPATCH */
    return this->ParCharStyle(lParam);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_Style_Pure:
#ifdef BW3_DISPATCH
    return SetPureStyle(menu_state_p);
#else /* BW3_DISPATCH */
    return SetPureStyle(lParam);
#endif /* BW3_DISPATCH */
    
   case IDM_Para_ChangeIndent:
    assert(Again::GetDoingAgain());
    this->ChangeIndent(Again::GetOtherInfo(0) != 0,
		       Again::GetOtherInfo(1),
		       Again::GetOtherInfo(2) != 0,
		       Again::GetOtherInfo(3),
		       Again::GetOtherInfo(4) != 0,
		       Again::GetOtherInfo(5));
    return 0;
    
#ifndef NDEBUG
#ifdef BW2_VERBOSE
   default:
    syserr("unknown msg 0x%x in epa", command);
    break;
#endif
#endif
  }
  return(0);
}

// MEMO(konno)
// Following code is a old paragraph style handler.
// Including search style.
//
//      if (command >= IDM_FirstParaStyle && command <= IDM_LastParaStyle)
//      {
//	uword style = command-IDM_FirstParaStyle;
//
//#ifndef NO_HIDDEN_FEATURES
//	IF_MENU_STATE ;
//	else if (PWordPresentation::ControlKey())
//	{
//	  DocumentEdit *editor = GetEditor();
//	  IntervalList *il = editor->GetDocument()->FindStyle(style);
//	  if (il != NULL)
//	  {
//	    editor->GetSelectionStack()->InstallSelection(il);
//	  }
//	  else
//	  {
//	    MessageBeep(0);
//	  }
//	  return 0;
//	}
//#endif
//
//	return SetStyle(lParam, style);
//      }

// ------------------------------------------------------------
// Virtual functions on AttMan which EditParAtts
// needs to customize

// private method
int NEAR
EditParAtts::GetNewStyleName(char* buf, int& existing)
{
  char* suggestion = GetSelection()->GetHead()->GetHint();
  DefParaStyleDialog dlg(suggestion);
  int ret = dlg.Go();
  if (ret) 
  {
    strcpy(buf, dlg.GetStyleName());
    existing = dlg.GetExistingStyle();
  }
  delete suggestion;
  return ret;
}


attr
EditParAtts::GetCurrentAtts()
{
  Interval* h=GetSelection()->GetHead();
  if (!h) return 0;
  return h->GetLeft()->GetParagraph()->GetAtts();
}

// private method
attr NEAR
EditParAtts::GetCommonAtts()
{
  BaseIntervalListTraversor ilt(GetSelection());
  attr common_atts = 0;
  
  Interval* i;
  
  while ((i= (Interval*)ilt.GetNext()) != 0)
  {  
    Paragraph* lp = i->GetLeft()->GetParagraph();
    Paragraph* rp = i->GetRight()->GetParagraph();
    for (Paragraph* p = lp;; p = p->GetNextParagraph())
    {
      if (common_atts == 0) 
      {
	common_atts = p->GetAtts();
      }
      else if (p->GetAtts() != common_atts)
      {
	return 0;
      }
      if (p == rp)
      {
	break;
      }
    }
  }
  return common_atts;
}

// private method
void NEAR
EditParAtts::Apply
(
 attr(*func) (attr, int, int),
 int attcode, int attvalue,
 PUndo::UndoDesc desc
)
{
  THIS_CHECK;
  
  DocumentEdit* editor = GetEditor();
  editor->WillEdit();
  
  IntervalList* il = editor->GetSelection();
  
  Interval* head = il->GetHead();
  if (!head) return;
  PUndo* undo = head->GetDocumentContent()->GetUndo();
  undo->StartAtom(il, desc);
  
  BaseIntervalListTraversor ilt(il);
  Interval* i;
  while ((i= (Interval*)ilt.GetNext()) != 0)
  {
    undo->Register(i, PUndo::UF_ParAtt);
    i->ApplyParAtt(func, attcode, attvalue);
  }
  undo->EndAtom(il);
  editor->DidEdit();
}

void
EditParAtts::MakeIndentAttList(AttSpecList* attlist,
			       bool change_left1, Iunit left1, 
			       bool change_left2, Iunit left2,
			       bool change_right, Iunit right)
{
  int j = 0;
  
  if (change_left1)
  {
    attlist[j].attcode = PA_firstleftmargin;
    attlist[j++].attvalue = left1;
  }
  if (change_left2)
  {
    attlist[j].attcode = PA_secondleftmargin;
    attlist[j++].attvalue = left2;
  }
  if (change_right)
  {
    attlist[j].attcode = PA_rightmargin;
    attlist[j++].attvalue = right;
  }
  attlist[j].attcode = 0;
}

// Change indent, applying to current interval list
void
EditParAtts::ChangeIndent(bool change_left1, Iunit left1, 
			  bool change_left2, Iunit left2,
			  bool change_right, Iunit right)
{
  THIS_CHECK;
  
  AttSpecList attlist [4];
  this->MakeIndentAttList(attlist,
			   change_left1, left1,
			   change_left2, left2,
			   change_right, right);
  
  DocumentEdit* editor = GetEditor();
  
  IntervalList* il = editor->GetSelection();
  editor->WillEdit();
  Interval* head = il->GetHead();
  PUndo* undo = head->GetDocumentContent()->GetUndo();
  undo->StartAtom(il, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt+PA_firstleftmargin));
  
  for (Interval* i=head; i != NULL; i = i->GetNext())
  {
    undo->Register(i, PUndo::UF_ParAtt);
    i->ApplyParAtt(attlist);
  }
  undo->EndAtom(il);
  editor->DidEdit();
}

// change paragraph margin.  Called by frame editor
void
EditParAtts::ChangeIndent(Paragraph* p, 
			  bool change_left1, Iunit left1, 
			  bool change_left2, Iunit left2,
			  bool change_right, Iunit right)
{
  Again::SetAgain(IDM_Para_ChangeIndent);
  Again::SetOtherInfo(change_left1, 0);
  Again::SetOtherInfo(left1, 1);
  Again::SetOtherInfo(change_left2, 2);
  Again::SetOtherInfo(left2, 3);
  Again::SetOtherInfo(change_right, 4);
  Again::SetOtherInfo(right, 5);
  
  AttSpecList attlist [4];
  this->MakeIndentAttList(attlist,
			   change_left1, left1,
			   change_left2, left2,
			   change_right, right);
  
  DocumentEdit* editor = GetEditor();
  
  editor->WillEdit();
  {
    Interval* head = new Interval(p);
    PUndo* undo = editor->GetDocumentContent()->GetUndo();
    IntervalList* cur = editor->GetSelection();
    
    undo->StartAtom(cur, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt+PA_firstleftmargin));
    {
      undo->Register(head, PUndo::UF_ParAtt);
      attr a = p->GetAtts();
      p->SetAtts(ApplyAttList(a, attlist));
    }
    undo->EndAtom(cur);
    delete head;
  }
  editor->DidEditNoCaret();
}


// ------------------------------------------------------------
// Top-level routines invoked from the dispatcher
#ifdef BW3_DISPATCH
LRESULT_T
EditParAtts::set_style(bool menu_state_p, int style)
#else /* BW3_DISPATCH */
long
EditParAtts::set_style(int menu_state_p, int style)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return(GetBaseStyle(GetCurrentAtts()) == style
	    ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  
  DocumentEdit* editor = GetEditor();
  editor->WillEdit();
  
  IntervalList* il = editor->GetSelection();
  
  Interval* head = il->GetHead();
  assert(head != NULL);
  PUndo* undo = head->GetDocumentContent()->GetUndo();
  undo->StartAtom(il, PUndo::UD_ParaStyleApply);
  
  BaseIntervalListTraversor ilt(il);
  Interval* i;
  while ((i= (Interval*)ilt.GetNext()) != 0)
  {
    undo->Register(i, PUndo::UF_ParAtt);
    i->ApplyParAtt(EditParAtts::_SetStyle, 0, style);
    Interval* ii = i->IncludeAllChars();
    if (style != 0)
    {
      word par_char_atts = GetStyleAttValue(style, PA_charatt);
      if ((par_char_atts != 0) && (par_char_atts != AttsEntry::UNKNOWN))
      {
	undo->Register(ii, PUndo::UF_CharAtt);
	ii->ApplyCharAtt(AttMan::_SetDirect, 0, par_char_atts);
	i->SetAtts(par_char_atts);  // set character style for this par user style at insertion point as well
      }
    }
    delete ii;
  }
  undo->EndAtom(il);
  editor->DidEdit();
  
  return 0;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::SetPureStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::SetPureStyle(long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
#else /* BW3_DISPATCH */
  MENU_STATE_ENABLED
#endif /* BW3_DISPATCH */ 
  Apply(EditParAtts::_SetPureStyle, 0, 0, PUndo::UD_PureParaStyle);
  return 0;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR 
EditParAtts::Toggle(bool menu_state_p, int attcode)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::Toggle(long lParam, int attcode)
#endif /* BW3_DISPATCH */  
{
  int cur = GetAttValue(attcode);
#ifdef BW3_DISPATCH
  if (menu_state_p)
#else /* BW3_DISPATCH */
  IF_MENU_STATE
#endif /* BW3_DISPATCH */
  {
    return MF_ENABLED | (cur ? MF_CHECKED : 0);
  }
  
  Apply(EditParAtts::_SetOne, attcode, !cur, 
	(PUndo::UndoDesc) (PUndo::UD_FirstParAtt+attcode));
  return 0;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::CopyAttr(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::CopyAttr(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  attr common_atts = this->GetCommonAtts();
  if (common_atts == 0)
  {
    if (menu_state_p)
    {
      return(MF_GRAYED);
    }
    this->BitchAboutConflictingAtts();
  }
  else if (!menu_state_p)
  {
    EditParAtts::clipboard = common_atts;
  }
  // MF_ENABLE == 0
  return(0);
}	

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::PasteAttr(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::PasteAttr(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (EditParAtts::clipboard == 0)
  {
    return(disabled_command(menu_state_p));
  }
  if (!menu_state_p)
  {
    Apply(EditParAtts::_SetDirect,
	   0, EditParAtts::clipboard, PUndo::UD_PasteParaStyle);
  }
  // MF_ENABLE == 0
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::DefineStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::DefineStyle(long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
#else /* BW3_DISPATCH */  
  MENU_STATE_ENABLED
#endif /* BW3_DISPATCH */
  
  attr common_atts = this->GetCommonAtts();
  if (common_atts==0) 
  {
    BitchAboutConflictingAtts();
    return 0;
  }
  
  char buf[ 128 ];
  int style; 
  if (! GetNewStyleName(buf, style)) 
  {
    return 0; // cancelled
  }
  
  IntervalList* il = this->GetSelection();
  DocumentEdit* editor = this->GetEditor();
  PUndo* undo = editor->GetDocumentContent()->GetUndo();
  
  bool redefining = style != 0;
  if (!redefining)
  {
    undo->StartAtom(il, PUndo::UD_ParaStyleDefine);
    style = ::DefineParaStyle(buf, common_atts);
    undo->Register(0, PUndo::UF_StyleDefine, style);
  }
  else
  {
    int old_par_char = GetStyleAttValue(style, PA_charatt);
    AttMan::ReportStyleRedefinition(style);
    undo->StartAtom(il, PUndo::UD_ParaStyleRedefine);
    undo->Register(0, PUndo::UF_StyleRedefine, style);
    ::RedefineParaStyle(style, common_atts);
    PWordBase::StyleChange(style);
    int new_par_char = GetStyleAttValue(style, PA_charatt);
    if (new_par_char != old_par_char)
    {
      this->ParCharAtts(style);
    }
  }
  
  editor->WillEdit();
  
  for (Interval* i = il->GetHead(); i != NULL; i = i->GetNext())
  {
    undo->Register(i, PUndo::UF_ParAtt);
    i->ApplyParAtt(_SetStyle, 0, style);
  }
  
  undo->EndAtom(il);
  
  GetEditor()->DidEdit();
  return 0;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::RedefineStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::RedefineStyle(long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
#else /* BW3_DISPATCH */
  MENU_STATE_ENABLED
#endif /* BW3_DISPATCH */
  
  attr common_atts = GetCommonAtts();
  if (common_atts==0) 
  {
    BitchAboutConflictingAtts();
    return 0;
  }
  
  int style = ::GetBaseStyle(common_atts);			
  if (!style) 
  {
    ::StatusOut(S_CantRedefineStyleNone);
    return 0;
  }
  
  // put a message out and do it
  this->ReportStyleRedefinition(style);
  MouseCursor::StartLongActivity();
  DocumentEdit* editor = this->GetEditor();
  int old_par_char = GetStyleAttValue(style, PA_charatt);
  editor->WillEdit();
  
  PUndo* undo = GetEditor()->GetDocumentContent()->GetUndo();
  IntervalList* il = GetSelection();
  
  undo->StartAtom(il, PUndo::UD_ParaStyleRedefine);
  {
    // redefine the style itself
    undo->Register(0, PUndo::UF_StyleRedefine, style);
    ::RedefineParaStyle(style, common_atts);
    PWordBase::StyleChange(style);
    
    // put the style on the selection again.  This causes underlying
    // attributes to be changed.
    for (Interval* i = il->GetHead(); i != NULL; i = i->GetNext())
    {
      undo->Register(i, PUndo::UF_ParAtt);
      i->ApplyParAtt(_SetStyle, 0, style);
    }
  }
  
  // may have to do paragraph character attribute handling
  int new_par_char = GetStyleAttValue(style, PA_charatt);
  if (new_par_char != old_par_char)
  {
    this->ParCharAtts(style);
  }
  
  undo->EndAtom(il);
  editor->DidEdit();
  MouseCursor::EndLongActivity();
  return 0;
}

// private method
void NEAR
EditParAtts::ParCharAtts(unsigned int style)
{
  DocumentContent* dc = GetEditor()->GetDocumentContent();
  Document* doc = dc->GetDocument();
  IntervalList* cil = doc->FindStyle(style);
  
  if (cil)
  {
    PUndo* undo = dc->GetUndo();
    BaseIntervalListTraversor ilt(cil);
    Interval* ci;
    while ((ci= (Interval*)ilt.GetNext()) != NULL)
    {
      undo->Register(ci, PUndo::UF_CharAtt);
      ci->SetParCharAtts();
    }
    delete cil;
  }
  
  // and register for all other documents but this one,
  // as a separate undoable item
  for (Document* d = PWordBase::GetFirstDocument();
       d != NULL;
       d = d->GetNextDocument())
  {
    if (doc != d)
    {
      d->ParCharAtts(style);
    }
  }
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditParAtts::specific_value(bool menu_state_p, int attcode, int attvalue)
#else /* BW3_DISPATCH */
long NEAR
EditParAtts::specific_value(int menu_state_p, int attcode, int attvalue)
#endif /* BW3_DISPATCH */
{
  int cur = GetAttValue(attcode);
  if (menu_state_p)
  {
    return(cur == attvalue ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  Apply(EditParAtts::_SetOne,
	 attcode,
	 attvalue, (PUndo::UndoDesc) (PUndo::UD_FirstParAtt + attcode));
  return(0L);
}

char* 
EditParAtts::GetRedefinitionMessageString()
{
  return S_RedefineParaStyleMsg; 
}
