// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: epa.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// class EditParAtts

#ifndef EPA_H
#define EPA_H

#include "attman.h"
#include "attribut.h"
#include "pmenus.h"

class EditParAtts
  : public AttMan
{
  static attr clipboard;

public:
  EditParAtts(DocumentEdit* de)
  : AttMan(de)
  {
  }
  
private:
  attr GetCurrentAtts();
  char* GetRedefinitionMessageString();

private:
  attr NEAR GetCommonAtts();
  int NEAR GetNewStyleName(char* , int& existing);
#ifdef BW3_DISPATCH
  LRESULT_T NEAR Border(bool menu_state_p);
  LRESULT_T NEAR SimpleBorder(bool menu_state_p);
  LRESULT_T NEAR Toggle(bool menu_state_p, int attcode);
  LRESULT_T NEAR DefineStyle(bool menu_state_p);
  LRESULT_T NEAR ParCharStyle(bool menu_state_p);
  LRESULT_T NEAR SetPureStyle(bool menu_state_p);
  LRESULT_T NEAR RedefineStyle(bool menu_state_p);

  LRESULT_T NEAR CopyAttr(bool menu_state_p);
  LRESULT_T NEAR LineSpacing(bool menu_state_p);
  LRESULT_T NEAR LineSpacing_Inc_Dec(bool menu_state_p, int delta, int other_command);
  LRESULT_T NEAR Margin(bool menu_state_p);
  LRESULT_T NEAR PasteAttr(bool menu_state_p);
  LRESULT_T NEAR Spacing(bool menu_state_p);
  LRESULT_T NEAR Spacing_Inc_Dec(bool menu_state_p, int delta, int other_command);
  LRESULT_T NEAR Style_Search(bool menu_state_p);
  LRESULT_T NEAR Tab(bool menu_state_p);
  LRESULT_T NEAR specific_value(bool menu_state_p, int attcode, int attvalue);
#else /* BW3_DISPATCH */
  long NEAR Border(long lParam);
  long NEAR DefineStyle(long lParam);
  long NEAR ParCharStyle(long lParam);
  long NEAR RedefineStyle(long lParam);
  long NEAR SetPureStyle(long lParam);
  long NEAR SimpleBorder(long lParam);
  long NEAR Toggle(long lParam, int attcode);
  long NEAR CopyAttr(int menu_state_p);
  long NEAR LineSpacing(int menu_state_p);
  long NEAR LineSpacing_Inc_Dec(int menu_state_p, int delta, int other_command);
  long NEAR Margin(int menu_state_p);
  long NEAR PasteAttr(int menu_state_p);
  long NEAR Spacing(int menu_state_p);
  long NEAR Spacing_Inc_Dec(int menu_state_p, int delta, int other_command);
  long NEAR Style_Search(int menu_state_p);
  long NEAR Tab(int menu_state_p);
  long NEAR specific_value(int menu_state_p, int attcode, int attvalue);
#endif /* BW3_DISPATCH */
  void NEAR Apply(attr(*func) (attr, int, int), int attcode, int attval, PUndo::UndoDesc);
  void NEAR ParCharAtts(unsigned int);
  void NEAR set_line_spacing(int mm0, int do_message);
  void NEAR set_spacing(int mm0, int do_message);
public:
#ifdef BW3_DISPATCH
  LRESULT_T set_style(bool menu_state_p, int style);
#else /* BW3_DISPATCH */
  long set_style(int menu_state_p, int style);
#endif /* BW3_DISPATCH */

#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long Dispatch(int command, long lParam);
#endif /* BW3_DISPATCH */
  
  // change paragraph margin
  void ChangeIndent(Paragraph* ph,
		    bool change_left1, Iunit left1,
		    bool change_left2, Iunit left2,
		    bool change_right, Iunit right);
  void ChangeIndent(bool change_left1, Iunit left1,
		    bool change_left2, Iunit left2,
		    bool change_right, Iunit right);
  void MakeIndentAttList(AttSpecList* ,
			 bool change_left1, Iunit left1,
			 bool change_left2, Iunit left2,
			 bool change_right, Iunit right);
};

#endif /* EPA_H */
