// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fileopen.cpp,v 3.7 1999/07/03 00:42:04 kudou Exp $
// Get a filename from a dialog box to open

#include "pword.h"
#include "fileopen.h"
#include "dialogs.h"
#include "memo.h"
#include "docconte.h"
#include "document.h"
#include "pmenus.h"
#include "pref.h"
#include "fileutil.h"
#include "xstr.h"
#include <string.h>

#ifdef BW3_FILEDLG

FileOpenDialog::FileOpenDialog(char* init_file_name, char* filter_str, bool _read_pic_p)
 : FileDialog(init_file_name, filter_str),
   read_pic_p(_read_pic_p)
{
}

bool
FileOpenDialog::Go(bool insert_file)
{
  insert_file_p = insert_file;
  if (read_pic_p)
  {
    SetTitleString(S_ReadPic);
  }
  else if (insert_file)
  {
    SetTitleString(S_InsertFile);
  }
  else
  {
    SetTitleString(S_OpenFile);
  }
  return FileDialog::Go(false);
}

extern "C" UINT CALLBACK
ComDlgCustFileOpenDlgProc(HWND hDlg, MSG_T uMsg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch(uMsg)
  {
  case WM_INITDIALOG:
    SetWindowLong(hDlg, DWL_USER, lParam);
    break;

  case WM_DESTROY:
    {
      LPOPENFILENAME lpOFN = (LPOPENFILENAME)GetWindowLong(hDlg, DWL_USER);
      FileOpenDialog* file_open = (FileOpenDialog*)lpOFN->lCustData;
    }
    break;

  case WM_NOTIFY:
    {
      LPOFNOTIFY pofn = (LPOFNOTIFY)lParam;
      switch (pofn->hdr.code)
      {
      case CDN_SELCHANGE:
        {
	  char current_name[MAX_PATH + 1];
	  if (CommDlg_OpenSave_GetFilePath(GetParent(hDlg),
					   current_name, sizeof(current_name))
	      <= sizeof(current_name))
	  {
	    char* p = strchr(current_name, '"');
	    if (p)
	    {
	      // Multiple File name selection
	      // ex.) C:\TEMP\"2.bw" "1.bw"
	      SetDlgItemText(hDlg, IDD_FileOpen_Memo, S_MultiSelectNote);
	    }
	    else if (FileUtil::IsWild(current_name))
	    {
	      SetDlgItemText(hDlg, IDD_FileOpen_Memo, "");
	    }
	    else if (FileUtil::FileExists(current_name))
	    {
	      Document* d = Document::MakeForMemo(current_name);
	      if (d == NULL)
	      {
		SetDlgItemText(hDlg, IDD_FileOpen_Memo, "");
		// IɃeLXgt@Cǂ𒲂ׂ,
		// ŏ̐sɏނ悤ɂB
	      }
	      else
	      {
		SetDlgItemText(hDlg, IDD_FileOpen_Memo,
			       d->GetDocumentContent()->GetMemo());
		// BeatWord version 2 code doesn't delete d! (kudou)
		delete d;
	      }
	    }
	    //else
	    //{
	    //  MessageBeep(0);
	    //}
	  }
        }
	break;
#if 0
      case CDN_FOLDERCHANGE:
      case CDN_HELP:
      case CDN_FILEOK:
#endif

      case CDN_SHAREVIOLATION:
	// received a sharing violation.
	break;
      }
    }
    break;

  default:
    return FALSE;
  }
  return TRUE;
}

void
FileOpenDialog::OpenfilenameSetupHook(OPENFILENAME& ofn)
{
  if (!(read_pic_p || insert_file_p))
  {
    // setup custom fileopen common dialog.
    ofn.lpTemplateName = "FILEOPEN";
    ofn.Flags |= OFN_EXPLORER | OFN_ENABLETEMPLATE | OFN_ENABLEHOOK;
    ofn.lpfnHook = ComDlgCustFileOpenDlgProc;
    ofn.lCustData = (LPARAM_T)this;
  }
}

#else /* BW3_FILEDLG */

int 
FileOpenDialog::Go(bool insert_file)
{
  this->insert_file = insert_file;
  return FileDialog::Go();
}

// The Select() method is where FileOpen distinguishes itself from run-of-
// the mill abstract FileDialog boxes -- it checks to see if the file
// exists right before it is going to be confirmed, beeps if it doesn't

int
FileOpenDialog::Select()
{
  if (FileUtil::FileExists(current_name))
  {
    return 1;
  }
  else
  {
    MessageBeep(0);
    return 0;
  }
}

// The FileOpenDialog WndProc does nothing at all different from the
// generic one defined on FileDialog, but it might later.

LRESULT_T
FileOpenDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      if (ReadPicP())
      {
	SetText(S_ReadPic);
      }
      else
      {
	this->SetText(insert_file ? S_InsertFile : S_OpenFile);
      }
      
      if (ReadPicP() || insert_file)
      {
	::ShowWindow(GetItem(IDD_FileOpen_Memo), SW_HIDE);
      }
      
      if (ReadPicP())
      {
	SetItemText(ID_FILE_STAR_BW, "*.bmp");
      }
      else if (insert_file)
      {
	::ShowWindow(GetItem(ID_FILE_STAR_BW), SW_HIDE);
      }	
    }
    break;

   case WM_COMMAND:
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case ID_FILENAME:
	GetItemText(ID_FILENAME, current_name, MAX_PATH);
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case CBN_DROPDOWN:
	 case CBN_SETFOCUS:
	  break;
	  
	 case CBN_SELCHANGE:
	  ::EnableWindow(GetItem(IDOK), TRUE);
	  break;
	  
	 default:
	  ::EnableWindow(GetItem(IDOK), current_name[0]);
	  break;
	}
	return 0;
       case IDD_FileOpen_Memo:
	{
	  if (FileUtil::IsWild(current_name)) {
	    MessageBeep(0);
	  }
	  else if (FileUtil::FileExists(current_name)) {
	    Document* d = Document::MakeForMemo(current_name);
	    if (d == NULL)
	    {
	      MessageBeep(0);
	    }
	    else
	    {
	      MemoNoEditDialog memo_dialog(d->GetDocumentContent()
					    ->GetMemo());
	      memo_dialog.Go();
	    }
	  }
	  else {
	    MessageBeep(0);
	  }
	}
      }
      break;
    }
   default:
    break;
  }
  return FileDialog::WndProc(Msg, wParam, lParam);
}

void 
FileOpenDialog::Init()
{
  this->class_name = "FileOpen";
  insert_file = False;
}

FileOpenDialog::FileOpenDialog(char* _initial_name, bool read_pic_p)
  : FileDialog(_initial_name, read_pic_p)
{
  this->Init();
}

FileOpenDialog::FileOpenDialog()
{
  this->Init();
}
#endif /* BW3_FILEDLG */
