// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fileutil.cpp,v 3.7 1999/07/25 13:20:19 kudou Exp $
// Utility functions for files

#include "pword.h"
#include <stdlib.h>
#include <direct.h>
#include <malloc.h>
#include <ctype.h>
#include <dos.h>
#include "sjis.h"
#include "fileutil.h"
#ifdef _WIN32
#include <io.h>
#include <fcntl.h>
#endif /* _WIN32 */

#ifndef BCC4
// bc4 has original min, max definition in <stdlib.h>
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif /* BCC4 */

// Gets the filename(or wildcard) only from a filespec.  No path is wanted.

char* 
FileUtil::GetFileNameOnly(char* FileName)
{
  char* ShortName;
  
  for (ShortName = FileName; *FileName; FileName = AnsiNext(FileName))
  {
    if (*FileName == '\\' || *FileName == '/' || *FileName == ':')
    {
      ShortName = FileName + 1;
    }
  }
  
  return(ShortName);
}


// Gets the extension only from a filespec. 

char* 
FileUtil::GetExtension(char* FileName)
{
  for (char* c = AnsiPrev(FileName, FileName+strlen(FileName));
       c > FileName; c = AnsiPrev(FileName, c))
  {
    switch (*c)
    {
     case '.':
      return c+1;
     case '/':
     case '\\':
     case ':':
      return 0;
     default:
      break;
    }
  }
  return 0;
}

// Gets the pathname only from a filespec.  No filename is wanted.  Returns a
// valid pathname which is suitable for passing to functions like chdir.
// Handles the cases where you want the directory separator at the end(C:\)
// and the cases where it is invalid(C:\C\GOOBER) and you don't want it. 

char* 
FileUtil::GetPathNameOnly(char* PathName, char* FileName)
{
  char* Last;
  
  strcpy(PathName, FileName);
  
  for (Last = PathName + strlen(PathName) - 1;
       Last >= PathName; Last = AnsiPrev(PathName, Last))
  {
    switch (*Last)
    {
     case '/':
     case '\\':   if ((Last > PathName) && (*AnsiPrev(PathName, Last) != ':'))
      {
	*Last = 0;
      }
      // fall through
     case ':':    return(PathName);
     default:     *Last = 0;
    }
  }
  
  return(PathName);
}

// Simply determines if a file exists.  Returns TRUE or FALSE.
int 
FileUtil::FileExists(char* FileName)
{
  int File;
  if ((File = _lopen(FileName, 0)) < 0) {
    return(FALSE);
  }
  _lclose(File);
  return(TRUE);
}

// Determines if a filename contains a wildcard character.

int 
FileUtil::IsWild(char* FileName)
{
  for (; *FileName; FileName=AnsiNext(FileName))
  {
    if (*FileName == '*' || *FileName == '?')  return(TRUE);
  }
  return(FALSE);
}

// Tacks a filename onto a pathname.  If the directory separator does not
// appear at the end of the pathname it's OK- I'll put one in.  This occurs
// in the awkward cases where C:\ is a valid path but C:\C\ is not.

char* 
FileUtil::ConcatPathAndFileName(char* Path, char* FileName)
{
  // if filename is absolute, return it by itself
  if (IsAbsolute(FileName))
  {
    strcpy(Path, FileName);
  }
  else
  {
    if (*Path && (*AnsiPrev(Path, Path + strlen(Path)) != '\\'))
    {
      strcat(Path, "\\");
    }
    strcat(Path, FileName);
  }
  return Path;
}

// Changes to a new drive and directory.
void 
FileUtil::ChDir(char* Dir)
{
  if (*Dir)
  {
    if (!iskanji(*Dir) && Dir[ 1 ] == ':')
    {
#ifdef __BORLANDC__
      // A: = 0, B: = 1, ...
      setdisk(toupper(*Dir) - 'A');
#else
#ifdef _WIN32
      _chdrive(toupper(*Dir) - 'A' + 1);
#else /* _WIN32 */
      unsigned int foo;
      // A: = 1, B: = 2, ...
      _dos_setdrive(toupper(*Dir) - 'A' + 1, &foo);
#endif /* _WIN32 */
#endif /* __BORLANDC__ */
      Dir += 2;
    }
    if (*Dir)
    {
      chdir(Dir);
    }
  }
}

// Gets the drive and directory name.
#ifdef __BORLANDC__
char* 
FileUtil::GetDir(char* PathName)
{
  PathName[ 0 ] = getdisk() + 'A';
  PathName[ 1 ] = ':';
  PathName[ 2 ] = '\\';
  
  getcurdir(0, PathName + 3);
  
  return(PathName);
}
#else
char* 
FileUtil::GetDir(char* PathName)
{
  _getcwd(PathName, MAX_PATH);
  return(PathName);
}
#endif

// sees if a path is absolute

bool 
FileUtil::IsAbsolute(char* PathName)
{
  if (!PathName)
  {
    return False;
  }
  if (isalpha(*PathName) && (*(PathName+1)==':'))
  {
    PathName += 2;  // skip over drive letter and colon
  }
  if ((*PathName=='\\') || (*PathName=='/'))
  {
    return True;
  }
  else return False;
}

bool 
FileUtil::IsFileName(char* PathName)
{
  if (isalpha(*PathName) && (*(PathName+1)==':'))
  {
    return False;
  }
  if (IsWild(PathName))
  {
    return False;
  }
  for (char* c=PathName; *c; c=AnsiNext(c))
  {
    if (!iskanji(*c) && (*c=='\\' || *c=='/'))
    {
      return False;
    }
  }
  return True;
}

// truncate a filename to eight characters and a three character extension
bool 
FileUtil::TruncateFilename(char* PathName, char* Truncated)
{
  if (!PathName) 
  {
    return False;
  }
  
  // we do not truncate the drive, sorry
  if (isalpha(*PathName) && (*(PathName+1)==':')) 
  {
    PathName += 2;  // skip over drive letter and colon
  }

  bool was_truncated = False;        // return value -- have we truncated?
  int piece_len = 0;                 // length of current piece
  bool in_extension = False;         // remember if in extension

  for (char* c = PathName; *c; c = AnsiNext(c))
  {
    switch (*c)
    {
     case '.':
      in_extension = True;
      // fall through

     case '/':
     case '\\':
      piece_len = -1;
      // fall through
     
     default:
      int allowed =  (in_extension ? 3 : 8) - piece_len;
      int len = iskanji(*c) ? 2 : 1;
      if (len<=allowed)
      {
	*Truncated++ = *c;
	if (iskanji(*c))
	{
	  *Truncated++ = *(c+1);
	}
	piece_len += len;
      }
      else
      {
	was_truncated = True;
      }
    }
  }
  *Truncated = '\0';
  return was_truncated;
}

#if (0) /* UNUSED */
long
FileUtil::DiskFreeSpace(char drive)
{
  long dwFreeDiskSpace;
  
#ifdef __BORLANDC__
  struct dfree DiskFreeSpace;

  getdfree(drive - 'A' + 1, &DiskFreeSpace);
  dwFreeDiskSpace = ((DWORD) DiskFreeSpace.df_avail *
		     (DWORD) DiskFreeSpace.df_sclus *
		     (DWORD) DiskFreeSpace.df_bsec) / 1024UL;
#else

  struct diskfree_t DiskFreeSpace;

  _dos_getdiskfree(drive - 'A' + 1, &DiskFreeSpace);
  dwFreeDiskSpace = ((DWORD) DiskFreeSpace.avail_clusters *
		     (DWORD) DiskFreeSpace.sectors_per_cluster *
		     (DWORD) DiskFreeSpace.bytes_per_sector) / 1024UL;
#endif
  
  return dwFreeDiskSpace;
}
#endif

void 
FileUtil::ChangeExtension(char* PathName, char* NewExtension)
{
  char* ext_start = PathName + strlen(PathName);
  int going = 1;
  
  for (char* here = ext_start; here>=PathName && going;
       here = AnsiPrev(PathName, here))
  {
    switch (*here)
    {
     case '.':
      ext_start = here;
     case ':':
     case '/':
     case '\\':
      going = 0;
      break;
    }
  }
  
  if (*NewExtension=='.')
  {
    NewExtension++;
  }
  *ext_start++ = '.';

  while ((*ext_start++ = *NewExtension++) != 0)
  {
  }
}

char* 
FileUtil::ElideFileName(char* name, int mx)
{ 
  bool skipping=False;  // first we go to end of initial directory name,
                        //then start 'skipping'
  bool done = False;
  int skipped = 0;      // number of characters skipped so far
  char* end_part = 0;   // second piece of path, to get tacked on after
                        // initial part
  char* start_ellipsis = 0;
  
  int len = strlen(name);
  int need = len - mx;
  if (need <= 0)
  {
    done = True;
  }
  if (need <= 4)
  {
    need = 4;
  }
  
  for (char* c=name; (*c != '\0') && !done; c=AnsiNext(c))
  {
    switch (*c)
    {
     case ':':
      c = AnsiNext(c); // skip over possible '/' after drive colon
      break;
      
     case '/':
     case '\\':
      if (skipping)	
      {
	if (skipped>=need)
	{
	  done = True;
	  end_part = c++;
	}
	else
	{
	  skipped++;
	}
      }
      else
      {
	skipping = True;
	start_ellipsis = c+1;
      }
      break;
      
     default:
      if (skipping)
      {
	skipped++;
      }
      break;
    }
  }

  if (end_part != NULL)
  {
    strcpy(start_ellipsis, "...");
    strcat(name, end_part);
  }
  
  return name;
}

#ifdef _WIN32

static char*
ansi_strchr(char* s, char c)
{
  while (s && 
	 *s != '\0')
  {
    if (*s == c)
    {
      return s;
    }
    s = AnsiNext(s);
  }
  return 0;
}

static char*
ansi_strrchr(char* s, char c)
{
  char* p = 0;
  while (s &&
	 *s != '\0')
  {
    if (*s == c)
    {
      p = s;
    }
    s = AnsiNext(s);
  }
  return p;
}

bool
FileUtil::GetLongFileName(char* short_name, char* long_name, unsigned int buf_len)
{
  long_name[0] = '\0';
  WIN32_FIND_DATA ffd;
  char tmp_short_file[MAX_PATH + 1];
  char long_file[MAX_PATH + 1];
  char tmp[MAX_PATH + 1];
  char* yen;
  int npos;
  long_file[0] = '\0';
  strcpy(tmp_short_file, short_name);
  HANDLE hf;
  hf = ::FindFirstFile(tmp_short_file, &ffd);
  if (hf == INVALID_HANDLE_VALUE)
  {
    return false;
  }
  ::FindClose(hf);

  char* network_file_name_ptr = 0;
  if (tmp_short_file[0] == '\\' &&
      tmp_short_file[1] == '\\')
  {
    network_file_name_ptr = ansi_strchr(&tmp_short_file[2], '\\');
    if (network_file_name_ptr)
    {
      network_file_name_ptr = ansi_strchr(network_file_name_ptr + 1, '\\');
    }
  }
  
  do
  {
    yen = ansi_strrchr(tmp_short_file, '\\');
    if (network_file_name_ptr &&
	network_file_name_ptr == yen)
    {
      wsprintf(tmp, "%s\\%s", tmp_short_file, long_file);
      strcpy(long_file, tmp);
      yen = 0;
    }
    else if (yen)
    {
      npos = yen - tmp_short_file;
      if (strlen(long_file) == 0)
      {
	strcpy(long_file, ffd.cFileName);
      }
      else
      {
	wsprintf(tmp, "%s\\%s", ffd.cFileName, long_file);
	strcpy(long_file, tmp);
      }
      tmp_short_file[npos] = '\0';
      if (npos == 2 && tmp_short_file[1] == ':')
      {
	wsprintf(tmp, "%s\\%s", tmp_short_file, long_file);
	strcpy(long_file, tmp);
	break;
      }
      hf = ::FindFirstFile(tmp_short_file, &ffd);
      if (hf == INVALID_HANDLE_VALUE)
      {
	return false;
      }
      ::FindClose(hf);
    }
    else
    {
      wsprintf(tmp, "%s\\%s", tmp_short_file, long_file);
      strcpy(long_file, tmp);
    }
  } while (yen);
  if (strlen(long_file) >= buf_len)
  {
    return false;
  }
  strcpy(long_name, long_file);
  return true;
}
#endif /* _WIN32 */

// ------------------------------------------------------------
// class FileError

#include <errno.h>

#define FERROR_STR
// deine enum
#define DEF_ENUM
#define FERROR_SHORT_ERROR
#define FERROR_DETAIL_ERROR
#include "ferr_m.h"

// define message string table
#undef DEF_ENUM
#define FERROR_SHORT_ERROR
#define FERROR_DETAIL_ERROR
#include "ferr_m.h"

char* 
ErrorMsg::GetDetailOpenFileError(WORD err_code)
{
  if (err_code >= DE_Last)
  {
    err_code = DE_OtherFileError;
  }
  return detail_error_message[err_code];
}

char* 
ErrorMsg::GetShortOpenFileError(WORD err_code, bool read)
{
  static ShortErrorMessage correspond_table [] =
  {
    // short error                   detail error
    // -------------------------+---------------------
    SE_CantReadWrite,		// DE_OtherFileError
    SE_CantReadWrite,		// DE_InvalidFunction
    SE_FileNotFound,		// DE_FileNotFound
    SE_PathNotFound,		// DE_PathNotFound
    SE_CantReadWrite,		// DE_TooManyOpenFiles
    SE_CantReadWrite,		// DE_AccessDenied
    SE_CantReadWrite,		// DE_InvalidHandle
    SE_CantReadWrite,		// DE_ArenaTrashed
    SE_CantReadWrite,		// DE_NotEnoughMemory
    SE_CantReadWrite,		// DE_InvalidBlock
    SE_CantReadWrite,		// DE_BadEnvironment
    SE_DiskError,		// DE_BadFormat
    SE_CantReadWrite,		// DE_InvalidAccess
    SE_CantReadWrite,		// DE_InvalidData
    SE_DriveNotFound,		// DE_InvalidDrive
    SE_CantReadWrite,		// DE_CurrentDirectory
    SE_CantReadWrite,		// DE_NotSameDevice
    SE_CantReadWrite,		// DE_NoMoreFiles
    SE_WriteProtected,		// DE_WriteProtectError
    SE_DriveNotFound,		// DE_BadUnit
    SE_DriveNotReady,		// DE_NotReady
    SE_CantReadWrite,		// DE_BadCommand
    SE_DiskError,		// DE_CRCError
    SE_DiskError,		// DE_BadLength
    SE_DiskError,		// DE_SeekError
    SE_DiskError,		// DE_NotMSDOSDisk
    SE_DiskError,		// DE_SectorNotFound
    SE_CantReadWrite,		// DE_OutOfPaper
    SE_WriteProtected,		// DE_WriteFault
    SE_CantReadFile,		// DE_ReadFault
    SE_CantReadWrite,		// DE_GeneralFailure
    SE_NetworkError,		// DE_SharingViolation
    SE_NetworkError,		// DE_LockViolation
    SE_DiskError,		// DE_WrongDisk
    SE_CantReadWrite,		// DE_FileControlBlockUnavailable
    SE_NetworkError,		// DE_SharingBufferExceeded
    SE_NetworkError,		// DE_NotSupported
    SE_NetworkError,		// DE_RemoteNotListed
    SE_NetworkError,		// DE_DuplicateName
    SE_NetworkError,		// DE_BadNetpath
    SE_NetworkError,		// DE_NetworkBusy
    SE_NetworkError,		// DE_DeviceDoesNotExist
    SE_NetworkError,		// DE_TooManyCommands
    SE_NetworkError,		// DE_AdaptorHardwareError
    SE_NetworkError,		// DE_BadNetworkEesponse
    SE_NetworkError,		// DE_UnexpectedNetworkError
    SE_NetworkError,		// DE_BadRemoteAdaptor
    SE_NetworkError,		// DE_PrintQueueFull
    SE_NetworkError,		// DE_NoSpoolSpace
    SE_NetworkError,		// DE_PrintCanceled
    SE_NetworkError,		// DE_NetnameDeleted
    SE_NetworkError,		// DE_NetworkAccessDenied
    SE_NetworkError,		// DE_BadDeviceType
    SE_NetworkError,		// DE_BadNetworkName
    SE_NetworkError,		// DE_TooManyNames
    SE_NetworkError,		// DE_TooManySessions
    SE_NetworkError,		// DE_SharingPaused
    SE_NetworkError,		// DE_RequestNotAccepted
    SE_NetworkError,		// DE_RedirectionPaused
    SE_NetworkError,		// DE_FileExists
    SE_NetworkError,		// DE_DuplicateFileControlBlock
    SE_NetworkError,		// DE_CannotMake
    SE_NetworkError,		// DE_Interrupt24Failure
    SE_NetworkError,		// DE_OutOfStructures
    SE_NetworkError,		// DE_AlreadyAssigned
    SE_NetworkError,		// DE_InvalidPassword
    SE_NetworkError,		// DE_InvalidParameter
    SE_NetworkError,		// DE_NetWriteFault
    SE_CantReadWrite,		// DE_Last
  };
  
  if (err_code >= DE_Last)
  {
    err_code = DE_OtherFileError;
  }
  ShortErrorMessage short_name = correspond_table [err_code];
  if (short_name == SE_CantReadWrite)
  {
    short_name = read ? SE_CantReadFile : SE_CantWriteFile;
  }
  return short_error_message[short_name];
}

static char* 
get_other_error_no_msg(int err_no)
{
  switch (err_no)
  {
#ifndef _WIN32
   case EZERO:        // Error 0
    return S_EZERO;
#endif /* _WIN32 */
   case EINVAL:       // Invalid argument
    return S_EINVAL;
   case E2BIG:        // Arg list too long
    return S_E2BIG;
   case ENOEXEC:      // Exec format error
    return S_ENOEXEC;
   case EXDEV:        // Cross-device link
    return S_EXDEV;
   case EDOM:         // Math argument
    return S_EDOM;
   case ERANGE:       // Result too large
    return S_ERANGE;
   default:
    return S_EOTHER;  // other error
  }
}

char* 
ErrorMsg::GetDetailErrorNoError(int err_no)
{
  if (err_no >= 1 && err_no <= 18)
  {
    // EINVFNC ENOFILE ENOENT ENOPATH EMFILE EACCES EBADF ECONTR ENOMEM
    // EINVMEM EINVENV EINVFMT EINVACC EINVDAT EINVDRV ENODEV ECURDIR
    // ENOTSAM ENMFILE
    return GetDetailOpenFileError(err_no);
  }
  if ((err_no == EEXIST) ||
      (err_no == EDEADLOCK))
  {
    return short_error_message[SE_NetworkError];
  }
  return get_other_error_no_msg(err_no);
}

char*
ErrorMsg::GetShortErrNoError(int err_no, bool read)
{
  if (err_no >= 1 && err_no <= 18)
  {
    // EINVFNC ENOFILE ENOENT ENOPATH EMFILE EACCES EBADF ECONTR ENOMEM
    // EINVMEM EINVENV EINVFMT EINVACC EINVDAT EINVDRV ENODEV ECURDIR
    // ENOTSAM ENMFILE
    return GetShortOpenFileError(err_no, read);
  }
  if (err_no == EEXIST)
  {
    return detail_error_message[DE_FileExists];
  }
  if (err_no == EDEADLOCK)
  {
    return detail_error_message[DE_LockViolation];
  }
  else
  {
    return get_other_error_no_msg(err_no);
  }
}

void 
ErrorMsg::ShowOpenFileError(char* /*file_name*/, WORD err_code, bool read)
{
  char* msg = GetShortOpenFileError(err_code, read);
  Issue(msg, MB_OK);
}

void 
ErrorMsg::ShowErrorNoError(char* /*file_name*/, bool read)
{
  char* msg = GetShortErrNoError(errno, read);
  Issue(msg, MB_OK);
};


// ------------------------------------------------------------
// class File

File::File(char* file_name, bool read)
{
#ifdef _WIN32
  fh = open(file_name, read ? O_RDONLY | O_BINARY : O_WRONLY | O_BINARY);
#else /* _WIN32 */
  fh = ::OpenFile(file_name, &ofs, 
		   read ? OF_READ | OF_SHARE_DENY_WRITE : 
 		          OF_WRITE | OF_SHARE_DENY_READ);
#endif /* _WIN32 */
  if (fh == -1)
  {
    // open error
    fp = 0;
    open_p = False;
    error_p = True;
#ifdef _WIN32
    ErrorMsg::ShowErrorNoError(file_name, read);
#else /* _WIN32 */
    ErrorMsg::ShowOpenFileError(file_name, ofs.nErrCode, read);
#endif /* _WIN32 */
  }
  else
  {
    fp = fdopen(fh, read ? "rb" : "wb");
    if (fp == 0)
    {
      // open error
      ::_lclose(fh);
      fh = 0;
      open_p = False;
      error_p = True;
      ErrorMsg::ShowErrorNoError(file_name, read);
    }
    else
    {
      open_p = True;
      error_p = False;
    }
  }
}

File::~File()
{
  Close();
}

void
File::Close()
{
  if (open_p && !error_p)
  {
    if (fp != 0)
    {
      ::fclose(fp);
    }
    if (fh != -1)
    {
      ::_lclose(fh);
    }
  }
}

