// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fileutil.h,v 3.3 1999/07/19 20:04:10 kudou Exp $
// Utility functions for files

#ifndef FILEUTIL_H
#define FILEUTIL_H

class FileUtil
{
public:
  static int   IsWild(char* FileName);
  static int   FileExists(char* FileName);
  static char* GetFileNameOnly(char* FileName);
  static char* GetExtension(char* FileName);
  static char* GetPathNameOnly(char* PathName, char* FileName);
  static char* ConcatPathAndFileName(char* Path, char* FileName);
  static void  ChDir(char* Dir);
  static char* GetDir(char* PathName);
  static bool IsAbsolute(char* PathName);
  static bool IsFileName(char* PathName);
  static bool TruncateFilename(char* PathName, char* Truncated);
  static long DiskFreeSpace(char drive);
  static void ChangeExtension(char* PathName, char* NewExtension);
  static char* ElideFileName(char* name, int mx);
#ifdef _WIN32
  static bool GetLongFileName(char* short_name, char* long_name, unsigned int buf_len);
#endif /* _WIN32 */
};

// error message
class ErrorMsg
{
private:
  static char* GetDetailOpenFileError(WORD err_code);
  static char* GetShortOpenFileError(WORD err_code, bool read);
  static char* GetDetailErrorNoError(int err_no);
  static char* GetShortErrNoError(int err_no, bool read);
  
public:
  static void ShowOpenFileError(char* file_name, WORD err_code, bool read);
  static void ShowErrorNoError(char* file_name, bool read);
};

// file open
class File
{
  OFSTRUCT ofs;
  int fh;
  FILE* fp;
  bool open_p;
  bool error_p;
  
public:
  // constructor
  File(char* file_name, bool read = True);
  
  // destructor
  ~File();
  
  int GetFileHandle()
  {
    return fh;
  }
  
  FILE* GetFilePointer()
  {
    return fp;
  }
  
  bool ErrorP()
  {
    return error_p;
  }
  
  void Close();
};

#endif /* FILEUTIL_H */

