// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fillobjc.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class FillObject
// hԂt[̃NX

#include "pword.h"
#include "rect.h"
#include "vdisplay.h"
#include "fillobjc.h"
#include "objectid.h"
#include "view.h"

extern RECT global_brush_org_rect[1];

// default fill type
FillObject::FillType FillObject::def_type = FillObject::Gray;

// constructor
FillObject::FillObject(CrossPoint* cp, FillType fill_type)
  : FrameObject(cp)
{
  FillObject::fill_type = fill_type;
}

// constructor(default fill type)
FillObject::FillObject(CrossPoint* cp)
  : FrameObject(cp)
{
  fill_type = def_type;
}

// constructor
FillObject::FillObject(CrossPoint* cp, FillObject* fr)
  : FrameObject(cp)
{
  fill_type = fr->fill_type;
}

// destructor
FillObject::~FillObject()
{
}

// display function.
void
FillObject::DisplayObject(VDisplay* vdsp)
{
  // display
  HDC hDC = vdsp->GetDC();
  HBRUSH br;
  switch (fill_type) 
  {
   case White:
    br = (HBRUSH)GetStockObject(WHITE_BRUSH);
    break;
   case LtGray:
    br = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
    break;
   case Gray:
    br = (HBRUSH)GetStockObject(GRAY_BRUSH);
    break;
   case DkGray:
    br = (HBRUSH)GetStockObject(DKGRAY_BRUSH);
    break;
   case Black:
    br = (HBRUSH)GetStockObject(BLACK_BRUSH);
    break;
   case HorizontalHatch:
    br = CreateHatchBrush(HS_HORIZONTAL, 0L);
    break;
   case VerticalHatch:
    br = CreateHatchBrush(HS_VERTICAL, 0L);
    break;
   case FDiagonalHatch:
    br = CreateHatchBrush(HS_FDIAGONAL, 0L);
    break;
   case DiagcrossHatch:
    br = CreateHatchBrush(HS_DIAGCROSS, 0L);
    break;
   case CrossHatch:
    br = CreateHatchBrush(HS_CROSS, 0L);
    break;
   case BDiagonalHatch:
    br = CreateHatchBrush(HS_BDIAGONAL, 0L);
    break;
   default:
    br = (HBRUSH)GetStockObject(WHITE_BRUSH);
    break;
  }
  
  if (((int)fill_type) & ~StockObjectMask) 
  {
    vdsp
    ->GetView()
    ->set_brush_org(CastWindowsRECTToDrect(global_brush_org_rect), br);
  }
  
  RECT r = vdsp->ItoWR(GetInternalRect());
  FillRect(hDC, &r, br);
  
  if (((int)fill_type) & ~StockObjectMask) 
  {
    DeleteObject(br);
  }
}

// get freme object ID
uword
FillObject::GetObjectID()
{
  return IDFillObject;
}

// duplicator
FrameObject*
FillObject::Duplicator(CrossPoint* cp)
{
  return new FillObject(cp, this);
}
