// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fillobjc.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class FillObject
// fill pattern description

#ifndef FILLOBJC_H
#define FILLOBJC_H

#include "frameown.h"
#include "rect.h"

class FillObject 
  : public FrameObject 
{
public:
  enum FillType 
  {
    White            = 0x00,
    LtGray           = 0x01,
    Gray             = 0x02,
    DkGray           = 0x03,
    Black            = 0x04,
    HorizontalHatch  = 0x10,
    VerticalHatch    = 0x11,
    FDiagonalHatch   = 0x12,
    DiagcrossHatch   = 0x13,
    CrossHatch       = 0x14,
    BDiagonalHatch   = 0x15,
    
    StockObjectMask  = 0x0f,
  };
  
private:
  // fill type
  FillType fill_type;
  
  // default fill type
  static FillType def_type;
  
public:
  // constructor
  FillObject(CrossPoint* cp, FillType fill_type);
  
  // constructor(default fill type)
  FillObject(CrossPoint* cp);
  
  // constructor for dumplicate
  FillObject(CrossPoint* cp, FillObject* fr);
  
  // destructor
  ~FillObject();
  
  // get fill type
  FillType GetFillType() 
  {
    return fill_type; 
  }
  
  // set fill type
  void SetFillType(FillType type) 
  {
    fill_type = type; 
  }
  
  // get default fill type
  static FillType GetDefaultFillType() 
  {
    return def_type; 
  }
  
  // set default fill type
  static void SetDefaultFillType(FillType type) 
  {
    def_type = type; 
  }
  
protected:
  // display fill object
  void DisplayObject(VDisplay* dsp);
  
  // get frame object
  uword GetObjectID();
  
  // dumplicate object
  FrameObject* Duplicator(CrossPoint* cp);
};

#endif /* FILLOBJC_H */
