// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: findtext.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// This file contains the EditText method which
// searches for text in edit buffers.
// And now also the TextFlow method which effectively searches for
// edit buffers(containing sought string) in a text.

#include "pword.h"
#include "bufnew.h"
#include "textflow.h"
#include "interval.h"
#include "intlist.h"
#include "searchdl.h"
#include "docedit.h"
#include "interval.h"

IntervalList*
TextFlow::FindText(sjis* what)
{
  BufferPointer* bp = GetEndBufferPointer();
  IntervalList* result = FindText(what, True, bp, True);
  delete bp;
  return result;
}

IntervalList*
TextFlow::FindText(sjis* what, bool reverse, 
		    BPP where)
{
  return FindText(what, reverse, where, False);
}

IntervalList* 
TextFlow::FindText(sjis*  what, bool reverse, BPP xwhere, bool all)
{
  BufferPointer* where = new BufferPointer(xwhere);
  
  IntervalList* result = new IntervalList;
  
  // start off in our own paragraph, at the current point
		
  Paragraph* para = where->GetParagraph();

  BPP newpoint = para->FindText(what, where, reverse);
	
  for (;;)
  {
    // make a buffer pointer representing the other end,
    // calculate where it is based on length of search string,
    // and add it to the list of selections
		    
    if (newpoint)
    { // got a match
      BufferPointer otherend(newpoint);
      int len = jislen(what);
      otherend += len;

      Interval* i = new Interval(&otherend, newpoint);
      
      result->AddInterval(i);
		    
      if (reverse) otherend = *newpoint;
      *where = otherend;
      delete newpoint;
      if (!all) break;
    }
	    
    
    // get the next paragraph and the bp in it to start the search
		    
    else if ((para = (reverse ? para->GetPrevParagraph()
		      : para->GetNextParagraph()))
	     == NULL)
    {
      break;
    }
    else
    {
      delete where;
      where = (reverse ? (para->GetEndBufferPointer())
			  : para->GetStartBufferPointer());
    }
    newpoint = para->FindText(what, where, reverse);
  }
  if (result->GetHead() == NULL) 
  {
    delete result;
    result = 0;
  }
  delete where;
  return result;
}
