// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fission.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Fission
// t[̐\NX

#include "pword.h"
#include "fission.h"
#include <assert.h>

Fission::Fission(FissionFrame* ff)
{
  Fission::ff = ff;
  ff->AddFission(this);
}

// constructor
Fission::Fission(Iunit point, Fission* start_f, Fission* end_f, 
		  Direction dir, FissionFrame* ff, uword border_index)
{
  Fission::ff = ff;
  ff->AddFission(this);
  Fission::dir = dir;
  Fission::point = point;
  if (dir == Vertical) 
  {
    start = new CrossPoint((VFission*)this, 
			    (HFission*)start_f, 
			    (HFission*)end_f, 
			    border_index);
    end = start->GetVNext();
    start->MakeMiddleCrossPoint((VFission*)this);
    SetVFrameObject();
  }
  else 
  {
    start = new CrossPoint((HFission*)this, 
			    (VFission*)start_f, 
			    (VFission*)end_f, 
			    border_index);
    end = start->GetHNext();
    start->MakeMiddleCrossPoint((HFission*)this);
    SetHFrameObject();
  }
}

// constructor, for first FissionFrame
Fission::Fission(Iunit x, Iunit y, FissionFrame* ff)
{
  Fission::ff = ff;
  ff->AddFission(this);
  
  // top fission
  Fission::dir = Horizontal;
  Fission::point = 0;
  
  // bottom fission
  Fission* bottom = new Fission(ff);
  bottom->dir = Horizontal;
  bottom->point = y;
  
  // left fission
  Fission* left = new Fission(ff);
  left->dir = Vertical;
  left->point = 0;
  
  // right fission
  Fission* right = new Fission(ff);
  right->dir = Vertical;
  right->point = x;
  
  // create corner CrossPoint
  start = new CrossPoint((HFission*)this, (VFission*)left,
			  (CrossPoint::CrossKind) (CrossPoint::VStart | 
						   CrossPoint::HStart));
  // 1st.
  end   = new CrossPoint((HFission*)this, (VFission*)right,
			  (CrossPoint::CrossKind) (CrossPoint::VStart | 
						   CrossPoint::HEnd));
  // 2nd.
  
  left->start  = start;
  right->start = end;
  
  bottom->start = new CrossPoint((HFission*)bottom, (VFission*)left,
				  (CrossPoint::CrossKind) 
				  (CrossPoint::VEnd | CrossPoint::HStart));
  // 3rd.
  bottom->end   = new CrossPoint((HFission*)bottom, (VFission*)right,
				  (CrossPoint::CrossKind)
				  (CrossPoint::VEnd | CrossPoint::HEnd));
  // 4th.
  left->end  = bottom->start;
  right->end = bottom->end;
}

// constructor for special purpos
Fission::Fission(Iunit point, Direction dir, FissionFrame* ff)
{
  Fission::ff = ff;
  ff->AddFission(this);
  Fission::dir = dir;
  Fission::point = point;
  start = new CrossPoint(this);
  end = new CrossPoint(this);
  if (dir == Vertical)
  {
    start->SetVNext(end);
    end->SetVPrev(start);
  }
  else
  {
    start->SetHNext(end);
    end->SetVPrev(start);
  }
}

// destructor
Fission::~Fission()
{
  if ((start == 0) &&
      (end == 0)) 
  {
    ff->RemoveFission(this);
    return;
  }
  if (dir == Vertical) 
  {
    CrossPoint* cp;
    while ((cp = start->GetVNext()) != end) 
    {
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	{
	  // delete dependent fission!!
// 
// !!! You don't have to write like next code. Bcc sometimes generates
// under these object.
//
//      delete cp->GetHFission();  // cp is deleted in this destructor
//                                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	les	bx,dword ptr [bp-4]
//	push	word ptr es:[bx+8]
//	push	word ptr es:[bx+6]
//	push	0
//	push	cs
//	call	near ptr @Fission@$bdtr$qv	<< destructor
//	les	bx,dword ptr [bp-4]
//	push	word ptr es:[bx+8]
//	push	word ptr es:[bx+6]
//	call	far ptr @$bdele$qnv 		<< delete
//
	  HFission* hf = cp->GetHFission();
	  delete hf;
	}
	break;
       case CrossPoint::HCross:
	CrossPoint* prev = cp->GetHPrevCell();
	// delete crosspoint
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
    }
    
    // delete start crosspoint
    CrossPoint* prev = start->GetHPrevCell();
    if ((start->GetKind() & CrossPoint::HCross) ||
	(start->GetHFission() == 0)) 
    {
      delete start;
      if (prev) 
      {
	prev->UpdateFrameObject();
      }
    }
    else 
    {
      start->SetVDeletedMark();
    }
    
    // delete end crosspoint
    if (end->GetKind() & CrossPoint::HCross) 
    {
      delete end;
    }
    else if (end->GetHFission() == 0) 
    {
      delete end;
    }
    else 
    {
      end->SetVDeletedMark();
    }
  }
  else 
  {
    CrossPoint* cp;
    while ((cp = start->GetHNext()) != end) 
    {
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	{
	  // delete dependent fission
	  VFission* vf = cp->GetVFission();
	  delete vf;
	}
	break;
       case CrossPoint::VCross:
	CrossPoint* prev = cp->GetVPrevCell();
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
    }
    
    // delete start crosspoint
    CrossPoint* prev = start->GetVPrevCell();
    if ((start->GetKind() & CrossPoint::VCross) ||
	(start->GetVFission() == 0)) 
    {
      delete start;
      if (prev) 
      {
	prev->UpdateFrameObject();
      }
    }
    else 
    {
      start->SetHDeletedMark();
    }
    
    // delete end crosspoint
    if (end->GetKind() & CrossPoint::VCross) 
    {
      delete end;
    }
    else if (end->GetVFission() == 0) 
    {
      delete end;
    }
    else 
    {
      end->SetHDeletedMark();
    }
  }
  
  ff->RemoveFission(this);
}

// set cross-point's frame-object on this fission
void 
Fission::SetHFrameObject()
{
  CrossPoint* cp = GetStartCrossPoint();
  CrossPoint* prev = cp->GetVPrevCell();
  do 
  {
    cp->SetFrameObject(prev);
    cp = cp->GetHNext();
    prev = cp->GetVPrevCell();
  } while (cp != GetEndCrossPoint());
}

// set cross-point's frame-object on this fission
void 
Fission::SetVFrameObject()
{
  CrossPoint* cp = GetStartCrossPoint();
  CrossPoint* prev = cp->GetHPrevCell();
  do 
  {
    cp->SetFrameObject(prev);
    cp = cp->GetVNext();
    prev = cp->GetHPrevCell();
  } while (cp != GetEndCrossPoint());
}

// set border
void 
Fission::SetBorder(uword index)
{
  CrossPoint* cp = start;
  if (dir == Vertical) 
  {
    do 
    {
      cp->SetVBorder(index);
      cp = cp->GetVNext();
    } while (cp != end);
  }
  else 
  {
    do 
    {
      cp->SetHBorder(index);
      cp = cp->GetHNext();
    } while (cp != end);
  }
}

// set border
void 
Fission::SetBorder(CrossPoint* from, CrossPoint* to, uword index)
{
  // change
  CrossPoint* cp = from;
  if (dir == Vertical) 
  {
    // poor error check! but effective
    if ((from->GetVFission() != this) || 
	(to->GetVFission() != this)) 
    {
      // error
      return;
    }
    do 
    {
      cp->SetVBorder(index);
      cp = cp->GetVNext();
    } while (cp != to);
  }
  else 
  {
    // poor error check! but effective
    if ((from->GetHFission() != this) || 
	(to->GetHFission() != this)) 
    {
      // error
      return;
    }
    do 
    {
      cp->SetHBorder(index);
      cp = cp->GetHNext();
    } while (cp != to);
  }
}

// move position
void 
Fission::MovePosition(Iunit p)
{
  point = p;
  CrossPoint* cp = start;
  if (dir == Vertical) 
  {
    // re-position start and end crosspoint
    start->RepositionH();
    end->RepositionH();
    
    // update
    do 
    {
      cp->UpdateVertical();
      cp = cp->GetVNext();
    } while (cp != end);
  }
  else 
  { // horizontal
    // re-position start and end crosspoint
    start->RepositionV();
    end->RepositionV();
    
    // update
    do 
    {
      cp->UpdateHorizontal();
      cp = cp->GetHNext();
    } while (cp != end);
  }
}

// shorten fission start
void 
Fission::ShortenStart(CrossPoint* to)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = start->GetVNext();
    // delete middle
    while (cp != to) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	{
	  // delete dependent fission!!
	  HFission* hf = cp->GetHFission();
	  delete hf;
	}
	break;
       case CrossPoint::HCross:
	CrossPoint* prev = cp->GetHPrevCell();
	// delete crosspoint
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // delete start crosspoint
    CrossPoint* prev = start->GetHPrevCell();
    if ((start->GetKind() & CrossPoint::HCross) ||
	(start->GetHFission() == 0)) 
    {
      delete start;
      if (prev) 
      {
	prev->UpdateFrameObject();
      }
    }
    else 
    {
      start->SetVDeletedMark();
    }
    // change 'to' crosspoint
    to->SetVStart();
  }
  else 
  {
    CrossPoint* cp = start->GetHNext();
    while (cp != to) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	{
	  // delete dependent fission !!
	  VFission* vf = cp->GetVFission();
	  delete vf;
	}
	break;
       case CrossPoint::VCross:
	CrossPoint* prev = cp->GetVPrevCell();
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // delete start crosspoint
    CrossPoint* prev = start->GetVPrevCell();
    if ((start->GetKind() & CrossPoint::VCross) ||
	(start->GetVFission() == 0)) 
    {
      delete start;
      if (prev) 
      {
	prev->UpdateFrameObject();
      }
    }
    else 
    {
      start->SetHDeletedMark();
    }
    // change 'to' crosspoint
    to->SetHStart();
  }
  start = to;
}

// shorten fission end
void 
Fission::ShortenEnd(CrossPoint* from)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = from->GetVNext();
    while (cp != end) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	{
	  // delete dependent fission!!
	  HFission* hf = cp->GetHFission();
	  delete hf;
	}
	break;
       case CrossPoint::HCross:
	CrossPoint* prev = cp->GetHPrevCell();
	// delete crosspoint
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // change 'from' crosspoint
    CrossPoint* prev = from->GetHPrevCell();
    from->SetVEnd();
    if (prev) 
    {
      prev->UpdateFrameObject();
    }
    
    // delete end crosspoint
    if (end->GetKind() & CrossPoint::HCross) 
    {
      delete end;
    }
    else if (end->GetHFission() == 0) 
    {
      delete end;
    }
    else 
    {
      end->SetVDeletedMark();
    }
  }
  else 
  {
    CrossPoint* cp = from->GetHNext();
    while (cp != end) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	{
	  // delete dependent fission !!
	  VFission* vf = cp->GetVFission();
	  delete vf;
	}
	break;
       case CrossPoint::VCross:
	CrossPoint* prev = cp->GetVPrevCell();
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // change 'from' crosspoint
    CrossPoint* prev = from->GetVPrevCell();
    from->SetHEnd();
    if (prev) 
    {
      prev->UpdateFrameObject();
    }
    
    // delete end crosspoint
    if (end->GetKind() & CrossPoint::VCross) 
    {
      delete end;
    }
    else if (end->GetVFission() == 0) 
    {
      delete end;
    }
    else 
    {
      end->SetHDeletedMark();
    }
  }
  end = from;
}

// cut fission middle
Fission* 
Fission::CutMiddle(CrossPoint* from, CrossPoint* to)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = from->GetVNext();
    // cut middle crosspoint
    while (cp != to) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	{
	  // delete dependent fission!!
	  HFission* hf = cp->GetHFission();
	  delete hf;
	}
	break;
       case CrossPoint::HCross:
	CrossPoint* prev = cp->GetHPrevCell();
	// delete crosspoint
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // create second fission.
    Fission* f = new Fission(from->GetFissionFrame());
    f->dir = Vertical;
    f->point = point;
    f->start = to;
    f->end = end;
    to->SetVStart();
    // change crosspoint owner
    for (cp = to; ; cp = cp->GetVNext()) 
    {
      cp->ChangeOwner((VFission*) f);
      if (cp == end) 
      {
	break;
      }
    }
    
    // update end crosspoint
    CrossPoint* prev = from->GetHPrevCell();
    from->SetVEnd();
    if (prev) 
    {
      prev->UpdateFrameObject();
    }
    
    end = from;
    return f;
  }
  else 
  {
    CrossPoint* cp = from->GetHNext();
    while (cp != to) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	{
	  // delete dependent fission !!
	  VFission* vf = cp->GetVFission();
	  delete vf;
	}
	break;
       case CrossPoint::VCross:
	CrossPoint* prev = cp->GetVPrevCell();
	delete cp;
	if (prev) 
	{
	  prev->UpdateFrameObject();
	}
	break;
      }
      cp = next;
    }
    // create second fission.
    Fission* f = new Fission(from->GetFissionFrame());
    f->dir = Horizontal;
    f->point = point;
    f->start = to;
    f->end = end;
    to->SetHStart();
    // change crosspoint owner
    for (cp = to; ; cp = cp->GetHNext()) 
    {
      cp->ChangeOwner((HFission*) f);
      if (cp == end) 
      {
	break;
      }
    }
    
    // update end crosspoint
    CrossPoint* prev = from->GetVPrevCell();
    from->SetHEnd();
    if (prev) 
    {
      prev->UpdateFrameObject();
    }
    
    end = from;
    return f;
  }
}

Fission* 
Fission::Disconnect(CrossPoint* pos)
{
  if (pos->GetKind() != CrossPoint::Crossroads) 
  {
    // can't disconnect
    return 0;
  }
  
  if (dir == Vertical) 
  {
    CrossPoint* vprev = pos->GetVPrev();
    
    // create second fission.
    Fission* f = new Fission(start->GetFissionFrame());
    f->dir = Vertical;
    f->point = point;
    f->start = pos;
    f->end = end;
    pos->SetVStart();
    
    // change crosspoint owner
    for (CrossPoint* cp = pos; ; cp = cp->GetVNext()) 
    {
      cp->ChangeOwner((VFission*) f);
      if (cp == end) 
      {
	break;
      }
    }
    
    // create this->end crosspoint
    end = new CrossPoint((VFission*)this, vprev, pos->GetHFission());
    return f;
  }
  else 
  {
    CrossPoint* hprev = pos->GetHPrev();
    
    // create second fission.
    Fission* f = new Fission(pos->GetFissionFrame());
    f->dir = Horizontal;
    f->point = point;
    f->start = pos;
    f->end = end;
    pos->SetHStart();
    
    // change crosspoint owner
    for (CrossPoint* cp = pos; ; cp = cp->GetHNext()) 
    {
      cp->ChangeOwner((HFission*) f);
      if (cp == end) 
      {
	break;
      }
    }
    
    // create this->end crosspoint
    end = new CrossPoint((HFission*)this, hprev, pos->GetVFission());
    return f;
  }
}

// find cross-point
CrossPoint* 
Fission::FindCrossPoint(Fission* f)
{
  CrossPoint* cp = start;
  if (dir == Vertical) 
  {
    while (cp != end) 
    {
      if (cp->GetHFission() == f) 
      {
	return cp;
      }
      cp = cp->GetVNext();
    }
    if (end->GetHFission() == f) 
    {
      return end;
    }
  }
  else 
  {
    while (cp != end) 
    {
      if (cp->GetVFission() == f) 
      {
	return cp;
      }
      cp = cp->GetHNext();
    }
    if (end->GetVFission() == f) 
    {
      return end;
    }
  }
  // can not find!
  return 0;
}

// check vanish fission
bool 
Fission::CheckVanish()
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = start->GetVNext();
    while (cp != end) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	if (cp->GetHFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::HCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check start crosspoint
    if ((start->GetKind() & CrossPoint::HCross) ||
	(start->GetHFission() == 0)) 
    {
      if (start->CheckVanish() == False) 
      {
	return False;
      }
    }
    // check end crosspoint
    if ((end->GetKind() & CrossPoint::HCross) ||
	(end->GetHFission() == 0)) 
    {
      if (end->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  else 
  {
    CrossPoint* cp = start->GetHNext();
    while (cp != end) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	if (cp->GetVFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::VCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check start crosspoint
    if ((start->GetKind() & CrossPoint::VCross) ||
	(start->GetVFission() == 0)) 
    {
      if (start->CheckVanish() == False) 
      {
	return False;
      }
    }
    // check end crosspoint
    if ((end->GetKind() & CrossPoint::VCross) ||
	(end->GetVFission() == 0)) 
    {
      if (end->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  return True;
}

// check shorten start
bool 
Fission::CheckShortenStart(CrossPoint* to)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = start->GetVNext();
    while (cp != to) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	if (cp->GetHFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::HCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check start crosspoint
    if ((start->GetKind() & CrossPoint::HCross) ||
	(start->GetHFission() == 0)) 
    {
      if (start->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  else 
  {
    CrossPoint* cp = start->GetHNext();
    while (cp != to) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	if (cp->GetVFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::VCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check start crosspoint
    if ((start->GetKind() & CrossPoint::VCross) ||
	(start->GetVFission() == 0)) 
    {
      if (start->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  return True;
}

// check shorten fission end
bool 
Fission::CheckShortenEnd(CrossPoint* from)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = from;
    while (cp != end) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	if (cp->GetHFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::HCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check end crosspoint
    if ((end->GetKind() & CrossPoint::HCross) ||
	(end->GetHFission() == 0)) 
    {
      if (end->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  else 
  {
    CrossPoint* cp = from;
    while (cp != end) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	if (cp->GetVFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::VCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
    // check end crosspoint
    if ((end->GetKind() & CrossPoint::VCross) ||
	(end->GetVFission() == 0)) 
    {
      if (end->CheckVanish() == False) 
      {
	return False;
      }
    }
  }
  return True;
}

// check cut fission middle
bool 
Fission::CheckCutMiddle(CrossPoint* from, CrossPoint* to)
{
  if (dir == Vertical) 
  {
    CrossPoint* cp = from;
    while (cp != to) 
    {
      CrossPoint* next = cp->GetVNext();
      switch (cp->GetKind() & CrossPoint::HMask) 
      {
       case CrossPoint::HStart:
       case CrossPoint::HEnd:
	if (cp->GetHFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::HCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
  }
  else 
  {
    CrossPoint* cp = from;
    while (cp != to) 
    {
      CrossPoint* next = cp->GetHNext();
      switch (cp->GetKind() & CrossPoint::VMask) 
      {
       case CrossPoint::VStart:
       case CrossPoint::VEnd:
	if (cp->GetVFission()->CheckVanish() == False) 
	{
	  return False;
	}
	break;
       case CrossPoint::VCross:
	if (cp->CheckVanish() == False) 
	{
	  return False;
	}
	break;
      }
      cp = next;
    }
  }
  return True;
}

// reorder same position
void 
Fission::ReorderSamePosition(CrossPoint* from, CrossPoint* to)
{
  if (from->GetPoint() == to->GetPoint()) 
  {
    if (GetDir() == Vertical) 
    {
      if (from->GetVNext() != to) 
      {
	from->ReorderVSamePosition(to);
      }
    }
    else 
    {
      if (from->GetHNext() != to) 
      {
	from->ReorderHSamePosition(to);
      }
    }
  }
}

// expand x minimum direction and create new frame
VFission* 
Fission::PrevXInsertSpecial(Iunit size, uword border_index)
{
  Fission* top = GetStartFission();
  Fission* bot = GetEndFission();
  CrossPoint* old_left_up   = top->GetStartCrossPoint();
  CrossPoint* old_left_down = bot->GetStartCrossPoint();
  VFission* new_left = (VFission*)new Fission(-size, Vertical, ff);
  CrossPoint* new_left_up   = new_left->GetStartCrossPoint();
  CrossPoint* new_left_down = new_left->GetEndCrossPoint();
  
  // set new left-up corner
  top->start = new_left_up;
  new_left_up->SetHFission((HFission*)top);
  new_left_up->SetKind(CrossPoint::TStart);
  old_left_up->SetKind(((CrossPoint::CrossKind)
			 (CrossPoint::VStart | CrossPoint::HCross)));
  new_left_up->SetHNext(old_left_up);
  old_left_up->SetHPrev(new_left_up);
  new_left_up->SetHBorderX(old_left_up->GetHBorder());
  new_left_up->SetVBorderX(old_left_up->GetVBorder());

  // set new left-down corner
  bot->start = new_left_down;
  new_left_down->SetHFission((HFission*)bot);
  new_left_down->SetKind(CrossPoint::BStart);
  old_left_down->SetKind(((CrossPoint::CrossKind)
			   (CrossPoint::VEnd | CrossPoint::HCross)));
  new_left_down->SetHNext(old_left_down);
  old_left_down->SetHPrev(new_left_down);
  new_left_down->SetHBorderX(old_left_down->GetHBorder());
  new_left_down->SetVBorderX(old_left_down->GetVBorder());

  // shift
  ff->ShiftXPositionX(size);
  SetBorder(border_index);
  return new_left;
}

// expand y minimun direction and create new frame
HFission* 
Fission::PrevYInsertSpecial(Iunit size, uword border_index)
{
  Fission* left = GetStartFission();
  Fission* right = GetEndFission();
  CrossPoint* old_left_up = left->GetStartCrossPoint();
  CrossPoint* old_right_up = right->GetStartCrossPoint();
  HFission* new_top = (HFission*)new Fission(-size, Horizontal, ff);
  CrossPoint* new_left_up = new_top->GetStartCrossPoint();
  CrossPoint* new_right_up = new_top->GetEndCrossPoint();
  
  // set new left-up corner
  left->start = new_left_up;
  new_left_up->SetVFission((VFission*)left);
  new_left_up->SetKind(CrossPoint::TStart);
  old_left_up->SetKind(((CrossPoint::CrossKind)
			 (CrossPoint::HStart | CrossPoint::VCross)));
  new_left_up->SetVNext(old_left_up);
  old_left_up->SetVPrev(new_left_up);
  new_left_up->SetVBorderX(old_left_up->GetVBorder());
  new_left_up->SetHBorderX(old_left_up->GetHBorder());
  
  // set new right-up corner
  right->start = new_right_up;
  new_right_up->SetVFission((VFission*)right);
  new_right_up->SetKind(CrossPoint::RStart);
  old_right_up->SetKind(((CrossPoint::CrossKind)
			  (CrossPoint::HEnd | CrossPoint::VCross)));
  new_right_up->SetVNext(old_right_up);
  old_right_up->SetVPrev(new_right_up);
  new_right_up->SetHBorderX(old_right_up->GetHBorder());
  new_right_up->SetVBorderX(old_right_up->GetVBorder());
  
  // shift
  ff->ShiftYPositionX(size);
  SetBorder(border_index);
  return new_top;
}

// ------------------------------------------------------------
// class VFission

// get pointed cross-point
CrossPoint* 
VFission::GetCell(Vector& pnt)
{
  for (CrossPoint* cp = start; cp != end; cp = cp->GetVNext()) 
  {
    if (cp->HaveThisPoint(pnt)) 
    {
      return cp;		// find !!
    }
    if (cp->GetKind() == CrossPoint::Start) 
    {
      ;			// for kipping top-left
    }
    else if (cp->GetKind() & CrossPoint::HStart) 
    {
      CrossPoint* ret = cp->GetHFission()->GetCell(pnt);
      if (ret) 
      {
	return ret;
      }
    }
  }
  return 0;
}

void 
VFission::MergeFission(VFission* f)
{
  CrossPoint* f_start = f->start;
  CrossPoint* f_end = f->end;
  CrossPoint* f_cp = f_start->GetVNext();
  while (f_cp != f_end) 
  {
    CrossPoint* next = f_cp->GetVNext();
    f_cp->ChangeOwner(this);      
    f_cp = next;
  }
  f_end->ChangeOwner(this);
  end->VMergeCrossPoint(f_start);
  f->start = 0;
  f->end = 0;
  delete f;
  delete f_start;
  end = f_end;
}

// stretch start
void 
VFission::StretchStart(HFission* hf)
{
  CrossPoint* old_start = start;
  CrossPoint* new_start = new CrossPoint(this);
  start = new_start;
  new_start->SetHFission(hf);
  new_start->SetVNext(old_start);
  old_start->SetVPrev(new_start);
  new_start->SetVBorder(old_start->GetVBorder());
  old_start->SetKind(((CrossPoint::CrossKind)
		       ((old_start->GetKind() & CrossPoint::HMask)
			| CrossPoint::VCross)));
  new_start->SetKind(((CrossPoint::CrossKind)
		       (CrossPoint::VStart | CrossPoint::HCross)));
  CrossPoint* prev = hf->GetStartCrossPoint();
  for (CrossPoint* cp = prev->GetHNext();
       cp != 0;
       cp = cp->GetHNext())
  {
    if (cp->GetVFission()->GetPoint() > point)
    {
      new_start->SetHBorder(prev->GetHBorder());
      new_start->SetHPrev(prev);
      new_start->SetHNext(cp);
      prev->SetHNext(new_start);
      cp->SetHPrev(new_start);
      return;
    }
    prev = cp;
  }
  
  // may be f is funny
  assert(False);
}

// stretch end
void
VFission::StretchEnd(HFission* hf)
{
  CrossPoint* old_end = end;
  CrossPoint* new_end = new CrossPoint(this);
  end = new_end;
  new_end->SetHFission(hf);
  new_end->SetVPrev(old_end);
  old_end->SetVNext(new_end);
  old_end->SetVBorder(old_end->GetVPrev()->GetVBorder());
  old_end->SetKind(((CrossPoint::CrossKind)
		     ((old_end->GetKind() & CrossPoint::HMask)
		      | CrossPoint::VCross)));
  new_end->SetKind(((CrossPoint::CrossKind)
		     (CrossPoint::VEnd | CrossPoint::HCross)));
  CrossPoint* prev = hf->GetStartCrossPoint();
  for (CrossPoint* cp = prev->GetHNext();
       cp != 0;
       cp = cp->GetHNext())
  {
    if (cp->GetVFission()->GetPoint() > point)
    {
      new_end->SetHBorder(prev->GetHBorder());
      new_end->SetHPrev(prev);
      new_end->SetHNext(cp);
      prev->SetHNext(new_end);
      cp->SetHPrev(new_end);
      return;
    }
    prev = cp;
  }
  
  // may be f is funny
  assert(False);
}

// ------------------------------------------------------------
// class HFission

// get pointed cross-point
CrossPoint* 
HFission::GetCell(Vector& pnt)
{
  for (CrossPoint* cp = start; cp != end; cp = cp->GetHNext()) 
  {
    if (cp->HaveThisPoint(pnt)) 
    {
      return cp;		// find !!
    }
    if (cp->GetKind() & CrossPoint::VStart) 
    {
      CrossPoint* ret = cp->GetVFission()->GetCell(pnt);
      if (ret) 
      {
	return ret;
      }
    }
  }
  return 0;
}

void 
HFission::MergeFission(HFission* f)
{
  CrossPoint* f_start = f->start;
  CrossPoint* f_end = f->end;
  CrossPoint* f_cp = f_start->GetHNext();
  while (f_cp != f_end) 
  {
    CrossPoint* next = f_cp->GetHNext();
    f_cp->ChangeOwner(this);      
    f_cp = next;
  }
  f_end->ChangeOwner(this);
  end->HMergeCrossPoint(f_start);
  f->start = 0;
  f->end = 0;
  delete f;
  delete f_start;
  end = f_end;
}

void
HFission::StretchStart(VFission* vf)
{
  CrossPoint* old_start = start;
  CrossPoint* new_start = new CrossPoint(this);
  start = new_start;
  new_start->SetVFission(vf);
  new_start->SetHNext(old_start);
  old_start->SetHPrev(new_start);
  new_start->SetHBorder(old_start->GetHBorder());
  old_start->SetKind(((CrossPoint::CrossKind)
		       ((old_start->GetKind() & CrossPoint::VMask)
			| CrossPoint::HCross)));
  new_start->SetKind(((CrossPoint::CrossKind)
		       (CrossPoint::HStart | CrossPoint::VCross)));
  CrossPoint* prev = vf->GetStartCrossPoint();
  for (CrossPoint* cp = prev->GetVNext();
       cp != 0;
       cp = cp->GetVNext())
  {
    if (cp->GetHFission()->GetPoint() > point)
    {
      new_start->SetVBorder(prev->GetVBorder());
      new_start->SetVPrev(prev);
      new_start->SetVNext(cp);
      prev->SetVNext(new_start);
      cp->SetVPrev(new_start);
      return;
    }
    prev = cp;
  }
  
  // may be f is funny
  assert(False);
}

void
HFission::StretchEnd(VFission* vf)
{
  CrossPoint* old_end = end;
  CrossPoint* new_end = new CrossPoint(this);
  end = new_end;
  new_end->SetVFission(vf);
  new_end->SetHPrev(old_end);
  old_end->SetHNext(new_end);
  old_end->SetHBorder(old_end->GetHPrev()->GetHBorder());
  old_end->SetKind(((CrossPoint::CrossKind)
		     ((old_end->GetKind() & CrossPoint::VMask)
		      | CrossPoint::HCross)));
  new_end->SetKind(((CrossPoint::CrossKind)
		     (CrossPoint::HEnd | CrossPoint::VCross)));
  CrossPoint* prev = vf->GetStartCrossPoint();
  for (CrossPoint* cp = prev->GetVNext();
       cp != 0;
       cp = cp->GetVNext())
  {
    if (cp->GetHFission()->GetPoint() > point)
    {
      new_end->SetVBorder(prev->GetVBorder());
      new_end->SetVPrev(prev);
      new_end->SetVNext(cp);
      prev->SetVNext(new_end);
      cp->SetVPrev(new_end);
      return;
    }
    prev = cp;
  }
  
  // may be f is funny
  assert(False);
}

// ------------------------------------------------------------
// frame rect region

bool 
FrameRectRgn::ValidP()
{
  if ((top == 0) || (bot == 0) || (lft == 0) || (rgh == 0))
  {
    return False;
  }
  if ((top->FindCrossPoint(lft) != 0) &&
      (top->FindCrossPoint(rgh) != 0) &&
      (bot->FindCrossPoint(lft) != 0) &&
      (bot->FindCrossPoint(rgh) != 0))
  {
    return True;
  }
  return False;
}

void
FrameRectRgn::Set(CrossPoint* cp)
{
  assert(cp != 0);
  
  Fission* top1;
  Fission* bot1;
  Fission* lft1;
  Fission* rgh1;
  cp->GetCellFission(top1, bot1, lft1, rgh1);
  top = (HFission*)top1;
  bot = (HFission*)bot1;
  lft = (VFission*)lft1;
  rgh = (VFission*)rgh1;
}

void 
FrameRectRgn::Set(CrossPoint* cp1, CrossPoint* cp2)
{
  assert((cp1 != 0) && (cp2 != 0));
  
  Fission* top1;
  Fission* bot1;
  Fission* lft1;
  Fission* rgh1;
  cp1->GetCellFission(top1, bot1, lft1, rgh1);
  assert((top1 != 0) && (bot1 != 0) && (lft1 != 0) && (rgh1 != 0));
	  
  Fission* top2;
  Fission* bot2;
  Fission* lft2;
  Fission* rgh2;
  cp2->GetCellFission(top2, bot2, lft2, rgh2);
  assert((top2 != 0) && (bot2 != 0) && (lft2 != 0) && (rgh2 != 0));
  
  top = (HFission*)((top1->GetPoint() < top2->GetPoint()) ? top1 : top2);
  bot = (HFission*)((bot1->GetPoint() > bot2->GetPoint()) ? bot1 : bot2);
  lft = (VFission*)((lft1->GetPoint() < lft2->GetPoint()) ? lft1 : lft2);
  rgh = (VFission*)((rgh1->GetPoint() > rgh2->GetPoint()) ? rgh1 : rgh2);
}

CrossPoint* 
FrameRectRgn::GetTopLeft()
{
  return top->FindCrossPoint(lft);
}

CrossPoint* 
FrameRectRgn::GetTopRight()
{
  return top->FindCrossPoint(rgh);
}

CrossPoint* 
FrameRectRgn::GetBottomLeft()
{
  return bot->FindCrossPoint(lft);
}

CrossPoint* 
FrameRectRgn::GetBottomRight()
{
  return bot->FindCrossPoint(rgh);
}
