// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fissioni.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class HFissionIterator
// class VFissionIterator
// class FissionIterator
// class RectRgnFissionIterator
// class RectRgnVFissionIterator
// class RectRgnHFissionIterator
// lXȏɂFission ̃C^[^

#include "pword.h"
#include "fission.h"
#include "fissioni.h"

// ------------------------------------------------------------
// class HFissionIterator

// downward scan
CrossPoint* 
HFissionIterator::DownWard()
{
  CrossPoint* c;
  if ((c = cp->GetVNext()) == 0) 
  {
    return 0;
  }
  while (c->GetKind() & CrossPoint::HEnd) 
  {
    c = c->GetVNext();
    if (c == 0) 
    {
      return 0;
    }
  }
  return c;
}

// rightward scan
CrossPoint* 
HFissionIterator::RightWard()
{
  CrossPoint* c;
  if ((c = cp->GetHNext()) == 0) 
  {
    return 0;
  }
  while (c->GetKind() & CrossPoint::VEnd) 
  {
    c = c->GetHNext();
    if (c == 0) 
    {
      return 0;
    }
  }
  return c;
}

// constructor
HFissionIterator::HFissionIterator(HFission* f)
{
  HFissionIterator::f = f;
  y = f->Y();
  end = f->GetEndFission();
  cp = f->GetStartCrossPoint()->GetVPrev();
}

// iteator
VFission* 
HFissionIterator::operator() ()
{
  CrossPoint* next;
  switch (cp->GetKind() & CrossPoint::VMask) 
  {
   case CrossPoint::VStart:			// start point
    next = DownWard();
    if (next != 0 && next->Y() < y) 
    {
      // trace downward
      do 
      {
	cp = next;
	next = DownWard();
      } while (next != 0 && next->Y() < y);
    }
    // trace rightward
    if ((cp = RightWard()) == 0) 
    {
      return 0;
    }
    if (cp->GetVFission() == end) 
    {
      return 0;	// end iterate
    }
    return cp ? cp->GetVFission() : 0;
   case CrossPoint::VCross:			// cross point
    next = DownWard();
    if (next != 0 && next->Y() < y) 
    {
      // trace downward
      do 
      {
	cp = next;
	next = DownWard();
      } while (next != 0 && next->Y() < y);
    }
    else if ((cp->GetKind() & CrossPoint::HMask) == CrossPoint::HEnd) 
    {
      // trace upward
      do 
      {
	cp = cp->GetVPrev();
	if (cp == 0) 
	{
	  assert(False);
	  return 0;
	}
      } while ((cp->GetKind() & CrossPoint::HMask) == CrossPoint::HEnd);
    }
    // trace rightward
    if ((cp = RightWard()) == 0) 
    {
      return 0;
    }
    if (cp->GetVFission() == end) 
    {
      return 0;	// end iterate
    }
    return cp ? cp->GetVFission() : 0;
   case CrossPoint::VEnd:
   default:
    return 0;			// error
  }
}

// ------------------------------------------------------------
// class VFissionIterator

// downward scan
CrossPoint* 
VFissionIterator::DownWard()
{
  CrossPoint* c;
  if ((c = cp->GetHNext()) == 0) 
  {
    return 0;
  }
  while (c->GetKind() & CrossPoint::VEnd) 
  {
    c = c->GetHNext();
    if (c == 0) 
    {
      return 0;
    }
  }
  return c;
}

// rightward scan
CrossPoint* VFissionIterator::RightWard()
{
  CrossPoint* c;
  if ((c = cp->GetVNext()) == 0) 
  {
    return 0;
  }
  while (c->GetKind() & CrossPoint::HEnd) 
  {
    c = c->GetVNext();
    if (c == 0) 
    {
      return 0;
    }
  }
  return c;
}

// constructor
VFissionIterator::VFissionIterator(VFission* f)
{
  VFissionIterator::f = f;
  x = f->X();
  end = f->GetEndFission();
  cp = f->GetStartCrossPoint()->GetHPrev();
}

// iteator
HFission* 
VFissionIterator::operator() ()
{
  CrossPoint* next;
  switch (cp->GetKind() & CrossPoint::HMask) 
  {
   case CrossPoint::HStart:			// start point
    next = DownWard();
    if (next != 0 && next->X() < x) 
    {
      // trace downward
      do 
      {
	cp = next;
	next = DownWard();
      } while (next != 0 && next->X() < x);
    }
    // trace rightward
    if ((cp = RightWard()) == 0) 
    {
      return 0;
    }
    if (cp->GetHFission() == end) 
    {
      return 0;	// end iterate
    }
    return cp ? cp->GetHFission() : 0;
   case CrossPoint::HCross:			// cross point
    next = DownWard();
    if (next != 0 && next->X() < x) 
    {
      // trace downward
      do 
      {
	cp = next;
	next = DownWard();
      } while (next != 0 && next->X() < x);
    }
    else if ((cp->GetKind() & CrossPoint::VMask) == CrossPoint::VEnd) 
    {
      // trace upward
      do 
      {
	cp = cp->GetHPrev();
	if (cp == 0) 
	{
	  assert(False);
	  return 0;
	}
      } while ((cp->GetKind() & CrossPoint::VMask) == CrossPoint::VEnd);
    }
    // trace rightward
    if ((cp = RightWard()) == 0) 
    {
      return 0;
    }
    if (cp->GetHFission() == end) 
    {
      return 0;	// end iterate
    }
    return cp ? cp->GetHFission() : 0;
   case CrossPoint::HEnd:
   default:
    return 0;			// error
  }
}

// ------------------------------------------------------------
// class RectRgnFissionIterator

RectRgnFissionIterator::RectRgnFissionIterator(FrameRectRgn& rgn)
  : FissionIterator(rgn.GetTop()->GetFissionFrame())
{
  RectRgnFissionIterator::rgn = rgn;
  x1 = rgn.X1();
  x2 = rgn.X2();
  y1 = rgn.Y1();
  y2 = rgn.Y2();
}

Fission* 
RectRgnFissionIterator::operator() ()
{
  Fission* f;
  while ((f = FissionIterator::operator() ()) != 0)
  {
    if ((f != (Fission*)rgn.GetTop()) &&
	(f != (Fission*)rgn.GetBottom()) &&
	(f != (Fission*)rgn.GetLeft()) &&
	(f != (Fission*)rgn.GetRight()))
    {
      CrossPoint* cp_s = f->GetStartCrossPoint();
      CrossPoint* cp_e = f->GetEndCrossPoint();
      if ((cp_s->X() >= x1) && (cp_s->X() <= x2) &&
	  (cp_e->X() >= x1) && (cp_e->X() <= x2) &&
	  (cp_s->Y() >= y1) && (cp_s->Y() <= y2) &&
	  (cp_e->Y() >= y1) && (cp_e->Y() <= y2))
      {
	return f;
      }
    }      
  }
  return 0;
}

VFission* 
RectRgnVFissionIterator::operator() ()
{
  Fission* f;
  while ((f = GetNext()) != 0)
  {
    if ((f->GetDir() == Fission::Vertical) &&
	(f != (Fission*)rgn.GetLeft()) &&
	(f != (Fission*)rgn.GetRight()))
    {
      CrossPoint* cp_s = f->GetStartCrossPoint();
      CrossPoint* cp_e = f->GetEndCrossPoint();
      if ((cp_s->X() >= x1) && (cp_s->X() <= x2) &&
	  (cp_e->X() >= x1) && (cp_e->X() <= x2) &&
	  (cp_s->Y() >= y1) && (cp_s->Y() <= y2) &&
	  (cp_e->Y() >= y1) && (cp_e->Y() <= y2))
      {
	return(VFission*)f;
      }
    }
  }
  return 0;
}

HFission* 
RectRgnHFissionIterator::operator() ()
{
  Fission* f;
  while ((f = GetNext()) != 0)
  {
    if ((f->GetDir() == Fission::Horizontal) &&
	(f != (Fission*)rgn.GetTop()) &&
	(f != (Fission*)rgn.GetBottom()))
    {
      CrossPoint* cp_s = f->GetStartCrossPoint();
      CrossPoint* cp_e = f->GetEndCrossPoint();
      if ((cp_s->X() >= x1) && (cp_s->X() <= x2) &&
	  (cp_e->X() >= x1) && (cp_e->X() <= x2) &&
	  (cp_s->Y() >= y1) && (cp_s->Y() <= y2) &&
	  (cp_e->Y() >= y1) && (cp_e->Y() <= y2))
      {
	return(HFission*)f;
      }
    }
  }
  return 0;
}
