// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: framedlg.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// class FrameMarginDialog
// class FillPatternDialog 
// class SplitFrameDialog
// class RemoveFrameDialog
// class InsertFrameDialog
// class CombineFrameDialog
// class AlignFrameDialog
// frame menu dialogs

#include "pword.h"
#include "dialogs.h"
#include "pmenus.h"
#include "framedlg.h"
#include "xstr.h"
#include <assert.h>

// ------------------------------------------------------------
// class FrameMarginDialog

// constructor
FrameMarginDialog::FrameMarginDialog(Iunit top, Iunit bot, 
				      Iunit lft, Iunit rgh)
{
  this->class_name = "FrameMarginDialog";
  m[0] = iu_to_mm0(top);
  m[1] = iu_to_mm0(bot);
  m[2] = iu_to_mm0(rgh);
  m[3] = iu_to_mm0(lft);
}

// window proc.
LRESULT_T 
FrameMarginDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /* lParam */)
{
  switch (Msg) 
  {
   case WM_INITDIALOG:
    {
      for (uword i = 0; i < 4; i++)
      {
	set_item_mm0(GetHandle(), IDD_Value + i, m[i]);
      }
    }
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case(IDD_Value + 0):
     case(IDD_Value + 1):
     case(IDD_Value + 2):
     case(IDD_Value + 3):
      {
#ifdef _WIN32
	uword n = LOWORD(wParam) - IDD_Value;
#else /* _WIN32 */
	uword n = wParam - IDD_Value;
#endif /* _WIN32 */
	int i;
#ifdef _WIN32
	bool ok = (bool)(get_item_mm0(GetHandle(), LOWORD(wParam), &i) != 0);
#else /* _WIN32 */
	bool ok = (bool)(get_item_mm0(GetHandle(), wParam, &i) != 0);
#endif /* _WIN32 */
	m[n] = i;
	
	// check value
	if (ok)
	{
	  for (n = 0; n < 4; n++)
	  {
	    if (m[n] < 0)
	    {
	      ok = False;
	      break;
	    }
	  }
	}
	EnableWindow(GetItem(IDOK), ok);
      }
      break;

     case IDOK:
      End(1);
      break;
      
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default:
    return 0;
  }
  return 1;
}

// ------------------------------------------------------------
// class FillPatternDialog

FillPatternDialog::_pattmsg FillPatternDialog::pattmsg [] =
{
  { FillObject::White,           IDD_FillPattern_White },
  { FillObject::LtGray,          IDD_FillPattern_LtGray },
  { FillObject::Gray,            IDD_FillPattern_Gray },
  { FillObject::DkGray,          IDD_FillPattern_DkGray },
  { FillObject::Black,           IDD_FillPattern_Black },
  { FillObject::HorizontalHatch, IDD_FillPattern_HorizHatch },
  { FillObject::VerticalHatch,   IDD_FillPattern_VertHatch },
  { FillObject::BDiagonalHatch,  IDD_FillPattern_FdiagHatch },
  { FillObject::DiagcrossHatch,  IDD_FillPattern_DiagCross },
  { FillObject::CrossHatch,      IDD_FillPattern_Cross },
  { FillObject::FDiagonalHatch,  IDD_FillPattern_BdiagHatch },
  { (FillObject::FillType)0, 0 }
};

FillPatternDialog::FillPatternDialog(FillObject::FillType def_type)
{
  this->class_name = "FillPatternDialog";
  curpat = def_type;
}

LRESULT_T
FillPatternDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T)
{
  switch (Msg) 
  {
   case WM_INITDIALOG:
    {
      // set initial check mark
      WORD message = IDD_FillPattern_Cross;
      for (_pattmsg* e=pattmsg; e->msg != 0; e++)
      {
	if (e->patt == curpat)
	{
	  message = e->msg;
	  break;
	}
      }
      set_item_check(message);
      return 1;
    }
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case(IDOK):
      {
	End(1);
	return 1;
      }
      
     case(IDCANCEL):
      {
	End(0);
	return 1;
      }
      
     default:
      for (_pattmsg* e=pattmsg; e->msg; e++) 
      {
#ifdef _WIN32
	if (e->msg == (int) LOWORD(wParam))
#else /* _WIN32 */
	if (e->msg == (int) wParam)
#endif /* _WIN32 */
	{
	  curpat = e->patt;
	  break;
	}
      }
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return 1;
  }
  return 0;
}

// ------------------------------------------------------------
// class SplitFrameDialog

SplitFrameDialog::SplitFrameDialog()
  : TwoNumDialog(1, 1, 1)
{
  this->class_name = "SplitFrameDialog";
  make_table = False;
}

SplitFrameDialog::SplitFrameDialog(bool /*dummy*/)
  : TwoNumDialog(1, 1, 1)
{
  this->class_name = "SplitFrameDialog";
  make_table = True;
}

int 
SplitFrameDialog::CheckValue(int val , int item)
{
  const int split_cell_max = 1000;
  const int split_column_max = 100;
  
  if ((val < 1) || (val > split_column_max)) 
  {
    return False;
  }
  int val2 = (item == 1) ? GetValue2() : GetValue();
  if (val * val2 > split_cell_max) 
  {
    return False;
  }
  return True;
}

LRESULT_T 
SplitFrameDialog::WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  if (msg == WM_INITDIALOG)
  {
    if (make_table)
    {
      SetText(S_MakeTable);
    }
  }
  return TwoNumDialog::WndProc(msg, wParam, lParam);
}


// ------------------------------------------------------------
// class RemoveFrameDialog

RemoveFrameDialog::RemoveFrameDialog(bool posible_remove_line,
				      bool posible_remove_column,
				      bool is_table)
{
  this->class_name = "RemoveFrameDialog";
  RemoveFrameDialog::posible_remove_line = posible_remove_line;
  RemoveFrameDialog::posible_remove_column = posible_remove_column;
  RemoveFrameDialog::is_table = is_table;
  remove_line = posible_remove_line ? True : False;
  expand_size = is_table ? True : False;
}  

LRESULT_T 
RemoveFrameDialog::WndProc(MSG_T iMessage, WPARAM_T wParam,
			    LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_INITDIALOG:
    InitDialog();
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_COMMAND:		
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_DeleteFrameVertical:
       case IDD_DeleteFrameHorizontal:
       case IDD_DeleteFrameExpandSize:
	break;
        
       case IDOK:
	remove_line = (bool)(get_item_check(IDD_DeleteFrameHorizontal) != 0);
	expand_size = (bool)(get_item_check(IDD_DeleteFrameExpandSize) != 0);
	if (!is_table && expand_size)
	{
	  End(0);
	}
	else
	{
	  End(1);
	}
	break;
       
       case IDCANCEL:
	End(0);
	break;
       
       default:
	return 0;
      }
    }
    break;
    
   default:
    return 0;
  }
  return 1;
}

void 
RemoveFrameDialog::InitDialog()
{
  if (!posible_remove_line)
  {
    EnableWindow(GetItem(IDD_DeleteFrameHorizontal), False);
  }
  else
  {
    SendItemMessage(IDD_DeleteFrameHorizontal,
		     BM_SETCHECK, remove_line);
  }
  if (!posible_remove_column)
  {
    EnableWindow(GetItem(IDD_DeleteFrameVertical), False);
  }
  else
  {
    SendItemMessage(IDD_DeleteFrameVertical,
		     BM_SETCHECK, !remove_line);
  }
  EnableWindow(GetItem(IDD_DeleteFrameExpandSize), is_table);
  if (is_table)
  {
    SendItemMessage(IDD_DeleteFrameExpandSize, 
		     BM_SETCHECK, expand_size);
  }
}


// ------------------------------------------------------------
// class InsertFrameDialog

bool InsertFrameDialog::expand_size = true;
uword InsertFrameDialog::copy_num = 1;

InsertFrameDialog::InsertFrameDialog(bool posible_insert_line,
				      bool posible_insert_column,
				      bool is_table)
{
  this->class_name = "InsertFrameDialog";
  InsertFrameDialog::posible_insert_line = posible_insert_line;
  InsertFrameDialog::posible_insert_column = posible_insert_column;
  InsertFrameDialog::is_table = is_table;
   
  assert(posible_insert_line || posible_insert_column);
  
  // settings
  dir = posible_insert_line ? insert_up : insert_down;
}		     

void 
InsertFrameDialog::InitDialog()
{
  if (!posible_insert_line)
  {
    EnableWindow(GetItem(IDD_InsertFrameUp), False);
    EnableWindow(GetItem(IDD_InsertFrameDown), False);
  }
  if (!posible_insert_column)
  {
    EnableWindow(GetItem(IDD_InsertFrameLeft), False);
    EnableWindow(GetItem(IDD_InsertFrameRight), False);
  }
  
  if (!is_table)
  {
    EnableWindow(GetItem(IDD_InsertFrameExpandSize), False);
  }
  else
  {
    SendItemMessage(IDD_InsertFrameExpandSize, BM_SETCHECK, expand_size);
  }
  
  switch (dir)
  {
   case insert_up:
    set_item_check(IDD_InsertFrameUp);
    break;
   case insert_down:
    set_item_check(IDD_InsertFrameDown);
    break;
   case insert_left:
    set_item_check(IDD_InsertFrameLeft);
    break;
   case insert_right:
    set_item_check(IDD_InsertFrameRight);
    break;
  }
  
  set_item_int(GetHandle(), IDD_InsertFrameCopyNum, copy_num);
}

LRESULT_T 
InsertFrameDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, 
			    LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_INITDIALOG:
    InitDialog();
    break;
    
   case WM_COMMAND:
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_InsertFrameUp:
       case IDD_InsertFrameDown:
       case IDD_InsertFrameLeft:
       case IDD_InsertFrameRight:
       case IDD_InsertFrameExpandSize:
	break;
	
       case IDD_InsertFrameCopyNum:
	{
	  int i;
	  if (!get_item_int(GetHandle(), IDD_InsertFrameCopyNum, &i))
	  {
	    EnableWindow(GetItem(IDOK), False);
	  }
	  else
	  {
	    copy_num = i;
	    EnableWindow(GetItem(IDOK), True);
	  }
	}
	break;
	
       case IDOK:
	{
	  int i;
	  if (!get_item_int(GetHandle(), IDD_InsertFrameCopyNum, &i))
	  {
	    End(0);
	  }
	  else
	  {
	    copy_num = i;
	    End(1);
	    if (get_item_check(IDD_InsertFrameUp))
	    {
	      dir = insert_up;
	    }
	    if (get_item_check(IDD_InsertFrameDown))
	    {
	      dir = insert_down;
	    }
	    if (get_item_check(IDD_InsertFrameLeft))
	    {
	      dir = insert_left;
	    }
	    if (get_item_check(IDD_InsertFrameRight))
	    {
	      dir = insert_right;
	    }
	    expand_size = (bool)(get_item_check(IDD_InsertFrameExpandSize) != 0);
	  }
	}
	break;
	
       case IDCANCEL:
	End(0);
	break;
	
       default:
	return 0;
      }	
    }  
   default:
    return 0;
  }
  return 1;
}

// ------------------------------------------------------------
// class CombineFrameDialog

CombineFrameDialog::CombineFrameDialog()
{
  this->class_name = "CombineFrameDialog";
  combine_vertical = True;
  combine_horizontal = True;
}

LRESULT_T 
CombineFrameDialog::WndProc(MSG_T iMessage, WPARAM_T wParam,
			     LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_INITDIALOG:
    {
      if (combine_vertical && combine_horizontal)
      {
	set_item_check(IDD_Value + 0);
      }
      else if (!combine_horizontal)
      {
	set_item_check(IDD_Value + 1);
      }
      else
      {
	set_item_check(IDD_Value + 2);
      }
    }
    break;
    
   case WM_COMMAND:		
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case(IDD_Value + 0):
       case(IDD_Value + 1):
       case(IDD_Value + 2):
	break;
       case IDOK:
	{
	  int end = 1;
	  if (get_item_check(IDD_Value + 0))
	  {
	    combine_vertical = True;
	    combine_horizontal = True;
	  }
	  else if (get_item_check(IDD_Value + 1))
	  {
	    combine_vertical = True;
	    combine_horizontal = False;
	  }
	  else if (get_item_check(IDD_Value + 2))
	  {
	    combine_vertical = False;
	    combine_horizontal = True;
	  }
	  else 
	  {
	    end = 0;
	  }
	  End(end);
	}
	break;
	
       case IDCANCEL:
	End(0);
	break;
	
       default:
	return 0;
      }
    }
    break;
    
   default:
    return 0;
  }
  return 1;
}

// ------------------------------------------------------------
// class AlignFrameDialog

AlignFrameDialog::AlignFrameDialog()
{
  this->class_name = "AlignFrameDialog";
}

// ------------------------------------------------------------
// class MakeTableDialog

MakeTableDialog::MakeTableDialog()
{
  this->class_name = "MakeTableDialog";
  h_div = default_h_div;
  v_div = default_v_div;
  h_size = default_h_size;
  v_size = default_v_size;
}

LRESULT_T 
MakeTableDialog::WndProc(MSG_T iMessage, WPARAM_T wParam,
			  LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_INITDIALOG:
    {
      set_item_int(GetHandle(), IDD_Value + 0, default_h_div);
      set_item_int(GetHandle(), IDD_Value + 1, default_v_div);
      set_item_mm0(GetHandle(), IDD_Value + 2, default_h_size);
      set_item_mm0(GetHandle(), IDD_Value + 3, default_v_size);
      if ((h_size <= 0) || (v_size <= 0)) 
      {
	EnableWindow(GetItem(IDOK), False);
      }
    }
    break;
    
   case WM_COMMAND:
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case(IDD_Value + 0):
       case(IDD_Value + 1):
       case(IDD_Value + 2):
       case(IDD_Value + 3):
       case IDOK:
	{
	  int i;
	  if (!get_item_int(GetHandle(), IDD_Value + 0, &i))
	  {
	    i = 0;
	  }
	  h_div = i;
	  if (!get_item_int(GetHandle(), IDD_Value + 1, &i))
	  {
	    i = 0;
	  }
	  v_div = i;
	  if (!get_item_mm0(GetHandle(), IDD_Value + 2, &i))
	  {
	    i = 0;
	  }
	  h_size = mm0_to_iu(i);
	  if (!get_item_mm0(GetHandle(), IDD_Value + 3, &i))
	  {
	    i = 0;
	  }
	  v_size = mm0_to_iu(i);
	  bool ok = !!((h_div > 0) && (v_div > 0) &&
		       (h_size > 0) && (v_size > 0));
#ifdef _WIN32
	  if (LOWORD(wParam) == IDOK)
#else /* _WIN32 */
	  if (wParam == IDOK)
#endif /* _WIN32 */
	  {
	    End(ok);
	  }
	  else
	  {
	    EnableWindow(GetItem(IDOK), ok);
	  }
	}
	break;
	
       case IDCANCEL:
	End(0);
	break;
	
       default:
	return 0;
      }
    }
    break;
    
   default:
    return 0;
  }
  return 1;
}
